package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.common.PagingDto;
import fr.onema.sispea.service.data.ExerciseService;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.service.user.UserType;
import fr.onema.sispea.service.user.UsersFormDto;
import fr.onema.sispea.struts.AbstractSispeaAction;
import fr.onema.sispea.struts.user.bean.UserFormBean;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * This action handles the user edition.
 * It allows the end user to edit user props.
 *
 * @author CS
 */
public abstract class AbstractUserAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

//    /**
//     * translation key root
//     */
//    protected static final String PACKAGE_PREFIX_USER = "fr.onema.sispea.user.bean.UserFormBean.types.";

    @Autowired
    protected transient ExerciseService exerciseService;

    protected UserFormBean user = new UserFormBean();

    /**
     * Both not used, just to avoid warning when displaying profil from user's list
     */
    protected UsersFormDto form;

    protected PagingDto paging;

    /**
     * check user's validity
     */
    public UserFormBean validateUser(UserFormBean pUser, boolean pCreating) throws SispeaException {

        // check for user
        if (pUser == null) {
            throw new SispeaException("fr.onema.sispea.struts.user.action.UserAction.errors.noUser");
        }

        // check for user's login
        if (pUser.getLogin() == null || "".equals(pUser.getLogin())) {
            throw new SispeaException("fr.onema.sispea.struts.user.action.UserAction.errors.noLogin");
        }

        // check name
        //FIXME tchemit-2015-06-25 ? Check name or login
        if (pUser.getLogin() == null || "".equals(pUser.getLogin())) {
            throw new SispeaException("fr.onema.sispea.struts.user.action.UserAction.errors.noLogin");
        }

        // Remove all leading and trailing whitespaces
        pUser.trim();

        // check for user's login unicity if login has changed
        // login has changed, check new login
        // if existing user ->fail
        if (pCreating) {
            if (userService.userExists(pUser.getLogin())) {
                throw new SispeaException("fr.onema.sispea.struts.user.action.UserAction.errors.existingLogin");
            }
        } else {
            if (user.loginChanged() && userService.userExists(pUser.getLogin())) {
                throw new SispeaException("fr.onema.sispea.struts.user.action.UserAction.errors.existingLogin");
            }
        }

        // reload territory if null
        if ((pUser.getTerritory() == null) && (pUser.getForm() == pUser.getUserFormId())) {

            // load user
            String lLogin = pUser.getLogin();
            if (user.loginChanged()) {
                lLogin = pUser.getOldLogin();
            }
            UserDto lUser = userService.readUser(lLogin);

            // copy territory
            if ((lUser != null) && (lUser.getTerritory() != null)) {
                pUser.setTerritory(lUser.getTerritory());
            }
        } else if (pUser.getTerritory() != null && pUser.getTerritory().getId() != null) {
            pUser.setTerritory(territoryService.readTerritory(pUser.getTerritory().getId()));
        }

        // check for password requiered
        if ((pUser.getForm() == pUser.getIdsFormId()) && ((pUser.getPassWordNew() == null) || (pUser.getPassWordNew().length() == 0))) {
            throw new SispeaException("fr.onema.sispea.struts.user.action.UserAction.errors.pwdRequiered");
        }

        // check for password if new password
        if ((pUser.getPassWordNew() != null) && (pUser.getPassWordNew().length() != 0)) {

            // check for confirmation
            if ((pUser.getPassWordConfirm() == null) || (pUser.getPassWordConfirm().length() == 0)) {
                throw new SispeaException("fr.onema.sispea.struts.user.action.UserAction.errors.noPwdConfirmation");
            }

            // check if confirmation is same as new password
            if (!pUser.getPassWordConfirm().equals(pUser.getPassWordNew())) {
                throw new SispeaException("fr.onema.sispea.struts.user.action.UserAction.errors.pwdConfirmNotEqual");
            }

            // set the new password
            pUser.setPassWord(pUser.getPassWordNew());
        }

        // check for user type
        if (pUser.getType() == null) {
            throw new SispeaException("fr.onema.sispea.struts.user.action.UserAction.errors.noType");
        } else {
            // check if territory type is expected type
            TerritoryDto lUserTerritory = pUser.getTerritory();
            if ((pUser.getForm() != pUser.getCreationFormId())
                && (lUserTerritory != null)
                && (lUserTerritory.getType() != pUser.getType().getTerritoryTypeExpected())) {
                // reset territory
                pUser.setTerritory(null);
            }
            // adminstrators case
            if (pUser.isGeneralAdmin()) {
                // build a virtual territory of type "all"
                pUser.setTerritory(TerritoryDto.getSuperVirtualTerritory());
            }

        }

        // check validity date
        //if ((pUser.getForm()== pUser.getDateFormId())&&(!user.getPermanent())) {
        if (!user.isPermanent()) {
            try {

                // build date (!month are 0 based)
                Calendar lCal = Calendar.getInstance();
                lCal.setLenient(true);
                lCal.set(Calendar.DAY_OF_MONTH, user.getValidityEndDateDay());
                lCal.set(Calendar.MONTH, user.getValidityEndDateMonth() - 1);
                lCal.set(Calendar.YEAR, user.getValidityEndDateYear());
                lCal.set(Calendar.HOUR_OF_DAY, 1);
                lCal.set(Calendar.MINUTE, 0);
                lCal.set(Calendar.SECOND, 0);
                lCal.setLenient(false);
                lCal.getTime();

                // set user's date
                user.setValidityEndDate(lCal);

            } catch (Exception e) {
                throw new SispeaException("fr.onema.sispea.struts.user.action.UpdateUserDatesAction.errors.wrongDate", e);
            }
        }

        //Mantis 4272
        Pattern p = Pattern.compile("[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?");
        Matcher m = p.matcher(user.getEmail());
        if (!m.matches())
            throw new SispeaException("fr.onema.sispea.struts.user.action.UserAction.errors.noValidEmail");


        // result
        return pUser;
    }

    /**
     * check user's form
     */
    public void setForm() {

        // check if form is set
        if (getSubmitValue() == null) {
            user.setForm(user.getNoFormId());
        } else {
            // check user form
            if (getSubmitValue().equals(getText("fr.onema.sispea.jsp.user.showUser.btnEdit"))) {
                user.setForm(user.getUserFormId());
            } else if (getSubmitValue().equals(getText("fr.onema.sispea.jsp.user.showUser.btnEditConnexionIds"))) {
                user.setForm(user.getIdsFormId());
            } else if (getSubmitValue().equals(getText("fr.onema.sispea.jsp.user.showUser.btnEditTerritory"))) {
                user.setForm(user.getTerritoryFormId());
            } else if (getSubmitValue().equals(getText("fr.onema.sispea.jsp.user.showUser.btnEditDate"))) {
                user.setForm(user.getDateFormId());
            } else if (getSubmitValue().equals(getText("fr.onema.sispea.jsp.user.showUser.btnAddTerritory"))) {
                user.setForm(user.getTerritoryFormId());
            }
        }
    }

    /**
     * check if user is corrupted
     */
    public void checkUserCorruption() {
        if ((user != null) && (user.isCorrupted())) {
            String[] lParams = new String[]{user.getLogin(), getText(user.getCorruptionMessage(), "")};
            addActionError(getText("fr.onema.sispea.jsp.user.showUsers.corrution", lParams));
        }
    }

    /**
     * return true if editing profile, false else
     */
    public Boolean editingProfile() {
        // init result
        Boolean lRes;
        String lTestLogin;

        // auth user
        UserDto lSessionUser = getSispeaSession().getUser();

        //check if login has changed
        if (!user.loginChanged()) {
            // login has not changed -> check current user login
            lTestLogin = user.getLogin();
        } else {
            // login has changed, test with old login
            lTestLogin = user.getOldLogin();
        }

        // check login
        lRes = ((lTestLogin != null) && (lTestLogin.equals(lSessionUser.getLogin())));

        // result
        return lRes;
    }

    /**
     * Update the lastUpdateDate field from the user associated to the session,
     * with the current time.
     */
    protected void updateLastUpdateDateWithCurrentTime() {
        // We get the local current time, as a calendar
        final Calendar currentTimeCalendar = Calendar.getInstance();
        // We set the lastUpdateDate field with this value
        user.setLastUpdateDate(currentTimeCalendar);
    }


    /**
     * @return true if user type can be edited, false else
     */
    public Boolean getCanEditType() {
        // init
        Boolean lRes = false;

        // user's not editing profile
        if (!editingProfile()) {
            // user form id ?
            if (user.getForm() == user.getUserFormId()) {
                lRes = true;
            } else if (user.getForm() == user.getCreationFormId()) {
                lRes = ((user.getType() == null) || (user.getType() == UserType.Anonym));
            }
        }

        // result
        return lRes;

    }

    public UserFormBean getUser() {
        return user;
    }

    /**
     * @return user types
     */
    public Map<String, String> getUserTypes() {
        //init list
        HashMap<String, String> lRes = new HashMap<>();

        // get current user type
        UserDto lCurrentUser = getSispeaSession().getUser();
        if (lCurrentUser != null) {

            // get the allowed user type for current user
            for (UserType lUserType : lCurrentUser.getType().getIncludedTypes()) {
                if (lUserType.isAvailable()) {
                    lRes.put(lUserType.name(), getText(lUserType.getLabelKey()));
                }
            }

        }


        return lRes;
    }

    public UsersFormDto getForm() {
        return form;
    }

    public void setForm(UsersFormDto pForm) {
        form = pForm;
    }

    public PagingDto getPaging() {
        return paging;
    }

    public void setPaging(PagingDto pPaging) {
        paging = pPaging;
    }

}
