package fr.onema.sispea.struts.synthesis.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


/**
 * This enumeration represents synthesis chart type.
 *
 * @author CS
 */
public enum SynthesisChartType {
    Category(1),
    Scatter(2),
    BoxAndWhisker(3);

    /**
     * The resource keys prefix for the enumerated type.
     */
    public static final String PREFIX = "fr.onema.sispea.struts.synthesis.bean.chartType.";

    /**
     * The data detail type id.
     */
    private int id = -1;

    /**
     * The reliability internationalization Key.
     */
    private String labelKey = null;

    /**
     * Default constructor.
     *
     * @param pId The type ID.
     */
    SynthesisChartType(int pId) {
        id = pId;
        labelKey = PREFIX + id;
    }

    /**
     * This method parse a string and return a type value.
     *
     * @param pId The string to parse as a type.
     */
    public static SynthesisChartType parseFromId(int pId) {
        SynthesisChartType result = null;

        // If we find that one of the enum ID is equal to the given ID, we
        // return the corresponding enum type value.
        for (SynthesisChartType type : SynthesisChartType.values()) {
            if (type.getId() == pId) {
                result = type;
                break;
            }
        }

        // If execution goes here, no enum value has been recognized.
        return result;
    }

    // Getters and setters.

    public int getId() {
        return id;
    }

    public String getLabelKey() {
        return labelKey;
    }

    public boolean isSliceRequired() {
        return this == SynthesisChartType.Scatter;
    }

}
