package fr.onema.sispea.struts.synthesis.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.synthesis.ChartValueDto;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * This class is modeling a pie chart value to be rendered by the JWebChart servlet.
 *
 * @author CS
 */
public class PieValueBean extends ChartValueDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * The value.
     */
    protected String value = null;

    public PieValueBean() {
    }

    public PieValueBean(String pName, int pValue) {
        super(pName);
        value = String.valueOf(pValue);
    }

    public PieValueBean(String pName, double pValue) {
        super(pName);
        value = String.valueOf(pValue);
    }

    @Override
    public String getEncodedValue() throws UnsupportedEncodingException {
        return URLEncoder.encode(value, ENCODING);
    }

    /**
     * @return The value to be used in the url for this value.
     */
    public String getValue() {
        return value;
    }

}
