package fr.onema.sispea.struts.synthesis.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.CriterionDto;
import fr.onema.sispea.service.data.CriterionType;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.data.IndicatorDto;
import fr.onema.sispea.service.data.IndicatorService;
import fr.onema.sispea.service.data.IndicatorValueDto;
import fr.onema.sispea.service.data.SPEALotStatus;
import fr.onema.sispea.service.data.SliceDto;
import fr.onema.sispea.service.data.SliceService;
import fr.onema.sispea.service.data.SliceValuesDto;
import fr.onema.sispea.service.data.SynthDisplayDto;
import fr.onema.sispea.service.data.VPValueDto;
import fr.onema.sispea.service.data.Verification;
import fr.onema.sispea.service.referential.CompetenceDto;
import fr.onema.sispea.service.referential.OrganismType;
import fr.onema.sispea.service.referential.ReferentialService;
import fr.onema.sispea.service.synthesis.ScatterChartDto;
import fr.onema.sispea.service.synthesis.ScatterValueDto;
import fr.onema.sispea.service.synthesis.SliceVisibilityChecker;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.service.user.UserType;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.struts.referential.action.AbstractExerciseListAction;
import fr.onema.sispea.struts.synthesis.bean.BoxAndWhiskerChartBean;
import fr.onema.sispea.struts.synthesis.bean.CategoryChartBean;
import fr.onema.sispea.struts.synthesis.bean.CategoryValueBean;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * This action defines the synthesis pages.
 *
 * @author CS
 */
public abstract class AbstractSynthesisAction extends AbstractExerciseListAction {

    private static final long serialVersionUID = 1L;

    /**
     * The graph sizes
     */
    private static final int CATEGORY_CHART_WIDTH = 750;

    private static final int CATEGORY_CHART_HEIGHT = 350;

    private static final int CATEGORY_CHART_WIDTH_SMALL = 330;

    private static final int CATEGORY_CHART_HEIGHT_SMALL = 250;

    private static final int SCATTER_CHART_WIDTH = 750;

    private static final int SCATTER_CHART_HEIGHT = 400;

    private static final int SCATTER_CHART_WIDTH_SMALL = 330;

    private static final int SCATTER_CHART_HEIGHT_SMALL = 250;

//    private static final int BOXANDWHISKER_CHART_WIDTH = 750;
//
//    private static final int BOXANDWHISKER_CHART_HEIGHT = 400;
//
//    private static final int BOXANDWHISKER_CHART_SERIES_COUNT = 15;

    private static final int MAX_PERCENTAGE = 100;

//    private static final Logger logger = Logger.getLogger(AbstractSynthesisAction.class);

    @Autowired
    protected transient ReferentialService referentialService;

    @Autowired
    protected transient IndicatorService indicatorService;

    @Autowired
    protected transient SliceService sliceService;

    /**
     * competence id to display
     */
    protected Integer competenceId;

    /**
     * competence to display
     */
    protected CompetenceDto competence;

    /**
     * List of indicator.
     */
    protected Collection<IndicatorDto> indicators;

    /**
     * selectedIndicator :
     */
    protected Integer chosenIndicatorId;

    /**
     * The Indicator selected
     */
    protected IndicatorDto indicator;

    /**
     * exercise list
     */
    protected List<CriterionDto> criteria;

    /**
     * selected Criterion id
     */
    protected Integer chosenCriterionId;

    /**
     * selected Criterion :
     */
    protected CriterionDto criterion;

    /**
     * Slices :
     */
    protected List<SliceDto> slices = new ArrayList<>();

    /**
     * Selected slice :
     */
    protected Integer chosenSliceId;

    /**
     * Selected slice
     */
    protected SliceDto slice;

    /**
     * Selected slice year
     */
    protected Short sliceYear;

    /**
     * slicesValues_ :
     */
    protected List<SliceValuesDto> slicesConsolidatedValues = new ArrayList<>();

    /**
     * The scatter chart Synthesis generated by the action .
     */
    protected CategoryChartBean categoryChart;

    /**
     * The scatter chart generated by the action.
     */
    protected ScatterChartDto scatterChart;

    /**
     * The scatter chart generated by the action.
     */
    protected BoxAndWhiskerChartBean boxAndWhiskerChart;

    /**
     * Table of ip values for drawing.
     */
    protected List<IndicatorValueDto> ipValues;

    /**
     * the synth display list
     */
    protected List<SynthDisplayDto> synthDisplays = new ArrayList<>();

//    @Override
//    protected String doExecute() throws Exception {
//
//        //init
//        String lRes = Action.SUCCESS;
//
//        if (logger.isDebugEnabled()) {
//            logger.debug("SynthesisAction : should not be called");
//        }
//
//        return lRes;
//    }

//    /**
//     * param and return graph
//     */
//    protected CategoryChartBean buildBarChart(List<SliceValuesDto> pSlicesValues, IndicatorDto pIndicator, boolean pSmaller) {
//
//        // check if value add to chart
//        boolean lAtLeatOneValueAdded = false;
//
//        // init chart
//        CategoryChartBean categoryChart = new CategoryChartBean();
//        categoryChart.setXLabel(buildCriterionDescription(true));
//        categoryChart.setYLabel(buildIndicatorDescription(true));
//        categoryChart.setTitle(buildTitleDescription());
//        if (pSmaller) {
//            categoryChart.setWidth(CATEGORY_CHART_WIDTH_SMALL);
//            categoryChart.setHeight(CATEGORY_CHART_HEIGHT_SMALL);
//        } else {
//            categoryChart.setWidth(CATEGORY_CHART_WIDTH);
//            categoryChart.setHeight(CATEGORY_CHART_HEIGHT);
//        }
//
//        // add values
//        for (SliceValuesDto sliceValues : pSlicesValues) {
//
//            // check visibility
//            if (getVisibility(exercise.getId(), pIndicator.getId(), (int) sliceValues.getSlice().getId(), sliceValues.getNb())) {
//
//                // add if not null
//                if (sliceValues.getMoy() != null) {
//                    // add value to graph
//                    lAtLeatOneValueAdded = true;
//
//                    //String lLabel = sliceValues.getSlice().getXMin() + "-" + sliceValues.getSlice().getXMax();
//                    String lLabel = sliceValues.getSlice().getLabel();
//                    categoryChart.add(new CategoryValueBean(getText("fr.onema.sispea.jsp.synthesis.showTypologySynthesis.field.chartMin"),
//                                                            lLabel,
//                                                            sliceValues.getMin()));
//                    // add value to graph
//                    categoryChart.add(new CategoryValueBean(getText("fr.onema.sispea.jsp.synthesis.showTypologySynthesis.field.chartMoy"),
//                                                            lLabel,
//                                                            sliceValues.getMoy()));
//                    // add min value to graph
//                    categoryChart.add(new CategoryValueBean(getText("fr.onema.sispea.jsp.synthesis.showTypologySynthesis.field.chartMax"),
//                                                            lLabel,
//                                                            sliceValues.getMax()));
//                }
//            }
//        }
//
//        // update max Y value if unit needs it
//        if (pIndicator.getUnit() != null && pIndicator.getUnit().getSymbol().equals("%")) {
//            categoryChart.setYMaxValue((float) MAX_PERCENTAGE);
//        }
//
//        // empty graph ?
//        if (!lAtLeatOneValueAdded) {
//            categoryChart = null;
//        }
//
//        // result
//        return categoryChart;
//
//    }

    /**
     * return a point cloud chart for typology synthesis for one slice
     *
     * @param pSpeaIds
     * @param pIndicator
     * @param pCriterion
     * @return
     * @throws SispeaException
     */
    protected ScatterChartDto getChartSynthesisBySlice(List<Integer> pSpeaIds, List<Integer> pOwnSpeaIds, IndicatorDto pIndicator,
                                                       CriterionDto pCriterion, SliceDto pSlice, List<SliceValuesDto> pSliceValues, boolean pSmaller) throws SispeaException {

        // initialization
        ScatterChartDto scatterChart = new ScatterChartDto();
        List<ScatterValueDto> lCommonSerie = new ArrayList<>();
        List<ScatterValueDto> lMyAnomalySerie = new ArrayList<>();
        List<ScatterValueDto> lMySerie = new ArrayList<>();
        List<ScatterValueDto> lOtherSerie = new ArrayList<>();
        String lCommonSerieName = getText("fr.onema.sispea.struts.synthesis.action.synthesis.OK.common");
        String lMyAnomalySerieName = getText("fr.onema.sispea.struts.synthesis.action.synthesis.KO.my");
        String lMySerieName = getText("fr.onema.sispea.struts.synthesis.action.synthesis.OK.my");
        String lOtherSerieName = getText("fr.onema.sispea.struts.synthesis.action.synthesis.OK.other");
        boolean lAtLeastOneValue = false;

        // check visibility
        SliceValuesDto lSliceValues = null;
        for (Iterator<SliceValuesDto> iterator = pSliceValues.iterator(); iterator.hasNext() && lSliceValues == null; ) {
            SliceValuesDto lTmpSliceValues = iterator.next();
            if (pSlice.getId() == lTmpSliceValues.getSlice().getId()) {
                lSliceValues = lTmpSliceValues;
            }
        }

        // nb values
        Integer lNbValues = 0;
        if (lSliceValues != null && lSliceValues.getNb() != null) {
            lNbValues = lSliceValues.getNb();
        }

        // check visibility
        if (getVisibility(exercise.getId(), pIndicator.getId(), (int) pSlice.getId(), lNbValues)) {

            // chart params
            scatterChart.setTitle(buildTitleDescription());
            if (pSmaller) {
                scatterChart.setWidth(SCATTER_CHART_WIDTH_SMALL);
                scatterChart.setHeight(SCATTER_CHART_HEIGHT_SMALL);
            } else {
                scatterChart.setWidth(SCATTER_CHART_WIDTH);
                scatterChart.setHeight(SCATTER_CHART_HEIGHT);
            }
            scatterChart.setXLabel(buildCriterionDescription(true));
            scatterChart.setYLabel(buildIndicatorDescription(true));

            // allowed lot status type
            List<Short> lStatusIdList = buildAllowedStatusIds();

            // prepare series titles
            if (canViewItsOwnServices(getCurrentUser())) {
                scatterChart.getTitleSeries().add(lMyAnomalySerieName);
                scatterChart.getTitleSeries().add(lMySerieName);
                scatterChart.getTitleSeries().add(lOtherSerieName);
            } else {
                scatterChart.getTitleSeries().add(lCommonSerieName);
            }

            //for all spea selected :
            for (Integer lSpeaId : pSpeaIds) {

                // init status
                Boolean lYStatusOK;
                Boolean lXStatusOK = false;
                Double lYValue;
                Double lXValue = null;

                //get indicator value :
                IndicatorValueDto indicValue = indicatorService.findIndicatorValueByIp(pIndicator.getId(), lSpeaId, chosenExerciseId, lStatusIdList);
                if ((indicValue != null) && (!indicValue.isEmpty())) {

                    // save value and status
                    lYStatusOK = indicValue.getVerification() != Verification.Anomaly;
                    lYValue = indicValue.getFloatValue();

                    // get criterion
                    IndicatorValueDto lCriterionIpValue;
                    VPValueDto lCriterionPvValue;

                    //if criterion is a indicator :
                    if (pCriterion.getIndicator() != null) {

                        // get indicator value and associated status
                        lCriterionIpValue = indicatorService.findIndicatorValueByIp(pCriterion.getIndicator().getId(), lSpeaId, chosenExerciseId, lStatusIdList);
                        if ((lCriterionIpValue != null) && (!lCriterionIpValue.isEmpty())) {
                            lXValue = lCriterionIpValue.getFloatValue();
                            lXStatusOK = lCriterionIpValue.getVerification() != Verification.Anomaly;
                        }

                    } else if (pCriterion.getPv() != null) {

                        // if criterion is a VP :
                        // status is OK for VP
                        lXStatusOK = true;
                        //get value
                        lCriterionPvValue = indicatorService.findVpValueByVp(pCriterion.getPv().getId(), lSpeaId, chosenExerciseId, lStatusIdList);
                        if ((lCriterionPvValue != null) && (!lCriterionPvValue.isEmpty())) {
                            lXValue = lCriterionPvValue.getFloatValue();
                            lXStatusOK = true;
                        }
                    } else if (pCriterion.getCd() != null) {

                        // if criterion is a CD :
                        // status is OK for CD
                        lXStatusOK = true;
                        //get value
                        lCriterionPvValue = indicatorService.findVpValueByVp(pCriterion.getPv().getId(), lSpeaId, chosenExerciseId, lStatusIdList);
                        if ((lCriterionPvValue != null) && (!lCriterionPvValue.isEmpty())) {
                            lXValue = lCriterionPvValue.getFloatValue();
                            lXStatusOK = true;
                        }
                    }

                    //add value in graph:
                    if ((lYValue != null) && (lXValue != null)) {

                        // chart serie
                        List<ScatterValueDto> lChartSerie;
                        String lChartSerieName;

                        // status check
                        if ((lYStatusOK) && (lXStatusOK)) {

                            // display own spea ?
                            if (pOwnSpeaIds.contains(lSpeaId)) {
                                lChartSerie = lMySerie;
                                lChartSerieName = lMySerieName;
                            } else if (canViewItsOwnServices(getCurrentUser())) {
                                lChartSerie = lOtherSerie;
                                lChartSerieName = lOtherSerieName;
                            } else {
                                lChartSerie = lCommonSerie;
                                lChartSerieName = lCommonSerieName;
                            }
                        } else {
                            if (pOwnSpeaIds.contains(lSpeaId)) {
                                lChartSerie = lMyAnomalySerie;
                                lChartSerieName = lMyAnomalySerieName;
                            } else {
                                lChartSerie = null;
                                lChartSerieName = null;
                            }
                        }

                        // add ?
                        if (lChartSerie != null) {
                            lChartSerie.add(new ScatterValueDto(lChartSerieName, Double.valueOf(lXValue), Double.valueOf(lYValue)));

                            // added !
                            lAtLeastOneValue = true;
                        }
                    }
                }
            }
        }

        // empty chart ?
        if (!lAtLeastOneValue) {
            scatterChart = null;
        } else {

            // add series in proper order
            // series titles
            if (canViewItsOwnServices(getCurrentUser())) {
                // three series
                addScatterValueToChart(scatterChart, lMyAnomalySerie);
                addScatterValueToChart(scatterChart, lMySerie);
                addScatterValueToChart(scatterChart, lOtherSerie);
            } else {
                // just a simple serie with data without anomaly
                addScatterValueToChart(scatterChart, lCommonSerie);
            }
        }

        return scatterChart;
    }

    /**
     * adds the value of the list in the chart object
     *
     * @param pScatterChart
     * @param pSerie
     */
    protected void addScatterValueToChart(ScatterChartDto pScatterChart, List<ScatterValueDto> pSerie) {
        for (ScatterValueDto lValue : pSerie) {
            pScatterChart.add(lValue);
            if (!pScatterChart.getTitleSeries().contains(lValue.getName())) {
                pScatterChart.getTitleSeries().add(lValue.getName());
            }
        }
    }

    /**
     * check parameters and raise exception if not valid
     */
    protected void checkAndGetParameters(boolean pGlobalSynthesis, boolean pCheckConsolidation) throws SispeaException {

        // get synthDisplays
        synthDisplays = indicatorService.readAllSynthDisplay();

        // check exercise
        checkExercise();

        // check competence id
        checkAndGetCompetence();

        // load Indicator
        checkAndGetIndicator(pGlobalSynthesis, pCheckConsolidation);

        // load criterion
        checkAndGetCriterion(pGlobalSynthesis);

        // load slices
        checkAndGetSlices(pGlobalSynthesis);
    }

    /**
     * check competence parameters and raise exception if not valid
     *
     * @throws SispeaException
     */
    protected void checkAndGetCompetence() throws SispeaException {

        // check competence id
        if (competenceId == null) {
            throw new SispeaException("fr.onema.sispea.struts.synthesis.action.synthesis.error.noCompetenceId");
        }

        // get competence
        competence = referentialService.readCompetence(competenceId);
        if (competence == null) {
            throw new SispeaException("fr.onema.sispea.struts.synthesis.action.synthesis.error.wrongCompetenceId");
        } else if ((!competence.isDrinkingWater())
                   && (!competence.isCollectivePurification())
                   && (!competence.isNotCollectivePurification())) {
            throw new SispeaException("fr.onema.sispea.struts.synthesis.action.synthesis.error.wrongCompetenceId");
        }
    }

    /**
     * check indicator parameter and raise exception if not valid
     *
     * @throws SispeaException
     */
    protected void checkAndGetIndicator(boolean pGlobalSynthesis, boolean pCheckConsolidation) throws SispeaException {

        // read
        indicators = indicatorService.getIndicatorsByCompetence(competence);

        // remove indicators not consolidated and find selected one
        for (Iterator<IndicatorDto> iterator = indicators.iterator(); iterator.hasNext(); ) {
            IndicatorDto lIndicator = iterator.next();

            // check consolidation
            if (pCheckConsolidation && !lIndicator.getHasConsolidation()) {
                iterator.remove();
            } else if ((!pGlobalSynthesis) && lIndicator.getId().equals(chosenIndicatorId)) {
                indicator = lIndicator;
            }
        }

        // proper indicator ?
        if ((!pGlobalSynthesis) && chosenIndicatorId != null && indicator == null) {
            throw new SispeaException("fr.onema.sispea.struts.synthesis.action.synthesis.error.wrongIndicatorId");
        }

    }

    /**
     * check criterion parameter and raise exception if not valid
     *
     * @throws SispeaException
     */
    protected void checkAndGetCriterion(boolean pGlobalSynthesis) throws SispeaException {

        if (!pGlobalSynthesis) {

            // criterion types to load
            List<Byte> lCriterionTypesIds = new ArrayList<>();
            lCriterionTypesIds.add(CriterionType.IP.getId());
            lCriterionTypesIds.add(CriterionType.VP.getId());
            if (indicator != null && indicator.getReferenceOfCriterion() != null) {
                lCriterionTypesIds.add(CriterionType.Ponderation.getId());
            }

            // load criteria
            criteria = indicatorService.getCriteriaByCompetence(competence, lCriterionTypesIds);

            // remove indicators not consolidated and find selected one
            for (CriterionDto lCriterion : criteria) {
                if (Integer.valueOf(lCriterion.getId()).equals(chosenCriterionId)) {
                    criterion = lCriterion;
                }
            }
        }
    }

    /**
     * check slice parameter and raise exception if not valid
     *
     * @throws SispeaException
     */
    protected void checkAndGetSlices(boolean pGlobalSynthesis) throws SispeaException {

        // criterion chosen ?
        if (criterion != null && (!pGlobalSynthesis)) {

            // What kind of Criterion
            if (criterion.getType() == CriterionType.IP || criterion.getType() == CriterionType.VP) {

                // IP or VP Criterion chosen

                // load slices
                slices = indicatorService.getSliceByCriterionAndCompetence(criterion.getId(), competence.getId());

            } else {

                // Ponderation Criterion chosen

                // retrieve the ponderation criterion assiociated with the indicator
                CriterionDto pounderationCriterion = indicator.getReferenceOfCriterion();
                if (pounderationCriterion != null) {
                    // load slices
                    slices = indicatorService.getSliceByCriterionAndCompetence(pounderationCriterion.getId(), competence.getId());
                } else {
                    slices = null;
                }

            }

            // If slices are found
            if (slices != null && !slices.isEmpty()) {

                // get slice values :
                slicesConsolidatedValues = indicatorService.getSlicesValues(slices, indicator.getId(), exercise.getId());

                // find selected slice
                if (chosenSliceId != null) {
                    for (Iterator<SliceDto> iterator = slices.iterator(); iterator.hasNext() && slice == null; ) {
                        SliceDto lSlice = iterator.next();
                        if (lSlice.getId() == chosenSliceId.shortValue()) {
                            slice = lSlice;
                        }
                    }
                }

                // when changing criterion, no slice found -> select first slice
                if (slice == null || chosenSliceId == null) {
                    slice = slices.get(0);
                    chosenSliceId = (int) slice.getId();
                }
            }
        }
    }

    /**
     * do the job for bar synthesis display
     *
     * @throws SispeaException
     */
    protected void processBarChart(ExerciseDto exercise, IndicatorDto indicator, List<SliceValuesDto> slicesConsolidatedValues, boolean pSmaller) throws SispeaException {

        // display for this exercice and indicator ?
        if (getVisibility(exercise.getId(), indicator.getId())) {

            // build graph
            if ((slicesConsolidatedValues == null) || (slicesConsolidatedValues.size() == 0)) {
                categoryChart = null;
            } else {

//                categoryChart = buildBarChart(pSmaller);

                // check if value add to chart
                boolean lAtLeatOneValueAdded = false;

                // init chart
                categoryChart = new CategoryChartBean();
                categoryChart.setXLabel(buildCriterionDescription(true));
                categoryChart.setYLabel(buildIndicatorDescription(true));
                categoryChart.setTitle(buildTitleDescription());
                if (pSmaller) {
                    categoryChart.setWidth(CATEGORY_CHART_WIDTH_SMALL);
                    categoryChart.setHeight(CATEGORY_CHART_HEIGHT_SMALL);
                } else {
                    categoryChart.setWidth(CATEGORY_CHART_WIDTH);
                    categoryChart.setHeight(CATEGORY_CHART_HEIGHT);
                }

                // add values
                for (SliceValuesDto sliceValues : slicesConsolidatedValues) {

                    // check visibility
                    if (getVisibility(exercise.getId(), indicator.getId(), (int) sliceValues.getSlice().getId(), sliceValues.getNb())) {

                        // add if not null
                        if (sliceValues.getMoy() != null) {
                            // add value to graph
                            lAtLeatOneValueAdded = true;

                            //String lLabel = sliceValues.getSlice().getXMin() + "-" + sliceValues.getSlice().getXMax();
                            String lLabel = sliceValues.getSlice().getLabel();
                            categoryChart.add(new CategoryValueBean(getText("fr.onema.sispea.jsp.synthesis.showTypologySynthesis.field.chartMin"),
                                                                    lLabel,
                                                                    sliceValues.getMin()));
                            // add value to graph
                            categoryChart.add(new CategoryValueBean(getText("fr.onema.sispea.jsp.synthesis.showTypologySynthesis.field.chartMoy"),
                                                                    lLabel,
                                                                    sliceValues.getMoy()));
                            // add min value to graph
                            categoryChart.add(new CategoryValueBean(getText("fr.onema.sispea.jsp.synthesis.showTypologySynthesis.field.chartMax"),
                                                                    lLabel,
                                                                    sliceValues.getMax()));
                        }
                    }
                }

                // update max Y value if unit needs it
                if (indicator.getUnit() != null && indicator.getUnit().getSymbol().equals("%")) {
                    categoryChart.setYMaxValue((float) MAX_PERCENTAGE);
                }

                // empty graph ?
                if (!lAtLeatOneValueAdded) {
                    categoryChart = null;
                }
            }

            // Put the chart into the session so that the JWebChart servlet can access it.
            getSession().put("CATEGORY_CHART", categoryChart);
        }
    }

//    /**
//     * do the job for box and whisker synthesis display
//     *
//     * @throws SispeaException
//     * @throws SispeaException
//     */
//    protected void processBoxAndWhiskerChart(List<SliceDto> pSlices) throws SispeaException {
//
//        // init
//        List<SliceDto> lSlices = new ArrayList<>(pSlices);
//
//        // initialization of box and whisker chart
//        boxAndWhiskerChart = new BoxAndWhiskerChartBean();
//
//        // chart params
//        boxAndWhiskerChart.setTitle(buildTitleDescription());
//        boxAndWhiskerChart.setWidth(BOXANDWHISKER_CHART_WIDTH);
//        boxAndWhiskerChart.setHeight(BOXANDWHISKER_CHART_HEIGHT);
//        boxAndWhiskerChart.setXLabel(buildCriterionDescription(true));
//        boxAndWhiskerChart.setYLabel(buildIndicatorDescription(true));
//        getSession().put("BOX_AND_WHISKER_CHART", boxAndWhiskerChart);
//
//        // allowed lot status type
//        List<Short> lStatusIdList = buildAllowedStatusIds();
//
//        if (lSlices.size() < BOXANDWHISKER_CHART_SERIES_COUNT) {
//            for (int i = lSlices.size() + 1; i <= BOXANDWHISKER_CHART_SERIES_COUNT; i++) {
//                SliceDto lSlice = new SliceDto();
//                short lId = -1;
//                lSlice.setId(lId);
//                String lLabel = "";
//                for (int j = 0; j < i; j++) {
//                    lLabel = lLabel + " ";
//                }
//                lSlice.setLabel(lLabel);
//                lSlices.add(lSlice);
//            }
//        }
//
//        // build box and whisker chart lopping on each slice
//        for (SliceDto lSlice : lSlices) {
//            // init slice value list
//            List<Double> lSliceValues = new ArrayList<>();
//
//            if (lSlice.getId() >= 0) {
//                // get SPEA in slice :
//                List<Integer> speaIds = referentialService.readBySlice(lSlice.getId(), exercise.getId());
//
//                // build value list for box and whisker
//                for (Integer lSpeaId : speaIds) {
//                    // read IP value
//                    IndicatorValueDto lIndicatorValue = indicatorService.findIndicatorValueByIp(indicator.getId(),
//                                                                                                lSpeaId, exercise.getId(), lStatusIdList);
//
//                    // add to slice data list
//                    if (lIndicatorValue != null
//                        && lIndicatorValue.getFloatValue() != null
//                        && (!lIndicatorValue.isEmpty())
//                        && lIndicatorValue.getVerification() != Verification.Anomaly) {
//                        lSliceValues.add(lIndicatorValue.getFloatValue());
//                    }
//                }
//            }
//
//            // box and whisker chart value
//            BoxAndWhiskerValueBean lChartValue = new BoxAndWhiskerValueBean(buildIndicatorDescription(false),
//                                                                            lSlice.getLabel(), lSliceValues);
//            boxAndWhiskerChart.add(lChartValue);
//        }
//    }

    /**
     * do the job for box and whisker synthesis display
     *
     * @throws SispeaException
     */
    protected void processScatterChart(SliceDto slice, boolean pSmaller) throws SispeaException {

        // get SPEA in slice :
        // Mantis 4275 : all data are displayed (all lot status and all data verifications)
        boolean allData = true;
        List<Integer> speaIds = referentialService.readBySlice(this.slice.getId(), exercise.getId(), allData);

        // if user is collectivity or spea -> read its spea(s) ids
        List<Integer> lOwnSpeaIds = new ArrayList<>();
        UserDto lUser = getCurrentUser();
        if (lUser != null && canViewItsOwnServices(lUser)) {
            // search for user's speas
            lOwnSpeaIds = territoryService.searchIncludedOrganimIds(lUser.getTerritory(), OrganismType.SPEA, exercise);
        }

        // chart
        if (criterion.getType() == CriterionType.Ponderation) {
            scatterChart = getChartSynthesisBySlice(speaIds, lOwnSpeaIds, indicator, indicator.getReferenceOfCriterion(), this.slice,
                                                    slicesConsolidatedValues, pSmaller);
        } else {
            scatterChart = getChartSynthesisBySlice(speaIds, lOwnSpeaIds, indicator, criterion, this.slice,
                                                    slicesConsolidatedValues, pSmaller);
        }

        if (scatterChart != null) {
            scatterChart.setSessionChartName("SCATTER_CHART_SYNTHESIS");

            // Put the chart into the session so that the JWebChart servlet can access it.
            getSession().put(scatterChart.getSessionChartName(), scatterChart);
        }
    }

    /**
     * @return true if current user can view its own servcies on graph
     */
    protected boolean canViewItsOwnServices(UserDto pUser) {
        // init
        boolean lRes = false;

        // allowed user types
        List<UserType> lAllowedTypes = new ArrayList<>();
        lAllowedTypes.add(UserType.Collectivity);
        lAllowedTypes.add(UserType.SPEA);

        // check type
        if (pUser != null && lAllowedTypes.contains(pUser.getType())) {
            // search for user's speas
            lRes = true;
        }

        // reuslt
        return lRes;
    }

    /**
     * @param pGlobalSynthsesis true if called from global synthesis, false else
     * @return the menu to open
     */
    public String getMenuKey(Boolean pGlobalSynthsesis) {
        // init result
        String lRes = null;

        if (competence != null) {
            if (competence.isDrinkingWater()) {
                if (pGlobalSynthsesis) {
                    lRes = MenuConstants.MENU_KEY_SYN_DRINKINGWATER;
                } else {
                    lRes = MenuConstants.MENU_KEY_TYP_DRINKINGWATER;
                }
            } else if (competence.isCollectivePurification()) {
                if (pGlobalSynthsesis) {
                    lRes = MenuConstants.MENU_KEY_SYN_COLLPURIFIC;
                } else {
                    lRes = MenuConstants.MENU_KEY_TYP_COLLPURIFIC;
                }
            } else if (competence.isNotCollectivePurification()) {
                if (pGlobalSynthsesis) {
                    lRes = MenuConstants.MENU_KEY_SYN_NOTCOLLPURIFIC;
                } else {
                    lRes = MenuConstants.MENU_KEY_TYP_NOTCOLLPURIFIC;
                }
            }
        } else {
            if (pGlobalSynthsesis) {
                lRes = MenuConstants.MENU_KEY_WHOLEFRANCE;
            } else {
                lRes = MenuConstants.MENU_KEY_TYPOLOGY;
            }
        }

        // result
        return lRes;
    }

    protected List<Short> buildAllowedStatusIds() {

        // allowed lot status type
        List<Short> lRes = new ArrayList<>();
        lRes.add(SPEALotStatus.WaitingForInput.getId().shortValue());
        lRes.add(SPEALotStatus.InputInProgress.getId().shortValue());
        lRes.add(SPEALotStatus.WaitingForVerification.getId().shortValue());
        lRes.add(SPEALotStatus.VerificationInProgress.getId().shortValue());
        lRes.add(SPEALotStatus.Verified.getId().shortValue());
        lRes.add(SPEALotStatus.Published.getId().shortValue());
        return lRes;
    }

    /**
     * @return a title for chart
     */
    protected String buildTitleDescription() {

        // build criterion description
        List<Object> lParams = new ArrayList<>();
        lParams.add(buildIndicatorDescription(false));
        lParams.add(buildCriterionDescription(false));
        String lRes = getText("fr.onema.sispea.jsp.synthesis.showTypologySynthesis.chart.title", lParams);

        return lRes;
    }

    /**
     * @return a description of selected criterion
     */
    protected String buildCriterionDescription(boolean pOnlyUnit) {

        // init
        String lRes = "";
        CriterionDto lCriterion = criterion;
        if (criterion.getType() == CriterionType.Ponderation) {
            lCriterion = indicator.getReferenceOfCriterion();
        }

        // build criterion description
        if (!pOnlyUnit) {
            lRes = getText(lCriterion.getName() + ".read");
        } else {
            if (lCriterion.getIndicator() != null) {
                lRes = lCriterion.getIndicator().getUnit().getName();
            } else if (lCriterion.getPv() != null) {
                lRes = lCriterion.getPv().getUnit().getName();
            } else if (lCriterion.getCd() != null) {
                lRes = lCriterion.getCd().getUnit().getName();
            }
        }

        return lRes;
    }

    /**
     * @return a description of selected indicator
     */
    protected String buildIndicatorDescription(boolean pOnlyUnit) {

        // init
        String lRes;

        // build criterion description
        if (!pOnlyUnit) {
            if (exercise == null) {
                lRes = getText(indicator.getName() + ".read");
            } else {
                lRes = getText(indicator.getName() + ".read", exercise.getExerciceParamsForDataName());
            }
        } else {
            lRes = indicator.getUnit().getName();
        }

        return lRes;

    }

    protected Map<String, String> buildCriterionNameMap(Integer chosenExerciseId) throws SispeaException {

        ExerciseDto exercise;
        if (chosenExerciseId == null) {
            exercise = exerciseService.getCurrentExercise();
        } else {
            exercise = exerciseService.readExercise(chosenExerciseId);
        }
        if (exercise == null) {
            throw new SispeaException(getText("fr.onema.sispea.jsp.fixRef.exerciseListAction.error.wrongExerciseId"));
        }

        Map<String, String> criterionNameMap = new HashMap<>();

        for (CriterionDto criterionDto : criteria) {
            List<Object> params = new ArrayList<>();
            params.add(exercise.getDisplayYear(-1));
            params.add(exercise.getDisplayYear(0));
            params.add(exercise.getDisplayYear(1));
            params.add(exercise.getDisplayYear(-2));
            String lRes = getText(criterionDto.getName() + ".read", "", params);
            criterionNameMap.put(criterionDto.getName(), lRes);
        }
        return criterionNameMap;

    }

//    /**
//     * @param pCriterionName
//     * @return the criterion name from the translation key
//     */
//    public String getCriterionName(String pCriterionName) {
//        String lRes = pCriterionName;
//        try {
//            // Retrieve exercise
//            ExerciseDto exercise;
//            if (chosenExerciseId == null) {
//                exercise = exerciseService.getCurrentExercise();
//            } else {
//                exercise = exerciseService.readExercise(chosenExerciseId);
//            }
//            if (exercise == null) {
//                throw new SispeaException(getText("fr.onema.sispea.jsp.fixRef.exerciseListAction.error.wrongExerciseId"));
//            }
//            List<Object> params = new ArrayList<>();
//            params.add(exercise.getDisplayYear(-1));
//            params.add(exercise.getDisplayYear(0));
//            params.add(exercise.getDisplayYear(1));
//            params.add(exercise.getDisplayYear(-2));
//            lRes = getText(pCriterionName + ".read", "", params);
//
//        } catch (Exception e) {
//
//        }
//        return lRes;
//    }

    public Integer getCompetenceId() {
        return competenceId;
    }

    public void setCompetenceId(Integer pCompetenceId) {
        competenceId = pCompetenceId;
    }

    public CompetenceDto getCompetence() {
        return competence;
    }

    public void setCompetence(CompetenceDto pCompetence) {
        competence = pCompetence;
    }

    public Collection<IndicatorDto> getIndicators() {
        return indicators;
    }

    public void setIndicators(Collection<IndicatorDto> pIndicators) {
        indicators = pIndicators;
    }

    public Integer getChosenIndicatorId() {
        return chosenIndicatorId;
    }

    public void setChosenIndicatorId(Integer pChosenIndicatorId) {
        chosenIndicatorId = pChosenIndicatorId;
    }

    public IndicatorDto getIndicator() {
        return indicator;
    }

    public void setIndicator(IndicatorDto pIndicator) {
        indicator = pIndicator;
    }

    public Integer getChosenCriterionId() {
        return chosenCriterionId;
    }

    public void setChosenCriterionId(Integer pChosenCriterionId) {
        chosenCriterionId = pChosenCriterionId;
    }

    public CriterionDto getCriterion() {
        return criterion;
    }

    public void setCriterion(CriterionDto pCriterion) {
        criterion = pCriterion;
    }

    public SliceDto getSlice() {
        return slice;
    }

    public void setSlice(SliceDto pSlice) {
        slice = pSlice;
    }

    public List<SynthDisplayDto> getSynthDisplays() {
        return synthDisplays;
    }

    public void setSynthDisplays(List<SynthDisplayDto> pSynthDisplays) {
        synthDisplays = pSynthDisplays;
    }

    public List<CriterionDto> getCriteria() {
        return criteria;
    }

    public void setCriteria(List<CriterionDto> pCriteria) {
        criteria = pCriteria;
    }

    public List<SliceValuesDto> getSlicesValues() {
        return slicesConsolidatedValues;
    }

    public void setSlicesValues(
            List<SliceValuesDto> pSlicesValues) {
        slicesConsolidatedValues = pSlicesValues;
    }

    public ScatterChartDto getScatterChart() {
        return scatterChart;
    }

    public void setScatterChart(ScatterChartDto pScatterChart) {
        scatterChart = pScatterChart;
    }

    public BoxAndWhiskerChartBean getBoxAndWhiskerChart() {
        return boxAndWhiskerChart;
    }

    public void setBoxAndWhiskerChart(BoxAndWhiskerChartBean pBoxAndWhiskerChart) {
        boxAndWhiskerChart = pBoxAndWhiskerChart;
    }

    public Integer getChosenSliceId() {
        return chosenSliceId;
    }

    public void setChosenSliceId(Integer pChosenSliceId) {
        chosenSliceId = pChosenSliceId;
    }

    public List<SliceValuesDto> getSlicesConsolidatedValues() {
        return slicesConsolidatedValues;
    }

    public void setSlicesConsolidatedValues(
            List<SliceValuesDto> pSlicesConsolidatedValues) {
        slicesConsolidatedValues = pSlicesConsolidatedValues;
    }

    public List<SliceDto> getSlices() {
        return slices;
    }

    public void setSlices(List<SliceDto> pSlices) {
        slices = pSlices;
    }

    public CategoryChartBean getCategoryChart() {
        return categoryChart;
    }

    public void setCategoryChart(CategoryChartBean pCategoryChart) {
        categoryChart = pCategoryChart;
    }

    public String getChartServletUrl() {
        return getOption("sispea.chart.servlet");
    }

    public List<IndicatorValueDto> getIpValues() {
        return ipValues;
    }

    public void setIpValues(List<IndicatorValueDto> pIpValues) {
        ipValues = pIpValues;
    }

    public Short getSliceYear() {
        return sliceYear;
    }

    public void setSliceYear(Short pSliceYear) {
        sliceYear = pSliceYear;
    }

    /**
     * @param pExerciseId
     * @param pIndicatorId
     * @return true if synthesis is displayed for exercise and competence. False else.
     */
    protected boolean getVisibility(Integer pExerciseId, Integer pIndicatorId) {
        return getVisibility(pExerciseId, pIndicatorId, null, null);
    }

    /**
     * @param pExerciseId
     * @param pIndicatorId
     * @return true if synthesis is displayed for exercise and competence. False else.
     */
    protected Boolean getVisibility(Integer pExerciseId, Integer pIndicatorId, Integer pSliceId, Integer pSliceNbValues) {
        boolean isValid = false;
        IndicatorDto indicator = null;
        Short year = null;
        try {
            indicator = indicatorService.readIndicator(pIndicatorId);
            year = exerciseService.readExercise(getChosenExerciseId()).getYear();
        } catch (SispeaException e) {
            //Do nothing
        }
        // VALIDITY : keep non obsolete indicator
        if (indicator != null && year != null) {
            isValid = indicatorService.isInValidityPeriod(indicator.getCode(), year);
        }
        if (!isValid) {
            return false;
        }

        SliceVisibilityChecker checker = new SliceVisibilityChecker();
        return checker.isVisibile(synthDisplays, slices, pExerciseId, pIndicatorId, pSliceId, pSliceNbValues);
    }

}
