package fr.onema.sispea.struts.search.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import java.io.Serializable;

/**
 * This enumeration represents a Back type.
 *
 * @author CS
 */
public enum BackType implements Serializable {

    dashboard(1, "showDashboardInitAction"),
    comparator(2, "showComparatorAction"),
    newSpea(3, "showNewSpeaAction"),
    selections(4, "showUserSelectionsAction"),
    download(5, "initFileDownloadAction"),
    dataLists(6, "showDataListsAction");

    public static final String PREFIX = "fr.onema.sispea.common.jsp.back.";

    /**
     * The database id of the type.
     */
    private int id = -1;

    /**
     * The url to go back to
     */
    private String url = null;

    /**
     * The key label of the object.
     */
    private String labelKey = null;

    /**
     * Default constructor.
     */
    BackType(int pId, String pUrl) {
        id = pId;
        url = pUrl;
        labelKey = PREFIX + name();
    }

    /**
     * This method parse a id and return a type value.
     *
     * @param pId The Integer to parse as a type.
     */
    public static BackType parse(Integer pId) {

        BackType result = null;
        // If we find that one of the enum values Id is equal to the given Integer pId, we return the corresponding enum type value.
        for (BackType type : BackType.values()) {
            if (pId != null && type.getId() == pId) {
                result = type;
                break;
            }
        }

        // If execution goes here, no enum value has been recognized.
        return result;
    }

    // getters and setters

    public int getId() {
        return id;
    }

    public String getUrl() {
        return url;
    }

    public String getLabelKey() {
        return labelKey;
    }

}
