package fr.onema.sispea.struts.referential.xml;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


/**
 * This enumeration represents xml group type.
 *
 * @author CS
 */
public enum XmlGroupType {
    TabGeneral(11),
    TabData(12),

    SubGroup(2),

    DataIndicator(31),
    DataIndicatorDetail(311),
    DataVariable(32),
    DataContext(33),
    DataTitle(34),

    DetailEquipment(41),
    DetailEquipmentData(411),
    DetailDelegateePrice(42),
    DetailDelegateePriceData(421),
    DetailDelegateePriceSliceData(422),
    DetailCollectivityPrice(43),
    DetailCollectivityPriceData(431),
    DetailCollectivityPriceSliceData(432),
    DetailTarifs(44);

    /**
     * The resource keys prefix for the enumerated type.
     */
    public static final String PREFIX = "fr.onema.sispea.referential.xmlGroupType.";

    /**
     * The data detail type id.
     */
    private int id = -1;

    /**
     * The reliability internationalization Key.
     */
    private String labelKey = null;

    /**
     * Default constructor.
     *
     * @param pId The type ID.
     */
    XmlGroupType(int pId) {
        id = pId;
        labelKey = PREFIX + name();
    }

    /**
     * This method parses an identifier and returns a type value.
     *
     * @param pId The id to parse as a type.
     */
    public static XmlGroupType parseFromId(int pId) {

        XmlGroupType result = null;

        // If we find that one of the enum values name is equal to the given id,
        // we return the corresponding enum type value.
        for (XmlGroupType type : XmlGroupType.values()) {
            if (type.getId() == pId) {
                result = type;
                break;
            }
        }

        return result;
    }

    public int getId() {
        return id;
    }

    public String getLabelKey() {
        return labelKey;
    }

}
