package fr.onema.sispea.struts.referential.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.SispeaInputException;
import fr.onema.sispea.service.data.DataDto;
import fr.onema.sispea.service.data.SPEALotDto;
import fr.onema.sispea.struts.referential.action.AbstractSpeaIndicatorsAction;
import org.apache.commons.lang3.BooleanUtils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * This class is a support class to read xml group from a xml file
 *
 * @author CS
 */
public class XmlGroupTable extends XmlGroup {

    /**
     * Generated serial version ID. To be used if the type does not undergo
     * structural changes since its first release.
     */
    private static final long serialVersionUID = 1L;

    /**
     * xml sub group list
     */
    protected List<XmlGroupTableValue> groupTableValues = new ArrayList<>();

    public XmlGroupTable() {
        super();
    }

    public XmlGroupTable(XmlGroupTable pXmlGroup) {
        super(pXmlGroup);
    }

    /**
     * updates the table group and returns it updated
     *
     * @return
     * @throws SispeaException
     */
    public static XmlGroupTable updateXmlGroupTable(SPEALotDto pLot, SPEALotDto pOldLot, int pCompetenceId, Boolean pHasViewRight,
                                                    XmlGroupTable pXmlGroupTable, AbstractSpeaIndicatorsAction pAction) throws SispeaException {

        // init
        XmlGroupTable lXmlGroupTable = pXmlGroupTable;
        List<XmlGroupTableValue> lValues = new ArrayList<>();

        // update tables
        for (XmlGroupTableValue lXmlGroupTableValue : lXmlGroupTable.getGroupTableValues()) {
            // update values
            lXmlGroupTableValue = XmlGroupTableValue.updateXmlGroupTableValue(pLot, pOldLot, pCompetenceId, pHasViewRight, lXmlGroupTableValue, pAction);
            if (lXmlGroupTableValue != null && !lXmlGroupTableValue.isEmpty()) {
                // VALIDITY : keep non obsolete indicator
                Boolean isValid = pAction.getIndicatorService().isInValidityPeriod(lXmlGroupTableValue.getCode(), pLot.getExercise().getYear());
                if (BooleanUtils.isTrue(isValid)) {
                    lValues.add(lXmlGroupTableValue);
                }
            }
        }

        // check the toggle with params
        for (Iterator<XmlGroupTableValue> iterator = lValues.iterator(); iterator.hasNext(); ) {
            XmlGroupTableValue lXmlGroupTableValue = iterator.next();

            // check for the table value
            if (lXmlGroupTableValue.getToggleWith() != null) {

                // find in values with toggle code
                XmlGroupTableValue lValueToToggleWith = XmlGroupTableValue.findTableValueByCodes(lValues, lXmlGroupTableValue.getToggleWith());
                if (lValueToToggleWith != null) {
                    iterator.remove();
                }
            }

            // check for the table value detail
            if (lXmlGroupTableValue.getGroupTableDetails() != null) {
                for (Iterator<XmlGroupTableDetail> iterator2 = lXmlGroupTableValue.getGroupTableDetails().iterator(); iterator2.hasNext(); ) {
                    XmlGroupTableDetail lXmlGroupTableDetail = iterator2.next();

                    // toggle ?
                    if (lXmlGroupTableDetail.getToggleWith() != null) {

                        // find in values with toggle code
                        XmlGroupTableValue lValueToToggleWith = XmlGroupTableValue.findTableValueByCodes(lValues, lXmlGroupTableDetail.getToggleWith());
                        if (lValueToToggleWith != null) {
                            // remove detail !
                            iterator2.remove();
                        }
                    }
                }
            }
        }

        // set list
        lXmlGroupTable.groupTableValues = lValues;

        // result
        return lXmlGroupTable;
    }

    /**
     * updates lot with group data
     *
     * @param pXmlGroupTabs
     * @param pLot
     * @return
     * @throws SispeaException
     */
    public static SPEALotDto updateLotWithGroupData(XmlGroupTable pXmlGroupTable, SPEALotDto pLot) throws SispeaException, SispeaInputException {

        // init
        SPEALotDto lRes = pLot;

        for (XmlGroupTableValue lXmlGroupTableValue : pXmlGroupTable.getGroupTableValues()) {
            // update lot
            lRes = XmlGroupTableValue.updateLotWithGroupData(lXmlGroupTableValue, lRes);
        }

        // result
        return lRes;

    }

    /**
     * return a table detail (or its clone if indicated) corresponding to id passed. Null if not found
     *
     * @param pXmlGroupTableDetailId
     * @param pXmlGroupTabs
     * @param pCloneResult           if true result is the clone, else it's the result its self
     * @return
     */
    public static XmlGroupTableDetail findTableDetail(String pXmlGroupTableDetailId, XmlGroupTable pXmlGroupTable, boolean pCloneResult) {

        // init
        XmlGroupTableDetail lRes = null;

        // search
        for (Iterator<XmlGroupTableValue> iterator = pXmlGroupTable.getGroupTableValues().iterator(); iterator.hasNext() && lRes == null; ) {
            XmlGroupTableValue lXmlGroupTableValue = iterator.next();
            lRes = XmlGroupTableValue.findTableDetail(pXmlGroupTableDetailId, lXmlGroupTableValue, pCloneResult);
        }

        // result
        return lRes;
    }

    public static XmlGroupTableValue findTableDetail(Integer pDetailTypeId, XmlGroupTable pXmlGroupTable) {

        // init
        XmlGroupTableValue lRes = null;
        XmlGroupTableDetail lRes2;

        // search
        for (Iterator<XmlGroupTableValue> iterator = pXmlGroupTable.getGroupTableValues().iterator(); iterator.hasNext() && lRes == null; ) {
            XmlGroupTableValue lXmlGroupTableValue = iterator.next();
            lRes2 = XmlGroupTableValue.findTableDetail(pDetailTypeId, lXmlGroupTableValue);
            if (lRes2 != null) {
                lRes = lXmlGroupTableValue;
            }
        }

        // result
        return lRes;
    }

    /**
     * adds a groupTable to groupTablelist
     *
     * @param pGroupTableValue
     */
    public void add(XmlGroupTableValue pGroupTableValue) {
        groupTableValues.add(pGroupTableValue);
    }

    /**
     * return true if table is empty, false else
     *
     * @return
     */
    public boolean isEmpty() {

        // init
        boolean lRes = true;

        // check tables
        if (groupTableValues != null && groupTableValues.size() > 0) {
            // table empty ?
            for (Iterator<XmlGroupTableValue> iterator = groupTableValues.iterator(); iterator.hasNext() && lRes; ) {
                XmlGroupTableValue lXmlGroupTableValue = iterator.next();

                if (!lXmlGroupTableValue.isEmpty()) {
                    lRes = false;
                }
            }
        }

        // result
        return lRes;
    }

    /**
     * return true if table contains indicator
     *
     * @return
     */
    public boolean containsIndicator() {

        //init
        boolean lRes = false;

        // check tables
        if (groupTableValues != null && groupTableValues.size() > 0) {
            // table empty ?
            for (Iterator<XmlGroupTableValue> iterator = groupTableValues.iterator(); iterator.hasNext() && !lRes; ) {
                XmlGroupTableValue lXmlGroupTableValue = iterator.next();

                if (lXmlGroupTableValue.containsIndicator()) {
                    lRes = true;
                }
            }
        }

        return lRes;
    }

    /**
     * try to replace both group in tab
     *
     * @param pXmlGroupDetailed
     * @param pXmlGroupToDetail
     */
    public void replaceBoth(XmlGroupTableDetailValue pXmlGroupDetailed, XmlGroupTableDetail pXmlGroupToDetail) {

        // loop on tables
        for (XmlGroupTableValue lXmlGroupTableValue : getGroupTableValues()) {
            lXmlGroupTableValue.replaceBoth(pXmlGroupDetailed, pXmlGroupToDetail);
        }
    }

    /**
     * return a list of detail values from codes
     *
     * @param pCodes        list of string codes
     * @param pXmlGroupTabs tab list to look for
     * @return
     */
    public List<XmlGroupTableDetailValue> findTableDetailValuesByCodes(List<String> pCodes) {
        // init
        List<XmlGroupTableDetailValue> lRes = new ArrayList<>();

        // search for
        for (XmlGroupTableValue lXmlGroupTableValue : getGroupTableValues()) {
            lRes.addAll(lXmlGroupTableValue.findTableDetailValuesByCodes(pCodes));
        }

        // result
        return lRes;
    }

    /**
     * Returns true if this table contains the data code
     *
     * @param pDatum
     * @return
     */
    public boolean containsData(DataDto pDatum) {

        // init
        boolean lContains = false;

        if (groupTableValues != null) {
            for (Iterator<XmlGroupTableValue> iterator = groupTableValues.iterator(); iterator.hasNext() && !lContains; ) {
                XmlGroupTableValue lValue = iterator.next();
                lContains = lValue.containsData(pDatum);
            }
        }

        // result
        return lContains;
    }

    // Getters and setters

    public List<XmlGroupTableValue> getGroupTableValues() {
        return groupTableValues;
    }

}
