package fr.onema.sispea.struts.referential.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.struts.referential.xml.XmlGroupType;

import java.io.Serializable;


/**
 * This class is a support class to read xml group from a xml file
 *
 * @author CS
 */
public class XmlGroup implements Serializable, Cloneable {

    /**
     * List of VP which should be always editable
     */
    //protected List<String>alwaysEditableVp = new ArrayList<String>();
    protected static final String[] alwaysEditableVp = {"VP.176"};

    private static final long serialVersionUID = 1L;

    /**
     * the type of data
     */
    protected Integer type = null;

    /**
     * The object type
     */
    protected XmlGroupType xmlType = null;

    /**
     * the title of data
     */
    protected String title = null;

    /**
     * the dynamic title of block
     */
    protected String dynamicTitle = null;

    /**
     * the competence of data
     */
    protected Integer competence = null;

    /**
     * the data code
     */
    protected String code = null;

    /**
     * the display as DC parameter
     */
    protected Boolean displayAsDC = null;

    /**
     * the group id
     */
    protected String id = null;

    /**
     * the group help
     */
    protected String help = null;

    /**
     * Default constructor.
     */
    public XmlGroup() {
        super();
    }

    /**
     * copy constructor.
     */
    public XmlGroup(XmlGroup pXmlGroup) {
        super();
        type = pXmlGroup.getType();
        title = pXmlGroup.getTitle();
        competence = pXmlGroup.getCompetence();
        code = pXmlGroup.getCode();
        id = pXmlGroup.getId();
        help = pXmlGroup.getHelp();
    }

    public static String escapeCode(String pCode) {
        if (pCode != null) {
            return pCode.replace(".", "_");
        } else {
            return pCode;
        }
    }

    /**
     * clone an XmlGroup Object
     */
    public XmlGroup clone() {

        // init
        XmlGroup lRes = new XmlGroup();

        // copy attributes to the clone
        lRes.copy(this);

        // result
        return lRes;
    }

    /**
     * copy parameter into this
     */
    public void copy(XmlGroup pXmlGroupToCopy) {
        // copy attributs to the clone
        setType(pXmlGroupToCopy.getType());
        setTitle(pXmlGroupToCopy.getTitle());
        setCompetence(pXmlGroupToCopy.getCompetence());
        setCode(pXmlGroupToCopy.getCode());
        setId(pXmlGroupToCopy.getId());
        setHelp(pXmlGroupToCopy.getHelp());
    }

    // Getters and setters

    /**
     * return true if group is general tab, false else
     *
     * @return
     */
    public boolean isGeneralTab() {
        return getType() == XmlGroupType.TabGeneral.getId();
    }

    public boolean isSliceValue() {
        return type != null
               && (getType() == XmlGroupType.DetailCollectivityPriceSliceData.getId() || getType() == XmlGroupType.DetailDelegateePriceSliceData.getId());
    }

    public boolean isPriceValue() {
        return type != null
               && (getType() == XmlGroupType.DetailDelegateePriceData.getId() || getType() == XmlGroupType.DetailCollectivityPriceData.getId());
    }

    public boolean isDelegateeDetail() {
        return type != null && type == DataDetailType.DelegateePriceDetail.getId();
    }

    public boolean isCollectivityDetail() {
        return type != null && type == DataDetailType.CollectivityPriceDetail.getId();
    }

    public boolean isPriceDetail() {
        return isDelegateeDetail() || isCollectivityDetail();
    }

    public boolean isTaxeDetail() {
        return type != null && type == DataDetailType.TaxDetail.getId();
    }

    public boolean isEquipmentDetail() {
        return type != null && type == DataDetailType.Equipment.getId();
    }

    public boolean isDataIndicatorDetail() {
        return isDataIndicatorListDetail() || (type != null && type == DataDetailType.InnerValuesDetail.getId());
    }

    public boolean isDataIndicatorListDetail() {
        return type != null && type == DataDetailType.InnerValueListDetail.getId();
    }

    public boolean isIndicatorValue() {
        return (XmlGroupType.DataIndicator.getId() == getType());
    }

    public boolean isTitleValue() {
        return (XmlGroupType.DataTitle.getId() == getType());
    }

    public boolean isVariableValue() {
        return (XmlGroupType.DataVariable.getId() == getType());
    }

    public boolean isDescriptive() {
        return (displayAsDC != null && getDisplayAsDC());
    }

    public boolean isContextValue() {
        return (XmlGroupType.DataContext.getId() == getType());
    }

    public boolean isAlawaysEditable() {
        String[] lAlwaysEditableVp = getAlwaysEditableVp();
        boolean lRes = false;
        int lCount = 0;
        while (lCount < lAlwaysEditableVp.length && !lRes) {
            if (getCode().equals(lAlwaysEditableVp[lCount])) {
                lRes = true;
            }
            lCount++;
        }
        return lRes;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer pType) {
        type = pType;
        xmlType = XmlGroupType.parseFromId(pType);
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String pTitle) {
        title = pTitle;
    }

    public String getDynamicTitle() {
        return dynamicTitle;
    }

    public void setDynamicTitle(String dynamicTitle) {
        this.dynamicTitle = dynamicTitle;
    }

    public Integer getCompetence() {
        return competence;
    }

    public void setCompetence(Integer pCompetence) {
        competence = pCompetence;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String pCode) {
        code = pCode;
    }

    public String getEscapedCode() {
        return XmlGroup.escapeCode(code);
    }

    public String getId() {
        return id;
    }

    public void setId(String pId) {
        id = pId;
    }

    public Boolean getDisplayAsDC() {
        return displayAsDC;
    }

    public void setDisplayAsDC(Boolean pDisplayAsDC) {
        displayAsDC = pDisplayAsDC;
    }

    public String[] getAlwaysEditableVp() {
        return alwaysEditableVp;
    }

    public XmlGroupType getXmlType() {
        return xmlType;
    }

    public void setXmlType(XmlGroupType pXmlType) {
        xmlType = pXmlType;
    }

    public String getHelp() {
        return help;
    }

    public void setHelp(String pHelp) {
        help = pHelp;
    }

}
