package fr.onema.sispea.struts.referential.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import java.util.ArrayList;
import java.util.List;

/**
 * This enumeration represents data sub groups.
 *
 * @author CS
 */
public enum DataDetailSubGroup {
    CO_2_1(1321, 132, DataDetailType.DelegateePriceDetail, "VP.177", new String[]{"VP.190"}),
    CO_2_2(1322, 132, DataDetailType.CollectivityPriceDetail, "VP.178", new String[]{"VP.191"}),
    CO_2_3(1323, 132, DataDetailType.TaxDetail, "VP.179", new String[]{"VP.213", "VP.214", "VP.215", "VP.216", "VP.219"}),

    CA_2_1(2521, 252, DataDetailType.DelegateePriceDetail, "VP.177", new String[]{"VP.190"}),
    CA_2_2(2522, 252, DataDetailType.CollectivityPriceDetail, "VP.178", new String[]{"VP.191"}),
    CA_2_3(2523, 252, DataDetailType.TaxDetail, "VP.179", new String[]{"VP.213", "VP.214", "VP.215", "VP.216", "VP.219"}),

    WQ_4_1(1141, 114, DataDetailType.Equipment, "P108.3", new String[]{"P108.3", "VP.212", "VP.194"}),

    CC_2_1(2221, 222, DataDetailType.Equipment, "P203.3", new String[]{"P203.3", "VP.176"}),

    PC_2_1(2321, 232, DataDetailType.Equipment, "P204.3", new String[]{"P204.3", "VP.176"}),
    PC_3_1(2331, 233, DataDetailType.Equipment, "P205.3", new String[]{"P205.3"}),
    PC_4_1(2341, 234, DataDetailType.Equipment, "P254.3", new String[]{"VP.210", "VP.211"}),

    SC_1_1(2411, 234, DataDetailType.Equipment, "D203.0", new String[]{"VP.208"}),
    SC_2_1(2421, 234, DataDetailType.Equipment, "P206.3", new String[]{"VP.209"});

    /**
     * The resource keys prefix for the enumerated type.
     */
    public static final String PREFIX = "fr.onema.sispea.referential.dataDetailSubGroup.";

    /**
     * data code list
     */
    List<String> data = new ArrayList<>();

    /**
     * The data equipment sub group id.
     */
    private int id = -1;

    /**
     * The data sub group id.
     */
    private int subGroupId = -1;

    /**
     * the detail type
     */
    private DataDetailType detailtype = null;

    /**
     * The data detailed code.
     */
    private String detailedDataCode = null;

    /**
     * The reliability internationalization Key.
     */
    private String labelKey = null;

    /**
     * Default constructor.
     *
     * @param pId The type ID.
     */
    DataDetailSubGroup(int pId, int pSubGroupId, DataDetailType pDetailtype, String pDetailedDataCode, String[] pData) {
        id = pId;
        subGroupId = pSubGroupId;
        detailtype = pDetailtype;
        detailedDataCode = pDetailedDataCode;
        labelKey = PREFIX + name();
        for (String aPData : pData) {
            data.add(aPData);
        }
    }

    /**
     * This method parse a string and return a type value.
     *
     * @param pId
     * @return
     */

    public static DataDetailSubGroup parseFromId(int pId) {
        DataDetailSubGroup result = null;

        // If we find that one of the enum ID is equal to the given ID, we
        // return the corresponding enum type value.
        for (DataDetailSubGroup type : DataDetailSubGroup.values()) {
            if (type.getId() == pId) {
                result = type;
                break;
            }
        }

        // If execution goes here, no enum value has been recognized.
        return result;
    }

    /**
     * This method parse a string and return a type value.
     *
     * @param pSubGroupId
     * @return
     */
    public static List<DataDetailSubGroup> parseFromSubGroupId(int pSubGroupId) {
        List<DataDetailSubGroup> lRes = new ArrayList<>();

        // If we find that one of the enum ID is equal to the given ID, we
        // return the corresponding enum type value.
        for (DataDetailSubGroup lEquipmentDataSubGroup : DataDetailSubGroup.values()) {
            if (lEquipmentDataSubGroup.getSubGroupId() == pSubGroupId) {
                lRes.add(lEquipmentDataSubGroup);
            }
        }

        // If execution goes here, no enum value has been recognized.
        return lRes;
    }

    // Getters and setters.

    public int getId() {
        return id;
    }

    public String getLabelKey() {
        return labelKey;
    }

    public List<String> getData() {
        return data;
    }

    public int getSubGroupId() {
        return subGroupId;
    }

    public String getDetailedDataCode() {
        return detailedDataCode;
    }

    public DataDetailType getDetailtype() {
        return detailtype;
    }

}
