package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.OrganismType;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.user.MandateDto;
import fr.onema.sispea.service.user.Right;
import org.apache.log4j.Logger;

/**
 * This action handles the SPEA visualisation and modification.
 * It allows the end user to visualize a service and to edit its mandated users list.
 *
 * @author CS
 */
public class UpdateSPEAPresentationAction extends AbstractSPEAPresentationAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateSPEAPresentationAction.class);

    /**
     * Territory associated to current organism displayed.
     */
    protected TerritoryDto territory;

    @Override
    protected String doExecute() throws Exception {

        // log
        if (logger.isDebugEnabled()) {
            logger.debug("update spea");
        }

        // check params
        initPagingSizes();
        checkExercise();
        checkId();

        // read spea
        spea = referentialService.readSPEA(orgId, exercise, false);

        // check spea
        if (spea == null) {
            throw new SispeaException("fr.onema.sispea.jsp.fixRef.showSPEAPresentation.error.emptySpea");
        }

        territory = territoryService.readTerritory(spea.getId(), OrganismType.SPEA);

        // check rights
        if (!checkUserRight(Right.Edit, territory, exercise)) {
            throw new SispeaException("fr.onema.sispea.jsp.fixRef.showSPEAPresentation.error.unauthorized");
        }

        // do the mandate
        String lCurrentLogin = getCurrentUser().getLogin();
        Integer mandatedCount = 0;
        for (String lLogin : getUsersToMandate()) {
            // add mandate if mandated is not current user
            if (!lLogin.equals(lCurrentLogin)) {
                userService.mandate(lLogin, spea.getId(), lCurrentLogin);
                // load mandate
                MandateDto lMandate = userService.readMandate(lLogin, spea.getId(), lCurrentLogin);
                // send notification
                userService.notifyUserMandated(getCurrentUser(), lMandate, getLocale().getLanguage());
                mandatedCount = mandatedCount + 1;
            } else {
                // error message
                addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showSPEAPresentation.error.sameLogin"));
            }
        }

        // success message
        if (mandatedCount.equals(0)) {
            addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showSPEAPresentation.message.mandateAddedCount0"));
        } else if (mandatedCount.equals(1)) {
            addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showSPEAPresentation.message.mandateAddedCount1"));
        } else {
            addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showSPEAPresentation.message.mandateAddedCountMore", "", mandatedCount.toString()));
        }

        //FIXME tc20150701 On la déjà lue plus haut ???
        // read spea
        spea = referentialService.readSPEA(spea.getId(), false);

        // check spea
        if (spea == null) {
            throw new SispeaException("fr.onema.sispea.jsp.fixRef.showSPEAPresentation.error.emptySpea");
        }

        // read mandates ?
        spea.setMandates(userService.readSpeaMandates(spea.getId()));

        // users
        loadUsers(territory);

        // paging
        manageMemberPaging();
        manageEquipmentPaging();
        manageMandatePaging();

        // change menu ?
        openMenu(getProperMenuKey(spea, territory));

        // message sent
        addActionMessage(getText("fr.onema.sispea.jsp.user.showSPEAPresentation.mandate.sent"));

        // result
        return SUCCESS;
    }

    public TerritoryDto getTerritory() {
        return territory;
    }

}
