package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.struts.common.menu.MenuConstants;

import java.util.List;


/**
 * This action manages territory removal.
 * These two functionalities are available for administrator users only, in the territory search web page.
 *
 * @author CS
 */
public class RemoveTerritoryAction extends AbstractTerritoryAction {

    private static final long serialVersionUID = 1L;

    /**
     * ID of the mixed territory to remove.
     */
    private List<String> territoryIdsSave;

    @Override
    protected String doExecute() throws Exception {
        String lResult = SUCCESS;

        // check exercise
        checkExercise();

        // If ID of a territory to remove exists...
        if (territoryIdsSave != null && territoryIdsSave.size() > 0) {

            try {
                for (String lIdToRemove : territoryIdsSave) {
                    // Test if the Territory ID is a valid integer.
                    Integer lRemoveTerritoryId = Integer.parseInt(lIdToRemove);

                    // Delete this territory.
                    territoryService.removeTerritoryById(lRemoveTerritoryId);

                    // succes message
                    addActionMessage(getText(TERRITORY_PREFIX + "msg.deletion"));
                }

            } catch (NumberFormatException nfe) {
                addActionError(getText(TERRITORY_PREFIX + "error.invalidTerritoryId"));
                lResult = ERROR;
            }

        } else {
            addActionError(getText(TERRITORY_PREFIX + "error.noTerritoryId"));
            lResult = ERROR;
        }

        // Set the current menu.
        openMenu(MenuConstants.MENU_KEY_SEARCH_TERRITORIES);

        // Add a success message.
        addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showTerritory.msg.removeOrganism.success"));

        // result
        return lResult;

    }

    public List<String> getTerritoryIdsSave() {
        return territoryIdsSave;
    }

    public void setTerritoryIdsSave(List<String> pTerritoryIdsSave) {
        territoryIdsSave = pTerritoryIdsSave;
    }

}
