package fr.onema.sispea.struts.data.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.OrganismType;
import fr.onema.sispea.service.referential.SPEADto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.service.user.UserDto;
import org.apache.log4j.Logger;

public class UnpublishLotAction extends AbstractLotStatusWorkflowAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UnpublishLotAction.class);

    /**
     * Territory associated to current organism displayed.
     */
    protected TerritoryDto territory;

    @Override
    protected String doExecute() throws Exception {
        // log
        if (logger.isDebugEnabled()) {
            logger.debug(getText("fr.onema.sispea.struts.data.action.UnpublishLotAction.debug.doExecute"));
        }

        // get auth user
        UserDto lSessionUser = getCurrentUser();
        if (lSessionUser == null) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        // check spea id
        if (getSpeaId() == null) {
            throw new SispeaException("fr.onema.sispea.struts.data.action.UnpublishLotAction.error.noSpeaId");
        }

        // check exercise id
        checkExercise();

        // get spea corresponding territory
        territory = territoryService.readTerritory(getSpeaId(), OrganismType.SPEA);
        if (territory == null) {
            throw new SispeaException("fr.onema.sispea.struts.data.action.UnpublishLotAction.error.noTerritory");
        }

        // check rights
        if (!checkUserRight(Right.Unpublish, territory, exercise)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        // change lot status
        SPEADto lSpea = referentialService.readSPEA(speaId, exercise, false);
        speaLotService.unpublish(lSpea.getName(), lSpea.getId(), lSpea.getGspId(), exercise.getId(),
                                 getLocale().getLanguage(), getCurrentUser(), true);

        // success
        return Action.SUCCESS;
    }

    public TerritoryDto getTerritory() {
        return territory;
    }
}
