package fr.onema.sispea.struts.common.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.AbstractSispeaAction;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

public class ShowPersonalSpaceAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowPersonalSpaceAction.class);

    @Override
    protected String doExecute() throws Exception {

        // init result
        String forward = Action.SUCCESS;

        // open menu
        openMenu(MenuConstants.MENU_KEY_PERSONAL_SPACE);

        // check if user is logged on
        UserDto lUser = getCurrentUser();
        if (lUser == null) {
            forward = Action.INPUT;

            if (logger.isDebugEnabled()) {
                logger.debug("No user found in session. Forwarding to input.");
            }
        }

        // result
        return forward;
    }
}
