package fr.onema.sispea.struts.common.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.ImageCaptchaService;
import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.common.ContactDto;
import fr.onema.sispea.service.common.ContactSenderType;
import fr.onema.sispea.service.common.ContactService;
import fr.onema.sispea.service.data.ExerciseService;
import fr.onema.sispea.service.referential.OrganismDto;
import fr.onema.sispea.service.referential.ReferentialService;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.referential.TerritoryPairDto;
import fr.onema.sispea.service.referential.TerritoryType;
import fr.onema.sispea.service.search.OrderByFieldDto;
import fr.onema.sispea.service.search.OrderByFieldType;
import fr.onema.sispea.service.search.SearchFieldsDto;
import fr.onema.sispea.service.search.SearchTerritoryResultDto;
import fr.onema.sispea.service.search.UserOrderByFieldPossibility;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.service.user.UserType;
import fr.onema.sispea.struts.AbstractSispeaAction;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.util.constants.SispeaConstants;
import org.apache.log4j.Logger;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * This action handles the user visualization. It allows the end user to view
 * user props.
 *
 * @author CS
 */
public class ContactAction extends AbstractSispeaAction implements ServletRequestAware {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ContactAction.class);

    @Autowired
    protected transient ContactService contactService;

    @Autowired
    protected transient ReferentialService referentialService;

    @Autowired
    protected transient ExerciseService exerciseService;

    @Autowired
    protected transient ImageCaptchaService imageCaptchaService;

    /**
     * The user bean returned by the action.
     */
    protected ContactDto contactInfo;

    /**
     * The current user's DDT
     */
    protected OrganismDto ddt;


    /**
     * The DDT local admins list
     */
    protected List<UserDto> ddtUsersList;

    /**
     * The captcha response
     */
    protected String captchaResponse;

    /**
     * HTTP request. Needed to validate the captcha
     */
    protected transient HttpServletRequest httpRequest;

    /**
     * sender type id
     */
    protected Integer contactSenderTypeId;

    /**
     * sender type
     */
    protected ContactSenderType contactSenderType;

    /**
     * list of sender types
     */
    protected List<ContactSenderType> contactSenderTypes;

    public ContactAction() {
        super();
        contactInfo = new ContactDto();
        contactSenderTypes = new ArrayList<>();
    }

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("Contact action");
        }

        // init
        boolean lDoSend = true;

        String result = Action.SUCCESS;

        // set menu item
        openMenu(MenuConstants.MENU_KEY_CONTACT);

        try {

            //
            // If the user has a DDT, we need to load the corresponding values
            //
            initializeDdtInformations();

            // check form
            if (submitValue != null) {

                if (contactSenderTypeId == ContactSenderType.Empty.getSenderTypeId()) {
                    addFieldError("contactSenderTypeId", getText("fr.onema.sispea.common.contact.form.compulsoryFields"));
                    lDoSend = false;
                } else {
                    contactInfo.setContactSenderTypeId(contactSenderTypeId);
                }

                if (contactInfo.getName() == null) {

                    addFieldError("contact.name", getText("fr.onema.sispea.common.contact.form.compulsoryFields"));
                    lDoSend = false;

                } else if (contactInfo.getName().length() < 2) {

                    addFieldError("contact.name", getText("fr.onema.sispea.common.contact.form.compulsoryFields"));
                    lDoSend = false;

                }

                if (contactInfo.getFirstName() == null) {

                    addFieldError("contact.firstName", getText("fr.onema.sispea.common.contact.form.compulsoryFields"));
                    lDoSend = false;

                } else if (contactInfo.getFirstName().length() < 2) {

                    addFieldError("contact.firstName", getText("fr.onema.sispea.common.contact.form.compulsoryFields"));
                    lDoSend = false;

                }

                if (contactInfo.getEmail() == null) {

                    addFieldError("contact.email", getText("fr.onema.sispea.common.contact.form.compulsoryFields"));
                    lDoSend = false;

                } else if (contactInfo.getEmail().length() < 5) {

                    addFieldError("contact.email", getText("fr.onema.sispea.common.contact.form.wrongEmail"));
                    lDoSend = false;

                } else {

                    // Previous regexp: String patrn = "^([a-zA-Z0-9]+(([\\.\\-\\_]?[a-zA-Z0-9]+)+)?)\\@(([a-zA-Z0-9]+[\\.\\-\\_])+[a-zA-Z]{2,4})$";
                    String patrn = "^[a-zA-Z0-9]+([\\.\\-_]([a-zA-Z0-9])+)*@[a-zA-Z0-9]+([\\.\\-_]([a-zA-Z0-9])+)*\\.[a-zA-Z]{2,4}";
                    if (!contactInfo.getEmail().matches(patrn)) {

                        addFieldError("contact.email", getText("fr.onema.sispea.common.contact.form.wrongEmail"));
                        lDoSend = false;

                    }
                }

                if (contactInfo.getZipCode() == null) {

                    addFieldError("contact.zipCode", getText("fr.onema.sispea.common.contact.form.compulsoryFields"));
                    lDoSend = false;

                } else if (contactInfo.getZipCode().length() < 2) {

                    addFieldError("contact.zipCode", getText("fr.onema.sispea.common.contact.form.compulsoryFields"));
                    lDoSend = false;
                }

                if (contactInfo.getCity() == null) {

                    addFieldError("contact.city", getText("fr.onema.sispea.common.contact.form.compulsoryFields"));
                    lDoSend = false;

                } else if (contactInfo.getCity().length() < 2) {

                    addFieldError("contact.city", getText("fr.onema.sispea.common.contact.form.compulsoryFields"));
                    lDoSend = false;
                }

                if (contactInfo.getMessage() == null) {

                    addFieldError("contact.message", getText("fr.onema.sispea.common.contact.form.compulsoryFields"));
                    lDoSend = false;

                } else if (contactInfo.getMessage().length() < 1) {

                    addFieldError("contact.message", getText("fr.onema.sispea.common.contact.form.compulsoryFields"));
                    lDoSend = false;
                }

                // captcha
                if (captchaResponse == null) {
                    // requiered
                    addFieldError("captchaResponse", getText("fr.onema.sispea.common.contact.form.emptyCaptcha"));
                    lDoSend = false;
                } else {
                    // get session id
                    String sessionId = httpRequest.getSession().getId();

                    // test letters matching
                    Boolean lMatches;
                    try {
                        // get match
                        lMatches = imageCaptchaService.validateResponseForID(sessionId, getCaptchaResponse());
                    } catch (CaptchaServiceException e) {
                        lMatches = false;
                    }

                    // get captcha original letters
                    if (!lMatches) {
                        addFieldError("captchaResponse", getText("fr.onema.sispea.common.contact.form.wrongCaptcha"));
                        lDoSend = false;
                    }
                }

                // do send ?
                if (lDoSend) {

                    // Send mail
                    contactService.sendMail(getCurrentUser(), contactInfo, getLocale().getLanguage());

                    // log it on jsp
                    addActionMessage(getText("fr.onema.sispea.common.contact.form.sendok"));

                    // result
                    result = Action.SUCCESS;
                } else {
                    // Input error(s)
                    result = Action.INPUT;
                }
            } else {

                // fill contact sender types
                Collections.addAll(contactSenderTypes, ContactSenderType.values());

                // fill contact info if possible
                UserDto lUser = getCurrentUser();
                if (lUser != null) {
                    contactInfo.setName(lUser.getName());
                    contactInfo.setEmail(lUser.getEmail());
                    contactInfo.setFirstName(lUser.getFirstName());

                    if (lUser.getType() == UserType.Municipality
                        || lUser.getType() == UserType.Collectivity
                        || lUser.getType() == UserType.SPEA) {
                        contactSenderType = ContactSenderType.Municipality;
                        contactSenderTypeId = ContactSenderType.Municipality.getSenderTypeId();
                    } else {
                        contactSenderType = ContactSenderType.Institutional;
                        contactSenderTypeId = ContactSenderType.Institutional.getSenderTypeId();
                    }
                }

                // if user has ddt, check ddt radio
                if (contactInfo.getAddressee() == null) {
                    if (ddt != null) {
                        contactInfo.setAddressee(ContactDto.CHOICE_DDT);
                    } else {
                        // else web master
                        contactInfo.setAddressee(ContactDto.CHOICE_WEBMASTER);
                    }
                }
            }

            // Reinitialize the captcha string
            captchaResponse = null;
        } catch (SispeaException e) {
            addActionError(getText(e.getMessage()));
            result = Action.INPUT;

        }

        return result;
    }

    /**
     * Initialize some informations related to the current user's DDT
     *
     * @throws SispeaException
     */
    protected void initializeDdtInformations() throws SispeaException {

        // current user
        UserDto currentUser = getCurrentUser();

        // authenticated with ddt ?
        if ((currentUser != null) && (currentUser.getType().getHasDDTContact())) {

            // search for ddt
            List<SearchTerritoryResultDto> lResults = territoryService.search(currentUser.getTerritory().getId(),
                                                                              currentUser.getTerritory().getType(), null, null, TerritoryType.DDT, null,
                                                                              exerciseService.getCurrentExerciseId(), null, null, false);
            List<TerritoryPairDto> lPairs = SearchTerritoryResultDto.getPairs(lResults);

            // check number of results
            if (lPairs.size() != 1) {
                // There is not one and only one DDT associated, so we have to raise an exception
                throw new SispeaException("fr.onema.sispea.common.contact.error.wrongDdt");
            }

            // get ddt territory
            TerritoryDto lDdtTerritory = lPairs.get(0).getChildTerritory();
            if (lDdtTerritory == null) {
                // There is not one and only one DDT associated, so we have to raise an exception
                throw new SispeaException("fr.onema.sispea.common.contact.error.wrongDdt");
            }

            // read ddt
            ddt = referentialService.readDDTFromTerritoryId(lDdtTerritory.getId(), exerciseService.getCurrentExercise());

            // read ddt users
            SearchFieldsDto lFilter = new SearchFieldsDto();
            lFilter.getOrderByFields().add(new OrderByFieldDto(OrderByFieldType.ASC, UserOrderByFieldPossibility.defaut.getTableAlias(),
                                                               UserOrderByFieldPossibility.defaut.getHqlFieldName(), UserOrderByFieldPossibility.defaut.getSqlFieldName()));
            ddtUsersList = userService.readUsers(lDdtTerritory, true, false, 0, SispeaConstants.RETURN_ALL_RESULTS, lFilter);

        }
    }

    /**
     * @return a map for webmaster send to address for HTML radio display
     */
    public Map<String, String> getWebMaster() {
        Map<String, String> webMaster = new HashMap<>();
        webMaster.put(ContactDto.CHOICE_WEBMASTER, getText("fr.onema.sispea.common.contact.form.addressee.webmaster"));
        return webMaster;
    }

    /**
     * @return a map for admin send to address for HTML radio display
     */
    public Map<String, String> getAdmin() {
        Map<String, String> admin = new HashMap<>();
        admin.put(ContactDto.CHOICE_ADMIN, getText("fr.onema.sispea.common.contact.form.addressee.admin"));
        return admin;
    }

    /**
     * @return a map for DDT send to address for HTML radio display
     */
    public Map<String, String> getDdea() {
        Map<String, String> ddea = new HashMap<>();
        ddea.put(ContactDto.CHOICE_DDT, getText("fr.onema.sispea.common.contact.form.addressee.ddea"));
        return ddea;
    }

    /**
     * @return a map of civilities for HTML select display
     */
    public Map<String, String> getCivilityList() {

        // init
        Map<String, String> lRes = new TreeMap<>();

        // build map
        lRes.put(getText("fr.onema.sispea.common.contact.form.civility.M"), getText("fr.onema.sispea.common.contact.form.civility.M"));
        lRes.put(getText("fr.onema.sispea.common.contact.form.civility.Mme"), getText("fr.onema.sispea.common.contact.form.civility.Mme"));
        lRes.put(getText("fr.onema.sispea.common.contact.form.civility.Mlle"), getText("fr.onema.sispea.common.contact.form.civility.Mlle"));

        // result
        return lRes;
    }

    // Getters and setters

    public ContactDto getContactInfo() {
        return contactInfo;
    }

    public void setContactInfo(ContactDto pContact) {
        contactInfo = pContact;
    }

    public String getCaptchaResponse() {
        return captchaResponse;
    }

    public void setCaptchaResponse(String pCaptchaResponse) {
        captchaResponse = pCaptchaResponse;
    }

    @Override
    public void setServletRequest(HttpServletRequest pArg0) {
        httpRequest = pArg0;
    }

    public OrganismDto getDdt() {
        return ddt;
    }

    public void setDdt(OrganismDto pDdt) {
        ddt = pDdt;
    }

    /**
     * @return the curent user DDT phone, or an empty string if there is not DDT for the current user.
     */
    public String getDdtPhone() {
        String lRes = null;

        if ((ddt != null) && (ddt.getAddress() != null)) {
            lRes = ddt.getAddress().getPhone();
        }

        return lRes;
    }

    /**
     * @return DDT emails' list, as a string, for JSP usage.
     */
    public String getDdtEmailListAsString() {

        // init
        String lRes = null;

        // loop on mails
        for (UserDto lUser : ddtUsersList) {
            // add to result ?
            if (lUser.getEmail() != null) {

                if (lRes == null) {
                    lRes = lUser.getEmail();
                } else {
                    lRes = lRes + ", " + lUser.getEmail();
                }
            }
        }

        return lRes;
    }

    public ContactSenderType getContactSenderType() {
        return contactSenderType;
    }

    public void setContactSenderType(ContactSenderType pContactSenderType) {
        contactSenderType = pContactSenderType;
    }

    public List<ContactSenderType> getContactSenderTypes() {
        return contactSenderTypes;
    }

    public void setContactSenderTypes(List<ContactSenderType> pContactSenderTypes) {
        contactSenderTypes = pContactSenderTypes;
    }

    /**
     * @return a map of contact sender types for HTML select display
     */
    public Map<Integer, String> getContactSenderTypesList() {

        // init
        Map<Integer, String> lRes = new TreeMap<>();

        for (ContactSenderType lSenderType : ContactSenderType.values()) {
            lRes.put(lSenderType.getSenderTypeId(), getText(lSenderType.getDisplayedValue()));
        }

        // result
        return lRes;
    }

    public Integer getContactSenderTypeId() {
        return contactSenderTypeId;
    }

    public void setContactSenderTypeId(Integer pContactSenderTypeId) {
        contactSenderTypeId = pContactSenderTypeId;
    }

}
