package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.OrganismDto;
import fr.onema.sispea.service.referential.OrganismType;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action handles the new spea management.
 * It allows the end user to show the new spea management.
 *
 * @author CS
 */
public class UpdateNewSpeaAction extends AbstractNewSpeaAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateNewSpeaAction.class);

    @Override
    protected String doExecute() throws Exception {

        String lRes = Action.SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("show newSpea");
        }

        // set the menu
        openMenu(MenuConstants.MENU_KEY_NEWSPEA);

        // check rights
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        try {

            //update spea for the chosen exercise
            speaOrgId = processNewSpea(getChosenExerciseId(), getSpeaTerritoryId());

            //message for the user
            addActionMessage(getText("fr.onema.sispea.jsp.admin.newSpea.success"));

        } catch (SispeaException e) {
            lRes = Action.INPUT;
            addActionError(getText(e.getMessage()));
        }
        try {

            // load exercises
            exercises = exerciseService.readNotCurrentExercises();

            //load territories
            checkUsersSelections();

            loadExcerciseList();

            loadSelectedTerritories();

        } catch (SispeaException e) {
            lRes = Action.INPUT;
            addActionError(getText(e.getMessage()));
        }

        // result
        return lRes;
    }

    /**
     * copy specifications of the territory for the current Exercise, to the Exercise in parameter
     * return if it's well done
     *
     * @return TODO
     * @throws SispeaException
     */
    protected Integer processNewSpea(int pExerciseId, int pTerritoryId) throws SispeaException {


        OrganismDto lOrganism = territoryService.getOrganismFromTerritoryId(pTerritoryId);
        if (lOrganism.getType() != OrganismType.SPEA) {
            throw new SispeaException("fr.onema.sispea.jsp.admin.newSpea.noSpeaTerritory");
        }

        referentialService.buildNewSpea(Integer.valueOf(pExerciseId).shortValue(), lOrganism.getId());

        return lOrganism.getId();

    }

}
