package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.ldap.LDAPService;
import fr.onema.sispea.service.user.ProfileDto;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.service.user.UserType;
import fr.onema.sispea.struts.AbstractSispeaAction;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * This action handles the LDAP migration to DB.
 * maitenance action
 *
 * @author CS
 */
public class SyncLDAPAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(SyncLDAPAction.class);

    @Autowired
    protected transient LDAPService ldapService;

    /**
     * user type id to read
     */
    protected Integer userTypeIdToRead;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("new exercise");
        }

        // check rights
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        // check param
        UserType lType = UserType.parseFromDbId(userTypeIdToRead);
        if (lType == null) {
            throw new SispeaException("wrong user type id");
        }

        // load profile corresponding to param
        List<ProfileDto> lProfiles = ldapService.readProfile(lType.getRole());

        // messages
        addActionMessage("processing user type " + lType.name() + " for role " + lType.getRole().getName());

        // loop on profiles
        for (ProfileDto lProfile : lProfiles) {
            for (String lMember : lProfile.getMembers()) {
                if (userService.usersExistsinDb(lMember)) {
                    userService.updateUserType(lMember, lType.getId());
                    addActionMessage(lMember + " update in db");
                } else {
                    addActionError(lMember + " not foung in db");
                }
            }
        }

        // result
        return Action.SUCCESS;
    }

    public Integer getUserTypeIdToRead() {
        return userTypeIdToRead;
    }

    public void setUserTypeIdToRead(Integer pUserTypeIdToRead) {
        userTypeIdToRead = pUserTypeIdToRead;
    }

}
