package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action handles the synthesis display administration visualization.
 *
 * @author CS
 */
public class ShowSynthDisplayAction extends AbstractSynthDisplayAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowSynthDisplayAction.class);

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("show synth display");
        }

        // init result
        String lRes = Action.SUCCESS;

        // open menu
        openMenu(MenuConstants.MENU_KEY_SYNTHDISPLAY);

        // check user right
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        try {

            manageViewAction();

        } catch (SispeaException lEx) {
            lRes = Action.INPUT;
            addActionError(getText(lEx.getMessage()));
        }

        // result
        return lRes;

    }

}
