package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action handles the synthesis relevant levels administration visualization.
 *
 * @author CS
 */
public class ShowRelevantLevelsAction extends AbstractRelevantLevelsAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowRelevantLevelsAction.class);

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("show relevant levels");
        }

        // init result
        String lRes = Action.SUCCESS;

        // open menu
        openMenu(MenuConstants.MENU_KEY_RELEVANTLEVELS);

        // check user right
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }


        try {

            // load competences and check the choosen one
            checkCompetence();

            // get Slices :
            slices = indicatorService.findSliceLeveledByCompetence(competence.getId());

        } catch (SispeaException lEx) {
            lRes = Action.INPUT;
            addActionError(getText(lEx.getMessage()));
        }

        // result
        return lRes;

    }

}
