package fr.onema.sispea.struts;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.ActionInvocation;
import org.apache.struts2.dispatcher.StreamResult;

/**
 * This class for result-type="RPQSStream"
 *
 * <result-types> <result-type name="RPQSStream" default="false"
 * class="fr.onema.sispea.struts.RPQSStreamResult"/>
 *
 * </result-types>
 *
 * It extends StreamResult Used to download file as a stream.
 */

public class RPQSStreamResult extends StreamResult {

    private static final long serialVersionUID = 1L;

    @Override
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        // Get name of downloaded file 
        String downloadedFileName = (String) invocation.getStack().findValue(conditionalParse("rpqsFileName", invocation));

        contentDisposition = "filename=\"" + downloadedFileName + "\"";

        // Get file size
        contentLength = "" + invocation.getStack().findValue(conditionalParse("rpqsSize", invocation));

        // Get type of file
        contentType = "" + invocation.getStack().findValue(conditionalParse("rpqsContentType", invocation));

        /*
            Executes the result given a final location
            (jsp page, action, etc) and
            the action invocation (the state in which
            the action was executed).
        */

        super.doExecute(finalLocation, invocation);

    }
}
