package fr.onema.sispea.struts;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import fr.onema.sispea.service.user.UserDto;

import java.util.Map;

/**
 * This class assures that the users are authenticated
 * when accessing protected SISPEA actions.
 *
 * @author CS
 */
public class AuthenticationInterceptor implements Interceptor {

    private static final long serialVersionUID = 1L;

    @Override
    public void destroy() {
        // Nothing to do
    }

    @Override
    public void init() {
        // Nothing to do
    }

    /**
     * Assures that the user is authenticated.
     * If there is not any current user, the method forwards towards the login action.
     */
    @Override
    public String intercept(ActionInvocation pActionInvocation) throws Exception {

        Map<String, Object> strutsSession = pActionInvocation.getInvocationContext().getSession();
        SispeaSession sispeaSession = (SispeaSession) strutsSession.get(SispeaSession.SISPEA_SESSION);

        boolean isAuthenticated = false;
        if (sispeaSession != null) {
            UserDto currentUser = sispeaSession.getUser();
            // Only an authenticated user will be in the session.
            isAuthenticated = currentUser != null;
        }

        String next = Action.LOGIN;

        if (isAuthenticated) {
            next = pActionInvocation.invoke();
        } else {
            // Which is the URL the user wanted to go to?
            String actionName = pActionInvocation.getProxy().getActionName();

            // Do not put an URL into the session if the user explicitly invoked
            // the show login action
            if (!"showLogin".equals(actionName)) {

                StringBuilder requestString = new StringBuilder();
                Map<String, Object> parameters = pActionInvocation.getInvocationContext().getParameters();

                boolean firstParam = true;
                for (Map.Entry<String, Object> entry : parameters.entrySet()) {

                    // add the parameter onto the request string
                    String parameterKey = entry.getKey();
                    String[] parameterValue = (String[]) entry.getValue();
                    for (String aParameterValue : parameterValue) {
                        // if it's the first parameter add a '?' else add a '&'
                        if (firstParam) {
                            requestString.append("?");
                            firstParam = false;
                        } else {
                            requestString.append("&");
                        }

                        //get the parameter at this point
                        requestString.append(parameterKey);
                        requestString.append("=");
                        requestString.append(aParameterValue); // FIXME AThimel 29/06/15 Some values may not be URL proof
                    }
                }
                if (sispeaSession == null) {
                    // force creating session
                    sispeaSession = new SispeaSession();
                    strutsSession.put(SispeaSession.SISPEA_SESSION, sispeaSession);
                }
                sispeaSession.setUrlGoingTo(actionName + ".action" + requestString.toString());

            }
        }
        return next;
    }
}
