package fr.onema.sispea.struts;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.ActionSupport;
import fr.onema.sispea.SispeaConfiguration;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.ServiceMessages;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.referential.OrganismDto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.referential.TerritoryService;
import fr.onema.sispea.service.user.IUserService;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.common.bean.MenuBean;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.struts.common.menu.MenuReader;
import fr.onema.sispea.util.date.Chrono;
import org.apache.log4j.Logger;
import org.apache.struts2.interceptor.ApplicationAware;
import org.apache.struts2.interceptor.ParameterAware;
import org.apache.struts2.interceptor.SessionAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.util.Map;

/**
 * Super class of all SISPEA struts action classes.
 *
 * @author CS
 */
public abstract class AbstractSispeaAction extends ActionSupport implements ParameterAware, SessionAware, ApplicationAware {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(AbstractSispeaAction.class);

    @Autowired
    protected transient TerritoryService territoryService;

    @Autowired
    protected transient IUserService userService;

    @Autowired
    protected transient ServiceMessages serviceMessages;

    @Autowired
    protected transient StrutsMessages strutsMessages;

    @Autowired
    protected transient SispeaConfiguration configuration;

    @Value("${sispea.format.date}")
    protected String formatDate;

    @Value("${sispea.format.date.only}")
    protected String formatDateOnly;

    /**
     * The application context. Set by Struts.
     */
    protected Map<String, Object> application = null;

    /**
     * The session context.
     */
    protected Map<String, Object> session;

    /**
     * The request parameters.
     */

    protected Map<String, String[]> parameters;

    /**
     * The submit button activated.
     */
    protected String submitValue = null;

    /**
     * The next page.
     */
    protected String nextPage = null;

    /**
     * Menu container
     */
    protected MenuBean menu = null;

    /**
     * The business Sispea session object (contains anything in user's session)
     */
    protected transient SispeaSession sispeaSession;

    /**
     * This method is called by the execute method. It should implement the real
     * processing of the action. To be overridden by the subclasses.
     *
     * @throws Exception
     */
    protected abstract String doExecute() throws Exception;

    /**
     * Returns the application context.
     */
    public Map<String, Object> getApplication() {
        return application;
    }

    @Override
    public void setApplication(Map<String, Object> pMap) {
        application = pMap;
    }

    /**
     * Returns the session context.
     */
    public Map<String, Object> getSession() {
        return session;
    }

    @Override
    public void setSession(Map<String, Object> pMap) {
        session = pMap;
    }

    /**
     * Returns the request parameters.
     */
    public Map<String, String[]> getParameters() {
        return parameters;
    }

    @Override
    public void setParameters(Map<String, String[]> pMap) {
        parameters = pMap;
    }

    /**
     * This method is called by the web app controller. It is the entry point of
     * all SISPEA actions. It implements common methods such as logging and
     * exception handling. Then it delegates the processing to the
     * <code>doExceute</code> method.
     *
     * @throws Exception
     */
    @Override
    public final String execute() throws Exception {

        // To get the execution time of the action
        Chrono timer = new Chrono();
        String forward;
        try {
            // Debug trace
            if (logger.isDebugEnabled()) {
                logger.debug(strutsMessages.getMessage(
                        "fr.onema.sispea.struts.action.start.execute",
                        getClass().getName()));

                // Start timer
                timer.start();
            }

            // create menu
            createMenu(false);

            // This method allows subclasses to perform a checkRight on the current user
            checkRight();

            // execute action
            forward = doExecute();

            // consolidate menu
            buildMenu();

        } catch (SispeaException e) {
            forward = doHandleSispeaException(e);
        } catch (Exception e) {
            forward = doHandleException(e);
        }

        // Stop the timer and print the execution time
        if (logger.isDebugEnabled()) {
            timer.stop();
            logger.debug(strutsMessages.getMessage(
                    "fr.onema.sispea.struts.action.done",
                    Long.toString(timer.getMilliSec()), getClass().getName()));
        }

        return forward;
    }

    public String getOption(String optionKey) {
        return configuration.getOption(optionKey);
    }

    /**
     * This method should throw an exception if the user has not got the right to access the function.
     *
     * @throws SispeaException
     */
    protected void checkRight() throws SispeaException {

        // Do nothing
        // The sub classes may check the rights
    }

    /**
     * Returns the value of the request parameter pParameterName.
     *//*

    protected String getParameterValue(String pParameterName) {

        String parameterValue = null;

        Map parameters = getParameters();
        if (parameters != null) {
            String[] values = (String[]) parameters.get(pParameterName);
            if (values != null && values.length > 0) {
                parameterValue = values[0];
            }
        }

        return parameterValue;
    }*/

    /**
     * Handles exceptions of the type <code>SispeaException</code>.
     */
    protected String doHandleSispeaException(SispeaException pException) {

        return doHandleException(pException);
    }

    /**
     * Handles all exceptions. Forwards towards the ERROR page.
     */
    protected String doHandleException(Exception pException) {

        logException(pException);

        // Forward to error page.
        return ERROR;
    }

    /**
     * Removes the session.
     */
    protected void removeSession() {

        // Just remove the SISPEA session
        getSession().remove(SispeaSession.SISPEA_SESSION);
    }

    /**
     * Initializes the session.
     */
    protected void initSession() {

        // Just remove the SISPEA session
        getSispeaSession().init();
    }

    /**
     * Logs the exception.
     */
    protected void logException(Exception pException) {

        // Never show an exception to the end user
        logger.error(strutsMessages.getMessage(
                "fr.onema.sispea.struts.action.error.execute",
                pException.getMessage(), getClass().getName()), pException);

        // Make the error message available to the jsp page
        String message = getText(pException.getMessage());
        if (message == null) {
            // Set the message to something - anything - to prevent the property
            // to be set to null and hence be removed from the scope (which
            // would
            // generate another error when the jsp page try to print the non
            // existing property).
            message = pException.getClass().getName();
        }

        // Store the message in request scope for the jsp page
        addActionError(message);
    }

    // Getters and setters

    /**
     * Returns the SISPEA session. The session is always existing.
     */
    public SispeaSession getSispeaSession() {
        if (sispeaSession == null) {
            if (getSession().containsKey(SispeaSession.SISPEA_SESSION)) {
                sispeaSession = (SispeaSession) getSession().get(SispeaSession.SISPEA_SESSION);
                Preconditions.checkState(sispeaSession != null, "SispeaSession's key is present but no value in session");
            } else {
                sispeaSession = new SispeaSession();
                getSession().put(SispeaSession.SISPEA_SESSION, sispeaSession);
            }
        }
        return sispeaSession;
    }

    /**
     * @return current user if exists, null else
     */
    public UserDto getCurrentUser() {
        UserDto lRes = null;
        SispeaSession lSession = getSispeaSession();
        if (lSession != null) {
            lRes = lSession.getUser();
        }
        return lRes;
    }

    /**
     * @return current user territory if exists, null else
     */
    public TerritoryDto getCurrentUserTerritory() {
        // init result
        TerritoryDto lRes = null;

        // get current user
        UserDto lCurrentUser = getCurrentUser();
        if (lCurrentUser != null) {
            // return its ref territory
            lRes = lCurrentUser.getTerritory();
        }

        // result
        return lRes;
    }

    public String getNextPage() {
        return nextPage;
    }

    public void setNextPage(String pNextPage) {
        nextPage = pNextPage;
    }

    /**
     * This method returns true if the language is english, false otherwise.
     *
     * @return True if the language is english.
     */
    public boolean isEnglish() {
        boolean isEnglish = false;
        if ("en".equals(getLocale().getLanguage())) {
            isEnglish = true;
        }
        return isEnglish;
    }

    /**
     * This method returns true if the language is french, false otherwise.
     *
     * @return True if the language is french.
     */
    public boolean isFrench() {
        boolean isFrench = false;
        if ("fr".equals(getLocale().getLanguage())) {
            isFrench = true;
        }
        return isFrench;
    }

    /**
     * This method returns true if the language is spanish, false otherwise.
     *
     * @return True if the language is spanish.
     */
    public boolean isSpanish() {
        boolean isSpanish = false;
        if ("es".equals(getLocale().getLanguage())) {
            isSpanish = true;
        }
        return isSpanish;
    }

    /**
     * Initializes the menu if not already done.
     *
     * @param pForce if true, menu is rebuild
     * @return
     * @throws Exception
     */
    public void createMenu(boolean pForce) throws Exception {
        // get session
        SispeaSession lSession = getSispeaSession();

        // get menu from session
        MenuBean rootMenu = null;
        if (lSession != null) {
            rootMenu = lSession.getMenu();
        }

        // create ?
        if ((rootMenu == null) || (pForce)) {

            // read xml
            MenuReader menuReader = new MenuReader();
            rootMenu = menuReader.parse("/fr/onema/sispea/struts/common/menu/menu.xml");

            // set menu in session
            lSession.setMenu(rootMenu);
        }
    }

    /**
     * Initializes the menu
     *
     * @return
     * @throws SispeaException
     */
    public void buildMenu() throws SispeaException {
        try {
            // get session
            SispeaSession lSession = getSispeaSession();

            // get menu from session
            MenuBean rootMenu = lSession.getMenu();

            // current user
            UserDto lUser = lSession.getUser();

            // Bug: ShowPersonalSpaceAction - rootMenu
            // Test the rootMenu. When handling the ShowPersonalSpaceAction the rootMenu
            // might somehow be null.
            // If the rootMenu is null, do not proceed
            if (rootMenu == null) {
                try {
                    // Build exception to have the stack trace
                    throw new SispeaException("rootMenu is null");
                } catch (SispeaException e) {
                    logger.error(strutsMessages.getMessage("fr.onema.sispea.struts.action.error.execute",
                                                           e.getMessage(), getClass().getName()), e);
                    // Do not throw the exception.
                }
            } else {
                // first level menus
                rootMenu.setVisible(MenuConstants.MENU_KEY_NEWS, false);
                rootMenu.show(MenuConstants.MENU_KEY_PERSONAL_SPACE);
                rootMenu.show(MenuConstants.MENU_KEY_SERVICES);
                rootMenu.show(MenuConstants.MENU_KEY_STAKES);
                rootMenu.show(MenuConstants.MENU_KEY_MYSERVICE);
                // hide synthsesis
                String lForceDisplaySynthsesis = getOption("sispea.display.synthesis");
                if (lForceDisplaySynthsesis != null && Boolean.valueOf(lForceDisplaySynthsesis)) {
                    rootMenu.show(MenuConstants.MENU_KEY_SYNTHESIS);
                } else {
                    rootMenu.setVisible(MenuConstants.MENU_KEY_SYNTHESIS, false);
                }

                // personal space menus
                if (rootMenu.isOpen(MenuConstants.MENU_KEY_PERSONAL_SPACE)) {
                    rootMenu.show(MenuConstants.MENU_KEY_MYSELECTION);
                    rootMenu.show(MenuConstants.MENU_KEY_MYREQUESTS);
                }

                // set menu for auth user
                if (lUser != null) {

                    // autenticated user -> set personal space menu open
                    rootMenu.setOpen(true, MenuConstants.MENU_KEY_PERSONAL_SPACE);

                    // show personal infos if menu
                    if (rootMenu.isOpen(MenuConstants.MENU_KEY_PERSONAL_SPACE)) {

                        // show menus for logged in users
                        // link to connection / disconnection
                        rootMenu.setVisible(MenuConstants.MENU_KEY_CONNECTION, false);
                        rootMenu.show(MenuConstants.MENU_KEY_DISCONNECTION);
                        // link for profile
                        rootMenu.show(MenuConstants.MENU_KEY_PROFILE);
                        // my mandates
                        rootMenu.show(MenuConstants.MENU_KEY_MYMANDATES);
                        // link for downloading data
                        rootMenu.show(MenuConstants.MENU_KEY_EXTRACTDATA);
                        // link for dash bord
                        if (checkIfUserCanViewDashBoard()) {
                            rootMenu.show(MenuConstants.MENU_KEY_DASHBOARD);
                        } else {
                            rootMenu.setVisible(MenuConstants.MENU_KEY_DASHBOARD, false);
                        }

                        // show menus for admin users
                        // drupal connection
                        if (checkUserRight(Right.Manage)) {
                            rootMenu.show(MenuConstants.MENU_KEY_ADMINISTRATION);
                            rootMenu.show(MenuConstants.MENU_KEY_DRUPAL_CONNECTION);
                            rootMenu.show(MenuConstants.MENU_KEY_WARNINGLEVELS);
                            rootMenu.show(MenuConstants.MENU_KEY_CHANGEEXERCISE);
                            rootMenu.show(MenuConstants.MENU_KEY_NEWSPEA);
                            rootMenu.show(MenuConstants.MENU_KEY_SYNTHDISPLAY);
                            rootMenu.show(MenuConstants.MENU_KEY_RELEVANTLEVELS);
                            rootMenu.show(MenuConstants.MENU_KEY_EXCHANGESQUEUE);
                            rootMenu.show(MenuConstants.MENU_KEY_ADMINPUBLICATION);
                            rootMenu.show(MenuConstants.MENU_KEY_DATALISTS);
                        } else {
                            rootMenu.setVisible(MenuConstants.MENU_KEY_ADMINISTRATION, false);
                            rootMenu.setVisible(MenuConstants.MENU_KEY_DRUPAL_CONNECTION, false);
                            rootMenu.setVisible(MenuConstants.MENU_KEY_WARNINGLEVELS, false);
                            rootMenu.setVisible(MenuConstants.MENU_KEY_CHANGEEXERCISE, false);
                            rootMenu.setVisible(MenuConstants.MENU_KEY_NEWSPEA, false);
                            rootMenu.setVisible(MenuConstants.MENU_KEY_SYNTHDISPLAY, false);
                            rootMenu.setVisible(MenuConstants.MENU_KEY_RELEVANTLEVELS, false);
                            rootMenu.setVisible(MenuConstants.MENU_KEY_EXCHANGESQUEUE, false);
                            rootMenu.setVisible(MenuConstants.MENU_KEY_ADMINPUBLICATION, false);
                            rootMenu.setVisible(MenuConstants.MENU_KEY_DATALISTS, false);
                        }

                        // link for profile
                        rootMenu.show(MenuConstants.MENU_KEY_PROFILE);

                        // link for selections
                        rootMenu.show(MenuConstants.MENU_KEY_MYSELECTION);

                        // link for selections
                        rootMenu.show(MenuConstants.MENU_KEY_MYREQUESTS);

                        // link for users only if editUser right
                        if (checkUserRight(Right.EditUser)) {
                            rootMenu.show(MenuConstants.MENU_KEY_MYUSERS);
                        } else {
                            rootMenu.setVisible(MenuConstants.MENU_KEY_MYUSERS, false);
                        }

                        // link for uploading data: only for certain users
                        if (lUser.getMandatable()) {
                            rootMenu.show(MenuConstants.MENU_KEY_SENDDATA);
                        } else if (checkUserRight(Right.EditRef)) {
                            rootMenu.show(MenuConstants.MENU_KEY_SENDDATA);
                        } else if (checkUserRight(Right.Edit)) {
                            rootMenu.show(MenuConstants.MENU_KEY_SENDDATA);
                        } else {
                            rootMenu.setVisible(MenuConstants.MENU_KEY_SENDDATA, false);
                        }

                        // link for my territory
                        if (getCurrentUserTerritory() != null) {
                            rootMenu.show(MenuConstants.MENU_KEY_MYTERRITORIES);
                        } else {
                            rootMenu.setVisible(MenuConstants.MENU_KEY_MYTERRITORIES, false);
                        }

                        // link for comparator
                        // shown for all authenticated users
                        rootMenu.show(MenuConstants.MENU_KEY_COMPARATOR);
                    }

                    // if displaying spea -> show associated menus
                    if (rootMenu.isOpen(MenuConstants.MENU_KEY_SEE_SPEA)) {
                        // open presentation and data
                        rootMenu.show(MenuConstants.MENU_KEY_PRESENTATION);
                        rootMenu.show(MenuConstants.MENU_KEY_SPEA_INDICATORS);
                        rootMenu.show(MenuConstants.MENU_KEY_SPEA_DATA);
                    }
                } else {

                    // user not logged on -> hide indicators list
                    rootMenu.setVisible(MenuConstants.MENU_KEY_SEARCH_INDICATOR, false);

                    // which display on my services
                    if (rootMenu.isOpen(MenuConstants.MENU_KEY_MYSERVICE)) {
                        rootMenu.show(MenuConstants.MENU_KEY_SEARCH_TERRITORIES);
                    } else {
                        // show connection if personal space
                        if (rootMenu.isOpen(MenuConstants.MENU_KEY_PERSONAL_SPACE)) {
                            // show connection
                            rootMenu.show(MenuConstants.MENU_KEY_CONNECTION);
                            rootMenu.show(MenuConstants.MENU_KEY_MYREQUESTS);
                            rootMenu.show(MenuConstants.MENU_KEY_MYSELECTION);
                        }
                    }
                }
            }
        } catch (NullPointerException e) {
            logger.error("NullPointerException while building menu", e);
            throw new SispeaException("fr.onema.sispea.struts.action.error.menuBuild", e);
        } catch (Exception e) {
            logger.error("Error while building menu", e);
            throw new SispeaException("fr.onema.sispea.struts.action.error.menuBuild", e);
        }
    }

    /**
     * Open the menu corresponding to the key.
     */
    public void openMenu(String pKey) {

        // get the session menu
        SispeaSession lSession = getSispeaSession();
        MenuBean rootMenu = lSession.getMenu();

        // Bug: ShowPersonalSpaceAction - rootMenu
        // The root menu disappears in the action ShowPersonalSpaceAction
        // which calls this method.
        //
        // Log an exception if there is not any root menu
        if (rootMenu == null) {
            try {
                // Build exception to have the stack trace
                throw new SispeaException("rootMenu is null");
            } catch (SispeaException e) {
                logger.error(strutsMessages.getMessage("fr.onema.sispea.struts.action.error.execute",
                                                       e.getMessage(), getClass().getName()), e);
                // Do not throw the exception.
            }
        } else {
            // desactivate old current menu
            rootMenu.deactivate();

            // close all
            rootMenu.close();

            // open the right sub menu
            rootMenu.show(pKey);
            rootMenu.open(pKey);

            // No need to redo a set. The root menu is already referenced
            // by the SISPEA session
        }
    }

    /**
     * @return true if current user has more than view right
     */
    public Boolean checkIfUserCanViewDashBoard() throws SispeaException {
        // init
        Boolean lRes = true;
        if (!checkUserRight(Right.View)) {
            // message
            lRes = false;
        }
        return lRes;
    }

    /**
     * @param pRight
     * @return true if current user has right, false else
     */
    public Boolean checkUserRight(Right pRight) throws SispeaException {
        //FIXME TC20150701 Bizzare ce code, à revoir
        TerritoryDto territory = null;
        return checkUserRight(pRight, territory, null);
    }

    /**
     * @param pRight
     * @return true if current user has right, false else
     */
    public Boolean checkUserRight(Right pRight, TerritoryDto pTerritoryTest, ExerciseDto pExercise) throws SispeaException {

        // get user
        UserDto lUser = getCurrentUser();

        Boolean lRes = userService.checkUserRight(lUser, pRight, pTerritoryTest, pExercise);

        // result
        return lRes;
    }

    /**
     * @param pRight    The right to check for
     * @param pOrganism Has the user the right pRightName for the organism pOrganism
     * @param pExercise The exercise to check for.
     * @return true if current user has right, false else
     */
    public boolean checkUserRight(Right pRight, OrganismDto pOrganism, ExerciseDto pExercise) throws SispeaException {

        UserDto user = getCurrentUser();
        boolean hasRight = userService.checkUserRight(user, pRight, pOrganism, pExercise);
        return hasRight;
    }

    // Getters and setters

    public MenuBean getMenu() {
        return menu;
    }

    public void setMenu(MenuBean pMenu) {
        menu = pMenu;
    }

    public String getSubmitValue() {
        return submitValue;
    }

    public void setSubmitValue(String pSubmitValue) {
        submitValue = pSubmitValue;
    }

    public String getFormatDate() {
        return formatDate;
    }

    public String getFormatDateOnly() {
        return formatDateOnly;
    }
}
