/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage;

import com.google.common.base.Preconditions;
import fr.ird.observe.DataService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.IObserveConfig;
import fr.ird.observe.ObserveActionExecutor;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveRunner;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceConfig;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.DataSourceFactory;
import fr.ird.observe.db.ReplicationService;
import fr.ird.observe.db.constants.CreationMode;
import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.db.event.DataSourceEvent;
import fr.ird.observe.db.event.DataSourceListener;
import fr.ird.observe.db.event.DataSourceListenerAdapter;
import fr.ird.observe.db.impl.H2DataSource;
import fr.ird.observe.db.impl.H2DataSourceConfig;
import fr.ird.observe.db.impl.PGDataSource;
import fr.ird.observe.db.impl.PGDataSourceConfig;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.db.util.PGInstall;
import fr.ird.observe.db.util.SecurityModel;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.entities.seine.TripSeine;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.storage.ObstunaAdminAction;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUI;
import fr.ird.observe.ui.storage.StorageUILauncher;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.ui.storage.tabs.RolesTableModel;
import fr.ird.observe.ui.storage.tabs.SelectDataUI;
import fr.ird.observe.ui.storage.tabs.StorageTabUI;
import fr.ird.observe.ui.tree.DataSelectionTreeCellRenderer;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.wizard.WizardUILancher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.util.version.Version;

@DefaultApplicationContext.AutoLoad
public class StorageUIHandler {
    private static final Log log = LogFactory.getLog(StorageUIHandler.class);
    protected ReplicationService replicationService = ObserveServiceHelper.newReplicationService();

    public DataSource newServiceFromModel(StorageUIModel model, boolean isMain, String localLabel, String remoteLabel) throws IOException {
        PGDataSource mainStorage = null;
        switch (model.getDbMode()) {
            case CREATE_LOCAL: 
            case USE_LOCAL: {
                H2DataSourceConfig h2Config = model.toH2StorageConfig(localLabel);
                if (model.getDbMode() == DbMode.USE_LOCAL) {
                    h2Config.setCreationMode(null);
                }
                H2DataSource h2Service = DataSourceFactory.newService((H2DataSourceConfig)h2Config);
                h2Service.addDataSourceListener((DataSourceListener)new DataSourceListenerAdapter(){

                    public void onOpened(DataSourceEvent event) {
                        H2DataSource s = (H2DataSource)event.getSource();
                        ObserveContext context = ObserveContext.get();
                        ((ObserveConfig)((Object)context.getContextValue(ObserveConfig.class))).setLocalStorageExist(true);
                        s.getConfig().setCreationMode(null);
                    }
                });
                mainStorage = h2Service;
                break;
            }
            case USE_REMOTE: {
                PGDataSource pgservice;
                PGDataSourceConfig pgConfig = model.toPostgresStorageConfig(remoteLabel);
                mainStorage = pgservice = DataSourceFactory.newService((PGDataSourceConfig)pgConfig);
            }
        }
        if (isMain) {
            ObserveContext.get().prepareMainStorage((DataSource)mainStorage);
        }
        return mainStorage;
    }

    public void initUI(final StorageUI ui) {
        StorageUIModel model = ui.getModel();
        model.addPropertyChangeListener("step", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StorageUIModel model = (StorageUIModel)((Object)evt.getSource());
                StorageStep oldStep = (StorageStep)((Object)evt.getOldValue());
                StorageStep newStep = (StorageStep)((Object)evt.getNewValue());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("step has changed <old:" + (Object)((Object)oldStep) + ", new:" + (Object)((Object)newStep) + ">"));
                }
                int oldStepIndex = oldStep == null ? -1 : model.getStepIndex(oldStep);
                int newStepIndex = model.getStepIndex(newStep);
                JTabbedPane tabs = ui.getTabs();
                if (oldStepIndex + 1 == newStepIndex) {
                    StorageTabUI c = (StorageTabUI)ui.getObjectById(newStep.name());
                    String title = I18n.t((String)newStep.getLabel(), (Object[])new Object[0]);
                    String tip = I18n.t((String)newStep.getDescription(), (Object[])new Object[0]);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Create tab " + title + " ui = " + c));
                    }
                    tabs.addTab(title, null, c, tip);
                    tabs.setMnemonicAt(newStepIndex, title.charAt(0));
                    int index = tabs.indexOfComponent(c);
                    if (index > -1) {
                        tabs.setSelectedIndex(index);
                    }
                    ui.onStepChanged(oldStep, newStep);
                } else if (oldStepIndex > newStepIndex) {
                    int index = newStepIndex + 1;
                    while (tabs.getTabCount() > index) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("remove tab : " + index));
                        }
                        tabs.remove(index);
                    }
                    ui.onStepChanged(oldStep, newStep);
                } else {
                    throw new IllegalStateException("can not go from " + (Object)((Object)oldStep) + " to " + (Object)((Object)newStep));
                }
            }
        });
        ui.CHOOSE_DB_MODE.init();
        ui.CONFIG.init();
        ui.CONFIG_REFERENTIEL.init();
        ui.CONFIG_DATA.init();
        ui.BACKUP.init();
        ui.SELECT_DATA.init();
        ui.ROLES.init();
        ui.CONFIRM.init();
        DataSource source = ui.getContextValue(DataSource.class);
        model.init((JAXXContext)ui, source);
    }

    public void start(StorageUI ui) {
        ui.getModel().start(ui.getModel().getDbMode());
        UIHelper.center((Component)ui.getContextValue(Window.class, "parent"), (Component)ui);
        ui.setVisible(true);
    }

    public void onStepChanged(StorageUI ui, StorageStep oldStep, StorageStep newStep) {
        boolean mustRecompute;
        if (newStep == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("new step : " + (Object)((Object)newStep)));
        }
        StorageUIModel model = ui.getModel();
        boolean bl = mustRecompute = oldStep == null || oldStep.ordinal() < newStep.ordinal();
        if (StorageStep.CONFIG == newStep) {
            model.setConnexionStatus(null);
        }
        if (StorageStep.CONFIG_REFERENTIEL == newStep && mustRecompute) {
            ui.getModel().updateUniverse();
        }
        if (StorageStep.CONFIG_DATA == newStep && mustRecompute) {
            ui.getModel().updateUniverse();
        }
        if (StorageStep.SELECT_DATA == newStep && mustRecompute && ObstunaAdminAction.CREATE == ui.getModel().getAdminAction() && model.getSelectDataModel() == null) {
            this.initSelectData(ui);
        }
        if (StorageStep.ROLES == newStep && mustRecompute) {
            this.updateSecurity(model, ui.getROLES().getRolesModel());
        }
        if (StorageStep.CONFIRM == newStep) {
            String text = this.computeReport(ui, oldStep);
            ui.CONFIRM.getResume().setText(text);
        }
    }

    public void launchApply(final StorageUI ui) {
        ObserveMainUI mainUI;
        Runnable action = (Runnable)WizardUILancher.APPLY_DEF.getContextValue((JAXXContext)ui);
        if (action == null) {
            final StorageUILauncher launcher = ui.getContextValue(StorageUILauncher.class);
            action = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        launcher.doAction(ui);
                    }
                    finally {
                        launcher.doClose(ui, false);
                    }
                }
            };
        }
        if ((mainUI = ObserveContext.get().getObserveMainUI()) == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Launch standalone apply action " + action));
            }
            action.run();
        } else {
            ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
            executor.addAction(I18n.t((String)"observe.action.storage.applyAction", (Object[])new Object[0]), action);
        }
    }

    public void launchCancel(StorageUI ui) {
        Runnable action = (Runnable)WizardUILancher.CANCEL_DEF.getContextValue((JAXXContext)ui);
        ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
        if (mainUI == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Launch standalone cancel action " + action));
            }
            if (action != null) {
                action.run();
            }
        } else {
            ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
            executor.addAction(I18n.t((String)"observe.action.storage.cancel", (Object[])new Object[0]), action);
        }
    }

    public void doChangeStorage(JAXXContext context, StorageUIModel model) {
        File f;
        H2DataSource localStorage;
        DataSource mainStorage;
        ObserveConfig config;
        block42: {
            boolean destroyLocalBase;
            config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
            boolean bl = destroyLocalBase = config.isLocalStorageExist() && model.getDbMode() == DbMode.CREATE_LOCAL;
            if (log.isDebugEnabled()) {
                log.debug((Object)(">>> should destroy local db ? " + destroyLocalBase));
            }
            mainStorage = ObserveContext.get().getDataSource();
            localStorage = null;
            if (mainStorage instanceof H2DataSource) {
                localStorage = (H2DataSource)mainStorage;
            }
            boolean localDbIsSane = true;
            if ((destroyLocalBase || model.isDoBackup()) && localStorage == null) {
                try {
                    H2DataSourceConfig localConfig = config.toH2StorageConfig(I18n.n((String)"observe.storage.label.local", (Object[])new Object[0]));
                    localConfig.setCanMigrate(false);
                    localStorage = DataSourceFactory.newService((H2DataSourceConfig)localConfig);
                    localStorage.doOpen();
                }
                catch (Exception e) {
                    Exception e2 = new Exception(I18n.t((String)"observe.error.storage.could.not.load.local.db", (Object[])new Object[]{e.getMessage()}), e);
                    ErrorDialogUI.showError((Exception)e2);
                    if (log.isErrorEnabled()) {
                        log.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    localDbIsSane = false;
                    localStorage = null;
                }
            }
            if (model.isDoBackup()) {
                if (!localDbIsSane) {
                    Exception e = new Exception(I18n.t((String)"observe.error.storage.could.not.backup.unsane.local.db", (Object[])new Object[0]));
                    ErrorDialogUI.showError((Exception)e);
                    return;
                }
                f = model.getBackupFile();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(">>> do backup with " + localStorage + " in " + f));
                }
                try {
                    this.backupLocalDatabase((DataSource)localStorage, f);
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    if (log.isErrorEnabled()) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    return;
                }
            }
            if (destroyLocalBase) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(">>> destroy local db " + localStorage));
                }
                if (!localDbIsSane) {
                    File localDBDirectory = config.getLocalDBDirectory();
                    if (log.isInfoEnabled()) {
                        log.info((Object)(">>> destroy local db directory " + localDBDirectory));
                    }
                    try {
                        FileUtils.deleteDirectory((File)localDBDirectory);
                    }
                    catch (IOException e) {
                        ErrorDialogUI.showError((Exception)e);
                        if (log.isErrorEnabled()) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                        break block42;
                    }
                }
                try {
                    localStorage.doClose(true);
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    if (log.isErrorEnabled()) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    return;
                }
            }
        }
        if (mainStorage != null && mainStorage.isOpen()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(">>> close main storage " + mainStorage));
                }
                mainStorage.doClose(false);
            }
            catch (DataSourceException ex) {
                ErrorDialogUI.showError((Exception)((Object)ex));
            }
        }
        if (localStorage != null && localStorage.isOpen()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(">>> close local storage " + localStorage));
                }
                localStorage.doClose(false);
            }
            catch (DataSourceException ex) {
                ErrorDialogUI.showError((Exception)((Object)ex));
            }
        }
        localStorage = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Will create new storage...");
        }
        try {
            mainStorage = this.newServiceFromModel(model, true, "observe.storage.label.local", "observe.storage.label.remote");
            mainStorage.doOpen();
            if (log.isInfoEnabled()) {
                log.info((Object)(">>> main storage opened " + mainStorage.getLabel()));
            }
            if (model.isStoreRemoteConfig()) {
                this.storeRemoteConfig(context, model);
            }
            if (model.getDbMode() == DbMode.CREATE_LOCAL && model.getCreationMode() == CreationMode.IMPORT_REMOTE_STORAGE) {
                f = config.getInitialDbDump();
                if (f.exists() && !f.delete()) {
                    throw new IllegalStateException("could not delete " + f);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)(">>> create initial dump with " + localStorage + " in " + f));
                }
                try {
                    this.backupLocalDatabase(mainStorage, f);
                    config.setInitialDumpExist(true);
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    if (log.isErrorEnabled()) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception ex) {
            ErrorDialogUI.showError((Exception)ex);
            if (log.isErrorEnabled()) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            throw new RuntimeException(ex);
        }
    }

    public void storeRemoteConfig(JAXXContext context, StorageUIModel model) {
        ObserveConfig config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        PGDataSourceConfig remoteConfig = model.toPostgresStorageConfig("");
        config.fromStorageConfig(remoteConfig);
    }

    public String getDefaultBackupFilename() {
        return String.format("obstuna-local-%1$tF--%1$tk-%1$tM-%1$tS.sql.gz", new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupLocalDatabase(DataSource service, File dst) {
        if (dst == null) {
            throw new IllegalArgumentException("file where to backup can not be null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)dst);
        }
        if (service instanceof H2DataSource) {
            try {
                service.storeDB(dst);
            }
            catch (DataSourceException ex) {
                ErrorDialogUI.showError((Exception)((Object)ex));
            }
        } else {
            ObserveConfig config = ObserveContext.get().getConfig();
            DataSource tempStorage = null;
            try {
                tempStorage = ObserveServiceHelper.newEmptyTempStorage((IObserveConfig)config, (String)I18n.t((String)"observe.storage.label.backup", (Object[])new Object[0]), (String)("tmpBackup_" + dst.getName()));
                tempStorage.doOpen();
                this.replicationService.replicateReferentiel(service, tempStorage);
                this.replicationService.replicateAllData(service, tempStorage);
                tempStorage.storeDB(dst);
            }
            catch (Exception e) {
                ErrorDialogUI.showError((Exception)e);
                if (log.isErrorEnabled()) {
                    log.error((Object)e);
                }
            }
            finally {
                block20: {
                    if (tempStorage != null) {
                        try {
                            tempStorage.doClose(true);
                        }
                        catch (DataSourceException e) {
                            ErrorDialogUI.showError((Exception)((Object)e));
                            if (!log.isErrorEnabled()) break block20;
                            log.error((Object)e);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupLocalDatabase(DataSource service, File dst, Set<String> marees) {
        if (marees == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"will export all datas.");
            }
            this.backupLocalDatabase(service, dst);
            return;
        }
        if (dst == null) {
            throw new IllegalArgumentException("file where to backup can not be null");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("will export " + marees.size() + " marees to " + dst));
        }
        if (log.isDebugEnabled()) {
            log.debug(marees);
        }
        ObserveConfig config = ObserveContext.get().getConfig();
        String[] mareeIds = new String[marees.size()];
        int index = 0;
        for (String m : marees) {
            mareeIds[index++] = m;
        }
        DataSource tempStorage = null;
        try {
            tempStorage = ObserveServiceHelper.newEmptyTempStorage((IObserveConfig)config, (String)I18n.t((String)"observe.storage.label.backup", (Object[])new Object[0]), (String)("tmpBackup_" + dst.getName()));
            tempStorage.doOpen();
            this.replicationService.replicateReferentiel(service, tempStorage);
            this.replicationService.replicateData(service, tempStorage, mareeIds);
            tempStorage.storeDB(dst);
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
        }
        finally {
            block20: {
                if (tempStorage != null) {
                    try {
                        tempStorage.doClose(true);
                    }
                    catch (DataSourceException e) {
                        ErrorDialogUI.showError((Exception)((Object)e));
                        if (!log.isErrorEnabled()) break block20;
                        log.error((Object)e);
                    }
                }
            }
        }
    }

    public String computeReport(StorageUI ui, StorageStep step) {
        StorageUIModel model;
        DbMode dbMode;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Build report from step " + (Object)((Object)step)));
        }
        if ((dbMode = (model = ui.getModel()).getDbMode()) == null) {
            return "";
        }
        SelectDataUI selectDataUI = (SelectDataUI)ui.getStepUI(StorageStep.SELECT_DATA);
        StringBuilder sb = new StringBuilder(512);
        if (model.isBackupAction()) {
            this.computeBackupReport(selectDataUI, model, sb);
        } else {
            switch (model.getDbMode()) {
                case USE_LOCAL: {
                    this.computeConnectLocalReport(model, sb);
                    break;
                }
                case CREATE_LOCAL: {
                    this.computeCreateLocalReport(model, sb);
                    break;
                }
                case USE_REMOTE: {
                    this.computeConnectRemoteReport(selectDataUI, model, sb);
                }
            }
        }
        return sb.toString();
    }

    public void destroy(StorageUI ui) {
        ui.getModel().destroy();
        if (log.isDebugEnabled()) {
            log.debug((Object)("destroy ui " + ui.getName()));
        }
        SwingUtil.TabbedPaneIterator itr = UIHelper.newTabbedPaneIterator((JTabbedPane)ui.getTabs());
        while (itr.hasNext()) {
            StorageTabUI tab = (StorageTabUI)itr.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("destroy ui " + tab.getName()));
            }
            tab.destroy();
        }
        UIHelper.destroy((Component)ui);
    }

    protected DecoratorService getDecoratorService() {
        DecoratorService decoratorService = ObserveContext.get().getDecoratorService();
        return decoratorService;
    }

    protected void computeCreateLocalReport(StorageUIModel model, StringBuilder sb) {
        CreationMode creationMode = model.getCreationMode();
        if (creationMode == null) {
            return;
        }
        if (model.isDoBackup()) {
            StorageUIHandler.addTag("h2", sb, I18n.t((String)"observe.storage.report.action.backup.local", (Object[])new Object[0]));
            StorageUIHandler.addTag("hr", sb, "");
            StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.selected.backup.file", (Object[])new Object[0]));
            StorageUIHandler.addOpenTag("ul", sb);
            StorageUIHandler.addTag("li", sb, model.getBackupFile().getAbsolutePath());
            StorageUIHandler.addCloseTag("ul", sb);
        }
        StorageUIHandler.addTag("h2", sb, I18n.t((String)"observe.storage.report.action.create.local", (Object[])new Object[0]));
        StorageUIHandler.addTag("hr", sb, "");
        switch (creationMode) {
            case IMPORT_INTERNAL_DUMP: {
                StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.action.import.internal", (Object[])new Object[0]));
                StorageUIHandler.addOpenTag("ul", sb);
                StorageUIHandler.addTag("li", sb, model.getConfig().getInitialDbDump().getAbsoluteFile().getAbsolutePath());
                StorageUIHandler.addCloseTag("ul", sb);
                break;
            }
            case IMPORT_EXTERNAL_DUMP: {
                StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.action.import.backup", (Object[])new Object[0]));
                StorageUIHandler.addOpenTag("ul", sb);
                StorageUIHandler.addTag("li", sb, model.getDumpFile().getAbsolutePath());
                StorageUIHandler.addCloseTag("ul", sb);
                break;
            }
            case IMPORT_REMOTE_STORAGE: {
                StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.action.import.remote.referentiel", (Object[])new Object[0]));
                StorageUIHandler.addTag("pre", sb, model.getPgConfig().toString());
                break;
            }
            case EMPTY: {
                break;
            }
        }
        this.computeCanMigrateAction(model, sb);
    }

    protected void computeConnectLocalReport(StorageUIModel model, StringBuilder sb) {
        StorageUIHandler.addTag("h2", sb, I18n.t((String)"observe.storage.report.action.connect.local", (Object[])new Object[0]));
        StorageUIHandler.addTag("hr", sb, "");
        StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.selected.localStorageFile", (Object[])new Object[0]));
        StorageUIHandler.addOpenTag("ul", sb);
        StorageUIHandler.addTag("li", sb, model.getH2Config().getDataDirectory().getAbsolutePath());
        StorageUIHandler.addCloseTag("ul", sb);
        this.computeCanMigrateAction(model, sb);
    }

    protected void computeConnectRemoteReport(SelectDataUI tabUI, StorageUIModel model, StringBuilder sb) {
        ObstunaAdminAction action = model.getAdminAction();
        if (action == null) {
            StorageUIHandler.addTag("h2", sb, I18n.t((String)"observe.storage.report.action.connect.remote", (Object[])new Object[0]));
            StorageUIHandler.addTag("hr", sb, "");
            StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.selected.remoteStorage", (Object[])new Object[0]));
            StorageUIHandler.addTag("pre", sb, model.getPgConfig().toString());
            this.computeCanMigrateAction(model, sb);
        } else {
            StorageUIHandler.addTag("h2", sb, I18n.t((String)action.getLabel(), (Object[])new Object[0]));
            StorageUIHandler.addTag("hr", sb, "");
            StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.selected.remoteStorage", (Object[])new Object[0]));
            StorageUIHandler.addTag("pre", sb, model.getPgConfig().toString());
            if (ObstunaAdminAction.CREATE == action) {
                if (model.isImportReferentiel()) {
                    switch (model.getReferentielImportMode()) {
                        case IMPORT_EXTERNAL_DUMP: {
                            StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.action.referentiel.import.backup", (Object[])new Object[0]));
                            StorageUIHandler.addOpenTag("ul", sb);
                            StorageUIHandler.addTag("li", sb, model.getCentralSourceModel().getDumpFile().getAbsolutePath());
                            StorageUIHandler.addCloseTag("ul", sb);
                            break;
                        }
                        case IMPORT_REMOTE_STORAGE: {
                            StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.action.import.remote.referentiel", (Object[])new Object[0]));
                            StorageUIHandler.addTag("pre", sb, model.getCentralSourceModel().getPgConfig().toString());
                        }
                    }
                } else {
                    StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.action.no.referentiel.import", (Object[])new Object[0]));
                }
                if (model.isImportData()) {
                    switch (model.getDataImportMode()) {
                        case IMPORT_EXTERNAL_DUMP: {
                            StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.action.data.import.backup", (Object[])new Object[0]));
                            StorageUIHandler.addOpenTag("ul", sb);
                            StorageUIHandler.addTag("li", sb, model.getDataSourceModel().getDumpFile().getAbsolutePath());
                            StorageUIHandler.addCloseTag("ul", sb);
                            break;
                        }
                        case IMPORT_REMOTE_STORAGE: {
                            StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.action.import.remote.data", (Object[])new Object[0]));
                            StorageUIHandler.addTag("pre", sb, model.getDataSourceModel().getPgConfig().toString());
                        }
                    }
                    try {
                        this.computeImportDataReport(model, sb);
                    }
                    catch (DataSourceException e) {
                        throw new RuntimeException("Could not render data to import", e);
                    }
                } else {
                    StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.action.no.data.import", (Object[])new Object[0]));
                }
            } else {
                this.computeCanMigrateAction(model, sb);
            }
            this.computeSecurityreport(model, sb);
        }
    }

    protected void computeBackupReport(SelectDataUI stepUI, StorageUIModel model, StringBuilder sb) {
        if (model.isLocal()) {
            StorageUIHandler.addTag("h2", sb, I18n.t((String)"observe.storage.report.action.backup.local", (Object[])new Object[0]));
        }
        if (model.isRemote()) {
            StorageUIHandler.addTag("h2", sb, I18n.t((String)"observe.storage.report.action.backup.remote", (Object[])new Object[0]));
        }
        StorageUIHandler.addTag("hr", sb, "");
        StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.selected.backup.file", (Object[])new Object[0]));
        StorageUIHandler.addOpenTag("ul", sb);
        StorageUIHandler.addTag("li", sb, model.getBackupFile().getAbsolutePath());
        StorageUIHandler.addCloseTag("ul", sb);
        if (!model.isUseSelectData() || model.getSelectDataModel() == null) {
            return;
        }
        DataSelectionModel dataModel = model.getSelectDataModel();
        Set selectedData = dataModel.getSelectedData();
        StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.selected.data.to.export", (Object[])new Object[0]));
        StorageUIHandler.addOpenTag("ul", sb);
        if (dataModel.isDataEmpty()) {
            StorageUIHandler.addTag("li", sb, I18n.t((String)"observe.storage.report.selected.no.data", (Object[])new Object[0]));
        } else if (dataModel.isDataFull()) {
            StorageUIHandler.addTag("li", sb, I18n.t((String)"observe.storage.report.selected.all.data", (Object[])new Object[]{selectedData.size()}));
        } else {
            StorageUIHandler.addOpenTag("li", sb);
            sb.append(I18n.t((String)"observe.storage.report.selected.data", (Object[])new Object[]{selectedData.size()}));
            StorageUIHandler.addOpenTag("ul", sb);
            Decorator pDecorator = this.getDecoratorService().getDecoratorByType(Program.class);
            Decorator mDecorator = this.getDecoratorService().getDecoratorByType(TripSeine.class);
            DataSelectionTreeCellRenderer renderer = (DataSelectionTreeCellRenderer)((Object)stepUI.getSelectTree().getCellRenderer());
            DataSource source = renderer.getDataProvider().getDataSource();
            Map dataByProgram = dataModel.getSelectedDataByProgram();
            Preconditions.checkState((source != null && source.isOpen() ? 1 : 0) != 0, (Object)"La source de donn\u00e9es doit \u00eatre ouverte!");
            for (Map.Entry entry : dataByProgram.entrySet()) {
                String pId = (String)entry.getKey();
                List mareeIds = (List)entry.getValue();
                StorageUIHandler.addOpenTag("li", sb);
                try {
                    sb.append(source.decorateEntity(null, pId, pDecorator));
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Could not decorate entity " + pId), (Throwable)e);
                    }
                    StorageUIHandler.addTag("li", sb, pId);
                }
                StorageUIHandler.addOpenTag("ul", sb);
                for (String mareeId : mareeIds) {
                    try {
                        StorageUIHandler.addTag("li", sb, source.decorateEntity(null, mareeId, mDecorator));
                    }
                    catch (Exception e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Could not decorate entity " + mareeId), (Throwable)e);
                        }
                        StorageUIHandler.addTag("li", sb, mareeId);
                    }
                }
                StorageUIHandler.addCloseTag("ul", sb);
                StorageUIHandler.addCloseTag("li", sb);
            }
            StorageUIHandler.addCloseTag("li", sb);
            StorageUIHandler.addCloseTag("ul", sb);
        }
        StorageUIHandler.addTag("li", sb, I18n.t((String)"observe.storage.report.selected.data.referentiel", (Object[])new Object[0]));
        StorageUIHandler.addCloseTag("ul", sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeImportDataReport(StorageUIModel model, StringBuilder sb) throws DataSourceException {
        DataSelectionModel dataModel = model.getSelectDataModel();
        StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.selected.data.to.import", (Object[])new Object[0]));
        StorageUIHandler.addOpenTag("ul", sb);
        if (dataModel.isDataEmpty()) {
            StorageUIHandler.addTag("li", sb, I18n.t((String)"observe.storage.report.selected.no.data.to.import", (Object[])new Object[0]));
        } else {
            Set selectedData = dataModel.getSelectedData();
            if (dataModel.isDataFull()) {
                StorageUIHandler.addTag("li", sb, I18n.t((String)"observe.storage.report.selected.all.data.to.import", (Object[])new Object[]{selectedData.size()}));
            } else {
                StorageUIHandler.addOpenTag("li", sb);
                sb.append(I18n.t((String)"observe.storage.report.selected.data.for.import", (Object[])new Object[]{selectedData.size()}));
                StorageUIHandler.addOpenTag("ul", sb);
                DataSourceConfig dataSourceConfig = model.toImportDataSourceConfig();
                DataSource source = DataSourceFactory.newService((DataSourceConfig)dataSourceConfig);
                try {
                    source.doOpen();
                    Decorator pDecorator = this.getDecoratorService().getDecoratorByType(Program.class);
                    Decorator mDecorator = this.getDecoratorService().getDecoratorByType(TripSeine.class);
                    Map dataByProgram = dataModel.getSelectedDataByProgram();
                    for (Map.Entry entry : dataByProgram.entrySet()) {
                        String pId = (String)entry.getKey();
                        List mareeIds = (List)entry.getValue();
                        StorageUIHandler.addOpenTag("li", sb);
                        try {
                            sb.append(source.decorateEntity(null, pId, pDecorator));
                        }
                        catch (Exception e) {
                            if (log.isErrorEnabled()) {
                                log.error((Object)("Could not decorate entity " + pId), (Throwable)e);
                            }
                            StorageUIHandler.addTag("li", sb, pId);
                        }
                        StorageUIHandler.addOpenTag("ul", sb);
                        for (String mareeId : mareeIds) {
                            try {
                                StorageUIHandler.addTag("li", sb, source.decorateEntity(null, mareeId, mDecorator));
                            }
                            catch (Exception e) {
                                if (log.isErrorEnabled()) {
                                    log.error((Object)("Could not decorate entity " + mareeId), (Throwable)e);
                                }
                                StorageUIHandler.addTag("li", sb, mareeId);
                            }
                        }
                        StorageUIHandler.addCloseTag("ul", sb);
                        StorageUIHandler.addCloseTag("li", sb);
                    }
                }
                finally {
                    source.doClose(false);
                }
                StorageUIHandler.addCloseTag("li", sb);
                StorageUIHandler.addCloseTag("ul", sb);
            }
        }
        StorageUIHandler.addCloseTag("ul", sb);
    }

    protected void computeCanMigrateAction(StorageUIModel model, StringBuilder sb) {
        StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.action.migrate", (Object[])new Object[0]) + " :");
        StorageUIHandler.addOpenTag("ul", sb);
        if (model.isCanMigrate()) {
            Version version = model.getDbVersion();
            StorageUIHandler.addTag("li", sb, I18n.t((String)"observe.storage.report.can.migrate", (Object[])new Object[]{version}));
            if (model.isShowMigrationProgression()) {
                StorageUIHandler.addTag("li", sb, I18n.t((String)"observe.storage.showMigrationProgression", (Object[])new Object[0]));
            }
            if (model.isShowMigrationSql()) {
                StorageUIHandler.addTag("li", sb, I18n.t((String)"observe.storage.showMigrationSql", (Object[])new Object[0]));
            }
        } else {
            StorageUIHandler.addTag("li", sb, I18n.t((String)"observe.storage.report.can.not.migrate", (Object[])new Object[0]));
        }
        StorageUIHandler.addCloseTag("ul", sb);
    }

    protected void computeSecurityreport(StorageUIModel model, StringBuilder sb) {
        StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.report.selected.security", (Object[])new Object[0]));
        StorageUIHandler.addOpenTag("ul", sb);
        SecurityModel security = model.getSecurityModel();
        StorageUIHandler.addTag("li", sb, I18n.t((String)"observe.storage.report.security.owner", (Object[])new Object[]{security.getAdministrateur()}));
        StorageUIHandler.addTag("li", sb, I18n.t((String)"observe.storage.report.security.techniciens", (Object[])new Object[]{security.getTechnicien()}));
        StorageUIHandler.addTag("li", sb, I18n.t((String)"observe.storage.report.security.readers", (Object[])new Object[]{security.getUtilisateur()}));
        StorageUIHandler.addTag("li", sb, I18n.t((String)"observe.storage.report.security.referentiels", (Object[])new Object[]{security.getReferentiel()}));
        StorageUIHandler.addCloseTag("ul", sb);
    }

    public static void addTag(String tag, StringBuilder sb, String message) {
        sb.append('<').append(tag).append('>');
        sb.append(message);
        sb.append("</").append(tag).append('>');
    }

    public static void addOpenTag(String tag, StringBuilder sb) {
        sb.append('<').append(tag).append('>');
    }

    public static void addCloseTag(String tag, StringBuilder sb) {
        sb.append("</").append(tag).append('>');
    }

    public void initSelectData(StorageUI ui, DataSource source) {
        StorageUIModel model = ui.getModel();
        try {
            Preconditions.checkState((source != null ? 1 : 0) != 0, (Object)"Can't select data on a null dataSource");
            DataSelectionModel dataModel = new DataSelectionModel();
            dataModel.setUseData(true);
            dataModel.setUseOpenData(true);
            dataModel.setUseReferentiel(false);
            DataSelectionModel.populate((DataSelectionModel)dataModel, (DataService)ObserveContext.get().getDataService(), (DataSource)source);
            model.setSelectDataModel(dataModel);
            ui.getSELECT_DATA().initTree(source);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not grab data to select", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkImportDbVersion(StorageUIModel model, DataSource dataSource) throws DataSourceException {
        try {
            dataSource.doOpen();
            Version importServiceDbVersion = dataSource.getDbVersion();
            Version currentDbVersion = model.getDbVersion();
            if (importServiceDbVersion.before(currentDbVersion)) {
                throw new IllegalStateException("Import db version (" + importServiceDbVersion + ") is not compatible with the current database version (" + currentDbVersion + ")");
            }
        }
        finally {
            dataSource.doClose(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSelectData(StorageUI ui) {
        block5: {
            StorageUIModel model = ui.getModel();
            try {
                DataSourceConfig dataSourceConfig = model.toImportDataSourceConfig();
                Preconditions.checkState((dataSourceConfig != null ? 1 : 0) != 0, (Object)"Can't select data on a null dataSource");
                DataSource source = DataSourceFactory.newService((DataSourceConfig)dataSourceConfig);
                try {
                    source.doOpen();
                    model.checkImportDbVersion(source);
                    this.initSelectData(ui, source);
                }
                finally {
                    source.doClose(false);
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected void updateSecurity(StorageUIModel model, RolesTableModel roleModel) {
        SecurityModel security = model.getSecurityModel();
        PGInstall pgInstall = model.getPgInstall();
        PGDataSourceConfig config = model.getPgConfig();
        pgInstall.init(config, security);
        security.setAdministrateur(config.getLogin());
        try {
            Set roles = pgInstall.getRoles();
            String ownerRole = security.getAdministrateur();
            if (!roles.contains(ownerRole)) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not find owner role : " + ownerRole));
                }
            } else {
                roles.remove(ownerRole);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Db roles : " + roles));
            }
            security.init((Iterable)roles);
            roleModel.init(security);
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not obtain db roles", e);
        }
    }
}

