/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveConfigOption;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveTechnicalException;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.Entities;
import fr.ird.observe.entities.referentiel.SpeciesList;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveMainUIHandler;
import fr.ird.observe.ui.ObserveUICallback;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.config.ConfigUIHelper;
import jaxx.runtime.swing.config.model.CallBackFinalizer;
import jaxx.runtime.swing.config.model.ConfigUIModelBuilder;
import jaxx.runtime.swing.config.model.MainCallBackFinalizer;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.decorator.Decorator;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.i18n.I18n;

public class ShowConfigAction
extends AbstractAction {
    private static final long serialVersionUID = 3038774900992805790L;
    private static final Log log = LogFactory.getLog(ShowConfigAction.class);
    private final ObserveMainUI ui;

    public ShowConfigAction(ObserveMainUI ui) {
        super(I18n.t((String)"observe.action.configuration", (Object[])new Object[0]), SwingUtil.getUIManagerActionIcon((String)"config"));
        this.ui = ui;
        this.putValue("ShortDescription", I18n.t((String)"observe.action.configuration.tip", (Object[])new Object[0]));
        this.putValue("MnemonicKey", 67);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean canContinue;
        if (log.isInfoEnabled()) {
            log.info((Object)"ObServe opening configuration ui...");
        }
        if (canContinue = ObserveContext.get().closeSelectedContentUI(this.ui)) {
            ObserveConfigUIBuilder helper;
            DataSource dataSource = ObserveContext.get().getDataSource();
            ObserveConfig config = this.ui.getConfig();
            try {
                helper = this.buildUI(config, dataSource);
            }
            catch (DataSourceException e) {
                throw new ObserveTechnicalException("Could not load some data", (Throwable)e);
            }
            helper.buildUI((JAXXContext)this.ui, "observe.config.category.directories");
            helper.displayUI(this.ui, false);
        }
    }

    protected ObserveConfigUIBuilder buildUI(ObserveConfig config, DataSource dataSource) throws DataSourceException {
        SpeciesListsTableCellRenderer renderer;
        SpeciesListTableCellEditor editor;
        if (dataSource == null) {
            editor = null;
            renderer = null;
        } else {
            DataService dataService = ObserveContext.get().getDataService();
            Decorator speciesListDecorator = dataService.getDecoratorService().getDecoratorByType(SpeciesList.class);
            List speciesLists = dataService.loadDecoratedEntities(dataSource, SpeciesList.class);
            Map speciesListMap = Entities.toIdMap((Collection)speciesLists);
            editor = new SpeciesListTableCellEditor(speciesLists, speciesListMap, (Decorator<SpeciesList>)speciesListDecorator);
            renderer = new SpeciesListsTableCellRenderer(speciesListMap, (Decorator<SpeciesList>)speciesListDecorator);
        }
        ObserveConfigUIBuilder helper = new ObserveConfigUIBuilder(config, editor, renderer);
        for (ObserveUICallback callback : ObserveUICallback.values()) {
            helper.registerCallBack(callback);
        }
        helper.setFinalizer((CallBackFinalizer)new MainCallBackFinalizer(ObserveUICallback.application.name()));
        helper.setCloseAction(new Runnable(){

            @Override
            public void run() {
                ObserveMainUIHandler.restartEdit();
            }
        });
        this.addDirectoriesOptions(helper);
        this.addH2Options(helper);
        this.addObstunaOptions(helper);
        this.addChangeStorageOptions(helper);
        this.addGpsOptions(helper);
        this.addSynchroOptions(helper);
        this.addObservationsOptions(helper);
        if (dataSource != null) {
            this.addSeineSpeciesListOptions(helper);
            this.addLonglineSpeciesListOptions(helper);
        }
        this.addMapOptions(helper);
        this.addOthersOptions(helper);
        return helper;
    }

    protected void addDirectoriesOptions(ObserveConfigUIBuilder helper) {
        helper.addCategory(I18n.n((String)"observe.config.category.directories", (Object[])new Object[0]), I18n.n((String)"observe.config.category.directories.description", (Object[])new Object[0]));
        helper.addOption(ObserveConfigOption.CONFIG_FILE);
        helper.addOption(ObserveConfigOption.DATA_DIRECTORY);
        helper.addOption(ObserveConfigOption.DB_DIRECTORY);
        helper.addOption(ObserveConfigOption.BACKUP_DIRECTORY);
        helper.addOption(ObserveConfigOption.TMP_DIRECTORY);
        helper.addOption(ObserveConfigOption.VALIDATION_REPORT_DIRECTORY);
        helper.addOption(ObserveConfigOption.RESOURCES_DIRECTORY, ObserveUICallback.application);
    }

    protected void addH2Options(ObserveConfigUIBuilder helper) {
        helper.addCategory(I18n.n((String)"observe.config.category.h2", (Object[])new Object[0]), I18n.n((String)"observe.config.category.h2.description", (Object[])new Object[0]));
        helper.addOption(ObserveConfigOption.H2_LOGIN);
        helper.addOption(ObserveConfigOption.H2_PASSWORD);
        helper.addOption(ObserveConfigOption.H2_CAN_MIGRATE);
        helper.addOption(ObserveConfigOption.H2_SERVER_PORT);
    }

    protected void addObstunaOptions(ObserveConfigUIBuilder helper) {
        helper.addCategory(I18n.n((String)"observe.config.category.obstuna", (Object[])new Object[0]), I18n.n((String)"observe.config.category.obstuna.description", (Object[])new Object[0]));
        helper.addOption(ObserveConfigOption.OBSTUNA_URL);
        helper.addOption(ObserveConfigOption.OBSTUNA_LOGIN);
        helper.addOption(ObserveConfigOption.OBSTUNA_USE_SSL_CERT);
        helper.addOption(ObserveConfigOption.OBSTUNA_CAN_MIGRATE, ObserveUICallback.db);
    }

    protected void addChangeStorageOptions(ObserveConfigUIBuilder helper) {
        helper.addCategory(I18n.n((String)"observe.config.category.changeStorage", (Object[])new Object[0]), I18n.n((String)"observe.config.category.changeStorage.description", (Object[])new Object[0]));
        helper.addOption(ObserveConfigOption.DEFAULT_DB_MODE);
        helper.addOption(ObserveConfigOption.DEFAULT_CREATION_MODE);
        helper.addOption(ObserveConfigOption.STORE_REMOTE_STORAGE);
        helper.addOption(ObserveConfigOption.SHOW_MIGRATION_PROGRESSION);
        helper.addOption(ObserveConfigOption.SHOW_MIGRATION_SQL);
        helper.addOption(ObserveConfigOption.SHOW_SQL, ObserveUICallback.application);
    }

    protected void addGpsOptions(ObserveConfigUIBuilder helper) {
        helper.addCategory(I18n.n((String)"observe.config.category.gps", (Object[])new Object[0]), I18n.n((String)"observe.config.category.gps.description", (Object[])new Object[0]));
        helper.addOption(ObserveConfigOption.DEFAULT_GPS_MAX_DELAY);
        helper.addOption(ObserveConfigOption.DEFAULT_GPS_MAX_SPEED);
    }

    protected void addSynchroOptions(ObserveConfigUIBuilder helper) {
        helper.addCategory(I18n.n((String)"observe.config.category.synchro", (Object[])new Object[0]), I18n.n((String)"observe.config.category.synchro.description", (Object[])new Object[0]));
        helper.addOption(ObserveConfigOption.CHANGE_SYNCHRO_SRC);
        helper.addOption(ObserveConfigOption.H2_CAN_MIGRATE);
    }

    protected void addObservationsOptions(ObserveConfigUIBuilder helper) {
        helper.addCategory(I18n.n((String)"observe.config.category.observation", (Object[])new Object[0]), I18n.n((String)"observe.config.category.observation.description", (Object[])new Object[0]), ObserveUICallback.ui.name());
        helper.addOption(ObserveConfigOption.DETAILLED_ACTIVITIES_OBSERVATION);
        helper.addOption(ObserveConfigOption.NON_TARGET_OBSERVATION);
        helper.addOption(ObserveConfigOption.BAIT_OBSERVATION);
        helper.addOption(ObserveConfigOption.MAMMALS_OBSERVATION);
        helper.addOption(ObserveConfigOption.SAMPLES_OBSERVATION);
        helper.addOption(ObserveConfigOption.OBJECTS_OBSERVATION);
        helper.addOption(ObserveConfigOption.BIRDS_OBSERVATION);
        helper.addOption(ObserveConfigOption.TARGET_DISCARDS_OBSERVATION);
    }

    protected void addSeineSpeciesListOptions(ObserveConfigUIBuilder helper) {
        helper.addCategory(I18n.n((String)"observe.config.category.speciesList.seine", (Object[])new Object[0]), I18n.n((String)"observe.config.category.speciesList.seine.description", (Object[])new Object[0]), ObserveUICallback.ui.name());
        helper.addSpeciesListOption(ObserveConfigOption.SPECIES_LIST_SEINE_TARGET_CATCH_ID);
        helper.addSpeciesListOption(ObserveConfigOption.SPECIES_LIST_SEINE_SCHOOL_ESTIMATE_ID);
        helper.addSpeciesListOption(ObserveConfigOption.SPECIES_LIST_SEINE_OBJECT_SCHOOL_ESTIMATE_ID);
        helper.addSpeciesListOption(ObserveConfigOption.SPECIES_LIST_SEINE_NON_TARGET_CATCH_ID);
        helper.addSpeciesListOption(ObserveConfigOption.SPECIES_LIST_SEINE_OBJECT_OBSERVED_SPECIES_ID);
    }

    protected void addLonglineSpeciesListOptions(ObserveConfigUIBuilder helper) {
        helper.addCategory(I18n.n((String)"observe.config.category.speciesList.longline", (Object[])new Object[0]), I18n.n((String)"observe.config.category.speciesList.longline.description", (Object[])new Object[0]), ObserveUICallback.ui.name());
        helper.addSpeciesListOption(ObserveConfigOption.SPECIES_LIST_LONGLINE_CATCH_ID);
        helper.addSpeciesListOption(ObserveConfigOption.SPECIES_LIST_LONGLINE_ENCOUNTER_ID);
    }

    protected void addMapOptions(ObserveConfigUIBuilder helper) {
        helper.addCategory(I18n.n((String)"observe.config.category.map", (Object[])new Object[0]), I18n.n((String)"observe.config.category.map.description", (Object[])new Object[0]), ObserveUICallback.ui.name());
        helper.addOption(ObserveConfigOption.MAP_BACKGROUND_COLOR);
        for (ObserveConfigOption layerOption : ObserveConfigOption.MAP_LAYERS) {
            helper.addOption(layerOption);
        }
        helper.addOption(ObserveConfigOption.MAP_STYLE_FILE);
    }

    protected void addOthersOptions(ObserveConfigUIBuilder helper) {
        helper.addCategory(I18n.n((String)"observe.config.category.other", (Object[])new Object[0]), I18n.n((String)"observe.config.category.other.description", (Object[])new Object[0]));
        helper.addOption(ObserveConfigOption.SHOW_NUMBER_EDITOR_BUTTON);
        helper.addOption(ObserveConfigOption.AUTO_POPUP_NUMBER_EDITOR);
        helper.addOption(ObserveConfigOption.SHOW_DATE_TIME_EDITOR_SLIDER);
        helper.addOption(ObserveConfigOption.LOAD_LOCAL_STORAGE, ObserveUICallback.application);
        helper.addOption(ObserveConfigOption.LOCALE, ObserveUICallback.ui);
        helper.addOption(ObserveConfigOption.DB_LOCALE, ObserveUICallback.ui);
    }

    protected class SpeciesListTableCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;
        private final Map<String, SpeciesList> entityMap;
        private final Decorator<SpeciesList> decorator;

        protected SpeciesListTableCellEditor(List<SpeciesList> entities, Map<String, SpeciesList> entityMap, Decorator<SpeciesList> decorator) {
            super(new JComboBox());
            this.entityMap = entityMap;
            this.decorator = decorator;
            final BeanFilterableComboBox component = new BeanFilterableComboBox();
            component.setI18nPrefix("observe.common.");
            component.setShowReset(Boolean.valueOf(true));
            component.setBeanType(SpeciesList.class);
            this.setClickCountToStart(1);
            this.editorComponent = component;
            this.delegate = new DefaultCellEditor.EditorDelegate(){
                private static final long serialVersionUID = 1L;

                @Override
                public void setValue(Object value) {
                    if (value != null && String.class.isInstance(value)) {
                        value = SpeciesListTableCellEditor.this.entityMap.get(value);
                    }
                    component.setSelectedItem(value);
                }

                @Override
                public Object getCellEditorValue() {
                    SpeciesList speciesList;
                    String result = null;
                    Object selectedItem = component.getSelectedItem();
                    if (SpeciesList.class.isInstance(selectedItem) && (speciesList = (SpeciesList)component.getSelectedItem()) != null) {
                        result = speciesList.getTopiaId();
                    }
                    return result;
                }

                @Override
                public boolean shouldSelectCell(EventObject anEvent) {
                    if (anEvent instanceof MouseEvent) {
                        MouseEvent e = (MouseEvent)anEvent;
                        return e.getID() != 506;
                    }
                    return true;
                }

                @Override
                public boolean stopCellEditing() {
                    if (component.isEditable().booleanValue()) {
                        component.getCombobox().actionPerformed(new ActionEvent(SpeciesListTableCellEditor.this, 0, ""));
                    }
                    return super.stopCellEditing();
                }
            };
            component.init((JXPathDecorator)this.decorator, entities);
        }

        class SpeciesListListCellRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = 1L;

            SpeciesListListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, SpeciesListTableCellEditor.this.decorator.toString(value), index, isSelected, cellHasFocus);
            }
        }
    }

    protected class SpeciesListsTableCellRenderer
    extends DefaultTableRenderer {
        private static final long serialVersionUID = 1L;
        private final Map<String, SpeciesList> entityMap;
        private final Decorator<SpeciesList> decorator;

        public SpeciesListsTableCellRenderer(Map<String, SpeciesList> entityMap, Decorator<SpeciesList> decorator) {
            this.entityMap = entityMap;
            this.decorator = decorator;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String speciesListId = String.valueOf(value);
            SpeciesList speciesList = this.entityMap.get(speciesListId);
            return super.getTableCellRendererComponent(table, (Object)this.decorator.toString((Object)speciesList), isSelected, hasFocus, row, column);
        }
    }

    protected class ObserveConfigUIBuilder
    extends ConfigUIHelper {
        private final SpeciesListTableCellEditor speciesListTableCellEditor;
        private final SpeciesListsTableCellRenderer speciesListsTableCellRenderer;
        SpeciesListTableCellEditor editor;
        SpeciesListsTableCellRenderer renderer;

        protected ObserveConfigUIBuilder(ObserveConfig config, SpeciesListTableCellEditor speciesListTableCellEditor, SpeciesListsTableCellRenderer speciesListsTableCellRenderer) {
            super((ApplicationConfig)config);
            this.speciesListTableCellEditor = speciesListTableCellEditor;
            this.speciesListsTableCellRenderer = speciesListsTableCellRenderer;
        }

        public ConfigUIModelBuilder addOption(ConfigOptionDef option) {
            super.addOption(option);
            String beanProperty = ((ObserveConfigOption)option).getPropertyKey();
            if (StringUtils.isNotEmpty((CharSequence)beanProperty)) {
                this.setOptionPropertyName(beanProperty);
            }
            return this.modelBuilder;
        }

        public ConfigUIModelBuilder addOption(ObserveConfigOption option, ObserveUICallback callBack) {
            this.addOption(option);
            this.setOptionCallBack(callBack.name());
            return this.modelBuilder;
        }

        public ConfigUIModelBuilder registerCallBack(ObserveUICallback callback) {
            String name = callback.name();
            String description = callback.getLabel();
            ImageIcon icon = callback.getIcon();
            ObserveUICallback action = callback;
            this.registerCallBack(name, description, icon, action);
            return this.modelBuilder;
        }

        protected ConfigUIModelBuilder addSpeciesListOption(ObserveConfigOption option) {
            this.addOption(option).setOptionPropertyName(option.getPropertyKey()).setOptionEditor((TableCellEditor)this.speciesListTableCellEditor).setOptionRenderer((TableCellRenderer)((Object)this.speciesListsTableCellRenderer));
            return this.modelBuilder;
        }
    }
}

