/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.seine;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.referentiel.Species;
import fr.ird.observe.entities.seine.FloatingObject;
import fr.ird.observe.entities.seine.ObjectSchoolEstimate;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.impl.seine.ObjectSchoolEstimateUI;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ObjectSchoolEstimateUIHandler
extends ContentTableUIHandler<FloatingObject, ObjectSchoolEstimate> {
    private static Log log = LogFactory.getLog(ObjectSchoolEstimateUIHandler.class);

    public ObjectSchoolEstimateUIHandler(ObjectSchoolEstimateUI ui) {
        super(ui, DataContextType.SetSeine);
    }

    @Override
    public ObjectSchoolEstimateUI getUi() {
        return (ObjectSchoolEstimateUI)super.getUi();
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, ObjectSchoolEstimate bean, boolean create) {
        if (this.getTableModel().isEditable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Row has changed to " + editingRow));
            }
            this.getUi().getSpecies().requestFocus();
        }
    }

    @Override
    protected String getEditBeanIdToLoad(DataContext dataContext, DataService dataService, DataSource dataSource) {
        return dataContext.getSelectedFloatingObjectId();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.schoolEstimate.table.speciesThon", (Object[])new Object[0]), I18n.n((String)"observe.schoolEstimate.table.speciesThon.tip", (Object[])new Object[0]), I18n.n((String)"observe.schoolEstimate.table.weight", (Object[])new Object[0]), I18n.n((String)"observe.schoolEstimate.table.weight.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Species.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
    }

    @Override
    public void initUI() throws Exception {
        ObserveConfig config = this.getUi().getContextValue(ObserveConfig.class);
        String speciesListId = config.getSpeciesListSeineObjectObservedSpeciesId();
        this.prepareSpeciesList(speciesListId, (JComponent)this.getUi().getSpecies());
        super.initUI();
    }
}

