/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.seine;

import fr.ird.observe.DataService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor;
import fr.ird.observe.entities.referentiel.Ocean;
import fr.ird.observe.entities.referentiel.ReferenceEntities;
import fr.ird.observe.entities.referentiel.Species;
import fr.ird.observe.entities.referentiel.Species2;
import fr.ird.observe.entities.referentiel.seine.ReasonForDiscard;
import fr.ird.observe.entities.referentiel.seine.WeightCategory;
import fr.ird.observe.entities.seine.SetSeine;
import fr.ird.observe.entities.seine.TargetCatch;
import fr.ird.observe.entities.seine.TargetLength;
import fr.ird.observe.entities.seine.TargetSample;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.seine.TargetDiscardCatchUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;

public class TargetDiscardCatchUIHandler
extends ContentTableUIHandler<SetSeine, TargetCatch> {
    private static Log log = LogFactory.getLog(TargetDiscardCatchUIHandler.class);
    JAXXContextEntryDef<List<WeightCategory>> ALL_CATEGORIES_ENTRY = UIHelper.newListContextEntryDef((String)"RejetThonUI-all-categories");
    JAXXContextEntryDef<List<ReasonForDiscard>> ALL_RAISONS_REJET_ENTRY = UIHelper.newListContextEntryDef((String)"RejetThonUI-all-reasonForDiscards");
    JAXXContextEntryDef<List<TargetLength>> ALL_TAILLES_TO_DELETE_ENTRY = UIHelper.newListContextEntryDef((String)"RejetThonUI-all-taille-to-delete");
    TopiaExecutor<WeightCategory> weightCategoryTopiaExecutor = new TopiaExecutor<WeightCategory>(){

        public void execute(TopiaContext tx, WeightCategory bean) {
            TargetDiscardCatchUIHandler.this.getDecoratorService().decorate((Object)bean.getSpecies());
        }
    };

    public TargetDiscardCatchUIHandler(TargetDiscardCatchUI ui) {
        super(ui, DataContextType.SetSeine);
    }

    protected static Collection<WeightCategory> getWeightCategoryUsed(ContentTableModel<SetSeine, TargetCatch> model) {
        List list = model.getColumnValues(1);
        HashSet<WeightCategory> set = new HashSet<WeightCategory>(list);
        list.clear();
        return set;
    }

    protected static Collection<ReasonForDiscard> getReasonForDiscardUsed(ContentTableModel<SetSeine, TargetCatch> model, WeightCategory weightCategory) {
        HashSet<ReasonForDiscard> set = new HashSet<ReasonForDiscard>();
        if (weightCategory != null) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                TargetCatch c = model.getValueAt(i);
                if (c == null || !weightCategory.equals(c.getWeightCategory()) || c.getReasonForDiscard() == null) continue;
                set.add(c.getReasonForDiscard());
            }
        }
        return set;
    }

    @Override
    public TargetDiscardCatchUI getUi() {
        return (TargetDiscardCatchUI)super.getUi();
    }

    @Override
    public void initUI() throws Exception {
        super.initUI();
        TargetDiscardCatchUI ui = this.getUi();
        ui.getSpecies().addPropertyChangeListener("selectedItem", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ContentTableModel model = TargetDiscardCatchUIHandler.this.getTableModel();
                TargetCatch bean = (TargetCatch)model.getRowBean();
                if (bean.getTopiaId() == null) {
                    Species species = (Species)evt.getNewValue();
                    TargetDiscardCatchUIHandler.this.onEspeceChanged(bean, species);
                }
            }
        });
        ui.getWeightCategory().addPropertyChangeListener("selectedItem", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ContentTableModel model = TargetDiscardCatchUIHandler.this.getTableModel();
                TargetCatch bean = (TargetCatch)model.getRowBean();
                if (bean.getTopiaId() == null) {
                    WeightCategory weightCategory = (WeightCategory)evt.getNewValue();
                    TargetDiscardCatchUIHandler.this.onCategorieChanged(bean, weightCategory);
                }
            }
        });
    }

    @Override
    protected String getEditBeanIdToLoad(DataContext dataContext, DataService dataService, DataSource dataSource) {
        return dataContext.getSelectedSetId();
    }

    @Override
    protected SetSeine loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        ArrayList reasonForDiscardList;
        List categorieList;
        if (mode == ContentMode.UPDATE) {
            categorieList = new ArrayList(dataService.loadDecoratedEntities(dataSource, WeightCategory.class, this.weightCategoryTopiaExecutor));
            ObserveConfig config = this.getUi().getContextValue(ObserveConfig.class);
            String speciesListId = config.getSpeciesListSeineTargetCatch();
            Set speciesIds = this.getDataService().getSpeciesListSpeciesIds(this.getDataSource(), speciesListId);
            categorieList = Species2.filterWeightCategoryBySpeciesIds(categorieList, (Set)speciesIds);
            ReferenceEntities.filterReferentielListByStatus(categorieList);
            Ocean ocean = dataService.getTripOcean(dataSource, dataContext.getSelectedTripId());
            categorieList = Species2.filterWeightCategoryByOcean(categorieList, (Ocean)ocean);
            reasonForDiscardList = new ArrayList(dataService.loadDecoratedEntities(dataSource, ReasonForDiscard.class));
            ReferenceEntities.filterReferentielListByStatus(reasonForDiscardList);
        } else {
            categorieList = new ArrayList();
            reasonForDiscardList = new ArrayList();
        }
        TargetDiscardCatchUI ui = this.getUi();
        this.ALL_CATEGORIES_ENTRY.setContextValue((JAXXContext)ui, categorieList);
        this.ALL_RAISONS_REJET_ENTRY.setContextValue((JAXXContext)ui, reasonForDiscardList);
        return (SetSeine)super.loadEditBean(mode, dataContext, dataService, dataSource);
    }

    @Override
    protected Collection<TargetCatch> loadChilds(TopiaContext tx, SetSeine bean) throws TopiaException {
        Collection childs = ((ContentTableUIModel)this.getModel()).getChildsUpdator().getChilds((TopiaEntity)bean);
        ArrayList<TargetCatch> data = new ArrayList<TargetCatch>();
        if (CollectionUtils.isNotEmpty((Collection)childs)) {
            TopiaDAO dao = this.getDataSource().getDAO(tx, this.getTableEditBean());
            TopiaEntityBinder childLoador = ((ContentTableUIModel)this.getModel()).getChildLoador();
            DecoratorService decoratorService = this.getDecoratorService();
            for (TargetCatch c : childs) {
                if (!c.isDiscarded()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("targetCatch " + c.getSpecies().getLabel2() + " non retenu."));
                    continue;
                }
                try {
                    TargetCatch c2 = (TargetCatch)((ContentTableUIModel)this.getModel()).newTableEditBean();
                    TargetCatch safeC = (TargetCatch)dao.findByTopiaId(c.getTopiaId());
                    WeightCategory weightCategory = safeC.getWeightCategory();
                    if (weightCategory != null) {
                        Species species = weightCategory.getSpecies();
                        decoratorService.decorate((Object)species);
                    }
                    childLoador.load((TopiaEntity)safeC, (TopiaEntity)c2, true, new String[0]);
                    data.add(c2);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doSave(SetSeine bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<SetSeine> binder) throws Exception {
        try {
            boolean bl = super.doSave(bean, dataService, dataSource, binder);
            return bl;
        }
        finally {
            this.ALL_TAILLES_TO_DELETE_ENTRY.removeContextValue((JAXXContext)this.getUi());
        }
    }

    @Override
    protected boolean prepareSave(SetSeine bean, List<TargetCatch> objets) throws DataSourceException {
        HashSet<Species> speciessUsed = new HashSet<Species>();
        for (TargetCatch c : objets) {
            if (c.getBroughtOnDeck() == null || !c.getBroughtOnDeck().booleanValue()) continue;
            speciessUsed.add(c.getSpecies());
        }
        ArrayList tailleToDelete = new ArrayList();
        HashSet speciessToDelete = new HashSet();
        this.getDataService().getObsoleteEspeceForTargetSample(this.getDataSource(), bean.getTopiaId(), speciessUsed, speciessToDelete, tailleToDelete, false);
        if (!tailleToDelete.isEmpty()) {
            StringBuilder sb = new StringBuilder(512);
            StringBuilder sb2 = new StringBuilder(512);
            Decorator decorator = this.getDecoratorService().getDecoratorByType(Species.class);
            Decorator decorator2 = this.getDecoratorService().getDecoratorByType(TargetLength.class);
            for (Species e : speciessToDelete) {
                sb.append("  - ").append(decorator.toString((Object)e)).append('\n');
            }
            for (TargetLength t : tailleToDelete) {
                sb2.append("  - ").append(decorator2.toString((Object)t)).append('\n');
            }
            int reponse = UIHelper.askUser(I18n.t((String)"observe.title.need.confirm", (Object[])new Object[0]), I18n.t((String)"observe.targetDiscarded.message.table.will.delete.targetLength", (Object[])new Object[]{sb.toString(), sb2.toString()}), 0, new Object[]{I18n.t((String)"observe.choice.continue", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            boolean canContinue = false;
            switch (reponse) {
                case 0: {
                    canContinue = true;
                }
            }
            if (!canContinue) {
                return false;
            }
            this.ALL_TAILLES_TO_DELETE_ENTRY.setContextValue((JAXXContext)this.getUi(), tailleToDelete);
        }
        bean.setTargetDiscarded(Boolean.valueOf(!objets.isEmpty()));
        for (TargetCatch discarded : objets) {
            discarded.setDiscarded(true);
            discarded.setSetSeine(bean);
        }
        return true;
    }

    @Override
    protected void onUpdateFinalize(TopiaContext tx, SetSeine bean, Collection<TargetCatch> oldChilds) {
        List tailleToDelete;
        if (oldChilds != null && !oldChilds.isEmpty()) {
            for (TargetCatch targetCatch : oldChilds) {
                if (targetCatch.isDiscarded()) continue;
                bean.addTargetCatch(targetCatch);
            }
        }
        if ((tailleToDelete = (List)this.ALL_TAILLES_TO_DELETE_ENTRY.getContextValue((JAXXContext)this.getUi())) != null && !tailleToDelete.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Will remove " + tailleToDelete.size() + " obsolete targetLength(s)."));
            }
            TargetSample echantillon = bean.getTargetSample(false);
            echantillon.getTargetLength().removeAll(tailleToDelete);
        }
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, TargetCatch bean, boolean create) {
        NumberEditor requestFocus;
        TargetDiscardCatchUI ui = this.getUi();
        WeightCategory beanWeightCategory = bean.getWeightCategory();
        Species beanEspece = beanWeightCategory == null ? null : beanWeightCategory.getSpecies();
        ReasonForDiscard beanReasonForDiscard = bean.getReasonForDiscard();
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected categoriePoid " + beanWeightCategory));
            log.debug((Object)("selected species " + beanEspece));
            log.debug((Object)("selected reasonForDiscard " + beanReasonForDiscard));
        }
        if (create) {
            ContentTableModel model = this.getTableModel();
            if (model.isCreate()) {
                bean.setBroughtOnDeck(Boolean.valueOf(true));
            }
            List<Species> availableEspeces = this.buildEspeceList(beanEspece, beanWeightCategory);
            ui.getSpecies().setData(availableEspeces);
            ui.getSpecies().setSelectedItem(null);
            if (!model.isCreate()) {
                ui.getSpecies().setSelectedItem((Object)beanEspece);
                ui.getWeightCategory().setSelectedItem((Object)beanWeightCategory);
                ui.getReasonForDiscard().setSelectedItem((Object)beanReasonForDiscard);
            }
            requestFocus = ui.getSpecies();
        } else {
            ui.getSpecies().setSelectedItem((Object)beanEspece);
            ui.getWeightCategory().setData(Arrays.asList(beanWeightCategory));
            ui.getWeightCategory().setSelectedItem((Object)beanWeightCategory);
            ui.getReasonForDiscard().setData(Arrays.asList(beanReasonForDiscard));
            ui.getReasonForDiscard().setSelectedItem((Object)beanReasonForDiscard);
            requestFocus = ui.getCatchWeight();
        }
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.fixTableColumnWidth((JTable)table, (int)3, (int)75);
        UIHelper.fixTableColumnWidth((JTable)table, (int)4, (int)20);
        UIHelper.fixTableColumnWidth((JTable)table, (int)5, (int)50);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.targetDiscarded.table.speciesThon", (Object[])new Object[0]), I18n.n((String)"observe.targetDiscarded.table.speciesThon.tip", (Object[])new Object[0]), I18n.n((String)"observe.targetDiscarded.table.weightCategory", (Object[])new Object[0]), I18n.n((String)"observe.targetDiscarded.table.weightCategory.tip", (Object[])new Object[0]), I18n.n((String)"observe.targetDiscarded.table.reasonForDiscard", (Object[])new Object[0]), I18n.n((String)"observe.targetDiscarded.table.reasonForDiscard.tip", (Object[])new Object[0]), I18n.n((String)"observe.targetDiscarded.table.weight", (Object[])new Object[0]), I18n.n((String)"observe.targetDiscarded.table.weight.tip", (Object[])new Object[0]), I18n.n((String)"observe.targetDiscarded.table.broughtOnDeck", (Object[])new Object[0]), I18n.n((String)"observe.targetDiscarded.table.broughtOnDeck.tip", (Object[])new Object[0]), I18n.n((String)"observe.targetDiscarded.table.comment", (Object[])new Object[0]), I18n.n((String)"observe.targetDiscarded.table.comment.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Species.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, WeightCategory.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, ReasonForDiscard.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)20, (boolean)false));
        UIHelper.setTableColumnRenderer((JTable)table, (int)5, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
    }

    protected void onEspeceChanged(TargetCatch bean, Species species) {
        List<Object> data;
        WeightCategory weightCategory = null;
        if (species == null) {
            data = Collections.emptyList();
        } else {
            List<WeightCategory> availableCategories = this.buildWeightCategoryList(species);
            data = availableCategories;
            weightCategory = bean.getWeightCategory();
            if (weightCategory != null && !availableCategories.contains(weightCategory)) {
                weightCategory = null;
            }
        }
        BeanComboBox<WeightCategory> combo = this.getUi().getWeightCategory();
        combo.setData(data);
        combo.setSelectedItem((Object)weightCategory);
    }

    protected void onCategorieChanged(TargetCatch bean, WeightCategory weightCategory) {
        List<Object> data;
        TargetDiscardCatchUI ui = this.getUi();
        ReasonForDiscard reasonForDiscard = null;
        if (weightCategory == null) {
            data = Collections.emptyList();
        } else {
            List<ReasonForDiscard> reasonForDiscardList = this.buildReasonFordiscardList(weightCategory);
            if (log.isDebugEnabled()) {
                log.debug((Object)("new reasonForDiscard list " + reasonForDiscardList));
            }
            data = reasonForDiscardList;
            reasonForDiscard = bean.getReasonForDiscard();
            if (reasonForDiscard != null && !reasonForDiscardList.contains(reasonForDiscard)) {
                reasonForDiscard = null;
            }
        }
        BeanComboBox<ReasonForDiscard> combo = ui.getReasonForDiscard();
        combo.setData(data);
        combo.setSelectedItem(reasonForDiscard);
    }

    protected List<Species> buildEspeceList(Species species, WeightCategory weightCategory) {
        List<WeightCategory> weightCategoryList = this.getAllCategories((JAXXContext)this.getUi());
        this.removeFullyUsedCategories(weightCategoryList);
        if (weightCategory != null) {
            weightCategoryList.add(weightCategory);
        }
        HashSet<Species> usedEspeces = new HashSet<Species>();
        for (WeightCategory cat : weightCategoryList) {
            usedEspeces.add(cat.getSpecies());
        }
        ArrayList<Species> result = new ArrayList<Species>(usedEspeces);
        weightCategoryList.clear();
        usedEspeces.clear();
        return result;
    }

    protected List<WeightCategory> buildWeightCategoryList(Species species) {
        List<WeightCategory> weightCategoryList = this.getAllCategories((JAXXContext)this.getUi());
        Iterator<WeightCategory> it = weightCategoryList.iterator();
        while (it.hasNext()) {
            WeightCategory weighte = it.next();
            if (species.equals(weighte.getSpecies())) continue;
            it.remove();
        }
        this.removeFullyUsedCategories(weightCategoryList);
        return weightCategoryList;
    }

    protected List<ReasonForDiscard> buildReasonFordiscardList(WeightCategory weightCategory) {
        ContentTableModel model = this.getTableModel();
        ArrayList<ReasonForDiscard> reasonForDiscardList = new ArrayList<ReasonForDiscard>((Collection)this.ALL_RAISONS_REJET_ENTRY.getContextValue((JAXXContext)this.getUi()));
        for (int i = 0; i < model.getRowCount(); ++i) {
            TargetCatch c = (TargetCatch)model.getValueAt(i);
            if (c == null || c.getReasonForDiscard() == null || !weightCategory.equals(c.getWeightCategory())) continue;
            reasonForDiscardList.remove(c.getReasonForDiscard());
        }
        return reasonForDiscardList;
    }

    protected List<WeightCategory> getAllCategories(JAXXContext context) {
        ArrayList<WeightCategory> list = new ArrayList<WeightCategory>((Collection)this.ALL_CATEGORIES_ENTRY.getContextValue(context));
        return list;
    }

    protected void removeFullyUsedCategories(List<WeightCategory> weightCategoryAvaillable) {
        ContentTableModel<SetSeine, TargetCatch> model = this.getTableModel();
        int nbReasonForDiscard = ((List)this.ALL_RAISONS_REJET_ENTRY.getContextValue((JAXXContext)this.getUi())).size();
        for (WeightCategory c : TargetDiscardCatchUIHandler.getWeightCategoryUsed(model)) {
            Collection<ReasonForDiscard> raisonUsed = TargetDiscardCatchUIHandler.getReasonForDiscardUsed(model, c);
            if (raisonUsed.size() != nbReasonForDiscard) continue;
            weightCategoryAvaillable.remove(c);
        }
    }
}

