/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.seine;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.constants.seine.SchoolType;
import fr.ird.observe.entities.seine.ActivitySeine;
import fr.ird.observe.entities.seine.Route;
import fr.ird.observe.entities.seine.SetSeine;
import fr.ird.observe.entities.seine.TargetSample;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.impl.seine.SetSeineUI;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.util.Date;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.DateUtil;
import org.nuiton.validator.NuitonValidatorScope;

public class SetSeineUIHandler
extends ContentUIHandler<SetSeine> {
    private static Log log = LogFactory.getLog(SetSeineUIHandler.class);

    public SetSeineUIHandler(SetSeineUI ui) {
        super(ui, DataContextType.ActivitySeine, DataContextType.SetSeine);
    }

    public SetSeineUI getUi() {
        return (SetSeineUI)super.getUi();
    }

    public String updateTypeValue(SchoolType schoolType) {
        if (schoolType == null) {
            return I18n.t((String)"observe.setSeine.schoolType.not.fill", (Object[])new Object[0]);
        }
        return I18n.t((String)schoolType.getI18nKey(), (Object[])new Object[0]);
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String setId = this.getSelectedId();
        if (setId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(ActivitySeine.class)) {
            return ContentMode.UPDATE;
        }
        SetSeineUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, this.getEntityLabel(ActivitySeine.class), I18n.t((String)"observe.activitySeine.message.not.open", (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        String activityId = this.getSelectedParentId();
        String setId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)("activityId = " + activityId));
            log.info((Object)("setId    = " + setId));
        }
        ContentMode mode = this.computeContentMode();
        DataService dataService = this.getDataService();
        SetSeine bean = (SetSeine)this.getBean();
        TopiaEntityBinder binder = this.getLoadBinder();
        DataSource source = this.getDataSource();
        if (setId == null) {
            dataService.preCreate(source, activityId, (TopiaEntity)bean, binder, this.getPreCreateExecutor());
        } else {
            dataService.loadEditEntity(source, setId, this.getLoadExecutor());
        }
        Route route = (Route)this.getDataService().loadEntity(source, this.getDataContext().getSelectedRouteId(), false);
        Date time = bean.getStartTime();
        Date date = route.getDate();
        Date dateAndTime = DateUtil.getDateAndTime((Date)date, (Date)time, (boolean)false, (boolean)false);
        this.getUi().getStartTime().setDate(dateAndTime);
        this.setContentMode(mode);
        if (mode != ContentMode.READ) {
            this.getUi().startEdit(null);
        }
    }

    @Override
    protected SetSeine onPreCreate(TopiaContext tx, Object parent, SetSeine bean) throws TopiaException {
        ActivitySeine parentBean = (ActivitySeine)parent;
        Date date = DateUtil.getTime((Date)parentBean.getTime(), (boolean)false, (boolean)false);
        bean.setStartTime(date);
        try {
            Route route = (Route)this.getDataService().loadEntity(this.getDataSource(), this.getDataContext().getSelectedRouteId(), false);
            bean.setEndSetTimeStamp(date);
            bean.setEndPursingTimeStamp(date);
            bean.setEndSetDate(route.getDate());
            bean.setEndPursingDate(route.getDate());
        }
        catch (DataSourceException e) {
            throw new TopiaException("Could not obtain route", (Throwable)e);
        }
        SchoolType schoolType = parentBean.getSchoolType();
        bean.setSchoolType(schoolType);
        return bean;
    }

    @Override
    protected void onLoad(TopiaContext tx, SetSeine bean) throws TopiaException {
        super.onLoad(tx, bean);
        SetSeine editBean = (SetSeine)this.getBean();
        this.getDataContext().getOpenRouteId();
        if (!editBean.isTargetSampleEmpty()) {
            for (TargetSample e : editBean.getTargetSample()) {
                e.isTargetLengthEmpty();
            }
        }
        if (!editBean.isNonTargetSampleEmpty()) {
            for (TargetSample e : editBean.getNonTargetSample()) {
                e.isNonTargetLengthEmpty();
            }
        }
        UIHelper.processDataBinding((JAXXObject)this.getUi(), (String[])new String[]{"endSetTimeStamp.date", "endPursingTimeStamp.date"});
    }

    @Override
    public void startEditUI(String ... binding) {
        ContentUIModel model = this.getModel();
        boolean create = model.getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(model.getMode());
        this.getUi().getValidator().setContext(contextName);
        if (create) {
            this.addInfoMessage(I18n.t((String)"observe.setSeine.message.creating", (Object[])new Object[0]));
        } else {
            this.addInfoMessage(I18n.t((String)"observe.setSeine.message.updating", (Object[])new Object[0]));
        }
        super.startEditUI("supportVesselName.text", "comment2.text", "startTime.date", "endSetTimeStamp.date", "endSetTimeStamp.date", "endPursingTimeStamp.date", "currentSpeed.model", "currentDirection.model", "reasonForNullSet.selectedItem", "sonarUsed.selected", "currentSpeed.model", "nonTargetDiscarded.booleanValue", "targetDiscarded.booleanValue", "schoolThickness.model", "schoolType.text", "maxGearDepth.model", "schoolMeanDepth.model", "schoolTopDepth.model");
        model.setModified(create);
    }

    @Override
    protected boolean doSave(SetSeine bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<SetSeine> binder) throws Exception {
        String activityId = this.getSelectedParentId();
        if (bean.getTopiaId() == null) {
            dataService.create(dataSource, activityId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        }
        return true;
    }

    @Override
    protected SetSeine onCreate(TopiaContext tx, Object parent, SetSeine editBean) throws TopiaException {
        ActivitySeine parentBean = (ActivitySeine)parent;
        SetSeine beanToSave = (SetSeine)ObserveDAOHelper.getSetSeineDAO((TopiaContext)tx).create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        parentBean.setSetSeine(beanToSave);
        return beanToSave;
    }

    @Override
    protected SetSeine onUpdate(TopiaContext tx, Object parentBean, SetSeine beanToSave) throws TopiaException {
        this.getLoadBinder().copyExcluding(this.getBean(), (Object)beanToSave, new String[]{"targetSample", "nonTargetSample"});
        return beanToSave;
    }

    @Override
    protected void afterSave(boolean refresh) {
        boolean create;
        super.afterSave(refresh);
        SetSeine bean = (SetSeine)this.getBean();
        SwingValidatorUtil.setValidatorChanged((JAXXObject)this.getUi(), (boolean)false, (String[])new String[0]);
        ObserveTreeHelper treeHelper = SetSeineUIHandler.getTreeHelper((JAXXContext)this.getUi());
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        boolean bl = create = node.getId() == null;
        if (create) {
            this.getModel().setMode(ContentMode.UPDATE);
            ObserveNode parentNode = (ObserveNode)treeHelper.removeNode((NavNode)node);
            node = treeHelper.addSet(parentNode, bean);
            this.stopEditUI();
            treeHelper.selectNode((NavNode)node);
        } else {
            treeHelper.refreshNode((NavNode)node, false);
        }
    }

    @Override
    protected boolean doDelete(SetSeine bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, SetSeine> deletor) throws Exception {
        if (this.askToDelete(bean)) {
            return false;
        }
        String activityId = this.getSelectedParentId();
        dataService.delete(dataSource, activityId, (TopiaEntity)bean, deletor);
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, SetSeine beanToDelete) throws TopiaException {
        ActivitySeine parentBean = (ActivitySeine)parent;
        ObserveDAOHelper.getSetSeineDAO((TopiaContext)tx).delete(parentBean.getSetSeine());
        parentBean.setSetSeine(null);
    }
}

