/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui;

import fr.ird.observe.DataService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveConfigOption;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveRunner;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceConfig;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.DataSourceFactory;
import fr.ird.observe.db.constants.CreationMode;
import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.db.impl.H2DataSource;
import fr.ird.observe.db.impl.H2DataSourceConfig;
import fr.ird.observe.db.impl.PGDataSourceConfig;
import fr.ird.observe.entities.constants.ReferenceLocale;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveUIMode;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminUILauncher;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.ContentUIManager;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.ObserveContentUI;
import fr.ird.observe.ui.storage.StorageBackupUILauncher;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUI;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUILauncher;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import fr.ird.observe.ui.util.ObserveValidatorMessageTableRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.config.ConfigUIHelper;
import jaxx.runtime.swing.config.model.CallBackFinalizer;
import jaxx.runtime.swing.config.model.MainCallBackFinalizer;
import jaxx.runtime.swing.help.JAXXHelpBroker;
import jaxx.runtime.swing.help.JAXXHelpUIHandler;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.tools.Server;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;
import org.nuiton.validator.NuitonValidatorScope;

@DefaultApplicationContext.AutoLoad
public class ObserveMainUIHandler
implements JAXXHelpUIHandler {
    private static Log log = LogFactory.getLog(ObserveMainUIHandler.class);
    public static final String H2_SERVER = "server";
    public static final String H2_WEB_SERVER = "webServer";
    public static final String H2_SERVER_URL_PATTERN = "jdbc:h2:%s/%s/obstuna";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeNavigationNode(ObserveMainUI ui, TreeSelectionEvent event) {
        DataSource source = ui.getDataSource();
        if (source == null || !source.isOpen()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No open Data source.");
            }
            return;
        }
        if (ui.getNavigation().isSelectionEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No selection, do nothing...");
            }
            return;
        }
        TreePath path = event.getPath();
        ObserveNode node = (ObserveNode)((Object)path.getLastPathComponent());
        ContentUIManager manager = ui.getContentManager();
        Class<? extends ObserveContentUI<?>> uiClass = manager.convertNodeToContentUI(node);
        if (log.isDebugEnabled()) {
            log.debug((Object)("new selected path = " + (Object)((Object)node) + ", ui = " + uiClass));
        }
        if (uiClass == null) {
            return;
        }
        ui.setBusy(true);
        try {
            this.doOpencontent(ui, path, manager, uiClass);
            ui.setBusy(false);
        }
        catch (Exception e) {
            try {
                if (log.isErrorEnabled()) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                ErrorDialogUI.showError((Exception)e);
                ui.setBusy(false);
            }
            catch (Throwable throwable) {
                ui.setBusy(false);
                String params = node.isStringNode() ? I18n.t((String)node.getId(), (Object[])new Object[0]) : I18n.t((String)ui.getDataService().getDecoratorService().getEntityLabel(node.getInternalClass()), (Object[])new Object[0]);
                ui.getStatus().setStatus(I18n.t((String)"observe.action.open.screen", (Object[])new Object[]{params}));
                throw throwable;
            }
            String params = node.isStringNode() ? I18n.t((String)node.getId(), (Object[])new Object[0]) : I18n.t((String)ui.getDataService().getDecoratorService().getEntityLabel(node.getInternalClass()), (Object[])new Object[0]);
            ui.getStatus().setStatus(I18n.t((String)"observe.action.open.screen", (Object[])new Object[]{params}));
        }
        String params = node.isStringNode() ? I18n.t((String)node.getId(), (Object[])new Object[0]) : I18n.t((String)ui.getDataService().getDecoratorService().getEntityLabel(node.getInternalClass()), (Object[])new Object[0]);
        ui.getStatus().setStatus(I18n.t((String)"observe.action.open.screen", (Object[])new Object[]{params}));
    }

    public void doOpencontent(ObserveMainUI ui, TreePath path, ContentUIManager manager, Class<? extends ObserveContentUI<?>> uiClass) {
        Object[] nodes = path.getPath();
        ArrayList<String> ids = new ArrayList<String>();
        for (Object o : nodes) {
            ObserveNode n = (ObserveNode)((Object)o);
            if (n.isStringNode() || n.isReferentielNode() || n.isRoot() || !n.isDataNode()) continue;
            ids.add(n.getId());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("new selected ids from tree = " + ids));
        }
        String[] selectedIds = ids.toArray(new String[ids.size()]);
        DataContext context = ui.getDataContext();
        context.populateSelectedIds(selectedIds);
        ObserveContentUI<?> content = manager.getContent(uiClass);
        if (content == null) {
            content = manager.createContent(uiClass);
        }
        manager.openContent(content);
    }

    public ObserveMainUI initUI(ObserveContext context, ObserveConfig config) {
        SwingValidatorMessageTableModel errorModel = new SwingValidatorMessageTableModel(){
            private static final long serialVersionUID = 1L;

            public void removeMessages(JComponent editor, NuitonValidatorScope scope) {
                if (scope == null) {
                    int nb = this.getRowCount();
                    if (nb > 0) {
                        this.data.clear();
                        this.fireTableRowsDeleted(0, nb - 1);
                    }
                } else {
                    super.removeMessages(editor, scope);
                }
            }
        };
        DecoratorService decoratorService = context.getDecoratorService();
        boolean reloadDecorators = false;
        Locale currentLocale = I18n.getDefaultLocale();
        Locale configurationLocale = config.getLocale();
        if (!configurationLocale.equals(currentLocale)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("re-init I18n with locale " + configurationLocale));
            }
            I18n.setDefaultLocale((Locale)configurationLocale);
            reloadDecorators = true;
        }
        if (!config.getDbLocale().equals(decoratorService.getReferentielLocale().getLocale())) {
            if (log.isInfoEnabled()) {
                log.info((Object)("re-init db with locale " + config.getDbLocale()));
            }
            decoratorService.setReferentielLocale(ReferenceLocale.valueOf((Locale)config.getDbLocale()));
            reloadDecorators = true;
        }
        if (reloadDecorators) {
            if (log.isInfoEnabled()) {
                log.info((Object)"reload decorators");
            }
            decoratorService.reload();
        }
        ObserveTreeHelper treeHelper = new ObserveTreeHelper();
        DataSource source = context.getDataSource();
        boolean open = context.getDataContext().getEnabled();
        if (open) {
            treeHelper.createModel(source);
        } else {
            treeHelper.createEmptyModel();
        }
        JAXXInitialContext tx = new JAXXInitialContext();
        tx.add((Object)context).add((Object)treeHelper).add((Object)errorModel);
        ObserveMainUI ui = new ObserveMainUI((JAXXContext)tx);
        ui.setUndecorated(config.isFullScreen());
        String title = ObserveRunner.isAdmin() ? I18n.t((String)"observe.title.welcome.admin", (Object[])new Object[0]) : I18n.t((String)"observe.title.welcome", (Object[])new Object[0]);
        title = title + " v " + config.getVersion();
        ui.setTitle(title);
        context.setObserveMainUI(ui);
        ErrorDialogUI.init((Frame)ui);
        ui.getGraphicsConfiguration().getDevice().setFullScreenWindow(config.isFullScreen() ? ui : null);
        context.registerShareActions(ui);
        return ui;
    }

    public void reloadResources(ObserveMainUI ui) {
        ObserveConfig config;
        block6: {
            boolean canContinue;
            if (log.isInfoEnabled()) {
                log.info((Object)"ObServe reloading resources...");
            }
            if (!(canContinue = this.ensureModification(ui))) {
                return;
            }
            config = ui.getConfig();
            File directory = config.getResourcesDirectory();
            if (log.isInfoEnabled()) {
                log.info((Object)I18n.t((String)"observe.message.delete.directory", (Object[])new Object[]{directory}));
            }
            try {
                FileUtils.deleteDirectory((File)directory);
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)("Could not delete resources directory: " + directory), (Throwable)e);
            }
        }
        I18n.reload();
        DecoratorService decoratorService = ui.getContextValue(DecoratorService.class);
        if (log.isInfoEnabled()) {
            log.info((Object)"reload decorators");
        }
        decoratorService.reload();
        ObserveRunner.getRunner().loadUIConfig(config);
        Callback.ui.run();
    }

    public void reloadDefaultConfiguration(ObserveMainUI ui) {
        block5: {
            boolean canContinue;
            if (log.isInfoEnabled()) {
                log.info((Object)"ObServe reloading default configuration...");
            }
            if (!(canContinue = this.ensureModification(ui))) {
                return;
            }
            ObserveConfig config = ui.getConfig();
            File directory = config.getResourcesDirectory();
            if (log.isInfoEnabled()) {
                log.info((Object)I18n.t((String)"observe.message.delete.directory", (Object[])new Object[]{directory}));
            }
            try {
                FileUtils.deleteDirectory((File)directory);
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)("Could not delete resources directory: " + directory), (Throwable)e);
            }
        }
        Callback.application.run();
    }

    public void reloadApplication(ObserveMainUI ui) {
        boolean canContinue;
        if (log.isInfoEnabled()) {
            log.info((Object)"ObServe reloading...");
        }
        if (!(canContinue = this.ensureModification(ui))) {
            return;
        }
        Callback.application.run();
    }

    public void changeLanguage(ObserveMainUI ui, Locale newLocale) {
        boolean canContinue;
        if (log.isInfoEnabled()) {
            log.info((Object)"ObServe changing application language...");
        }
        if (!(canContinue = this.ensureModification(ui))) {
            return;
        }
        ObserveConfig config = ui.getConfig();
        config.setOption(ObserveConfigOption.LOCALE, newLocale);
        Callback.ui.run();
    }

    public void changeDbLanguage(ObserveMainUI ui, ReferenceLocale newLocale) {
        boolean canContinue;
        if (log.isInfoEnabled()) {
            log.info((Object)"ObServe changing db language...");
        }
        if (!(canContinue = this.ensureModification(ui))) {
            return;
        }
        ObserveConfig config = ui.getConfig();
        config.setOption(ObserveConfigOption.DB_LOCALE, newLocale.getLocale());
        Callback.ui.run();
    }

    public void changeScreen(ObserveMainUI ui, boolean fullscreen) {
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        ObserveConfig config = ui.getConfig();
        config.setOption(ObserveConfigOption.FULL_SCREEN, fullscreen);
        this.reloadUI(ObserveContext.get(), config);
    }

    public void showStorageInfo(ObserveMainUI ui) {
        String text = ui.getConfig().isMainStorageOpened() ? ui.getDataSource().toString() : I18n.t((String)"observe.message.db.none.loaded", (Object[])new Object[0]);
        JOptionPane.showMessageDialog(ui, text, I18n.t((String)"observe.title.storage.info", (Object[])new Object[0]), 1);
    }

    public void launchImportFromFile(ObserveMainUI ui) {
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        new StorageUILauncher((JAXXContext)ui, this.getUI((JAXXContext)ui), I18n.t((String)"observe.title.import.localDB", (Object[])new Object[0])){

            @Override
            protected void init(StorageUI ui) {
                super.init(ui);
                StorageUIModel model = ui.getModel();
                model.setCanCreateLocalService(true);
                model.setCanUseLocalService(false);
                model.setCanUseRemoteService(false);
                model.setDbMode(DbMode.CREATE_LOCAL);
                model.setCreationMode(CreationMode.IMPORT_EXTERNAL_DUMP);
                if (model.isLocalStorageExist()) {
                    model.setSteps(new StorageStep[]{StorageStep.CONFIG, StorageStep.BACKUP, StorageStep.CONFIRM});
                    model.setDoBackup(true);
                } else {
                    model.setSteps(new StorageStep[]{StorageStep.CONFIG, StorageStep.CONFIRM});
                }
            }

            @Override
            protected void doAction(StorageUI ui) {
                super.doAction(ui);
                StorageUIHandler handler = this.getStorageUIHandler();
                handler.doChangeStorage((JAXXContext)ui, ui.getModel());
            }
        }.start();
    }

    public void launchChangeStorage(ObserveMainUI ui, DbMode mode, String title) {
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        StorageUILauncher.changeStorage((JAXXContext)ui, this.getUI((JAXXContext)ui), mode, I18n.t((String)title, (Object[])new Object[0]));
    }

    public void launchExportToFile(ObserveMainUI ui) {
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        DataSource service = ObserveMainUIHandler.getStorage();
        boolean local = service.getConfig() instanceof H2DataSourceConfig;
        if (!(local || service.canReadData() && service.canWriteData())) {
            UIHelper.askUser(null, I18n.t((String)"observe.title.can.not.export.obstuna", (Object[])new Object[0]), I18n.t((String)"observe.storage.required.rw.on.data", (Object[])new Object[]{service}), 0, new Object[]{I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
            return;
        }
        String title = local ? I18n.t((String)"observe.title.save.localDB", (Object[])new Object[0]) : I18n.t((String)"observe.title.save.remoteDB", (Object[])new Object[0]);
        StorageBackupUILauncher launcher = new StorageBackupUILauncher((JAXXContext)ui, ui, title);
        launcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchCloseStorage(ObserveMainUI ui) {
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        this.setBusy((JAXXContext)ui, true);
        try {
            DataSource storage = ObserveMainUIHandler.getStorage();
            if (log.isDebugEnabled()) {
                log.debug((Object)(">>> close main storage " + storage));
            }
            storage.doClose(false);
        }
        catch (DataSourceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
            if (log.isErrorEnabled()) {
                log.error((Object)ex);
            }
        }
        finally {
            this.setBusy((JAXXContext)ui, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchReloadStorage(ObserveMainUI ui) {
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        DataSource storage = ObserveMainUIHandler.getStorage();
        if (storage == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"No storage to reload");
            }
            return;
        }
        this.setBusy((JAXXContext)ui, false);
        String[] ids = ui.getTreeHelper().getSelectedIds();
        try {
            DataSourceConfig config;
            block14: {
                config = storage.getConfig().clone();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(">>> close main storage " + storage));
                    }
                    storage.doClose(false);
                }
                catch (DataSourceException e) {
                    ErrorDialogUI.showError((Exception)((Object)e));
                    if (!log.isErrorEnabled()) break block14;
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            ObserveConfig appConfig = ObserveContext.get().getConfig();
            if (config instanceof H2DataSourceConfig) {
                H2DataSourceConfig h2Config = (H2DataSourceConfig)config;
                h2Config.setCanMigrate(appConfig.isCanMigrateH2());
                h2Config.detectPolicy();
            }
            if (config instanceof PGDataSourceConfig) {
                PGDataSourceConfig pgConfig = (PGDataSourceConfig)config;
                pgConfig.setCanMigrate(appConfig.isCanMigrateObstuna());
            }
            try {
                storage = DataSourceFactory.newService((DataSourceConfig)config, storage.getClass());
                ObserveContext.get().setNodesToReselect(ids);
                ObserveContext.get().prepareMainStorage(storage);
                storage.doOpen();
            }
            catch (Exception e) {
                ErrorDialogUI.showError((Exception)e);
                if (log.isErrorEnabled()) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            this.setBusy((JAXXContext)ui, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeApplication(ObserveMainUI ui) {
        boolean canContinue;
        if (log.isInfoEnabled()) {
            log.info((Object)"ObServe quitting...");
        }
        if (!(canContinue = this.ensureModification(ui))) {
            return;
        }
        try {
            ui.dispose();
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ask to release runner.");
            }
            ObserveRunner.unlock();
        }
    }

    public void launchStartServerMode(ObserveMainUI ui) {
        if (log.isInfoEnabled()) {
            log.info((Object)"Will start server mode...");
        }
        ObserveConfig config = ui.getConfig();
        File dbDirectory = new File(config.getLocalDBDirectory(), "obstuna");
        String h2Login = config.getH2Login();
        String h2Password = new String(config.getH2Password());
        Integer port = config.getH2ServerPort();
        ui.setMode(ObserveUIMode.SERVER);
        try {
            Server server = Server.createTcpServer((String[])new String[]{"-tcp", "-tcpAllowOthers", "-ifExists", "-baseDir", dbDirectory.getAbsolutePath(), "-tcpDaemon", "-tcpPort", String.valueOf(port)});
            String url = String.format(H2_SERVER_URL_PATTERN, server.getURL(), dbDirectory.getAbsolutePath());
            server.start();
            if (log.isInfoEnabled()) {
                log.info((Object)("server starts at " + url));
            }
            String text = I18n.t((String)"observe.message.server.info", (Object[])new Object[]{dbDirectory});
            ui.getServerModeInfo().setText(text);
            ui.getServerModeURL().setText(url);
            ui.getServerModeLogin().setText(h2Login);
            ui.getServerModePassword().setText(h2Password);
            ui.setContextValue(server, H2_SERVER);
        }
        catch (SQLException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not start h2 server ", (Throwable)e);
            }
            ErrorDialogUI.showError((Exception)e);
        }
    }

    public void launchStopServerMode(ObserveMainUI ui) {
        Server server;
        if (log.isInfoEnabled()) {
            log.info((Object)"Will stop server mode...");
        }
        if ((server = ui.getContextValue(Server.class, H2_SERVER)) != null) {
            server.stop();
        }
        ui.setMode(ObserveUIMode.NO_DB);
        if (ui.isH2WebServer().booleanValue()) {
            this.launchStopH2WebServer(ui);
        }
    }

    public void launchStartH2WebServer(ObserveMainUI ui) {
        if (ui.isH2WebServer().booleanValue()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can not start h2 web server... (web server already found)");
            }
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Will start h2 web server ...");
        }
        try {
            Server server = Server.createWebServer((String[])new String[]{"-webAllowOthers"});
            server.start();
            Server.openBrowser((String)server.getURL());
            ui.setContextValue(server, H2_WEB_SERVER);
            ui.setH2WebServer(true);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not start h2 web server ", (Throwable)e);
            }
            ErrorDialogUI.showError((Exception)e);
        }
    }

    public void launchStopH2WebServer(ObserveMainUI ui) {
        Server server;
        if (!ui.isH2WebServer().booleanValue()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can not stop h2 web server... (no web server found)");
            }
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Will stop web server mode...");
        }
        if ((server = ui.getContextValue(Server.class, H2_WEB_SERVER)) != null) {
            server.stop();
        }
        ui.setH2WebServer(false);
    }

    public void showConfig(JAXXContext context) {
        boolean canContinue;
        ObserveMainUI ui = this.getUI(context);
        if (log.isInfoEnabled()) {
            log.info((Object)"ObServe opening configuration ui...");
        }
        if (ui != null && !(canContinue = this.ensureModification(ui))) {
            return;
        }
        ObserveConfig config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        ObserveConfigUIBuilder helper = new ObserveConfigUIBuilder(config);
        for (Callback callback : Callback.values()) {
            helper.registerCallBack(callback);
        }
        helper.setFinalizer((CallBackFinalizer)new MainCallBackFinalizer(Callback.application.name()));
        helper.setCloseAction(new Runnable(){

            @Override
            public void run() {
                ObserveMainUIHandler.restartEdit();
            }
        });
        helper.addCategory(I18n.n((String)"observe.config.category.directories", (Object[])new Object[0]), I18n.n((String)"observe.config.category.directories.description", (Object[])new Object[0]));
        helper.addOption(ObserveConfigOption.CONFIG_FILE);
        helper.addOption(ObserveConfigOption.DATA_DIRECTORY);
        helper.addOption(ObserveConfigOption.DB_DIRECTORY);
        helper.addOption(ObserveConfigOption.BACKUP_DIRECTORY);
        helper.addOption(ObserveConfigOption.TMP_DIRECTORY);
        helper.addOption(ObserveConfigOption.VALIDATION_REPORT_DIRECTORY);
        helper.addOption(ObserveConfigOption.RESOURCES_DIRECTORY, Callback.application);
        helper.addCategory(I18n.n((String)"observe.config.category.h2", (Object[])new Object[0]), I18n.n((String)"observe.config.category.h2.description", (Object[])new Object[0]));
        helper.addOption(ObserveConfigOption.H2_LOGIN);
        helper.addOption(ObserveConfigOption.H2_PASSWORD);
        helper.addOption(ObserveConfigOption.H2_CAN_MIGRATE);
        helper.addOption(ObserveConfigOption.H2_SERVER_PORT);
        helper.addCategory(I18n.n((String)"observe.config.category.obstuna", (Object[])new Object[0]), I18n.n((String)"observe.config.category.obstuna.description", (Object[])new Object[0]));
        helper.addOption(ObserveConfigOption.OBSTUNA_URL);
        helper.addOption(ObserveConfigOption.OBSTUNA_LOGIN);
        helper.addOption(ObserveConfigOption.OBSTUNA_USE_SSL_CERT);
        if (ObserveRunner.isAdmin()) {
            helper.addOption(ObserveConfigOption.OBSTUNA_CAN_MIGRATE, Callback.db);
        }
        helper.addCategory(I18n.n((String)"observe.config.category.changeStorage", (Object[])new Object[0]), I18n.n((String)"observe.config.category.changeStorage.description", (Object[])new Object[0]));
        helper.addOption(ObserveConfigOption.DEFAULT_DB_MODE);
        helper.addOption(ObserveConfigOption.DEFAULT_CREATION_MODE);
        helper.addOption(ObserveConfigOption.STORE_REMOTE_STORAGE);
        helper.addOption(ObserveConfigOption.SHOW_MIGRATION_PROGRESSION);
        helper.addOption(ObserveConfigOption.SHOW_MIGRATION_SQL);
        helper.addOption(ObserveConfigOption.SHOW_SQL, Callback.application);
        helper.addCategory(I18n.n((String)"observe.config.category.gps", (Object[])new Object[0]), I18n.n((String)"observe.config.category.gps.description", (Object[])new Object[0]));
        helper.addOption(ObserveConfigOption.DEFAULT_GPS_MAX_DELAY);
        helper.addOption(ObserveConfigOption.DEFAULT_GPS_MAX_SPEED);
        if (ObserveRunner.isAdmin()) {
            helper.addCategory(I18n.n((String)"observe.config.category.synchro", (Object[])new Object[0]), I18n.n((String)"observe.config.category.synchro.description", (Object[])new Object[0]));
            helper.addOption(ObserveConfigOption.CHANGE_SYNCHRO_SRC);
            helper.addOption(ObserveConfigOption.H2_CAN_MIGRATE);
            helper.addCategory(I18n.n((String)"observe.config.category.observation", (Object[])new Object[0]), I18n.n((String)"observe.config.category.observation.description", (Object[])new Object[0]));
            helper.addOption(ObserveConfigOption.DETAILLED_ACTIVITIES_OBSERVATION, Callback.ui);
            helper.addOption(ObserveConfigOption.NON_TARGET_OBSERVATION);
            helper.addOption(ObserveConfigOption.BAIT_OBSERVATION);
            helper.addOption(ObserveConfigOption.MAMMALS_OBSERVATION);
            helper.addOption(ObserveConfigOption.SAMPLES_OBSERVATION);
            helper.addOption(ObserveConfigOption.OBJECTS_OBSERVATION);
            helper.addOption(ObserveConfigOption.BIRDS_OBSERVATION);
            helper.addOption(ObserveConfigOption.TARGET_DISCARDS_OBSERVATION);
            helper.addCategory(I18n.n((String)"observe.config.category.speciesList.seine", (Object[])new Object[0]), I18n.n((String)"observe.config.category.speciesList.seine.description", (Object[])new Object[0]), Callback.ui.name());
            helper.addOption(ObserveConfigOption.SPECIES_LIST_SEINE_TARGET_CATCH);
            helper.addOption(ObserveConfigOption.SPECIES_LIST_SEINE_SCHOOL_ESTIMATE);
            helper.addOption(ObserveConfigOption.SPECIES_LIST_SEINE_OBJECT_SCHOOL_ESTIMATE);
            helper.addOption(ObserveConfigOption.SPECIES_LIST_SEINE_NON_TARGET_CATCH);
            helper.addOption(ObserveConfigOption.SPECIES_LIST_SEINE_OBJECT_OBSERVED_SPECIES);
            helper.addCategory(I18n.n((String)"observe.config.category.speciesList.longline", (Object[])new Object[0]), I18n.n((String)"observe.config.category.speciesList.longline.description", (Object[])new Object[0]), Callback.ui.name());
            helper.addOption(ObserveConfigOption.SPECIES_LIST_LONGLINE_CATCH);
            helper.addOption(ObserveConfigOption.SPECIES_LIST_LONGLINE_ENCOUNTER);
        }
        helper.addCategory(I18n.n((String)"observe.config.category.other", (Object[])new Object[0]), I18n.n((String)"observe.config.category.other.description", (Object[])new Object[0]));
        helper.addOption(ObserveConfigOption.SHOW_NUMBER_EDITOR_BUTTON);
        helper.addOption(ObserveConfigOption.AUTO_POPUP_NUMBER_EDITOR);
        helper.addOption(ObserveConfigOption.SHOW_DATE_TIME_EDITOR_SLIDER);
        helper.addOption(ObserveConfigOption.LOAD_LOCAL_STORAGE, Callback.application);
        helper.addOption(ObserveConfigOption.LOCALE, Callback.ui);
        helper.addOption(ObserveConfigOption.DB_LOCALE, Callback.ui);
        helper.buildUI(context, "observe.config.category.directories");
        helper.displayUI(ui, false);
    }

    public void showHelp(JAXXContext context, JAXXHelpBroker broker, String helpId) {
        ObserveMainUI mainUI = this.getUI(context);
        if (helpId == null) {
            helpId = broker.getDefaultID();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("show help " + helpId));
        }
        mainUI.getHelp().setCurrentID(helpId);
        mainUI.setContextValue(mainUI.getMode(), "oldMode");
        mainUI.setMode(ObserveUIMode.HELP);
    }

    public void closeHelp(JAXXContext context) {
        ObserveMainUI mainUI = this.getUI(context);
        ObserveUIMode oldMode = mainUI.getContextValue(ObserveUIMode.class, "oldMode");
        if (oldMode == null) {
            DataSource mainStorage = mainUI.getDataSource();
            oldMode = mainStorage == null ? ObserveUIMode.NO_DB : ObserveUIMode.DB;
        }
        mainUI.setMode(oldMode);
    }

    public void gotoSite(ObserveMainUI ui) {
        ObserveConfig config = ui.getConfig();
        URL siteURL = config.getOptionAsURL("application.site.url");
        UIHelper.displayInfo(I18n.t((String)"observe.message.goto.site", (Object[])new Object[]{siteURL}));
        if (log.isInfoEnabled()) {
            log.info((Object)("goto " + siteURL));
        }
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(siteURL.toURI());
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
                ErrorDialogUI.showError((Exception)ex);
            }
        }
    }

    public void showAbout(ObserveMainUI ui) {
        String translateText;
        AboutPanel about = new AboutPanel(){
            private static final long serialVersionUID = 1L;

            public void buildTopPanel() {
                this.topPanel.setLayout(new BorderLayout());
                ImageIcon logoIcon = Resource.getIcon((String)"/icons/logo-OT_web.png");
                JLabel labelIcon = new JLabel(logoIcon);
                this.topPanel.add((Component)labelIcon, "West");
                logoIcon = Resource.getIcon((String)"/icons/logo_ird.png");
                labelIcon = new JLabel(logoIcon);
                this.topPanel.add((Component)labelIcon, "East");
            }
        };
        String name = ObserveRunner.getRunner().getRunnerName();
        about.setTitle(I18n.t((String)"observe.title.about", (Object[])new Object[0]));
        about.setAboutText(I18n.t((String)"observe.about.message", (Object[])new Object[0]));
        about.setBottomText(ui.getConfig().getCopyrightText());
        about.setIconPath("/icons/logo-OT_web.png");
        about.setLicenseFile("META-INF/" + name + "-LICENSE.txt");
        about.setThirdpartyFile("META-INF/" + name + "-THIRD-PARTY.txt");
        about.buildTopPanel();
        JScrollPane translatePane = new JScrollPane();
        JEditorPane translateArea = new JEditorPane();
        translateArea.setContentType("text/html");
        translateArea.setEditable(false);
        if (translateArea.getFont() != null) {
            translateArea.setFont(translateArea.getFont().deriveFont(11.0f));
        }
        translateArea.setBorder(null);
        File csvFile = new File(ui.getConfig().getI18nDirectory(), "observe-i18n.csv");
        try {
            translateText = I18n.t((String)"observe.about.translate.content", (Object[])new Object[]{csvFile.toURI().toURL()});
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not obtain url from " + csvFile, e);
        }
        translateArea.setText(translateText);
        translatePane.getViewport().add(translateArea);
        translateArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                UIHelper.openLink(e);
            }
        });
        about.getTabs().add(I18n.t((String)"observe.about.translate.title", (Object[])new Object[0]), translatePane);
        about.init();
        about.showInDialog((Frame)ui, true);
    }

    protected static DataSource getStorage() {
        DataSource source = ObserveContext.get().getDataSource();
        return source;
    }

    protected static DataService getDataService() {
        return ObserveContext.get().getDataService();
    }

    protected void setBusy(JAXXContext context, boolean busy) {
        ObserveMainUI observeMainUI = this.getUI(context);
        if (observeMainUI != null) {
            observeMainUI.setBusy(busy);
        }
    }

    public static void restartEdit() {
        ContentUI<?> selectedUI = ObserveContext.get().getSelectedContentUI();
        if (selectedUI == null) {
            return;
        }
        ContentUIModel<?> model = selectedUI.getModel();
        if (!model.isEditable()) {
            return;
        }
        ContentMode contentMode = model.getMode();
        if (ContentMode.UPDATE != contentMode) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will restart edit for " + selectedUI.getName()));
        }
        selectedUI.restartEdit();
    }

    public void launchAdminAction(ObserveMainUI ui, AdminStep action) {
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        AdminUILauncher launcher = AdminUILauncher.newLauncher((JAXXContext)ui, action);
        launcher.start();
    }

    protected void reloadUI(ObserveContext rootContext, ObserveConfig config) {
        config.removeJaxxPropertyChangeListener();
        ObserveMainUI ui = this.getUI((JAXXContext)rootContext);
        DataSource mainStorage = rootContext.getDataSource();
        ObserveUIMode oldMode = null;
        String[] ids = null;
        if (ui != null) {
            oldMode = ui.getMode();
            ids = ui.getTreeHelper().getSelectedIds();
            ErrorDialogUI.init(null);
            rootContext.removeObserveMainUI();
            ui.dispose();
            ui.setVisible(false);
            System.runFinalization();
        }
        ui = this.initUI(rootContext, config);
        if (oldMode == null) {
            oldMode = mainStorage == null ? ObserveUIMode.NO_DB : ObserveUIMode.DB;
        }
        ui.setMode(oldMode);
        if (oldMode == ObserveUIMode.DB) {
            rootContext.setNodesToReselect(ids);
            ui.getTreeHelper().selectInitialNode(ui);
        }
        UIHelper.setMainUIVisible(ui);
    }

    public ContentUI<?> getSelectedContent(JAXXContext rootContext) {
        JPanel container;
        if (rootContext == null) {
            throw new IllegalArgumentException("rootContext can not be null");
        }
        ObserveMainUI ui = this.getUI(rootContext);
        ContentUI ui1 = null;
        if (ui == null) {
            return ui1;
        }
        CardLayout2 layout = ui.getContentLayout();
        Component currentContent = layout.getVisibleComponent((Container)(container = ui.getContent()));
        if (currentContent != null && currentContent instanceof ContentUI) {
            ui1 = (ContentUI)((Object)currentContent);
        }
        return ui1;
    }

    protected Icon updateStorageSatutIcon(ObserveMainUI ui, boolean isOpened) {
        DataSource service;
        Icon icon = ui.getConfig().isMainStorageOpened() ? ((service = ui.getDataSource()) instanceof H2DataSource ? (Icon)ui.storageStatus.getClientProperty("localIcon") : (Icon)ui.storageStatus.getClientProperty("remoteIcon")) : (Icon)ui.storageStatus.getClientProperty("noneIcon");
        return icon;
    }

    protected String updateStorageSatutText(ObserveMainUI ui, boolean isOpened) {
        String text;
        if (ui.getConfig().isMainStorageOpened()) {
            DataSource service = ui.getDataSource();
            text = service.getShortLabel();
        } else {
            text = I18n.t((String)"observe.message.db.none.loaded", (Object[])new Object[0]);
        }
        return text;
    }

    protected String updateStorageStatutToolTipText(ObserveMainUI ui, boolean isOpened) {
        String text;
        if (ui.getConfig().isMainStorageOpened()) {
            DataSource source = ui.getDataSource();
            text = I18n.t((String)"observe.message.loaded.tip", (Object[])new Object[]{source.getLabel()});
        } else {
            text = I18n.t((String)"observe.message.db.none.loaded.tip", (Object[])new Object[0]);
        }
        return text;
    }

    public boolean acceptMode(ObserveUIMode mode, ObserveUIMode ... modes) {
        return this.acceptMode(mode, true, modes);
    }

    public boolean acceptMode(ObserveUIMode mode, boolean condition, ObserveUIMode ... modes) {
        if (condition) {
            for (ObserveUIMode m : modes) {
                if (!m.equals((Object)mode)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean acceptMode(ObserveUIMode mode, boolean notBusy, boolean condition, ObserveUIMode ... modes) {
        if (notBusy && condition) {
            for (ObserveUIMode m : modes) {
                if (!m.equals((Object)mode)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean rejectMode(ObserveUIMode mode, ObserveUIMode ... modes) {
        for (ObserveUIMode m : modes) {
            if (!m.equals((Object)mode)) continue;
            return false;
        }
        return true;
    }

    public boolean acceptLocale(Locale l, String expected) {
        return l != null && l.toString().equals(expected);
    }

    protected boolean ensureModification(ObserveMainUI ui) throws IllegalArgumentException {
        boolean closed = ObserveContext.get().closeSelectedContentUI(ui);
        return closed;
    }

    protected ObserveMainUI getUI(JAXXContext context) {
        if (context instanceof ObserveMainUI) {
            return (ObserveMainUI)context;
        }
        ObserveMainUI ui = ObserveContext.get().getObserveMainUI();
        return ui;
    }

    protected void $afterCompleteSetup(final ObserveMainUI ui) {
        ui.getStatus().init();
        TreeSelectionListener listener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ObserveMainUIHandler.this.changeNavigationNode(ui, e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ui.getNavigationScrollPane().getHorizontalScrollBar().setValue(0);
                        ui.getSplitpane2().resetToPreferredSizes();
                    }
                });
            }
        };
        TreeWillExpandListener veteobableTreeWillExpand = new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                ObserveNode selectedNode = (ObserveNode)ui.getTreeHelper().getSelectedNode();
                if (selectedNode == null) {
                    return;
                }
                ObserveNode o = (ObserveNode)((Object)event.getPath().getLastPathComponent());
                if (((Object)((Object)selectedNode)).equals((Object)o) || !selectedNode.isNodeAncestor((TreeNode)((Object)o))) {
                    return;
                }
                boolean canChange = ObserveMainUIHandler.this.ensureModification(ui);
                if (!canChange) {
                    throw new ExpandVetoException(event, "Can not collapse node " + event.getPath());
                }
            }
        };
        ui.getTreeHelper().setUI(ui.getNavigation(), true, true, listener, veteobableTreeWillExpand);
        ui.setContextValue(ui.getBroker());
        SwingValidatorUtil.installUI((JTable)ui.getErrorTable(), (SwingValidatorMessageTableRenderer)new ObserveValidatorMessageTableRenderer());
        UIHelper.setLayerUI((JComponent)ui.getBody(), (LayerUI)ui.getBusyBlockLayerUI());
        ui.addPropertyChangeListener("busy", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean newvalue = (Boolean)evt.getNewValue();
                ObserveMainUIHandler.this.updateBusyState(ui, newvalue != null && newvalue != false);
            }
        });
    }

    protected void updateBusyState(ObserveMainUI ui, boolean busy) {
        if (busy) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"block ui in busy mode");
            }
            ui.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"unblock ui in none busy mode");
            }
            ui.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected class ObserveConfigUIBuilder
    extends ConfigUIHelper {
        public ObserveConfigUIBuilder(ObserveConfig config) {
            super((ApplicationConfig)config);
        }

        public ObserveConfigOption addOption(ObserveConfigOption option) {
            String beanProperty = option.getPropertyKey();
            super.addOption((ConfigOptionDef)option);
            if (StringUtils.isNotEmpty((CharSequence)beanProperty)) {
                this.setOptionPropertyName(beanProperty);
            }
            if (!option.isAdmin() || ObserveRunner.isAdmin()) {
                return option;
            }
            return null;
        }

        public void addOption(ObserveConfigOption option, Callback callBack) {
            if ((option = this.addOption(option)) != null) {
                this.setOptionCallBack(callBack.name());
            }
        }

        public void registerCallBack(Callback callback) {
            String name = callback.name();
            String description = callback.getLabel();
            ImageIcon icon = callback.getIcon();
            Callback action = callback;
            this.registerCallBack(name, description, icon, action);
        }
    }

    public static enum Callback implements Runnable
    {
        application(I18n.n((String)"observe.action.reload.application", (Object[])new Object[0]), "reload-application"){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"will reload application");
                }
                ObserveContext context = ObserveContext.get();
                ObserveMainUIHandler handler = new ObserveMainUIHandler();
                ObserveMainUI ui = handler.getUI((JAXXContext)context);
                context.askReload();
                handler.closeApplication(ui);
            }
        }
        ,
        ui(I18n.n((String)"observe.action.reload.ui", (Object[])new Object[0]), "reload-ui"){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"will reload ui");
                }
                ObserveContext context = ObserveContext.get();
                ObserveMainUIHandler handler = new ObserveMainUIHandler();
                ObserveMainUI ui = handler.getUI((JAXXContext)context);
                ObserveConfig config = ui.getConfig();
                handler.reloadUI(context, config);
            }
        }
        ,
        db(I18n.n((String)"observe.action.reload.storage", (Object[])new Object[0]), "reload-db"){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"will reload db");
                }
                ObserveContext context = ObserveContext.get();
                ObserveMainUIHandler handler = new ObserveMainUIHandler();
                ObserveMainUI ui = handler.getUI((JAXXContext)context);
                handler.launchReloadStorage(ui);
            }
        };

        private final String label;
        private final String iconPath;

        private Callback(String label, String iconPath) {
            this.iconPath = iconPath;
            this.label = label;
            this.getIcon();
        }

        public ImageIcon getIcon() {
            ImageIcon icon = UIHelper.createActionIcon((String)this.iconPath);
            return icon;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

