/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.gps;

import fr.ird.observe.entities.GPSAble;
import javax.swing.table.AbstractTableModel;
import org.nuiton.i18n.I18n;

public class GPSAbleTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected static final String[] COLUMN_NAMES = new String[]{I18n.n_((String)"observe.synchro.common.quadrant", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.common.latitude", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.common.longitude", (Object[])new Object[0])};
    protected static final Class<?>[] COLUMN_CLASSES = new Class[]{Integer.class, Float.class, Float.class};
    protected GPSAble[] data;
    protected final int columns;

    public GPSAbleTableModel(int columns) {
        this.columns = columns;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void init(GPSAble ... gpsable) {
        this.data = gpsable;
        this.fireTableDataChanged();
    }

    public void clear() {
        this.data = null;
    }

    @Override
    public int getRowCount() {
        return COLUMN_CLASSES.length;
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        GPSAble p;
        Integer value = null;
        GPSAble gPSAble = p = this.data == null ? null : this.data[columnIndex];
        if (p != null) {
            switch (rowIndex) {
                case 0: {
                    value = p.getQuadrant();
                    break;
                }
                case 1: {
                    value = p.getLatitude() == null ? null : Float.valueOf(Math.abs(p.getLatitude().floatValue()));
                    break;
                }
                case 2: {
                    value = p.getLongitude() == null ? null : Float.valueOf(Math.abs(p.getLongitude().floatValue()));
                    break;
                }
                default: {
                    throw new IllegalStateException("can not get value for row " + rowIndex + ", col " + columnIndex);
                }
            }
        }
        return value;
    }

    public String getTextValueAt(int rowIndex, int columnIndex) {
        Object value = null;
        String text = "";
        switch (rowIndex) {
            case 0: {
                value = this.getValueAt(rowIndex, columnIndex);
                if (value == null || (Integer)value == 0) {
                    text = I18n._((String)"observe.common.undefined", (Object[])new Object[0]);
                    break;
                }
                text = I18n._((String)("observe.common.quadrant" + value), (Object[])new Object[0]);
                break;
            }
            case 1: {
                value = this.getValueAt(rowIndex, columnIndex);
                if (value == null || ((Float)value).floatValue() == 0.0f) {
                    text = I18n._((String)"observe.common.undefined", (Object[])new Object[0]);
                    break;
                }
                text = Math.abs(((Float)value).floatValue()) + "";
                break;
            }
            case 2: {
                value = this.getValueAt(rowIndex, columnIndex);
                if (value == null || ((Float)value).floatValue() == 0.0f) {
                    text = I18n._((String)"observe.common.undefined", (Object[])new Object[0]);
                    break;
                }
                text = Math.abs(((Float)value).floatValue()) + "";
                break;
            }
            default: {
                throw new IllegalStateException("can not get value for column " + columnIndex);
            }
        }
        return text;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }
}

