/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree;

import fr.ird.observe.ui.tree.AbstractObserveTreeCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectDataTreeCellRenderer
extends AbstractObserveTreeCellRenderer {
    private static final Log log = LogFactory.getLog(SelectDataTreeCellRenderer.class);

    public SelectDataTreeCellRenderer() {
    }

    public SelectDataTreeCellRenderer(DefaultTreeCellRenderer delegate) {
        super(delegate);
    }

    @Override
    protected void init(DefaultTreeCellRenderer delegate) {
        super.init(delegate);
        delegate.setBackgroundNonSelectionColor(null);
        delegate.setBackgroundSelectionColor(null);
        delegate.setBackground(null);
        delegate.setTextNonSelectionColor(Color.GRAY);
        delegate.setTextSelectionColor(Color.BLACK);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value == null || !(tree.getModel() instanceof NavigationTreeModel)) {
            return this.getTreeCellRendererComponent0(tree, value, sel, expanded, leaf, row, hasFocus);
        }
        NavigationTreeNode node = SelectDataTreeCellRenderer.getNode(value);
        if (node == null) {
            return this.getTreeCellRendererComponent0(tree, value, sel, expanded, leaf, row, hasFocus);
        }
        this.setIcon(node);
        String text = this.getText(node);
        if (log.isDebugEnabled()) {
            text = text + " (" + row + ')';
            log.debug((Object)("repaint node " + text + " (selected:" + sel + ") for node  " + node.getFullPath()));
        }
        Component comp = this.getTreeCellRendererComponent0(tree, text, sel, expanded, leaf, row, false);
        ((JComponent)comp).setToolTipText(text);
        ((JComponent)comp).setBorder(null);
        return comp;
    }
}

