/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.MareeImpl;
import fr.ird.observe.entities.Route;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.data.RoutesUI;
import java.util.ArrayList;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class RoutesHandler
extends ObserveContentHandler<Void, Maree, RoutesUI> {
    private static Log log = LogFactory.getLog(RoutesHandler.class);

    public RoutesHandler() {
        super(Void.class, Maree.class, "open", "route");
    }

    public void addRoute(RoutesUI context) {
        NavigationTreeNode parentNode = RoutesHandler.getSelectedNode(context);
        NavigationTreeNode node = RoutesHandler.getTreeBuilder((JAXXContext)context).addRoute(parentNode, null);
        RoutesHandler.repaintNode((JAXXContext)context, parentNode, true);
        RoutesHandler.selectNode((JAXXContext)context, node);
    }

    public void gotoRoute(RoutesUI context, Route selectedRoute) {
        if (selectedRoute == null) {
            return;
        }
        NavigationTreeNode parentNode = RoutesHandler.getSelectedNode(context);
        NavigationTreeNode node = parentNode.getChild(selectedRoute.getTopiaId());
        RoutesHandler.selectNode((JAXXContext)context, node);
    }

    @Override
    public void openUI(RoutesUI context) throws Exception {
        super.openUI(context);
        Maree maree = RoutesHandler.getData((JAXXContext)context, Maree.class);
        ObserveContentMode mode = this.getObserveContentMode(context);
        MareeImpl editBean = context.getEditBean();
        this.loador.load((Object)maree, (Object)editBean, true, new String[0]);
        List routes = editBean.getRoute();
        if (routes != null) {
            editBean.setRoute(new ArrayList(routes));
        }
        context.setMode(mode);
    }

    @Override
    protected ObserveContentMode getObserveContentMode(RoutesUI context) {
        ObserveContentMode mode = super.getObserveContentMode(context);
        if (mode == null) {
            Maree maree = RoutesHandler.getData((JAXXContext)context, Maree.class);
            Route openRoute = RoutesHandler.getDataContext((JAXXContext)context).getOpenRoute();
            if (openRoute == null) {
                if (maree.isOpen()) {
                    mode = ObserveContentMode.CREATE;
                    RoutesHandler.addMessage(context, BeanValidatorScope.INFO, RoutesHandler.getEntityLabel(Maree.class), I18n._((String)"observe.message.no.active.route.found"));
                } else {
                    mode = ObserveContentMode.READ;
                }
            } else if (maree.getOpenChild() != null) {
                mode = ObserveContentMode.UPDATE;
                RoutesHandler.addMessage(context, BeanValidatorScope.INFO, RoutesHandler.getEntityLabel(Maree.class), I18n._((String)"observe.message.active.route.found"));
            } else {
                mode = ObserveContentMode.READ;
                RoutesHandler.addMessage(context, BeanValidatorScope.INFO, RoutesHandler.getEntityLabel(Maree.class), I18n._((String)"observe.message.active.route.found.for.other.maree"));
            }
            if (!maree.isOpen()) {
                RoutesHandler.addMessage(context, BeanValidatorScope.INFO, RoutesHandler.getEntityLabel(Maree.class), I18n._((String)"observe.message.maree.not.open"));
            }
        }
        return mode;
    }
}

