/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.MareeImpl;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.data.MareeUI;
import fr.ird.observe.ui.tree.ObserveTreeModelBuilder;
import java.awt.Desktop;
import java.net.URI;
import java.util.Date;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class MareeHandler
extends ObserveContentHandler<Programme, Maree, MareeUI> {
    private static final Log log = LogFactory.getLog(MareeHandler.class);

    public MareeHandler() {
        super(Programme.class, Maree.class, "dateDebut", "dateFin", "formulairesUrl", "rapportsUrl", "commentaire", "bateau", "senne", "observateur", "ocean", "route", "open");
    }

    @Override
    protected Maree onPreCreate(Programme parentBean, Maree bean) throws TopiaException {
        Date date = DBHelper.getDay((Date)new Date());
        log.debug((Object)("date debut " + date));
        bean.setDateDebut(date);
        return bean;
    }

    @Override
    protected Maree onCreate(Programme parentBean, Maree bean) throws TopiaException {
        TopiaContext ctxt = parentBean.getTopiaContext();
        Maree beanToSave = (Maree)ObserveDAOHelper.getMareeDAO((TopiaContext)ctxt).create(new Object[0]);
        bean.setTopiaId(beanToSave.getTopiaId());
        parentBean.addMaree(beanToSave);
        return beanToSave;
    }

    @Override
    protected void onDelete(Programme parentBean, Maree bean) {
        parentBean.removeMaree(bean);
    }

    @Override
    public void openOpenable(MareeUI context) {
        MareeImpl bean = context.getEditBean();
        bean.setOpen(true);
        try {
            Maree beanToSave = MareeHandler.getData((JAXXContext)context, Maree.class);
            MareeHandler.getStorageService((JAXXContext)context).update((TopiaEntity)beanToSave, (TopiaEntity)bean, this.loador);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        this.restartEditUI(context);
    }

    @Override
    public void closeOpenable(MareeUI context) {
        Maree beanToSave = MareeHandler.getData((JAXXContext)context, Maree.class);
        try {
            MareeHandler.closeOpenable((Openable)beanToSave);
            beanToSave = (Maree)MareeHandler.getStorageService((JAXXContext)context).update((TopiaEntity)beanToSave);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        this.closeOpenable(context, (Openable)beanToSave, I18n._((String)"observe.message.maree.not.open"));
    }

    @Override
    public void openUI(MareeUI context) throws Exception {
        super.openUI(context);
        ObserveContentMode mode = this.getObserveContentMode(context);
        Programme programme = MareeHandler.getData((JAXXContext)context, Programme.class);
        Maree bean = MareeHandler.getData((JAXXContext)context, Maree.class);
        if (bean == null) {
            MareeHandler.getStorageService((JAXXContext)context).preCreate((TopiaEntity)programme, (TopiaEntity)context.getEditBean(), this.loador, this.preCreator);
        } else {
            this.loador.load((Object)bean, (Object)context.getEditBean(), true, new String[0]);
            if (!context.getEditBean().isRouteEmpty()) {
                DBHelper.sortRoutes((List)context.getEditBean().getRoute());
            }
        }
        context.setMode(mode);
        if (mode != ObserveContentMode.READ) {
            context.startEdit(bean);
        }
    }

    @Override
    protected ObserveContentMode getObserveContentMode(MareeUI context) {
        ObserveContentMode mode = super.getObserveContentMode(context);
        if (mode == null) {
            boolean create;
            Maree bean = MareeHandler.getData((JAXXContext)context, Maree.class);
            boolean bl = create = bean == null;
            if (create) {
                mode = ObserveContentMode.CREATE;
                context.removeContextValue(Maree.class);
            } else {
                mode = bean.isOpen() ? ObserveContentMode.UPDATE : ObserveContentMode.READ;
            }
            if (!create && !bean.isOpen()) {
                MareeHandler.addMessage(context, BeanValidatorScope.INFO, MareeHandler.getEntityLabel(Maree.class), I18n._((String)"observe.message.maree.not.open"));
            }
        }
        return mode;
    }

    @Override
    public void saveUI(MareeUI context, boolean refresh) {
        Programme programme = MareeHandler.getData((JAXXContext)context, Programme.class);
        MareeImpl bean = context.getEditBean();
        boolean create = bean.getTopiaId() == null;
        try {
            Date date = DBHelper.getDay((Date)bean.getDateDebut());
            Date dateFin1 = bean.getDateFin();
            Date dateFin = DBHelper.getMareeDateFin((Maree)bean);
            log.debug((Object)("dateDebut " + date + " / dateFin : " + dateFin));
            bean.setDateDebut(date);
            if (dateFin1 != null && dateFin1.after(dateFin)) {
                dateFin = DBHelper.getEndOfDay((Date)dateFin1);
            }
            bean.setDateFin(dateFin);
            StorageService<?> service = MareeHandler.getStorageService((JAXXContext)context);
            if (create) {
                bean.setOpen(true);
                service.create((TopiaEntity)programme, (TopiaEntity)bean, this.loador, this.creator);
            } else {
                Maree beanToSave = MareeHandler.getData((JAXXContext)context, Maree.class);
                service.update((TopiaEntity)beanToSave, (TopiaEntity)bean, this.loador);
            }
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        BeanValidatorUtil.setValidatorChanged((JAXXObject)context, (boolean)false, (String[])new String[0]);
        NavigationTreeNode node = MareeHandler.getSelectedNode(context);
        if (create) {
            context.setMode(ObserveContentMode.UPDATE);
            ObserveTreeModelBuilder treeBuilder = MareeHandler.getTreeBuilder((JAXXContext)context);
            NavigationTreeNode parentNode = treeBuilder.removeChildNode(node);
            node = treeBuilder.addMaree(parentNode, (Maree)bean);
            this.stopEditUI(context);
            if (refresh) {
                MareeHandler.selectNode((JAXXContext)context, node);
            }
        } else {
            MareeHandler.repaintNode((JAXXContext)context, node);
        }
    }

    @Override
    public void startEditUI(MareeUI context, Maree o, Maree editBean, String ... binding) {
        boolean create = context.getMode() == ObserveContentMode.CREATE;
        String contextName = this.getValidatorContextName(context.getMode());
        context.getValidator().setContextName(contextName);
        if (create) {
            MareeHandler.addMessage(context, BeanValidatorScope.INFO, MareeHandler.getEntityLabel(Maree.class), I18n._((String)"observe.message.creating.maree"));
        } else {
            MareeHandler.addMessage(context, BeanValidatorScope.INFO, MareeHandler.getEntityLabel(Maree.class), I18n._((String)"observe.message.updating.maree"));
        }
        if (context.getMode() == ObserveContentMode.UPDATE && context.getEditBean().getDateFin() == null) {
            Date date = DBHelper.getEndOfDay((Date)new Date());
            context.getEditBean().setDateFin(date);
            log.info((Object)("date fin " + date));
        }
        super.startEditUI(context, o, editBean, "bateau.selectedItem", "observateur.selectedItem", "ocean.selectedItem", "senne.selectedItem", "dateDebut.date", "dateFin.date", "commentaire2.text", "close.enabled");
        context.setModified(create);
    }

    @Override
    public void deleteUI(MareeUI context) {
        Maree bean = MareeHandler.getData((JAXXContext)context, Maree.class);
        if (!UIHelper.confirmForEntityDelete(context, Maree.class, bean)) {
            return;
        }
        try {
            Programme programme = MareeHandler.getData((JAXXContext)context, Programme.class);
            MareeHandler.getStorageService((JAXXContext)context).delete((TopiaEntity)programme, (TopiaEntity)bean, this.deletator);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        context.stopEdit();
        NavigationTreeNode node = MareeHandler.getSelectedNode(context);
        NavigationTreeNode parentNode = MareeHandler.getTreeBuilder((JAXXContext)context).removeChildNode(node);
        MareeHandler.selectNode((JAXXContext)context, parentNode);
    }

    public void openLink(String url) {
        try {
            if (!Desktop.isDesktopSupported()) {
                throw new IllegalStateException(I18n._((String)"observe.error.desktop.not.supported"));
            }
            Desktop desktop = Desktop.getDesktop();
            if (!desktop.isSupported(Desktop.Action.BROWSE)) {
                throw new IllegalStateException(I18n._((String)"observe.error.desktop.browse.not.supported"));
            }
            URI uri = new URI(url);
            desktop.browse(uri);
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
        }
    }
}

