/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.entities.Route;
import fr.ird.observe.entities.RouteImpl;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.data.ActivitesUI;
import java.util.ArrayList;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.Loador;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.BinderBuilder;

public class ActivitesHandler
extends ObserveContentHandler<Void, Route, ActivitesUI> {
    private static Log log = LogFactory.getLog(ActivitesHandler.class);
    protected Loador<Activite> closeLoador;

    public ActivitesHandler() {
        super(Void.class, Route.class, "open", "activite");
        String binderContext = this.getClass().getName() + "_close";
        TopiaEntityBinder<Activite> binder = ActivitesHandler.getBinder(Activite.class, binderContext);
        if (binder == null) {
            BinderBuilder builder = new BinderBuilder(Activite.class, new String[]{"quadrant", "latitude", "longitude", "heureObservation", "temperatureSurface", "causeNonCoupSenne", "commentaire", "vitesseBateau", "systemeObserve", "activiteBateau", "activiteEnvironnante", "ventBeaufort", "modeDetection", "calee", "objetFlottant", "open"});
            binder = ActivitesHandler.registerBinder(Activite.class, builder, binderContext);
        }
        this.closeLoador = binder;
    }

    public void addActivite(ActivitesUI context) {
        NavigationTreeNode parentNode = ActivitesHandler.getSelectedNode(context);
        NavigationTreeNode node = ActivitesHandler.getTreeBuilder((JAXXContext)context).addActivite(parentNode, null);
        ActivitesHandler.repaintNode((JAXXContext)context, parentNode, true);
        ActivitesHandler.selectNode((JAXXContext)context, node);
    }

    public void gotoActivite(ActivitesUI context, Activite selectedActivite) {
        if (selectedActivite == null) {
            return;
        }
        NavigationTreeNode parentNode = ActivitesHandler.getSelectedNode(context);
        NavigationTreeNode node = parentNode.getChild(selectedActivite.getTopiaId());
        ActivitesHandler.selectNode((JAXXContext)context, node);
    }

    @Override
    public void closeOpenable(ActivitesUI ui) {
        RouteImpl bean = ui.getEditBean();
        Route beanToSave = ActivitesHandler.getData((JAXXContext)ui, Route.class);
        Activite activite = bean.getOpenActivite();
        Activite activiteToSave = beanToSave.getOpenActivite();
        activite.setOpen(false);
        try {
            activite = (Activite)ActivitesHandler.getStorageService((JAXXContext)ui).update((TopiaEntity)activiteToSave, (TopiaEntity)activite, this.closeLoador);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
            return;
        }
        this.closeOpenable(ui, (Openable)activite, I18n._((String)"observe.message.no.active.activite.found"));
        ui.setMode(ObserveContentMode.CREATE);
    }

    @Override
    public void openUI(ActivitesUI context) throws Exception {
        super.openUI(context);
        Route route = ActivitesHandler.getData((JAXXContext)context, Route.class);
        ObserveContentMode mode = this.getObserveContentMode(context);
        RouteImpl editBean = context.getEditBean();
        this.loador.load((Object)route, (Object)editBean, true, new String[0]);
        List activites = editBean.getActivite();
        if (activites != null) {
            editBean.setActivite(new ArrayList(activites));
        }
        context.setMode(mode);
    }

    @Override
    protected ObserveContentMode getObserveContentMode(ActivitesUI context) {
        ObserveContentMode mode = super.getObserveContentMode(context);
        if (mode == null) {
            Route route = ActivitesHandler.getData((JAXXContext)context, Route.class);
            Activite openActivite = ActivitesHandler.getDataContext((JAXXContext)context).getOpenActivite();
            if (openActivite == null) {
                if (route.isOpen()) {
                    mode = ObserveContentMode.CREATE;
                    ActivitesHandler.addMessage(context, BeanValidatorScope.INFO, ActivitesHandler.getEntityLabel(Route.class), I18n._((String)"observe.message.no.active.activite.found"));
                } else {
                    mode = ObserveContentMode.READ;
                }
            } else if (route.getOpenChild() != null) {
                mode = ObserveContentMode.UPDATE;
                ActivitesHandler.addMessage(context, BeanValidatorScope.INFO, ActivitesHandler.getEntityLabel(Route.class), I18n._((String)"observe.message.active.activite.found"));
            } else {
                mode = ObserveContentMode.READ;
                ActivitesHandler.addMessage(context, BeanValidatorScope.INFO, ActivitesHandler.getEntityLabel(Route.class), I18n._((String)"observe.message.active.activite.found.for.other.route"));
            }
            if (!route.isOpen()) {
                ActivitesHandler.addMessage(context, BeanValidatorScope.INFO, ActivitesHandler.getEntityLabel(Route.class), I18n._((String)"observe.message.route.not.open"));
            }
        }
        return mode;
    }
}

