/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content;

import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.ui.content.ObserveContent;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.ObserveContentTableMeta;
import fr.ird.observe.ui.content.ObserveContentTableModel;
import fr.ird.observe.ui.content.ObserveContentTableUI;
import fr.ird.observe.ui.content.ObserveContentUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.EntityListUpdator;
import org.nuiton.topia.persistence.util.Loador;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.BinderBuilder;

public abstract class ObserveContentTableHandler<E extends TopiaEntity, D extends TopiaEntity, UI extends ObserveContentTableUI<E, D>>
extends ObserveContentHandler<Void, E, UI> {
    private static Log log = LogFactory.getLog(ObserveContentTableHandler.class);
    protected final String propertyName;
    protected final Class<E> entityClass;
    protected final Class<D> childEntityClass;
    protected final Loador<D> childLoador;
    protected EntityListUpdator<E, D> childsUpdator;
    protected final Class<? extends TopiaEntity> enclosingClass;
    protected final String disableMessage;

    protected ObserveContentTableHandler(String propertyName, String listProperty, Class<E> entityClass, Class<D> childEntityClass, String[] parentProperties, String[] childProperties) {
        this(propertyName, listProperty, entityClass, childEntityClass, parentProperties, childProperties, Activite.class, I18n.n_((String)"observe.message.activite.not.open"));
    }

    protected ObserveContentTableHandler(String propertyName, Class<E> entityClass, Class<D> childEntityClass, String[] parentProperties, String[] childProperties) {
        this(propertyName, propertyName, entityClass, childEntityClass, parentProperties, childProperties, Activite.class, I18n.n_((String)"observe.message.activite.not.open"));
    }

    protected ObserveContentTableHandler(String propertyName, String listProperty, Class<E> entityClass, Class<D> childEntityClass, String[] parentProperties, String[] childProperties, Class<? extends TopiaEntity> enclosingClass, String disableMessage) {
        super(Void.class, entityClass, parentProperties);
        this.propertyName = propertyName;
        this.entityClass = entityClass;
        this.childEntityClass = childEntityClass;
        TopiaEntityBinder<D> binder = this.getBinder(childEntityClass);
        if (binder == null) {
            BinderBuilder builder = new BinderBuilder(childEntityClass, childProperties);
            binder = this.registerBinder(childEntityClass, builder);
        }
        this.childLoador = binder;
        this.childsUpdator = EntityListUpdator.newEntityListUpdator(entityClass, childEntityClass, (String)listProperty);
        this.enclosingClass = enclosingClass;
        this.disableMessage = disableMessage;
    }

    public abstract ObserveContentTableModel<E, D> newTableModel(ObserveContentTableUI<E, D> var1);

    protected ObserveContentTableMeta<D> newTableMeta(String property, boolean unmodiableWhenExisting) {
        return new ObserveContentTableMeta<D>(this.childEntityClass, property, unmodiableWhenExisting);
    }

    protected abstract void onSelectedRowChanged(UI var1, ObserveContentTableModel<E, D> var2, int var3, D var4, boolean var5);

    public final E newEditBean() {
        try {
            Class klass = ObserveDAOHelper.getImplementationClass(this.entityClass);
            return (E)((TopiaEntity)klass.newInstance());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public final D newTableEditBean() {
        try {
            Class klass = ObserveDAOHelper.getImplementationClass(this.childEntityClass);
            return (D)((TopiaEntity)klass.newInstance());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Loador<D> getChildLoador() {
        return this.childLoador;
    }

    public EntityListUpdator<E, D> getChildsUpdator() {
        return this.childsUpdator;
    }

    protected abstract void initTableUI(UI var1, DefaultTableCellRenderer var2);

    @Override
    public void initUI(UI context) throws Exception {
        super.initUI(context);
        ObserveContentTableModel tableModel = ((ObserveContentTableUI)context).getTableModel();
        ((ObserveContentUI)context).setContextValue((ObserveContentTableModel)tableModel);
        StorageService<?> service = ObserveContentTableHandler.getStorageService(context);
        ObserveContentTableHandler.attachTopiaContext(service, (TopiaEntityAbstract)context.getEditBean());
        ObserveContentTableHandler.attachTopiaContext(service, (TopiaEntityAbstract)context.getTableEditBean());
        SwingUtil.getLayer((JComponent)((ObserveContentUI)context).getBody()).setUI(null);
        SwingUtil.getLayer((JComponent)((ObserveContentTableUI)context).getExtraZone()).setUI((LayerUI)((ObserveContentUI)context).getBlockLayerUI());
        SwingUtil.getLayer((JComponent)((ObserveContentTableUI)context).getEditorPanel()).setUI((LayerUI)((ObserveContentTableUI)context).getEditorBlockLayerUI());
        this.initTableUI(context, new DefaultTableCellRenderer());
        tableModel.addPropertyChangeListener("selectedRow", new PropertyChangeListener((ObserveContentTableUI)context){
            final /* synthetic */ ObserveContentTableUI val$context;
            {
                this.val$context = observeContentTableUI;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ObserveContentTableModel model = (ObserveContentTableModel)evt.getSource();
                Object bean = model.getRowBean();
                boolean create = bean.getTopiaId() == null;
                Integer selectedRow = (Integer)evt.getNewValue();
                log.debug((Object)("callback new selectedRow : " + selectedRow));
                ObserveContentTableHandler.this.onSelectedRowChanged(this.val$context, model, selectedRow, bean, create);
                this.val$context.setRowSaved(!create);
                if (selectedRow == -1) {
                    log.debug((Object)">>>>>>>>>> will clear selection...");
                    this.val$context.getSelectionModel().clearSelection();
                    log.debug((Object)"<<<<<<<<<< has clear selection...");
                } else {
                    this.val$context.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                }
            }
        });
    }

    @Override
    public void openUI(UI ui) throws Exception {
        boolean canEdit;
        super.openUI(ui);
        ObserveContentMode mode = this.getObserveContentMode(ui);
        int oldIndex = ((ObserveContentTableUI)ui).getTableModel().getSelectedRow();
        ((ObserveContentTableUI)ui).getTableModel().dettachModel();
        E bean = this.loadEditBean(ui, mode);
        boolean bl = canEdit = mode == ObserveContentMode.UPDATE;
        if (canEdit) {
            ((ObserveContentUI)ui).startEdit(bean);
        }
        if (!((ObserveContentTableUI)ui).getTableModel().isEmpty()) {
            if (((ObserveContentTableUI)ui).getTableModel().getRowCount() <= oldIndex) {
                oldIndex = 0;
            }
            if (oldIndex == -1) {
                oldIndex = 0;
            }
            ((ObserveContentTableUI)ui).getTableModel().changeSelectedRow(oldIndex);
        }
        if (canEdit) {
            ((ObserveContentUI)ui).setModified(false);
        }
    }

    @Override
    public void startEditUI(UI context, E o, E editBean, String ... binding) {
        String message = I18n.n_((String)"observe.message.updating.entity");
        NavigationTreeNode node = ObserveContentTableHandler.getSelectedNode(context);
        String entityLabel = ObserveContentTableHandler.getEntityLabel(node.getParent().getInternalClass());
        message = I18n._((String)message, (Object[])new Object[]{I18n._((String)entityLabel)});
        ObserveContentTableHandler.addMessage(context, BeanValidatorScope.INFO, entityLabel, message);
        super.startEditUI(context, o, editBean, new String[0]);
    }

    @Override
    public void stopEditUI(UI ui) {
        super.stopEditUI(ui);
    }

    @Override
    public void saveUI(UI context, boolean refresh) {
        E toSave = this.getEntity((ObserveContent<?>)context);
        List objets = ((ObserveContentTableUI)context).getTableModel().getData();
        boolean canContinue = this.prepareSave(context, toSave, context.getEditBean(), objets);
        if (!canContinue) {
            return;
        }
        try {
            ObserveContentTableHandler.getStorageService(context).updateList(toSave, context.getEditBean(), this.childEntityClass, objets, this.loador, this.childLoador, this.childsUpdator);
            this.resetEditUI(context);
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
        }
    }

    protected E getEntity(ObserveContent<?> context) {
        return ObserveContentTableHandler.getData(context, this.entityClass);
    }

    protected E loadEditBean(UI ui, ObserveContentMode mode) {
        E bean = this.getEntity((ObserveContent<?>)ui);
        TopiaEntity editBean = ui.getEditBean();
        this.loador.load(bean, (Object)editBean, true, new String[0]);
        Collection<D> data = this.loadChilds(ui, bean);
        this.getChildsUpdator().setChilds(editBean, data);
        ((ObserveContentUI)ui).setMode(mode);
        ((ObserveContentTableUI)ui).getTableModel().attachModel();
        return bean;
    }

    protected Collection<D> loadChilds(UI ui, E bean) {
        Collection childs = this.getChildsUpdator().getChilds(bean);
        ArrayList<D> data = new ArrayList<D>();
        if (childs != null && !childs.isEmpty()) {
            for (TopiaEntity c : childs) {
                try {
                    D c2 = this.newTableEditBean();
                    this.getChildLoador().load((Object)c, c2, true, new String[0]);
                    data.add(c2);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return data;
    }

    @Override
    protected ObserveContentMode getObserveContentMode(UI context) {
        ObserveContentMode mode = super.getObserveContentMode(context);
        if (mode == null) {
            Activite activite = ObserveContentTableHandler.getData(context, Activite.class);
            if (activite.isOpen()) {
                mode = ObserveContentMode.UPDATE;
            } else {
                mode = ObserveContentMode.READ;
                ObserveContentTableHandler.addMessage(context, BeanValidatorScope.INFO, ObserveContentTableHandler.getEntityLabel(this.enclosingClass), I18n._((String)this.disableMessage));
            }
        }
        return mode;
    }

    protected boolean prepareSave(UI context, E toSave, E editBean, List<D> objets) {
        return true;
    }

    protected ObserveContentTableModel<E, D> getTableModel(UI context) {
        return ((ObserveContentTableUI)context).getTableModel();
    }
}

