/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.ReferentielLocaleEnum;
import fr.ird.observe.entities.ReferentielStatusEnum;
import fr.ird.observe.entities.referentiel.I18nReferentielEntity;
import fr.ird.observe.entities.referentiel.NeedCommentReferentielEntity;
import fr.ird.observe.entities.referentiel.ReferentielEntity;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.UsagesUI;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.ObserveContentReferentielUI;
import fr.ird.observe.ui.content.ObserveContentUI;
import fr.ird.observe.ui.content.ObserveUniqueKeyTableModel;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.Creator;

public abstract class ObserveContentReferentielHandler<E extends ReferentielEntity, UI extends ObserveContentReferentielUI<E>>
extends ObserveContentHandler<Void, E, UI> {
    private static final Log log = LogFactory.getLog(ObserveContentReferentielHandler.class);
    protected String[] dataBinding;
    protected String[] naturalIds;
    protected static final String[] DEFAULT_DATABINDING = new String[]{"code.text", "uri.text", "status.selectedIndex"};
    protected static final String[] DEFAULT_NEED_COMMENT_DATABINDING = new String[]{"needComment.selected"};
    protected static final String[] DEFAULT_I18N_DATABINDING = new String[]{"libelle1.text", "libelle2.text", "libelle3.text", "libelle4.text", "libelle5.text", "libelle6.text", "libelle7.text", "libelle8.text"};
    protected static final String[] DEFAULT_PROPERTIES = new String[]{"code", "uri", "status"};
    protected static final String[] DEFAULT_NEED_COMMENT_PROPERTIES = new String[]{"needComment"};
    protected static final String[] DEFAULT_I18N_PROPERTIES = new String[]{"libelle1", "libelle2", "libelle3", "libelle4", "libelle5", "libelle6", "libelle7", "libelle8"};

    protected ObserveContentReferentielHandler(Class<E> mainEntityClass) {
        this(mainEntityClass, new String[0], new String[0]);
    }

    protected ObserveContentReferentielHandler(Class<E> mainEntityClass, String[] extraProperties, String ... extraBindings) {
        this(mainEntityClass, extraProperties, new String[]{DEFAULT_PROPERTIES[0]}, extraBindings);
    }

    protected ObserveContentReferentielHandler(Class<E> mainEntityClass, String[] extraProperties, String[] naturalIds, String ... extraBindings) {
        this.mainEntityClass = mainEntityClass;
        this.naturalIds = naturalIds;
        List<String> bindings = this.buildDataBindings(extraBindings);
        List<String> properties = this.buildProperties(extraProperties);
        if (log.isDebugEnabled()) {
            log.debug((Object)("dataBinding = " + bindings));
            log.debug((Object)("properties = " + properties));
        }
        this.dataBinding = bindings.toArray(new String[bindings.size()]);
        this.properties = properties.toArray(new String[properties.size()]);
        this.loador = this.getBinder();
        this.preCreator = new Creator<Void, E>(){

            public E create(Void parent, E from) throws TopiaException {
                return ObserveContentReferentielHandler.this.onPreCreate(parent, from);
            }
        };
        this.creator = new Creator<Void, E>(){

            public E create(Void parent, E from) throws TopiaException {
                return ObserveContentReferentielHandler.this.onCreate(parent, from);
            }
        };
    }

    public void showUniqueKeys(UI context, JButton button) {
        List entities = ObserveContentReferentielHandler.getDataContext(context).getEditingReferentielList();
        ArrayList<Object[]> datas = new ArrayList<Object[]>(entities.size());
        int nbColumns = this.naturalIds.length + 1;
        String[] columns = new String[nbColumns];
        System.arraycopy(this.naturalIds, 0, columns, 1, this.naturalIds.length);
        columns[0] = Introspector.decapitalize(this.mainEntityClass.getSimpleName());
        Decorator decorator = ObserveContext.getDecorator(this.mainEntityClass);
        for (ReferentielEntity e : entities) {
            Map values = this.loador.obtainProperties((Object)e, this.naturalIds);
            Object[] data = new Object[nbColumns];
            int index = 0;
            data[0] = decorator.toString((Object)e);
            for (String property : this.naturalIds) {
                Object value;
                Object o = values.get(property);
                if (DEFAULT_PROPERTIES[0].equals(property) && o == null) {
                    o = 0;
                }
                if ("identifiant".equals(property) && o == null) {
                    o = 0;
                }
                if ("sexe".equals(property) && o == null) {
                    o = 0;
                }
                if (o instanceof ReferentielEntity) {
                    Decorator<?> d = ObserveContext.getDecorator(o.getClass());
                    value = d.toString(o);
                } else {
                    value = o;
                }
                data[++index] = value;
            }
            datas.add(data);
        }
        JTable table = new JTable(new ObserveUniqueKeyTableModel(columns, datas));
        table.setAutoCreateRowSorter(true);
        table.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        table.setFillsViewportHeight(true);
        JScrollPane pane = new JScrollPane();
        this.decorateUniqueKeyTable(table, new DefaultTableCellRenderer(), pane);
        pane.setViewportView(table);
        pane.setVerticalScrollBarPolicy(20);
        String title = I18n._((String)"observe.title.unique.key", (Object[])new Object[]{I18n._((String)DBHelper.getEntityLabel((Class)this.mainEntityClass))});
        pane.setBorder(new TitledBorder(title));
        JPopupMenu popup = new JPopupMenu();
        popup.setBorder(null);
        popup.add(pane);
        popup.pack();
        Dimension dim = popup.getPreferredSize();
        int x = (int)(button.getPreferredSize().getWidth() - dim.getWidth());
        int y = button.getHeight();
        popup.show(button, x, y);
    }

    protected void decorateUniqueKeyTable(JTable table, DefaultTableCellRenderer renderer, JScrollPane pane) {
        table.setAutoResizeMode(3);
        UIHelper.fixTableColumnWidth((JTable)table, (int)1, (int)70);
    }

    public <E extends TopiaEntity> void showUsages(JAXXContext context, E bean) {
        Map usages;
        StorageService<?> service = ObserveContentReferentielHandler.getStorageService(context);
        try {
            usages = service.findAllUsages(bean);
        }
        catch (StorageServiceException e) {
            ErrorDialogUI.showError((Exception)((Object)e));
            log.error((Object)e);
            return;
        }
        Decorator<?> decorator = ObserveContext.getDecorator(bean.getClass());
        String type = DBHelper.getEntityLabel(bean.getClass());
        type = I18n._((String)type);
        String message = I18n._((String)"observe.message.show.usages", (Object[])new Object[]{type, decorator.toString(bean)});
        UsagesUI usagesUI = new UsagesUI(context);
        usagesUI.init(message, null, null, usages);
        UIHelper.askUser(null, I18n._((String)"observe.title.show.usage"), usagesUI, 1, new Object[]{I18n._((String)"observe.choice.quit")}, 0);
    }

    @Override
    public void initUI(UI context) throws Exception {
        super.initUI(context);
        JList list = ((ObserveContentReferentielUI)context).getList();
        UIHelper.prepareEntityList(ObserveContentReferentielHandler.getStorageService(context), this.mainEntityClass, list, true);
        context.getShowUniqueKeysToolBar().add(((ObserveContentReferentielUI)context).getShowUniqueKeys());
    }

    @Override
    public void openUI(UI ui) throws Exception {
        super.openUI(ui);
        ObserveDataContext dataTx = ObserveContentReferentielHandler.getDataContext(ui);
        List entities = (List)((ObserveContentReferentielUI)ui).getList().getClientProperty("data");
        dataTx.setEditingReferentielList(entities);
        if (I18nReferentielEntity.class.isAssignableFrom(this.mainEntityClass)) {
            ReferentielLocaleEnum localeEnum = ReferentielLocaleEnum.valueOf((Locale)((ObserveContentUI)ui).getConfig().getDbLocale());
            String libelleName = localeEnum.getLibelle() + "Label";
            for (int i = 1; i <= 8; ++i) {
                String lib = "libelle" + i + "Label";
                JLabel label = (JLabel)((ObserveContentUI)ui).getObjectById(lib);
                if (label == null) continue;
                Font font = label.getFont();
                Font normalFont = font.deriveFont(0);
                Font boldFont = font.deriveFont(1);
                font = libelleName.equals(lib) ? boldFont : normalFont;
                label.setFont(font);
                ((JComponent)((ObserveContentUI)ui).getObjectById("libelle" + i)).setFont(font);
            }
        }
        ObserveContentMode mode = this.getObserveContentMode(ui);
        ((ObserveContentUI)ui).setMode(mode);
        if (mode != ObserveContentMode.READ) {
            ((ObserveContentUI)ui).processDataBinding("delete.enabled");
        }
    }

    @Override
    public void startEditUI(UI context, E o, E editBean, String ... binding) {
        boolean canEdit;
        ObserveContentMode mode = ((ObserveContentUI)context).getMode();
        boolean bl = canEdit = mode != ObserveContentMode.READ;
        if (canEdit) {
            ObserveContentReferentielHandler.removeAllMessages(context);
            String contextName = this.getValidatorContextName(mode);
            if (log.isDebugEnabled()) {
                log.debug((Object)("contextName = " + contextName));
            }
            context.getValidator().setContextName(contextName);
            ObserveContentReferentielHandler.getDataContext(context).setEditingReferentiel(editBean);
            if (mode == ObserveContentMode.CREATE) {
                ObserveContentReferentielHandler.addMessage(context, BeanValidatorScope.INFO, ObserveContentReferentielHandler.getEntityLabel(this.mainEntityClass), I18n._((String)"observe.message.creating.referentiel"));
                try {
                    ObserveContentReferentielHandler.getStorageService(context).preCreate(editBean, this.loador, this.preCreator);
                }
                catch (StorageServiceException e) {
                    ErrorDialogUI.showError((Exception)((Object)e));
                }
            } else {
                ObserveContentReferentielHandler.addMessage(context, BeanValidatorScope.INFO, ObserveContentReferentielHandler.getEntityLabel(this.mainEntityClass), I18n._((String)"observe.message.updating.referentiel"));
            }
            super.startEditUI(context, o, editBean, this.dataBinding);
        } else {
            BeanValidatorUtil.setValidatorBean(context, null, (String[])new String[0]);
            UIHelper.processDataBinding(context, (String[])this.dataBinding);
            ((ObserveContentUI)context).setEditing(true);
        }
    }

    @Override
    public void createUI(UI context) {
        ((ObserveContentUI)context).setMode(ObserveContentMode.CREATE);
        ((ObserveContentUI)context).startEdit(null);
    }

    @Override
    public void modifyUI(UI context) {
        if (((ObserveContentUI)context).getMode() != ObserveContentMode.READ) {
            ((ObserveContentUI)context).setMode(ObserveContentMode.UPDATE);
        }
        this.loador.load((Object)context.getSelectedBean(), (Object)context.getRefEditBean(), true, new String[0]);
        ((ObserveContentUI)context).startEdit((TopiaEntity)context.getSelectedBean());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUI(UI context, boolean refresh) {
        boolean stopEdit = false;
        try {
            ReferentielEntity bean = (ReferentielEntity)context.getRefEditBean();
            StorageService<?> service = ObserveContentReferentielHandler.getStorageService(context);
            if (bean.getTopiaId() == null) {
                service.create((TopiaEntity)bean, this.loador, this.creator);
                stopEdit = true;
                return;
            }
            ReferentielEntity editBean = (ReferentielEntity)((ObserveContentUI)context).getContextValue(this.mainEntityClass, "edit");
            if (editBean.getStatus() == ReferentielStatusEnum.enabled.ordinal() && bean.getStatus() == ReferentielStatusEnum.disabled.ordinal()) {
                Map usages;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"entity status was desactivated, looking for usage");
                }
                if ((usages = service.findAllUsages((TopiaEntity)editBean)).isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"No usage found, no warning to display");
                    }
                } else {
                    boolean willsave = ObserveContentReferentielHandler.showUsagesForDesactivated(context, bean, usages);
                    if (!willsave) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"User refuses to continue, skip saving...");
                        }
                        return;
                    }
                }
            }
            service.update((TopiaEntity)editBean, (TopiaEntity)bean, this.loador);
            stopEdit = true;
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
            log.error((Object)ex);
            stopEdit = false;
        }
        finally {
            if (stopEdit) {
                ((ObserveContentUI)context).stopEdit();
            }
        }
    }

    @Override
    public void deleteUI(UI context) {
        Map usages;
        ReferentielEntity bean = (ReferentielEntity)context.getSelectedBean();
        if (log.isInfoEnabled()) {
            log.info((Object)"entity to be deleted, looking for usage");
        }
        StorageService<?> service = ObserveContentReferentielHandler.getStorageService(context);
        try {
            usages = service.findAllUsages((TopiaEntity)bean);
        }
        catch (StorageServiceException e) {
            ErrorDialogUI.showError((Exception)((Object)e));
            log.error((Object)e);
            return;
        }
        if (usages.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No usage found, no warning to display");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"can not delete referentiel entity (found usages)");
            }
            ObserveContentReferentielHandler.showUsagesForDelete(context, bean, usages);
            return;
        }
        if (!UIHelper.confirmForEntityDelete(context, this.mainEntityClass, bean)) {
            return;
        }
        try {
            service.delete((TopiaEntity)bean);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        ((ObserveContentUI)context).stopEdit();
    }

    @Override
    public void stopEditUI(UI ui) {
        super.stopEditUI(ui);
        if (((ObserveContentUI)ui).getMode() != ObserveContentMode.READ) {
            ((ObserveContentUI)ui).setMode(ObserveContentMode.UPDATE);
            ObserveContentReferentielHandler.removeAllMessages(ui);
            ObserveContentReferentielHandler.addMessage(ui, BeanValidatorScope.INFO, ObserveContentReferentielHandler.getEntityLabel(this.mainEntityClass), I18n._((String)"observe.message.referentiel.editable"));
        }
    }

    @Override
    public final void resetEditUI(UI context) {
        ObserveContentMode mode = ((ObserveContentUI)context).getMode();
        super.resetEditUI(context);
        if (mode == ObserveContentMode.CREATE) {
            this.createUI(context);
        } else {
            this.modifyUI(context);
        }
    }

    @Override
    protected E onPreCreate(Void parent, E bean) throws TopiaException {
        bean.setStatus(1);
        return bean;
    }

    @Override
    protected final E onCreate(Void parent, E bean) throws TopiaException {
        Map properties = this.loador.obtainProperties(bean, this.naturalIds);
        ReferentielEntity beanToSave = (ReferentielEntity)this.getDAO(bean).create(properties);
        bean.setTopiaId(beanToSave.getTopiaId());
        return (E)beanToSave;
    }

    protected List<String> buildProperties(String[] properties) {
        ArrayList<String> listProperties = new ArrayList<String>();
        listProperties.addAll(Arrays.asList(DEFAULT_PROPERTIES));
        listProperties.addAll(Arrays.asList(properties));
        if (I18nReferentielEntity.class.isAssignableFrom(this.mainEntityClass)) {
            listProperties.addAll(Arrays.asList(DEFAULT_I18N_PROPERTIES));
        }
        if (NeedCommentReferentielEntity.class.isAssignableFrom(this.mainEntityClass)) {
            listProperties.addAll(Arrays.asList(DEFAULT_NEED_COMMENT_PROPERTIES));
        }
        return listProperties;
    }

    protected List<String> buildDataBindings(String[] dataBinding) {
        ArrayList<String> bindings = new ArrayList<String>();
        bindings.addAll(Arrays.asList(DEFAULT_DATABINDING));
        bindings.addAll(Arrays.asList(dataBinding));
        if (I18nReferentielEntity.class.isAssignableFrom(this.mainEntityClass)) {
            bindings.addAll(Arrays.asList(DEFAULT_I18N_DATABINDING));
        }
        if (NeedCommentReferentielEntity.class.isAssignableFrom(this.mainEntityClass)) {
            bindings.addAll(Arrays.asList(DEFAULT_NEED_COMMENT_DATABINDING));
        }
        return bindings;
    }

    @Override
    protected ObserveContentMode getObserveContentMode(UI context) {
        StorageService<?> service = ObserveContentReferentielHandler.getStorageService(context);
        if (service.canWriteReferentiel()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Can write on referentiel " + this.mainEntityClass));
            }
            ObserveContentReferentielHandler.addMessage(context, BeanValidatorScope.INFO, ObserveContentReferentielHandler.getEntityLabel(this.mainEntityClass), I18n._((String)"observe.message.referentiel.editable"));
            return ObserveContentMode.UPDATE;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Can not write on referentiel " + this.mainEntityClass));
        }
        ObserveContentReferentielHandler.addMessage(context, BeanValidatorScope.INFO, ObserveContentReferentielHandler.getEntityLabel(this.mainEntityClass), I18n._((String)"observe.message.referentiel.no.editable"));
        return ObserveContentMode.READ;
    }

    public static <E extends TopiaEntity> void showUsagesForDelete(JAXXContext tx, E entity, Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> usages) {
        Decorator<?> decorator = ObserveContext.getDecorator(entity.getClass());
        String type = DBHelper.getEntityLabel(entity.getClass());
        type = I18n._((String)type);
        String message = I18n._((String)"observe.message.show.usage.for.delete", (Object[])new Object[]{type, decorator.toString(entity)});
        String message2 = I18n._((String)"observe.message.show.usage.for.delete2");
        UsagesUI usagesUI = new UsagesUI(tx);
        usagesUI.init(message, message2, null, usages);
        UIHelper.askUser(null, I18n._((String)"observe.title.can.not.delete.referentiel"), usagesUI, 2, new Object[]{I18n._((String)"observe.choice.cancel")}, 0);
    }

    public static <E extends TopiaEntity> boolean showUsagesForDesactivated(JAXXContext tx, E entity, Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> usages) {
        Decorator<?> decorator = ObserveContext.getDecorator(entity.getClass());
        String type = DBHelper.getEntityLabel(entity.getClass());
        type = I18n._((String)type);
        String message = I18n._((String)"observe.message.show.usage.for.desactivated", (Object[])new Object[]{type, decorator.toString(entity)});
        String message2 = I18n._((String)"observe.message.show.usage.for.desactivated2");
        String message3 = I18n._((String)"observe.message.show.usage.for.desactivated3");
        UsagesUI usagesUI = new UsagesUI(tx);
        usagesUI.init(message, message2, message3, usages);
        int reponse = UIHelper.askUser(null, I18n._((String)"observe.title.need.confirm.to.desactivate.referentiel"), usagesUI, 2, new Object[]{I18n._((String)"observe.choice.save"), I18n._((String)"observe.choice.cancel")}, 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("response : " + reponse));
        }
        switch (reponse) {
            case 0: {
                return true;
            }
        }
        return false;
    }
}

