/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.application.web.injector;

import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.debux.webmotion.server.call.Call;
import org.debux.webmotion.server.handler.ExecutorParametersInjectorHandler;
import org.debux.webmotion.server.mapping.Mapping;

public class DateInjector
implements ExecutorParametersInjectorHandler.Injector {
    private static final Log log = LogFactory.getLog(DateInjector.class);
    protected final String datePattern;

    public DateInjector(String datePattern) {
        this.datePattern = datePattern;
    }

    public Object getValue(Mapping mapping, Call call, String name, Class<?> type, Type generic) {
        Call.ParameterTree parameterTree;
        Date result = null;
        if (type.equals(Date.class) && (parameterTree = (Call.ParameterTree)call.getParameterTree().getObject().get(name)) != null) {
            String dateString = ((String[])parameterTree.getValue())[0];
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.datePattern);
            try {
                result = dateFormat.parse(dateString);
            }
            catch (ParseException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"An exception occurred", (Throwable)e);
                }
                throw new JsonParseException("no parse to date from " + dateString, (Throwable)e);
            }
        }
        return result;
    }
}

