/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.rest.referentials;

import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.api.services.users.FeedbackContext;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AgrosystLayoutData;
import fr.inra.agrosyst.web.rest.CustomInject;
import fr.inra.agrosyst.web.rest.Secured;
import fr.inra.agrosyst.web.rest.referentials.FeedbackContextDto;
import fr.inra.agrosyst.web.rest.referentials.FeedbackResource;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Secured
@Path(value="/feedback")
public class FeedbackResource {
    private final AgrosystLayoutData agrosystLayoutData = new AgrosystLayoutData();
    @CustomInject
    private UserService userService;
    @CustomInject
    private ReferentialService referentialService;

    @GET
    @Path(value="categories")
    @Produces(value={"application/json"})
    public Response getCategories() {
        List agrosystFeedbackCategories = this.agrosystLayoutData.getAgrosystFeedbackCategories();
        return Response.ok().entity((Object)agrosystFeedbackCategories).build();
    }

    @GET
    @Path(value="sectors")
    @Produces(value={"application/json"})
    public Response getSectors() {
        Map agrosystSectorTypes = this.agrosystLayoutData.getAgrosystSectorTypes();
        return Response.ok().entity((Object)agrosystSectorTypes).build();
    }

    @POST
    @Path(value="send")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response sendFeedback(FeedbackContextDto feedbackContextDto) {
        FeedbackContext feedbackContext = this.userService.sendFeedback(feedbackContextDto.toFeedbackContext());
        FeedbackSendingStatus feedbackSendingStatus = new FeedbackSendingStatus(feedbackContext.getFeedbackStatus(), feedbackContext.getFeedbackRecipients());
        return Response.ok().entity((Object)feedbackSendingStatus).build();
    }

    @GET
    @Path(value="allEmailsByCategoryAndTypeDephyAndSector")
    @Produces(value={"application/json"})
    public Response getAllEmailsByCategoryAndTypeDephyAndSector() {
        Map allEmailsByCategoryAndTypeDephyAndSector = this.referentialService.getAllEmailsByCategoryAndTypeDephyAndSector();
        return Response.ok().entity((Object)allEmailsByCategoryAndTypeDephyAndSector).build();
    }

    @POST
    @Path(value="validateItEmail")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response validateItEmail(@QueryParam(value="itEmail") String itEmail) {
        boolean isItEmailValid = this.userService.isValidEmail(itEmail);
        return Response.ok().entity((Object)new ValidItEmailDto(Boolean.valueOf(isItEmailValid))).build();
    }
}

