/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.context;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanDto;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemDto;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.nuiton.util.pagination.PaginationResult;

@Results(value={@Result(type="agrosyst-json", name={"success"}), @Result(type="agrosyst-json", name={"error"})})
public class ContextChooseRaw
extends AbstractAgrosystAction
implements Preparable {
    private static final long serialVersionUID = 8311330060409844511L;
    private static final Function<String, Boolean> GET_TRUE = input -> Boolean.TRUE;
    private static final Function<Object, String> TO_STRING = String::valueOf;
    protected transient Object jsonData = null;
    protected ArrayList<Integer> campaignsList;
    protected PaginationResult<DomainDto> domains;
    protected PaginationResult<Network> networks;
    protected PaginationResult<GrowingPlanDto> growingPlans;
    protected PaginationResult<GrowingSystemDto> growingSystems;
    protected transient NavigationContext navigationContext;
    protected transient Set<Integer> selectedCampaigns;
    protected transient Set<String> selectedNetworks;
    protected transient Set<String> selectedDomains;
    protected transient Set<String> selectedGrowingPlans;
    protected transient Set<String> selectedGrowingSystems;

    public void prepare() {
    }

    public void setSelectedCampaigns(String selectedCampaigns) {
        Set selectedCampaignsAsString = (Set)this.getGson().fromJson(selectedCampaigns, Set.class);
        this.selectedCampaigns = selectedCampaignsAsString.stream().map(Integer::parseInt).collect(Collectors.toSet());
    }

    public void setSelectedNetworks(String selectedNetworks) {
        this.selectedNetworks = (Set)this.getGson().fromJson(selectedNetworks, Set.class);
    }

    public void setSelectedDomains(String selectedDomains) {
        this.selectedDomains = (Set)this.getGson().fromJson(selectedDomains, Set.class);
    }

    public void setSelectedGrowingPlans(String selectedGrowingPlans) {
        this.selectedGrowingPlans = (Set)this.getGson().fromJson(selectedGrowingPlans, Set.class);
    }

    public void setSelectedGrowingSystems(String selectedGrowingSystems) {
        this.selectedGrowingSystems = (Set)this.getGson().fromJson(selectedGrowingSystems, Set.class);
    }

    @Action(value="context-choose-raw-input")
    public String input() throws Exception {
        this.navigationContext = super.getNavigationContext();
        Set campaignForFiltering = this.navigationContext.getCampaigns();
        Set networksForFiltering = this.navigationContext.getNetworks();
        Set domainsForFiltering = this.navigationContext.getDomains();
        Set growingPlansForFiltering = this.navigationContext.getGrowingPlans();
        this.campaignsList = new ArrayList(this.navigationContextService.getAllCampaigns());
        this.networks = this.navigationContextService.getAllNetworks(this.getListNbElementByPage(Network.class, "NavigationContext").intValue());
        this.domains = this.navigationContextService.getAllDomainsForCampaign(campaignForFiltering, networksForFiltering, this.getListNbElementByPage(DomainDto.class, "NavigationContext").intValue());
        this.growingPlans = this.navigationContextService.getAllGrowingPlansForDomains(campaignForFiltering, domainsForFiltering, networksForFiltering, this.getListNbElementByPage(GrowingPlanDto.class, "NavigationContext").intValue());
        this.growingSystems = this.navigationContextService.getAllGrowingSystemsForGrowingPlans(campaignForFiltering, domainsForFiltering, growingPlansForFiltering, networksForFiltering, this.getListNbElementByPage(GrowingSystemDto.class, "NavigationContext").intValue());
        return "input";
    }

    public String execute() throws Exception {
        NavigationContext newNavigationContext = new NavigationContext();
        if (this.selectedCampaigns != null) {
            newNavigationContext.getCampaigns().addAll(this.selectedCampaigns);
        }
        if (this.selectedNetworks != null) {
            newNavigationContext.getNetworks().addAll(this.selectedNetworks);
        }
        if (this.selectedDomains != null) {
            newNavigationContext.getDomains().addAll(this.selectedDomains);
        }
        if (this.selectedGrowingPlans != null) {
            newNavigationContext.getGrowingPlans().addAll(this.selectedGrowingPlans);
        }
        if (this.selectedGrowingSystems != null) {
            newNavigationContext.getGrowingSystems().addAll(this.selectedGrowingSystems);
        }
        this.verifyAndSaveNavigationContext(newNavigationContext);
        return "success";
    }

    protected Map<String, Boolean> toMap(Set<String> set) {
        ImmutableMap result = set.isEmpty() ? new HashMap() : Maps.toMap(set, GET_TRUE::apply);
        return result;
    }

    public List<String> getCampaigns() {
        ArrayList<String> result = new ArrayList<String>();
        if (!this.campaignsList.isEmpty()) {
            Iterable campaignStr = this.campaignsList.stream().map(TO_STRING).collect(Collectors.toList());
            Iterables.addAll(result, (Iterable)campaignStr);
        }
        return result;
    }

    public Map<String, Boolean> getSelectedCampaigns() {
        ImmutableMap result;
        Set campaigns = this.navigationContext.getCampaigns();
        if (!campaigns.isEmpty()) {
            Iterable campaignStr = campaigns.stream().map(TO_STRING).collect(Collectors.toList());
            result = Maps.toMap((Iterable)campaignStr, GET_TRUE::apply);
        } else {
            result = new HashMap();
        }
        return result;
    }

    public PaginationResult<Network> getNetworks() {
        return this.networks;
    }

    public Map<String, Boolean> getSelectedNetworks() {
        Set networks = this.navigationContext.getNetworks();
        Map result = this.toMap(networks);
        return result;
    }

    public PaginationResult<DomainDto> getDomains() {
        return this.domains;
    }

    public Map<String, Boolean> getSelectedDomains() {
        Set domains = this.navigationContext.getDomains();
        Map result = this.toMap(domains);
        return result;
    }

    public PaginationResult<GrowingPlanDto> getGrowingPlans() {
        return this.growingPlans;
    }

    public Map<String, Boolean> getSelectedGrowingPlans() {
        Set dispositifs = this.navigationContext.getGrowingPlans();
        Map result = this.toMap(dispositifs);
        return result;
    }

    public PaginationResult<GrowingSystemDto> getGrowingSystems() {
        return this.growingSystems;
    }

    public Map<String, Boolean> getSelectedGrowingSystems() {
        Set sdcs = this.navigationContext.getGrowingSystems();
        Map result = this.toMap(sdcs);
        return result;
    }

    public NavigationContext getNavigationContext() {
        return this.navigationContext;
    }

    public Map<DomainType, String> getDomainTypes() {
        return this.i18nService.getEnumTranslationMap(DomainType.class);
    }

    public Object getJsonData() {
        return new Object();
    }

    public Map<TypeDEPHY, String> getDephyTypes() {
        return this.getEnumAsMap((Object[])new TypeDEPHY[]{TypeDEPHY.DEPHY_FERME, TypeDEPHY.DEPHY_EXPE, TypeDEPHY.NOT_DEPHY});
    }
}

