/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web;

import com.google.common.base.Preconditions;
import fr.inra.agrosyst.web.AgrosystWebConfig;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class CookieHelper {
    protected final HttpServletRequest httpServletRequest;
    protected final HttpServletResponse httpServletResponse;
    protected final String defaultPath;
    protected final boolean secure;

    public CookieHelper(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AgrosystWebConfig agrosystWebConfig) {
        this.httpServletRequest = httpServletRequest;
        this.httpServletResponse = httpServletResponse;
        Object path = httpServletRequest.getServletContext().getContextPath();
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        this.defaultPath = path;
        this.secure = agrosystWebConfig.isSecuredCookies();
    }

    public Optional<String> readCookie(String cookieName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)cookieName));
        Cookie[] cookies = this.httpServletRequest.getCookies();
        if (cookies == null) {
            return Optional.empty();
        }
        Optional<String> result = Arrays.stream(cookies).filter(c -> cookieName.equals(c.getName())).map(Cookie::getValue).filter(StringUtils::isNotBlank).map(v -> URLDecoder.decode(v, StandardCharsets.UTF_8)).findFirst();
        return result;
    }

    public <T> Optional<T> readCookie(String cookieName, Function<String, T> parser) {
        Optional cookieValue = this.readCookie(cookieName);
        Optional<T> result = cookieValue.map(parser);
        return result;
    }

    public void writeCookie(String cookieName, String cookieValue, OptionalInt maxAge, boolean httpOnly) {
        String encoded = URLEncoder.encode(cookieValue, StandardCharsets.UTF_8);
        Cookie cookie = new Cookie(cookieName, encoded);
        cookie.setHttpOnly(httpOnly);
        cookie.setPath(this.defaultPath);
        cookie.setSecure(this.secure);
        maxAge.ifPresent(arg_0 -> ((Cookie)cookie).setMaxAge(arg_0));
        this.httpServletResponse.addCookie(cookie);
    }

    public <T> void writeCookie(String cookieName, T value, Function<T, String> formatter, boolean httpOnly) {
        String cookieValue = formatter.apply(value);
        this.writeCookie(cookieName, cookieValue, OptionalInt.empty(), httpOnly);
    }

    public <T> void writeCookie(String cookieName, T value, Function<T, String> formatter, int maxAge, boolean httpOnly) {
        String cookieValue = formatter.apply(value);
        this.writeCookie(cookieName, cookieValue, OptionalInt.of(maxAge), httpOnly);
    }

    public void deleteCookie(String cookieName) {
        this.writeCookie(cookieName, "whatever", OptionalInt.of(0), true);
    }
}

