/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.rest.zones;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.api.services.plot.ZoneFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.web.rest.CustomInject;
import fr.inra.agrosyst.web.rest.Secured;
import fr.inra.agrosyst.web.rest.common.PaginationResultDto;
import fr.inra.agrosyst.web.rest.zones.ZoneDto;
import fr.inra.agrosyst.web.rest.zones.ZoneRequestFilter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.pagination.PaginationResult;

@Secured
@Path(value="/zones")
public class ZonesResource {
    @CustomInject
    private PerformanceService performanceService;

    private ZoneFilter buildFilter(NavigationContext navigationContext, Set<String> selectedPlots, Boolean active, Set<String> selectedIds, Integer pageNumber, Integer pageSize) {
        ZoneFilter filter = new ZoneFilter();
        filter.setNavigationContext(navigationContext);
        filter.setPlotIds(selectedPlots.stream().toList());
        filter.setActive(active);
        if (selectedIds != null && !selectedIds.isEmpty()) {
            filter.setSelectedIds(selectedIds);
        }
        if (pageNumber != null) {
            filter.setPage(pageNumber.intValue());
        }
        if (pageSize != null) {
            filter.setPageSize(pageSize.intValue());
        }
        return filter;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response readAll(@CookieParam(value="nav.context") Cookie jsonContext, ZoneRequestFilter requestFilter) throws JsonProcessingException {
        NavigationContext context = jsonContext != null ? (NavigationContext)new ObjectMapper().readValue(URLDecoder.decode(jsonContext.getValue(), StandardCharsets.UTF_8), NavigationContext.class) : new NavigationContext();
        ZoneFilter filter = this.buildFilter(context, requestFilter.getSelectedPlots(), requestFilter.getActive(), requestFilter.getSelectedIds(), requestFilter.getPageNumber(), requestFilter.getPageSize());
        PaginationResult paginationResult = this.performanceService.getZonesDto(filter);
        List<ZoneDto> zones = paginationResult.getElements().stream().map(arg_0 -> this.convertToDto(arg_0)).toList();
        return Response.ok().entity((Object)new PaginationResultDto(zones, paginationResult.getCount(), paginationResult.getCurrentPage())).build();
    }

    private ZoneDto convertToDto(fr.inra.agrosyst.api.services.domain.ZoneDto zone) {
        String plotName = zone.getPlot() != null ? zone.getPlot().getName() : "";
        String domainName = zone.getPlot() != null && zone.getPlot().getGrowingSystem() != null && zone.getPlot().getGrowingSystem().getGrowingPlan() != null && zone.getPlot().getGrowingSystem().getGrowingPlan().getDomain() != null ? zone.getPlot().getGrowingSystem().getGrowingPlan().getDomain().getName() : "";
        String growingPlanName = zone.getPlot() != null && zone.getPlot().getGrowingSystem() != null && zone.getPlot().getGrowingSystem().getGrowingPlan() != null ? zone.getPlot().getGrowingSystem().getGrowingPlan().getName() : "";
        String growingSystemName = zone.getPlot() != null && zone.getPlot().getGrowingSystem() != null ? zone.getPlot().getGrowingSystem().getName() : "";
        int campaign = zone.getPlot() != null && zone.getPlot().getGrowingSystem() != null && zone.getPlot().getGrowingSystem().getGrowingPlan() != null && zone.getPlot().getGrowingSystem().getGrowingPlan().getDomain() != null ? zone.getPlot().getGrowingSystem().getGrowingPlan().getDomain().getCampaign() : 0;
        return new ZoneDto(StringUtils.remove((String)zone.getTopiaId(), (String)Zone.class.getName()), zone.getName(), plotName, domainName, growingPlanName, growingSystemName, campaign, zone.isActive());
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/filtered-ids")
    @Produces(value={"application/json"})
    public Response readIds(@CookieParam(value="nav.context") Cookie jsonContext, ZoneRequestFilter requestFilter) throws JsonProcessingException {
        NavigationContext context = jsonContext != null ? (NavigationContext)new ObjectMapper().readValue(URLDecoder.decode(jsonContext.getValue(), StandardCharsets.UTF_8), NavigationContext.class) : new NavigationContext();
        ZoneFilter filter = this.buildFilter(context, requestFilter.getSelectedPlots(), requestFilter.getActive(), null, null, null);
        Set ids = this.performanceService.getZoneIds(filter);
        Collection shortenIds = DaoUtils.getShortenIds((Collection)ids, Zone.class);
        return Response.ok().entity((Object)shortenIds).build();
    }
}

