/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.rest.plots;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.api.services.plot.PlotFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.web.rest.CustomInject;
import fr.inra.agrosyst.web.rest.Secured;
import fr.inra.agrosyst.web.rest.common.PaginationResultDto;
import fr.inra.agrosyst.web.rest.plots.PlotDto;
import fr.inra.agrosyst.web.rest.plots.PlotRequestFilter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.pagination.PaginationResult;

@Secured
@Path(value="/plots")
public class PlotsResource {
    @CustomInject
    private PerformanceService performanceService;

    private PlotFilter buildFilter(NavigationContext navigationContext, Set<String> selectedDomains, Set<String> selectedGrowingSystems, Boolean active, Set<String> selectedIds, Integer pageNumber, Integer pageSize) {
        PlotFilter filter = new PlotFilter();
        filter.setNavigationContext(navigationContext);
        filter.setDomainIds(selectedDomains.stream().toList());
        filter.setGrowingSystemIds(selectedGrowingSystems.stream().toList());
        filter.setActive(active);
        if (selectedIds != null && !selectedIds.isEmpty()) {
            filter.setSelectedIds(selectedIds);
        }
        if (pageNumber != null) {
            filter.setPage(pageNumber.intValue());
        }
        if (pageSize != null) {
            filter.setPageSize(pageSize.intValue());
        }
        return filter;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response readAll(@CookieParam(value="nav.context") Cookie jsonContext, PlotRequestFilter requestFilter) throws JsonProcessingException {
        NavigationContext context = jsonContext != null ? (NavigationContext)new ObjectMapper().readValue(URLDecoder.decode(jsonContext.getValue(), StandardCharsets.UTF_8), NavigationContext.class) : new NavigationContext();
        PlotFilter filter = this.buildFilter(context, requestFilter.getSelectedDomains(), requestFilter.getSelectedGrowingSystems(), requestFilter.getActive(), requestFilter.getSelectedIds(), requestFilter.getPageNumber(), requestFilter.getPageSize());
        PaginationResult paginationResult = this.performanceService.getPlotsDto(filter);
        List<PlotDto> plots = paginationResult.getElements().stream().map(arg_0 -> this.convertToDto(arg_0)).toList();
        return Response.ok().entity((Object)new PaginationResultDto(plots, paginationResult.getCount(), paginationResult.getCurrentPage())).build();
    }

    private PlotDto convertToDto(fr.inra.agrosyst.api.services.domain.PlotDto plot) {
        String domainName = plot.getGrowingSystem() != null && plot.getGrowingSystem().getGrowingPlan() != null && plot.getGrowingSystem().getGrowingPlan().getDomain() != null ? plot.getGrowingSystem().getGrowingPlan().getDomain().getName() : "";
        String growingPlanName = plot.getGrowingSystem() != null && plot.getGrowingSystem().getGrowingPlan() != null ? plot.getGrowingSystem().getGrowingPlan().getName() : "";
        String growingSystemName = plot.getGrowingSystem() != null ? plot.getGrowingSystem().getName() : "";
        int campaign = plot.getGrowingSystem() != null && plot.getGrowingSystem().getGrowingPlan() != null && plot.getGrowingSystem().getGrowingPlan().getDomain() != null ? plot.getGrowingSystem().getGrowingPlan().getDomain().getCampaign() : 0;
        return new PlotDto(StringUtils.remove((String)plot.getTopiaId(), (String)Plot.class.getName()), plot.getName(), domainName, growingPlanName, growingSystemName, campaign, plot.isActive());
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/filtered-ids")
    @Produces(value={"application/json"})
    public Response readIds(@CookieParam(value="nav.context") Cookie jsonContext, PlotRequestFilter requestFilter) throws JsonProcessingException {
        NavigationContext context = jsonContext != null ? (NavigationContext)new ObjectMapper().readValue(URLDecoder.decode(jsonContext.getValue(), StandardCharsets.UTF_8), NavigationContext.class) : new NavigationContext();
        PlotFilter filter = this.buildFilter(context, requestFilter.getSelectedDomains(), requestFilter.getSelectedGrowingSystems(), requestFilter.getActive(), null, null, null);
        Set ids = this.performanceService.getPlotIds(filter);
        Collection shortenIds = DaoUtils.getShortenIds((Collection)ids, Plot.class);
        return Response.ok().entity((Object)shortenIds).build();
    }
}

