/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.rest.performances;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.performance.ActiveSubstance;
import fr.inra.agrosyst.api.entities.performance.DecomposedOperatingExpenses;
import fr.inra.agrosyst.api.entities.performance.ExportType;
import fr.inra.agrosyst.api.entities.performance.Ift;
import fr.inra.agrosyst.api.entities.performance.IndicatorFilter;
import fr.inra.agrosyst.api.entities.performance.IndicatorFilterImpl;
import fr.inra.agrosyst.api.entities.performance.MineralFertilization;
import fr.inra.agrosyst.api.entities.performance.OrganicFertilization;
import fr.inra.agrosyst.api.entities.performance.OrganicProduct;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.performance.TotalFertilization;
import fr.inra.agrosyst.api.entities.performance.indicators.gestim.Categories;
import fr.inra.agrosyst.api.entities.performance.indicators.gestim.GESElements;
import fr.inra.agrosyst.api.entities.performance.indicators.gestim.Modalities;
import fr.inra.agrosyst.api.entities.performance.indicators.gestim.PAElements;
import fr.inra.agrosyst.api.services.common.AttachmentService;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.services.performance.indicators.IndicatorOrganicProducts;
import fr.inra.agrosyst.services.performance.indicators.fertilization.IndicatorMineralFertilization;
import fr.inra.agrosyst.services.performance.indicators.fertilization.IndicatorOrganicFertilization;
import fr.inra.agrosyst.services.performance.indicators.fertilization.IndicatorTotalFertilization;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorEnergieTotale;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorFuelEmissions;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorGESTotaux;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorMineralFertilizationEmissions;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorOrganicFertilisationEmissions;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorPATotaux;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorPhytoEmissions;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorSeedingEmissions;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorSeedingTreatmentEmissions;
import fr.inra.agrosyst.services.performance.indicators.operatingexpenses.IndicatorDecomposedOperatingExpenses;
import fr.inra.agrosyst.services.performance.indicators.qsa.IndicatorActiveSubstanceAmount;
import fr.inra.agrosyst.services.performance.indicators.qsa.IndicatorNeonicotinoidsAmount;
import fr.inra.agrosyst.services.performance.indicators.qsa.IndicatorSoilAppliedHerbicidesAmount;
import fr.inra.agrosyst.web.rest.CustomInject;
import fr.inra.agrosyst.web.rest.Secured;
import fr.inra.agrosyst.web.rest.performances.Indicator;
import fr.inra.agrosyst.web.rest.performances.IndicatorUtils;
import fr.inra.agrosyst.web.rest.performances.Method;
import fr.inra.agrosyst.web.rest.performances.MethodUtils;
import fr.inra.agrosyst.web.rest.performances.PerformanceCreationEditionDto;
import fr.inra.agrosyst.web.rest.performances.PerformanceDto;
import fr.inra.agrosyst.web.rest.performances.PerformancesResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.SetUtils;
import org.jetbrains.annotations.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
@Secured
@Path(value="/performances")
public class PerformancesResource {
    @CustomInject
    private PerformanceService performanceService;
    @CustomInject
    private AttachmentService attachmentService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(PerformanceCreationEditionDto performanceDto) {
        List indicatorFilters = this.buildIndicatorFilters(performanceDto);
        Performance performanceCreated = this.performanceService.createperformance(performanceDto.name(), performanceDto.domainIds(), performanceDto.growingSystemIds(), performanceDto.plotIds(), performanceDto.zoneIds(), indicatorFilters, Collections.emptySet(), performanceDto.exportToDb(), performanceDto.practiced());
        Response response = Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.buildPerformanceDto(performanceCreated, 0)).build();
        return response;
    }

    @PUT
    @Path(value="/{topiaId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="topiaId") String topiaId, PerformanceCreationEditionDto performanceDto) {
        List indicatorFilters = this.buildIndicatorFilters(performanceDto);
        Performance performanceUpdated = this.performanceService.updatePerformance(topiaId, performanceDto.name(), performanceDto.domainIds(), performanceDto.growingSystemIds(), performanceDto.plotIds(), performanceDto.zoneIds(), indicatorFilters, Collections.emptySet(), performanceDto.exportToDb());
        int attachmentCount = this.attachmentService.getAttachmentMetadatas(performanceUpdated.getTopiaId()).size();
        Response response = Response.ok().entity((Object)this.buildPerformanceDto(performanceUpdated, attachmentCount)).build();
        return response;
    }

    private List<IndicatorFilter> buildIndicatorFilters(PerformanceCreationEditionDto performanceDto) {
        ArrayList<IndicatorFilter> indicatorFilters = new ArrayList<IndicatorFilter>();
        ArrayList does = new ArrayList();
        ArrayList ifts = new ArrayList();
        ArrayList mineralFertilizations = new ArrayList();
        ArrayList organicFertilizations = new ArrayList();
        ArrayList totalFertilizations = new ArrayList();
        ArrayList sasActiveSubstances = new ArrayList();
        ArrayList organicProducts = new ArrayList();
        SelectedGestimIndicators selectedGestimIndicators = PerformancesResource.getSelectedGestimIndicators();
        Set methods = SetUtils.emptyIfNull((Set)performanceDto.methods());
        for (Indicator indicator : performanceDto.indicators()) {
            PerformancesResource.addSimpleClassIndicators((Indicator)indicator, does, mineralFertilizations, organicFertilizations, totalFertilizations, sasActiveSubstances, organicProducts, (Set)methods, indicatorFilters);
            PerformancesResource.addSelectedGestimIndicators((Indicator)indicator, (SelectedGestimIndicators)selectedGestimIndicators);
            indicator.getIft().ifPresent(ifts::add);
            PerformancesResource.addClassResolvedIndicators((Indicator)indicator, (Set)methods, indicatorFilters);
        }
        this.createGestimIndicators(selectedGestimIndicators, methods, indicatorFilters);
        this.createDecomposedOperatingExpensesIndicator(performanceDto, does, indicatorFilters);
        this.createIftIndicators(performanceDto, ifts, indicatorFilters);
        this.createMineralFertilizationIndicator(mineralFertilizations, indicatorFilters);
        this.createOrganicFertilizationIndicator(organicFertilizations, indicatorFilters);
        this.createTotalFertilizationIndicator(totalFertilizations, indicatorFilters);
        this.createSpecificActiveSubstanceAmountIndicator(performanceDto, sasActiveSubstances, indicatorFilters);
        this.createOrganicProductsIndicator(organicProducts, indicatorFilters);
        return indicatorFilters;
    }

    @NotNull
    private static SelectedGestimIndicators getSelectedGestimIndicators() {
        SelectedGestimIndicators result = new SelectedGestimIndicators();
        return result;
    }

    private void createGestimIndicators(SelectedGestimIndicators selectedGestimIndicators, Set<Method> methods, ArrayList<IndicatorFilter> indicatorFilters) {
        Set emmisionTotalIndicatorFilter = PerformancesResource.createGestimTotauxIndicators((List)selectedGestimIndicators.getTotalEmissionsIndicators(), methods);
        Optional optionalMineralEmmisionIndicatorFilter = PerformancesResource.createGestimIndicators((List)selectedGestimIndicators.getMineralFertilizationEmissionsIndicators(), methods, (String)IndicatorMineralFertilizationEmissions.class.getSimpleName());
        Optional optionalFuelEmmisionIndicatorFilter = PerformancesResource.createGestimIndicators((List)selectedGestimIndicators.getFuelEmissionsIndicators(), methods, (String)IndicatorFuelEmissions.class.getSimpleName());
        Optional optionalFertilisationEmmisionIndicatorFilter = PerformancesResource.createGestimIndicators((List)selectedGestimIndicators.getOrganicFertilisationEmissionsIndicators(), methods, (String)IndicatorOrganicFertilisationEmissions.class.getSimpleName());
        Optional optionalPhytoEmmisionIndicatorFilter = PerformancesResource.createGestimIndicators((List)selectedGestimIndicators.getPhytoEmissionsIndicators(), methods, (String)IndicatorPhytoEmissions.class.getSimpleName());
        Optional optionalSeedingTraitmentEmmisionIndicatorFilter = PerformancesResource.createGestimIndicators((List)selectedGestimIndicators.getSeedingTraitementEmissionsIndicators(), methods, (String)IndicatorSeedingTreatmentEmissions.class.getSimpleName());
        Optional optionalSeedEmmisionIndicatorFilter = PerformancesResource.createGestimIndicators((List)selectedGestimIndicators.getSeedingEmissionsIndicators(), methods, (String)IndicatorSeedingEmissions.class.getSimpleName());
        this.addGestimIndicators(indicatorFilters, optionalMineralEmmisionIndicatorFilter, optionalFuelEmmisionIndicatorFilter, optionalFertilisationEmmisionIndicatorFilter, optionalPhytoEmmisionIndicatorFilter, optionalSeedingTraitmentEmmisionIndicatorFilter, optionalSeedEmmisionIndicatorFilter, emmisionTotalIndicatorFilter);
    }

    protected void addGestimIndicators(List<IndicatorFilter> indicatorFilters, Optional<IndicatorFilter> optionalMineralEmmisionIndicatorFilter, Optional<IndicatorFilter> optionalFuelEmmisionIndicatorFilter, Optional<IndicatorFilter> optionalFertilisationEmmisionIndicatorFilter, Optional<IndicatorFilter> optionalPhytoEmmisionIndicatorFilter, Optional<IndicatorFilter> optionalSeedingTraitmentEmmisionIndicatorFilter, Optional<IndicatorFilter> optionalSeedEmmisionIndicatorFilter, Set<IndicatorFilter> emmisionTotalIndicatorFilter) {
        optionalMineralEmmisionIndicatorFilter.ifPresent(indicatorFilters::add);
        optionalFuelEmmisionIndicatorFilter.ifPresent(indicatorFilters::add);
        optionalFertilisationEmmisionIndicatorFilter.ifPresent(indicatorFilters::add);
        optionalPhytoEmmisionIndicatorFilter.ifPresent(indicatorFilters::add);
        optionalSeedingTraitmentEmmisionIndicatorFilter.ifPresent(indicatorFilters::add);
        optionalSeedEmmisionIndicatorFilter.ifPresent(indicatorFilters::add);
        indicatorFilters.addAll(emmisionTotalIndicatorFilter);
    }

    private static void addClassResolvedIndicators(Indicator indicator, Set<Method> methods, ArrayList<IndicatorFilter> indicatorFilters) {
        indicator.getClazzResolver().ifPresent(resolver -> {
            List classes = (List)resolver.apply(methods);
            List<IndicatorFilterImpl> filters = classes.stream().map(clazz -> {
                IndicatorFilterImpl filter = new IndicatorFilterImpl();
                filter.setClazz(clazz.getSimpleName());
                indicator.getHandleParameters().ifPresent(consumer -> consumer.accept(methods, filter));
                return filter;
            }).toList();
            indicatorFilters.addAll(filters);
        });
    }

    private static void addSimpleClassIndicators(Indicator indicator, ArrayList<DecomposedOperatingExpenses> does, ArrayList<MineralFertilization> mineralFertilizations, ArrayList<OrganicFertilization> organicFertilizations, ArrayList<TotalFertilization> totalFertilizations, ArrayList<ActiveSubstance> sasActiveSubstances, ArrayList<OrganicProduct> organicProducts, Set<Method> methods, ArrayList<IndicatorFilter> indicatorFilters) {
        indicator.getClazz().ifPresent(clazz -> {
            block9: {
                block8: {
                    if (clazz.equals(IndicatorDecomposedOperatingExpenses.class)) {
                        indicator.getDoe().ifPresent(does::add);
                        return;
                    }
                    if (clazz.equals(IndicatorMineralFertilization.class)) {
                        indicator.getMineralFertilization().ifPresent(mineralFertilizations::add);
                        return;
                    }
                    if (clazz.equals(IndicatorOrganicFertilization.class)) {
                        indicator.getOrganicFertilization().ifPresent(organicFertilizations::add);
                        return;
                    }
                    if (clazz.equals(IndicatorTotalFertilization.class)) {
                        indicator.getTotalFertilization().ifPresent(totalFertilizations::add);
                        return;
                    }
                    if (clazz.equals(IndicatorActiveSubstanceAmount.class) || clazz.equals(IndicatorSoilAppliedHerbicidesAmount.class)) break block8;
                    if (!clazz.equals(IndicatorNeonicotinoidsAmount.class)) break block9;
                }
                indicator.getActiveSubstance().ifPresent(sasActiveSubstances::add);
                return;
            }
            if (clazz.equals(IndicatorOrganicProducts.class)) {
                indicator.getOrganicProduct().ifPresent(organicProducts::add);
                return;
            }
            IndicatorFilterImpl filter = new IndicatorFilterImpl();
            filter.setClazz(((Class)indicator.getClazz().get()).getSimpleName());
            indicator.getHandleParameters().ifPresent(consumer -> consumer.accept(methods, filter));
            indicatorFilters.add((IndicatorFilter)filter);
        });
    }

    private static void addSelectedGestimIndicators(Indicator indicator, SelectedGestimIndicators selectedGestimIndicators) {
        if (Indicator.GES_TOTAUX == indicator || Indicator.POLLUANTS_ATMOSPHERIQUES_TOTAUX == indicator || Indicator.ENERGIE_TOTAL == indicator) {
            selectedGestimIndicators.addTotalEmissionsIndicator(indicator);
        } else if (Indicator.GES_FERTILISANTS_MINERAUX == indicator || Indicator.POLLUANTS_ATMOSPHERIQUES_FERTILISANTS_MINERAUX == indicator || Indicator.ENERGIE_FERTILISANTS_MINERAUX == indicator) {
            selectedGestimIndicators.addMineralFertilizationEmissionsIndicators(indicator);
        } else if (Indicator.GES_CARBURANT == indicator || Indicator.POLLUANTS_ATMOSPHERIQUES_CARBURANT == indicator || Indicator.ENERGIE_CARBURANT_DIRECT == indicator || Indicator.ENERGIE_CARBURANT_INDIRECT == indicator) {
            selectedGestimIndicators.addFuelEmissionsIndicators(indicator);
        } else if (Indicator.GES_FERTILISANTS_ORGANIQUES == indicator || Indicator.POLLUANTS_ATMOSPHERIQUES_FERTILISANTS_ORGANIQUES == indicator || Indicator.ENERGIE_FERTILISANTS_ORGANIQUES == indicator) {
            selectedGestimIndicators.addOrganicFertilisationEmissionsIndicator(indicator);
        } else if (Indicator.GES_PRODUITS_PHYTOSANITAIRE == indicator || Indicator.POLLUANTS_ATMOSPHERIQUES_PRODUITS_PHYTOSANITAIRE == indicator || Indicator.ENERGIE_PRODUITS_PHYTOSANITAIRE == indicator) {
            selectedGestimIndicators.addPhytoEmissionsIndicator(indicator);
        } else if (Indicator.GES_TRAITEMENTS_SEMENCES == indicator || Indicator.POLLUANTS_ATMOSPHERIQUES_TRAITEMENTS_SEMENCES == indicator || Indicator.ENERGIE_TRAITEMENTS_SEMENCES == indicator) {
            selectedGestimIndicators.addSeedingTraitementEmissionsIndicator(indicator);
        } else if (Indicator.GES_SEMENCES_ET_PLANTS == indicator || Indicator.POLLUANTS_ATMOSPHERIQUES_SEMENCES_ET_PLANTS == indicator || Indicator.ENERGIE_SEMENCES_ET_PLANTS == indicator) {
            selectedGestimIndicators.addSeedingEmissionsIndicator(indicator);
        }
    }

    protected static Optional<IndicatorFilter> createGestimIndicators(List<Indicator> selectedIndicators, Set<Method> selectedMethods, String indicatorClasseName) {
        IndicatorFilterImpl filter = null;
        if (!selectedIndicators.isEmpty()) {
            filter = new IndicatorFilterImpl();
            HashSet<Modalities> modalities = new HashSet<Modalities>();
            HashSet<Categories> categories = new HashSet<Categories>();
            HashSet<GESElements> gesElements = new HashSet<GESElements>();
            HashSet<PAElements> paElements = new HashSet<PAElements>();
            filter.setClazz(indicatorClasseName);
            filter.setModalities(modalities);
            filter.setCategories(categories);
            filter.setgESElements(gesElements);
            filter.setpAElements(paElements);
            boolean isEnergie = selectedIndicators.stream().anyMatch(ind -> Indicator.ENERGIE_CARBURANT_DIRECT == ind || Indicator.ENERGIE_SEMENCES_ET_PLANTS == ind || Indicator.ENERGIE_FERTILISANTS_ORGANIQUES == ind || Indicator.ENERGIE_PRODUITS_PHYTOSANITAIRE == ind || Indicator.ENERGIE_TRAITEMENTS_SEMENCES == ind || Indicator.ENERGIE_CARBURANT_INDIRECT == ind || Indicator.ENERGIE_TOTAL == ind || Indicator.ENERGIE_FERTILISANTS_MINERAUX == ind);
            if (isEnergie) {
                categories.add(Categories.ENERGIE);
                modalities.add(Modalities.ENERGIE_INDIRECTES);
            }
            boolean isEnergieCarburantDirect = selectedIndicators.stream().anyMatch(ind -> Indicator.ENERGIE_CARBURANT_DIRECT == ind);
            boolean isEnergieCarburantIndirect = selectedIndicators.stream().anyMatch(ind -> Indicator.ENERGIE_CARBURANT_INDIRECT == ind);
            if (isEnergieCarburantDirect) {
                modalities.add(Modalities.ENERGIE_DIRECTES);
            }
            if (isEnergieCarburantIndirect) {
                modalities.add(Modalities.ENERGIE_INDIRECTES);
            }
            for (Method method : selectedMethods) {
                switch (1.$SwitchMap$fr$inra$agrosyst$web$rest$performances$Method[method.ordinal()]) {
                    case 1: {
                        categories.add(Categories.GES);
                        modalities.add(Modalities.GES_TOTAL);
                        break;
                    }
                    case 2: {
                        categories.add(Categories.GES);
                        modalities.add(Modalities.GES_DIRECT);
                        break;
                    }
                    case 3: {
                        categories.add(Categories.GES);
                        modalities.add(Modalities.GES_INDIRECT);
                        break;
                    }
                    case 4: {
                        categories.add(Categories.GES);
                        gesElements.add(GESElements.CO2);
                        break;
                    }
                    case 5: {
                        categories.add(Categories.GES);
                        gesElements.add(GESElements.CH4);
                        break;
                    }
                    case 6: {
                        categories.add(Categories.GES);
                        gesElements.add(GESElements.N2O);
                        break;
                    }
                    case 7: {
                        categories.add(Categories.GES);
                        gesElements.add(GESElements.GES_TOTAL);
                        break;
                    }
                    case 8: {
                        categories.add(Categories.PA);
                        modalities.add(Modalities.PA_TOTAL);
                        break;
                    }
                    case 9: {
                        categories.add(Categories.PA);
                        modalities.add(Modalities.PA_DIRECT);
                        break;
                    }
                    case 10: {
                        categories.add(Categories.PA);
                        modalities.add(Modalities.PA_INDIRECT);
                        break;
                    }
                    case 11: {
                        categories.add(Categories.PA);
                        paElements.add(PAElements.SO2);
                        break;
                    }
                    case 12: {
                        categories.add(Categories.PA);
                        paElements.add(PAElements.NOX);
                        break;
                    }
                    case 13: {
                        categories.add(Categories.PA);
                        paElements.add(PAElements.NH3);
                        break;
                    }
                }
            }
        }
        return Optional.ofNullable(filter);
    }

    protected static Set<IndicatorFilter> createGestimTotauxIndicators(List<Indicator> selectedIndicators, Set<Method> selectedMethods) {
        HashSet<IndicatorFilter> result = new HashSet<IndicatorFilter>();
        if (!selectedIndicators.isEmpty()) {
            for (Indicator selectedIndicator : selectedIndicators) {
                String clazz;
                if (Indicator.GES_TOTAUX == selectedIndicator) {
                    clazz = IndicatorGESTotaux.class.getSimpleName();
                } else if (Indicator.POLLUANTS_ATMOSPHERIQUES_TOTAUX == selectedIndicator) {
                    clazz = IndicatorPATotaux.class.getSimpleName();
                } else {
                    if (Indicator.ENERGIE_TOTAL != selectedIndicator) continue;
                    clazz = IndicatorEnergieTotale.class.getSimpleName();
                }
                Optional indicatorFilter = PerformancesResource.createGestimIndicators(selectedIndicators, selectedMethods, (String)clazz);
                indicatorFilter.ifPresent(result::add);
            }
        }
        return result;
    }

    private void createDecomposedOperatingExpensesIndicator(PerformanceCreationEditionDto performanceDto, ArrayList<DecomposedOperatingExpenses> does, ArrayList<IndicatorFilter> indicatorFilters) {
        if (!does.isEmpty()) {
            IndicatorFilterImpl filter = new IndicatorFilterImpl();
            filter.setClazz(IndicatorDecomposedOperatingExpenses.class.getSimpleName());
            filter.setDoeIndicators(does);
            MethodUtils.CHARGES_METHODS_PARAMETER.accept(performanceDto.methods(), filter);
            indicatorFilters.add((IndicatorFilter)filter);
        }
    }

    private void createIftIndicators(PerformanceCreationEditionDto performanceDto, ArrayList<Ift> ifts, ArrayList<IndicatorFilter> indicatorFilters) {
        if (!ifts.isEmpty()) {
            ((List)IndicatorUtils.IFT_INDICATORS_PARAMETER.apply(performanceDto.methods())).forEach(clazz -> {
                IndicatorFilterImpl filter = new IndicatorFilterImpl();
                filter.setClazz(clazz.getSimpleName());
                filter.setIfts((Collection)ifts);
                indicatorFilters.add((IndicatorFilter)filter);
            });
        }
    }

    private void createMineralFertilizationIndicator(ArrayList<MineralFertilization> mineralFertilizations, ArrayList<IndicatorFilter> indicatorFilters) {
        if (!mineralFertilizations.isEmpty()) {
            IndicatorFilterImpl filter = new IndicatorFilterImpl();
            filter.setClazz(IndicatorMineralFertilization.class.getSimpleName());
            filter.setMineralFertilizations(mineralFertilizations);
            indicatorFilters.add((IndicatorFilter)filter);
        }
    }

    private void createOrganicFertilizationIndicator(ArrayList<OrganicFertilization> organicFertilizations, ArrayList<IndicatorFilter> indicatorFilters) {
        if (!organicFertilizations.isEmpty()) {
            IndicatorFilterImpl filter = new IndicatorFilterImpl();
            filter.setClazz(IndicatorOrganicFertilization.class.getSimpleName());
            filter.setOrganicFertilizations(organicFertilizations);
            indicatorFilters.add((IndicatorFilter)filter);
        }
    }

    private void createTotalFertilizationIndicator(ArrayList<TotalFertilization> totalFertilizations, ArrayList<IndicatorFilter> indicatorFilters) {
        if (!totalFertilizations.isEmpty()) {
            IndicatorFilterImpl filter = new IndicatorFilterImpl();
            filter.setClazz(IndicatorTotalFertilization.class.getSimpleName());
            filter.setTotalFertilizations(totalFertilizations);
            indicatorFilters.add((IndicatorFilter)filter);
        }
    }

    private void createSpecificActiveSubstanceAmountIndicator(PerformanceCreationEditionDto performanceDto, ArrayList<ActiveSubstance> sasActiveSubstances, ArrayList<IndicatorFilter> indicatorFilters) {
        if (!sasActiveSubstances.isEmpty()) {
            IndicatorFilterImpl filter = new IndicatorFilterImpl();
            filter.setClazz(IndicatorActiveSubstanceAmount.class.getSimpleName());
            filter.setActiveSubstances(sasActiveSubstances);
            MethodUtils.SUBSTANCES_ACTIVES_SPECIFIQUES_METHODS_PARAMETER.accept(performanceDto.methods(), filter);
            indicatorFilters.add((IndicatorFilter)filter);
            if (sasActiveSubstances.contains(ActiveSubstance.NEONICOTINOIDES)) {
                IndicatorFilterImpl neonicotinoidesFilter = new IndicatorFilterImpl();
                neonicotinoidesFilter.setClazz(IndicatorNeonicotinoidsAmount.class.getSimpleName());
                MethodUtils.SUBSTANCES_ACTIVES_SPECIFIQUES_METHODS_PARAMETER.accept(performanceDto.methods(), neonicotinoidesFilter);
                indicatorFilters.add((IndicatorFilter)neonicotinoidesFilter);
            }
            if (sasActiveSubstances.contains(ActiveSubstance.HERBICIDES_RACINAIRES)) {
                IndicatorFilterImpl soilAppliedHerbicidesAmountFilter = new IndicatorFilterImpl();
                soilAppliedHerbicidesAmountFilter.setClazz(IndicatorSoilAppliedHerbicidesAmount.class.getSimpleName());
                MethodUtils.SUBSTANCES_ACTIVES_SPECIFIQUES_METHODS_PARAMETER.accept(performanceDto.methods(), soilAppliedHerbicidesAmountFilter);
                indicatorFilters.add((IndicatorFilter)soilAppliedHerbicidesAmountFilter);
            }
        }
    }

    private void createOrganicProductsIndicator(ArrayList<OrganicProduct> organicProducts, ArrayList<IndicatorFilter> indicatorFilters) {
        if (!organicProducts.isEmpty()) {
            IndicatorFilterImpl filter = new IndicatorFilterImpl();
            filter.setClazz(IndicatorOrganicProducts.class.getSimpleName());
            filter.setOrganicProducts(organicProducts);
            indicatorFilters.add((IndicatorFilter)filter);
        }
    }

    private boolean isComputeOnReal(PerformanceCreationEditionDto performanceDto) {
        return performanceDto.methods().contains(Method.PRIX_REELS_CHARGES) || performanceDto.methods().contains(Method.PRIX_REELS_PRODUITS_MARGES);
    }

    private boolean isComputeOnStandardised(PerformanceCreationEditionDto performanceDto) {
        return performanceDto.methods().contains(Method.PRIX_STANDARDISES_MILLESIMES_CHARGES) || performanceDto.methods().contains(Method.PRIX_STANDARDISES_MILLESIMES_PRODUITS_MARGES);
    }

    private PerformanceDto buildPerformanceDto(Performance performance, int attachmentCount) {
        Set methods = MethodUtils.CONVERT_TO_METHODS((Collection)performance.getIndicatorFilter());
        Set indicators = IndicatorUtils.CONVERT_TO_INDICATORS((Collection)performance.getIndicatorFilter());
        Collection domainsTopiaIds = DaoUtils.getShortenIds((Collection)performance.getDomainsTopiaIds(), Domain.class);
        Collection growingSystemsTopiaIds = DaoUtils.getShortenIds((Collection)performance.getGrowingSystemsTopiaIds(), GrowingSystem.class);
        Collection plotsTopiaIds = DaoUtils.getShortenIds((Collection)performance.getPlotsTopiaIds(), Plot.class);
        Collection zonesTopiaIds = DaoUtils.getShortenIds((Collection)performance.getZonesTopiaIds(), Zone.class);
        PerformanceDto performanceDto = new PerformanceDto(performance.getTopiaId(), performance.getName(), performance.isPracticed(), methods, indicators, domainsTopiaIds, growingSystemsTopiaIds, plotsTopiaIds, zonesTopiaIds, ExportType.DB.equals((Object)performance.getExportType()), performance.getComputeStatus(), attachmentCount);
        return performanceDto;
    }

    @GET
    @Path(value="/{topiaId}")
    @Produces(value={"application/json"})
    public Response read(@PathParam(value="topiaId") String topiaId) {
        Performance performance = this.performanceService.getPerformance(topiaId);
        int attachmentCount = this.attachmentService.getAttachmentMetadatas(performance.getTopiaId()).size();
        Response response = Response.ok().entity((Object)this.buildPerformanceDto(performance, attachmentCount)).build();
        return response;
    }
}

