/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.rest.domains;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.security.AuthorizationService;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.web.rest.CustomInject;
import fr.inra.agrosyst.web.rest.Secured;
import fr.inra.agrosyst.web.rest.common.PaginationResultDto;
import fr.inra.agrosyst.web.rest.domains.DomainDto;
import fr.inra.agrosyst.web.rest.domains.DomainRequestFilter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.pagination.PaginationResult;

@Secured
@Path(value="/domains")
public class DomainsResource {
    @CustomInject
    private DomainService domainService;
    @CustomInject
    private AuthorizationService authorizationService;

    private DomainFilter buildFilter(NavigationContext navigationContext, String name, Integer campaign, DomainType type, String responsable, String departement, Boolean active, Set<String> selectedIds, Boolean withoutContext, Integer pageNumber, Integer pageSize) {
        DomainFilter filter = new DomainFilter();
        NavigationContext contextWithoutDomains = new NavigationContext(navigationContext.getCampaigns(), navigationContext.getNetworks(), Collections.emptySet(), navigationContext.getGrowingPlans(), navigationContext.getGrowingSystems());
        filter.setNavigationContext(withoutContext != null && withoutContext != false ? contextWithoutDomains : navigationContext);
        filter.setDomainName(name);
        filter.setCampaign(campaign);
        filter.setType(type);
        filter.setResponsable(responsable);
        filter.setDepartement(departement);
        filter.setActive(active);
        if (selectedIds != null && !selectedIds.isEmpty()) {
            filter.setSelectedIds(selectedIds);
        }
        if (pageNumber != null) {
            filter.setPage(pageNumber.intValue());
        }
        if (pageSize != null) {
            filter.setPageSize(pageSize.intValue());
        }
        return filter;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response readAll(@CookieParam(value="nav.context") Cookie jsonContext, DomainRequestFilter requestFilter) throws JsonProcessingException {
        NavigationContext context = jsonContext != null ? (NavigationContext)new ObjectMapper().readValue(URLDecoder.decode(jsonContext.getValue(), StandardCharsets.UTF_8), NavigationContext.class) : new NavigationContext();
        DomainFilter filter = this.buildFilter(context, requestFilter.getName(), requestFilter.getCampaign(), requestFilter.getType(), requestFilter.getResponsable(), requestFilter.getDepartement(), requestFilter.getActive(), requestFilter.getSelectedIds(), requestFilter.getWithoutContext(), requestFilter.getPageNumber(), requestFilter.getPageSize());
        PaginationResult paginationResult = this.domainService.getFilteredDomains(filter);
        List<DomainDto> domains = paginationResult.getElements().stream().map(d -> {
            List responsibles = this.authorizationService.getDomainResponsibles(d.getCode());
            String responsiblesAsStr = responsibles.stream().map(r -> r.getFirstName() + " " + r.getLastName()).collect(Collectors.joining(", "));
            return new DomainDto(StringUtils.remove((String)d.getTopiaId(), (String)Domain.class.getName()), d.getName(), d.getCampaign(), d.getType(), responsiblesAsStr, d.getLocation().getDepartement(), d.isActive());
        }).toList();
        return Response.ok().entity((Object)new PaginationResultDto(domains, paginationResult.getCount(), paginationResult.getCurrentPage())).build();
    }

    @Path(value="/filtered-ids")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response readIds(@CookieParam(value="nav.context") Cookie jsonContext, DomainRequestFilter requestFilter) throws JsonProcessingException {
        NavigationContext context = jsonContext != null ? (NavigationContext)new ObjectMapper().readValue(URLDecoder.decode(jsonContext.getValue(), StandardCharsets.UTF_8), NavigationContext.class) : new NavigationContext();
        DomainFilter filter = this.buildFilter(context, requestFilter.getName(), requestFilter.getCampaign(), requestFilter.getType(), requestFilter.getResponsable(), requestFilter.getDepartement(), requestFilter.getActive(), null, requestFilter.getWithoutContext(), null, null);
        Collection ids = DaoUtils.getShortenIds((Collection)this.domainService.getFilteredDomainIds(filter), Domain.class);
        return Response.ok().entity((Object)ids).build();
    }
}

