/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.rest;

import com.google.common.base.Preconditions;
import fr.inra.agrosyst.api.entities.AgrosystTopiaApplicationContext;
import fr.inra.agrosyst.api.entities.AgrosystTopiaPersistenceContext;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.users.AuthenticatedUser;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.web.AgrosystWebApplicationContext;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestTransactionFilter
implements Filter {
    private static final Log LOGGER = LogFactory.getLog(RestTransactionFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        AgrosystWebApplicationContext webApplicationContext = this.getAgrosystApplicationContext(request.getServletContext());
        Optional authenticatedUser = this.getAuthenticatedUser(request);
        ServiceContext serviceContext = this.newServiceContext(webApplicationContext, authenticatedUser);
        request.setAttribute(ServiceContext.SERVICE_CONTEXT_PARAMETER, (Object)serviceContext);
        try {
            chain.doFilter(request, response);
        }
        catch (Exception eee) {
            this.rollbackTransaction(serviceContext);
            if (LOGGER.isErrorEnabled()) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                String userEmail = authenticatedUser.map(AuthenticatedUser::getEmail).orElse("?");
                String message = String.format("Exception occured for user '%s' during Rest endpoint invocation (path is '%s' and method is '%s'): %s", userEmail, httpServletRequest.getContextPath(), httpServletRequest.getMethod(), eee.getMessage());
                LOGGER.error((Object)message, (Throwable)eee);
            }
            throw eee;
        }
        finally {
            this.checkClosedPersistenceContext(serviceContext);
        }
    }

    protected AgrosystWebApplicationContext getAgrosystApplicationContext(ServletContext servletContext) {
        AgrosystWebApplicationContext applicationContext = (AgrosystWebApplicationContext)servletContext.getAttribute(AgrosystWebApplicationContext.APPLICATION_CONTEXT_PARAMETER);
        Preconditions.checkState((applicationContext != null ? 1 : 0) != 0, (Object)AgrosystWebApplicationContext.MISSING_APPLICATION_CONTEXT);
        return applicationContext;
    }

    protected Optional<AuthenticatedUser> getAuthenticatedUser(ServletRequest request) {
        AuthenticatedUser userDto = (AuthenticatedUser)request.getAttribute("authenticatedUser");
        Optional<AuthenticatedUser> result = Optional.ofNullable(userDto);
        return result;
    }

    protected ServiceContext newServiceContext(AgrosystWebApplicationContext webApplicationContext, Optional<AuthenticatedUser> authenticatedUser) {
        ServiceContext result;
        block2: {
            result = null;
            AgrosystTopiaApplicationContext topiaApplicationContext = webApplicationContext.getApplicationContext();
            Preconditions.checkState((topiaApplicationContext != null ? 1 : 0) != 0);
            try {
                result = authenticatedUser.isPresent() ? topiaApplicationContext.newServiceContext(authenticatedUser.get()) : topiaApplicationContext.newServiceContext();
            }
            catch (Exception eee) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error((Object)"Unable to create local serviceContext", (Throwable)eee);
            }
        }
        Preconditions.checkState((result != null ? 1 : 0) != 0, (Object)"ServiceContext not instantiated, check configuration");
        return result;
    }

    protected void rollbackTransaction(ServiceContext serviceContext) {
        try {
            AgrosystTopiaPersistenceContext persistenceContext = serviceContext.getPersistenceContext(false);
            if (persistenceContext != null) {
                persistenceContext.rollback();
            }
        }
        catch (Exception eee) {
            if (LOGGER.isFatalEnabled()) {
                LOGGER.fatal((Object)"Unable to rollback persistence context !", (Throwable)eee);
            }
            throw new AgrosystTechnicalException("Unable to rollback persistence context !", (Throwable)eee);
        }
    }

    protected void checkClosedPersistenceContext(ServiceContext serviceContext) {
        try {
            serviceContext.close();
        }
        catch (Exception eee) {
            if (LOGGER.isFatalEnabled()) {
                LOGGER.fatal((Object)"Unable to close persistence context !", (Throwable)eee);
            }
            throw new AgrosystTechnicalException("Unable to close persistence context !", (Throwable)eee);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

