/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.rest;

import com.google.common.base.Preconditions;
import fr.inra.agrosyst.api.Language;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.users.AuthenticatedUser;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.web.AgrosystWebApplicationContext;
import fr.inra.agrosyst.web.AgrosystWebConfig;
import fr.inra.agrosyst.web.AgrosystWebNotificationSupport;
import fr.inra.agrosyst.web.AgrosystWebNotificationSupportDistributed;
import fr.inra.agrosyst.web.rest.CustomInject;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;

public class CustomInjectionResolver
implements InjectionResolver<CustomInject> {
    @Inject
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpServletRequest;

    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        if (injectee.getInjecteeClass() != null) {
            AgrosystWebApplicationContext webApplicationContext = this.getAgrosystApplicationContext();
            Optional authenticatedUser = this.getAuthenticatedUser();
            ServiceContext serviceContext = (ServiceContext)this.httpServletRequest.getAttribute(ServiceContext.SERVICE_CONTEXT_PARAMETER);
            AgrosystService toInject = null;
            if (AgrosystService.class.isAssignableFrom((Class)injectee.getRequiredType())) {
                Class clazz = (Class)injectee.getRequiredType();
                toInject = serviceContext.newService(clazz);
            } else if (AgrosystWebConfig.class.isAssignableFrom((Class)injectee.getRequiredType())) {
                toInject = webApplicationContext.getWebConfig();
            } else if (AgrosystWebApplicationContext.class.isAssignableFrom((Class)injectee.getRequiredType())) {
                toInject = webApplicationContext;
            } else if (AgrosystWebNotificationSupport.class.isAssignableFrom((Class)injectee.getRequiredType())) {
                AgrosystWebNotificationSupport notificationSupport = this.getNotificationSupport(webApplicationContext, authenticatedUser);
                toInject = notificationSupport;
            }
            return toInject;
        }
        return null;
    }

    protected AgrosystWebApplicationContext getAgrosystApplicationContext() {
        AgrosystWebApplicationContext applicationContext = (AgrosystWebApplicationContext)this.servletContext.getAttribute(AgrosystWebApplicationContext.APPLICATION_CONTEXT_PARAMETER);
        Preconditions.checkState((applicationContext != null ? 1 : 0) != 0, (Object)AgrosystWebApplicationContext.MISSING_APPLICATION_CONTEXT);
        return applicationContext;
    }

    protected Optional<AuthenticatedUser> getAuthenticatedUser() {
        AuthenticatedUser userDto = (AuthenticatedUser)this.httpServletRequest.getAttribute("authenticatedUser");
        return Optional.ofNullable(userDto);
    }

    protected AgrosystWebNotificationSupport getNotificationSupport(AgrosystWebApplicationContext webApplicationContext, Optional<AuthenticatedUser> authenticatedUser) {
        if (authenticatedUser.isPresent()) {
            Map cache = webApplicationContext.getDistributedCache("notifications");
            String userId = authenticatedUser.get().getTopiaId();
            AgrosystWebNotificationSupportDistributed notificationSupport = Optional.ofNullable((AgrosystWebNotificationSupportDistributed)cache.get(userId)).orElseGet(AgrosystWebNotificationSupportDistributed::new);
            notificationSupport.setLanguage(authenticatedUser.get().getLanguage());
            Runnable updater = () -> {
                if (notificationSupport.isEmpty()) {
                    cache.remove(userId);
                } else {
                    cache.put(userId, notificationSupport);
                }
            };
            notificationSupport.setUpdater(updater);
            return notificationSupport;
        }
        AgrosystWebNotificationSupport result = new AgrosystWebNotificationSupport();
        result.setLanguage(Language.FRENCH);
        return result;
    }

    public boolean isConstructorParameterIndicator() {
        return true;
    }

    public boolean isMethodParameterIndicator() {
        return true;
    }
}

