/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.listeners;

import com.google.common.hash.Hashing;
import fr.inra.agrosyst.api.services.users.AuthenticatedUser;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AgrosystWebSessionListener
implements HttpSessionListener {
    private static final Log LOGGER = LogFactory.getLog(AgrosystWebSessionListener.class);

    private static String obfuscateSessionId(String sessionId) {
        String result = "";
        if (StringUtils.isNotEmpty((CharSequence)sessionId)) {
            result = Hashing.crc32().hashString((CharSequence)sessionId, StandardCharsets.UTF_8).toString();
        }
        return result;
    }

    private static String obfuscateSessionId(HttpSession session) {
        String sessionId = session.getId();
        Object result = AgrosystWebSessionListener.obfuscateSessionId((String)sessionId);
        if (session.isNew()) {
            result = (String)result + " NEW";
        }
        return result;
    }

    public static String getSessionId(HttpServletRequest servletRequest) {
        AuthenticatedUser authenticatedUser = (AuthenticatedUser)servletRequest.getAttribute("authenticatedUser");
        String result = Optional.ofNullable(authenticatedUser).map(AuthenticatedUser::getSid).orElse("--------");
        return result;
    }

    public void sessionCreated(HttpSessionEvent se) {
        if (LOGGER.isInfoEnabled()) {
            HttpSession session = se.getSession();
            LOGGER.info((Object)String.format("[%s] New HTTP session created", AgrosystWebSessionListener.obfuscateSessionId((HttpSession)session)));
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        String sessionId = AgrosystWebSessionListener.obfuscateSessionId((HttpSession)session);
        if (LOGGER.isInfoEnabled()) {
            Date created = new Date(session.getCreationTime());
            Date lastAccessed = new Date(session.getLastAccessedTime());
            String message = String.format("[%s] HTTP session about to be destroyed. Created on %s. Last accessed on: %s.", sessionId, created, lastAccessed);
            LOGGER.info((Object)message);
        }
    }
}

