/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.security;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.Language;
import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.services.security.UserRoleDto;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.util.StringUtil;

public class UsersEdit
extends AbstractAdminAction
implements Preparable {
    private static final Log LOGGER = LogFactory.getLog(UsersEdit.class);
    private static final long serialVersionUID = 259407617651911081L;
    protected transient UserService userService;
    protected String userTopiaId;
    protected UserDto user;
    protected boolean newUser;
    protected List<UserRoleDto> userRoles;
    protected String password;
    protected String confirmPassword;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setUserTopiaId(String userTopiaId) {
        this.userTopiaId = userTopiaId;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public void setUserRolesJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.userRoles = (List)this.getGson().fromJson(json, type);
    }

    public void prepare() throws Exception {
        super.prepare();
        if (Strings.isNullOrEmpty((String)this.userTopiaId)) {
            this.user = new UserDto();
            this.user.setActive(true);
            this.userRoles = new ArrayList();
            this.newUser = true;
        } else {
            this.user = this.userService.getUser(this.userTopiaId);
            this.userRoles = this.authorizationService.getUserRoles(this.userTopiaId);
            this.newUser = false;
        }
    }

    @Action(value="users-edit-input")
    public String input() throws Exception {
        return "input";
    }

    public void validate() {
        UserDto user = this.getUser();
        String email = user.getEmail();
        if (Strings.isNullOrEmpty((String)email)) {
            this.addFieldError("user.email", "Le champ 'Email' est obligatoire");
        } else if (!StringUtil.isEmail((String)email)) {
            this.addFieldError("user.email", "L'adresse email n'est pas valide");
        }
        if (this.userService.isEmailInUse(email, this.userTopiaId)) {
            this.addFieldError("user.email", "Cette adresse email est d\u00e9j\u00e0 utilis\u00e9e");
        }
        if (this.newUser) {
            if (Strings.isNullOrEmpty((String)this.password)) {
                this.addFieldError("password", "Le champ 'password' est obligatoire");
            }
            if (Strings.isNullOrEmpty((String)this.confirmPassword)) {
                this.addFieldError("confirmPassword", "Le champ 'confirmPassword' est obligatoire");
            }
        }
        if (!Objects.equal((Object)this.password, (Object)this.confirmPassword)) {
            this.addFieldError("confirmPassword", "Les champs 'password' et 'confirmPassword' ne correspondent pas");
        }
        if (Strings.isNullOrEmpty((String)user.getFirstName())) {
            this.addFieldError("user.firstName", "Le champ 'Pr\u00e9nom' est obligatoire");
        }
        if (Strings.isNullOrEmpty((String)user.getLastName())) {
            this.addFieldError("user.lastName", "Le champ 'Nom' est obligatoire");
        }
        if (this.userRoles != null) {
            ArrayList validateRules = Lists.newArrayListWithCapacity((int)this.userRoles.size());
            for (UserRoleDto userRoleDto : this.userRoles) {
                if (userRoleDto.getType() == null) continue;
                validateRules.add(userRoleDto);
                if (!userRoleDto.getType().equals((Object)RoleType.DOMAIN_RESPONSIBLE) && !userRoleDto.getType().equals((Object)RoleType.GROWING_PLAN_RESPONSIBLE) && !userRoleDto.getType().equals((Object)RoleType.GS_DATA_PROCESSOR) && !userRoleDto.getType().equals((Object)RoleType.NETWORK_RESPONSIBLE) && !userRoleDto.getType().equals((Object)RoleType.NETWORK_SUPERVISOR) || userRoleDto.getEntity() != null && !Strings.isNullOrEmpty((String)userRoleDto.getEntity().getIdentifier())) continue;
                this.addActionError("Les profils ne sont pas complets");
            }
            if (!this.hasErrors()) {
                if (this.hasErrors()) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error((Object)String.format("validate, action %s -> %s", UsersEdit.class.getSimpleName(), this.getActionErrors().toString()));
                        LOGGER.error((Object)String.format("validate, fields errors : '%s' -> %s", UsersEdit.class.getSimpleName(), this.getFieldErrors().toString()));
                    }
                    this.initForInput();
                }
                this.userRoles = validateRules;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)user.getItEmail()) && !this.userService.isValidEmail(user.getItEmail())) {
            this.addActionError("L'adresse email n'est pas reconnue");
        }
    }

    @Action(results={@Result(type="redirectAction", params={"namespace", "/security", "actionName", "users-edit-input", "userTopiaId", "${user.topiaId}"})})
    public String execute() throws Exception {
        this.checkIsAdmin();
        this.user = Strings.isNullOrEmpty((String)this.userTopiaId) ? this.userService.createUser(this.user, this.password) : this.userService.updateUser(this.user, this.password);
        this.authorizationService.saveUserRoles(this.user.getTopiaId(), this.userRoles);
        this.notificationSupport.userSaved(this.user);
        this.refreshAuthenticatedUser();
        return "success";
    }

    public UserDto getUser() {
        if (this.user == null) {
            return new UserDto();
        }
        return this.user;
    }

    public boolean isNewUser() {
        return this.newUser;
    }

    public Map<Boolean, String> getTrueFalse() {
        ImmutableMap result = ImmutableMap.of((Object)Boolean.TRUE, (Object)"Oui", (Object)Boolean.FALSE, (Object)"Non");
        return result;
    }

    public List<UserRoleDto> getUserRoles() {
        return this.userRoles;
    }

    public Map<RoleType, String> getRoleTypes() {
        return this.getEnumAsMap((Object[])RoleType.values());
    }

    public List<Language> getLanguages() {
        return Arrays.asList(Language.values());
    }
}

