/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.reports;

import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.entities.referential.BioAgressorParentType;
import fr.inra.agrosyst.api.entities.referential.RefNuisibleEDI;
import fr.inra.agrosyst.api.entities.referential.Referentials;
import fr.inra.agrosyst.api.entities.report.ArboAdventiceMaster;
import fr.inra.agrosyst.api.entities.report.ArboCropAdventiceMaster;
import fr.inra.agrosyst.api.entities.report.ArboCropPestMaster;
import fr.inra.agrosyst.api.entities.report.CropPestMaster;
import fr.inra.agrosyst.api.entities.report.FoodMaster;
import fr.inra.agrosyst.api.entities.report.IftEstimationMethod;
import fr.inra.agrosyst.api.entities.report.PestMaster;
import fr.inra.agrosyst.api.entities.report.ReportGrowingSystem;
import fr.inra.agrosyst.api.entities.report.ReportGrowingSystemImpl;
import fr.inra.agrosyst.api.entities.report.ReportRegional;
import fr.inra.agrosyst.api.entities.report.VerseMaster;
import fr.inra.agrosyst.api.entities.report.VitiPestMaster;
import fr.inra.agrosyst.api.entities.report.YieldLoss;
import fr.inra.agrosyst.api.entities.report.YieldLossCause;
import fr.inra.agrosyst.api.entities.report.YieldObjective;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.api.services.referential.GroupeCibleDTO;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.api.services.report.ReportFilter;
import fr.inra.agrosyst.api.services.report.ReportGrowingSystemCollections;
import fr.inra.agrosyst.api.services.report.ReportService;
import fr.inra.agrosyst.api.services.users.AuthenticatedUser;
import fr.inra.agrosyst.services.common.CommonService;
import fr.inra.agrosyst.web.actions.reports.AbstractReportAction;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class ReportGrowingSystemEdit
extends AbstractReportAction
implements Preparable {
    private static final Log LOGGER = LogFactory.getLog(ReportGrowingSystemEdit.class);
    private static final long serialVersionUID = -5620592252923620778L;
    protected transient ReportService reportService;
    protected transient ManagementModeService managementModeService;
    protected transient GrowingSystemService growingSystemService;
    protected transient ReferentialService referentialService;
    protected ReportGrowingSystem reportGrowingSystem;
    protected ReportFilter reportFilter;
    protected String domainId;
    protected String growingSystemId;
    protected String reportGrowingSystemId;
    protected String reportRegionalId;
    protected Map<String, String> reportRegionalList;
    protected boolean createManagementMode;
    protected String observeManagementModeId;
    protected LinkedHashMap<Integer, String> relatedReportGrowingSystems;
    protected String iftEstimationMethodName;
    protected IftEstimationMethod iftEstimationMethod;
    protected final ReportGrowingSystemCollections highlights = new ReportGrowingSystemCollections();
    private List<Sector> reportSectors;
    protected List<GroupeCibleDTO> groupesCibles;
    protected String defaultArboAdventiceId;
    protected Set<IftEstimationMethod> iftEstimationMethods;
    protected YieldObjective vitiYieldObjective;
    protected YieldLossCause vitiLossCause1;

    public void prepare() {
        if (StringUtils.isEmpty((CharSequence)this.reportGrowingSystemId)) {
            this.reportGrowingSystem = new ReportGrowingSystemImpl();
            AuthenticatedUser authenticatedUser = this.getAuthenticatedUser();
            this.reportGrowingSystem.setAuthor(authenticatedUser.getFirstName() + " " + authenticatedUser.getLastName());
        } else {
            this.authorizationService.checkReportGrowingSystemReadable(this.reportGrowingSystemId);
            this.reportGrowingSystem = this.reportService.getReportGrowingSystem(this.reportGrowingSystemId);
            this.reportFilter = this.getReportFilterFromReportGrowingSystem(this.reportGrowingSystem);
            this.reportRegionalList = this.reportService.getReportRegionalNameToId(this.reportFilter);
            this.iftEstimationMethods = this.reportService.getIftEstimationMethods(this.reportGrowingSystem);
            this.reportGrowingSystem.getVitiYieldObjective();
            this.reportGrowingSystem.getVitiLossCause1();
        }
    }

    public ReportFilter getReportFilterFromReportGrowingSystem(ReportGrowingSystem reportGrowingSystem) {
        ReportFilter rfilter = new ReportFilter();
        rfilter.setCampaign(Integer.valueOf(reportGrowingSystem.getGrowingSystem().getGrowingPlan().getDomain().getCampaign()));
        rfilter.setGrowingSystemId(reportGrowingSystem.getGrowingSystem().getTopiaId());
        rfilter.setSectors(new HashSet(reportGrowingSystem.getSectors()));
        rfilter.setNavigationContext(this.getNavigationContext());
        return rfilter;
    }

    protected void initForInput() {
        if (StringUtils.isNotEmpty((CharSequence)this.reportGrowingSystemId)) {
            this.relatedReportGrowingSystems = this.reportService.getRelatedReportGrowingSystems(this.reportGrowingSystem.getCode());
        }
        this.groupesCibles = this.referentialService.getGroupesCibles();
        this.defaultArboAdventiceId = this.reportService.getDefaultArboAdventiceIdForReport();
    }

    @Action(value="report-growing-system-edit-input")
    public String input() {
        this.initForInput();
        if (this.reportGrowingSystem.isPersisted()) {
            this.growingSystemId = this.reportGrowingSystem.getGrowingSystem().getTopiaId();
            ReportRegional reportRegional = this.reportGrowingSystem.getReportRegional();
            this.reportRegionalId = reportRegional != null ? reportRegional.getTopiaId() : null;
            this.observeManagementModeId = this.managementModeService.getObservedManagementModeIdForGrowingSystemId(this.growingSystemId).orElse(null);
        }
        if (!StringUtils.isBlank((CharSequence)this.reportGrowingSystemId)) {
            boolean bl = this.readOnly = !this.authorizationService.isReportGrowingSystemWritable(this.reportGrowingSystemId);
            if (this.readOnly) {
                this.notificationSupport.reportGrowingSystemNotWritable();
            }
        }
        return "input";
    }

    protected void validateHighlights() {
        GrowingSystem growingSystem = this.growingSystemService.getGrowingSystem(this.growingSystemId);
        this.reportGrowingSystem.setGrowingSystem(growingSystem);
        List cropIds = this.reportService.getCropIdsForGrowingSystemId(this.growingSystemId);
        this.validateCropAdventice(cropIds);
        this.validateCropPest(cropIds);
        this.validateCropDisease(cropIds);
        this.validateVerse(cropIds);
        this.validateFoodMasters(cropIds);
        this.validateYieldLosses(cropIds, this.vitiYieldObjective, this.vitiLossCause1);
        this.validateArboCropDisease(cropIds);
        this.validateArboCropPest(cropIds);
        this.validateArboCropAdventice(cropIds);
        this.validateVitiDisease();
        this.validateVitiPest();
    }

    private void validateFoodMasters(List<String> cropIds) {
        List allFoodMasters = this.highlights.getFoodMastersBySector().values().stream().filter(Objects::nonNull).flatMap(Collection::stream).toList();
        String actionErrorMessage = "Bilan des pratiques et \u00c9tat sanitaire des cultures (cultures assol\u00e9es), ma\u00eetrise de l\u2019alimentation hydrique et min\u00e9rale: ";
        for (FoodMaster foodMaster : allFoodMasters) {
            this.filterOnValidGrowingSystemCrops(cropIds, foodMaster);
            if (!foodMaster.getCrops().isEmpty()) continue;
            this.addActionError(actionErrorMessage + "Culture non renseign\u00e9e !");
        }
    }

    private void validateYieldLosses(List<String> cropIds, YieldObjective vitiYieldObjective, YieldLossCause vitiLossCause1) {
        String actionErrorMessage = "Bilan des pratiques et \u00c9tat sanitaire des cultures (cultures assol\u00e9es), Rendement et qualit\u00e9: ";
        if (this.reportSectors.contains(Sector.VITICULTURE) && this.isDephyFerme()) {
            boolean causeRequired;
            boolean bl = causeRequired = vitiYieldObjective != null && YieldObjective.MORE_95 != vitiYieldObjective;
            if (causeRequired && vitiLossCause1 == null) {
                this.addActionError(actionErrorMessage + "cause. non renseign\u00e9e !");
            }
        }
        if (this.highlights.getYieldLossesBySector() == null) {
            return;
        }
        Map yieldLossesBySector = this.highlights.getYieldLossesBySector();
        for (Map.Entry yieldLossBysectors : yieldLossesBySector.entrySet()) {
            Sector sector = (Sector)yieldLossBysectors.getKey();
            List yieldLossForSector = (List)yieldLossBysectors.getValue();
            for (YieldLoss yieldLoss : yieldLossForSector) {
                boolean causeRequired;
                this.filterOnValidGrowingSystemCrops(cropIds, yieldLoss);
                if (!Sector.VITICULTURE.equals((Object)sector) && yieldLoss.getCrops().isEmpty()) {
                    this.addActionError(actionErrorMessage + "Culture non renseign\u00e9e !");
                }
                if (this.isNotDephyExpe() && yieldLoss.getYieldObjective() == null) {
                    this.addActionError(actionErrorMessage + "Objectif de rendement. non renseign\u00e9e !");
                }
                if (!(causeRequired = this.isDephyFerme() && yieldLoss.getYieldObjective() != null && yieldLoss.getYieldObjective() != YieldObjective.MORE_95) || yieldLoss.getCause1() != null) continue;
                this.addActionError(actionErrorMessage + "cause. non renseign\u00e9e !");
            }
        }
    }

    private boolean isDephyFerme() {
        GrowingSystem growingSystem = this.growingSystemService.getGrowingSystem(this.growingSystemId);
        return TypeDEPHY.DEPHY_FERME == growingSystem.getGrowingPlan().getType();
    }

    private boolean isNotDephyExpe() {
        GrowingSystem growingSystem = this.growingSystemService.getGrowingSystem(this.growingSystemId);
        return TypeDEPHY.DEPHY_EXPE != growingSystem.getGrowingPlan().getType();
    }

    private void validateCropAdventice(List<String> cropIds) {
        List allCropAdventiceMasters = this.highlights.getCropAdventiceMastersBySector().values().stream().filter(Objects::nonNull).flatMap(Collection::stream).toList();
        String actionErrorMessage = "Bilan des pratiques et \u00c9tat sanitaire des cultures (cultures assol\u00e9es), ma\u00eetrise des adventices: ";
        for (CropPestMaster cropPestMaster : allCropAdventiceMasters) {
            this.filterOnValidGrowingSystemCrops(cropIds, cropPestMaster);
            if (cropPestMaster.getCrops().isEmpty()) {
                this.addActionError(actionErrorMessage + "Culture non renseign\u00e9e !");
            }
            if (cropPestMaster.getPestMasters().isEmpty()) {
                this.addActionError(actionErrorMessage + "Adventice. non renseign\u00e9 !");
                continue;
            }
            if (cropPestMaster.getPestMasters().stream().map(PestMaster::getAgressor).anyMatch(Predicate.isEqual(null))) {
                this.addActionError(actionErrorMessage + "Adventice. non renseign\u00e9 !");
                continue;
            }
            if (this.isNotDephyExpe() && cropPestMaster.getPestMasters().stream().map(PestMaster::getPressureScale).anyMatch(Predicate.isEqual(null))) {
                this.addActionError(actionErrorMessage + "\u00e9chelle de pression. non renseign\u00e9e !");
                continue;
            }
            if (this.isNotDephyExpe() && cropPestMaster.getPestMasters().stream().map(PestMaster::getMasterScale).anyMatch(Predicate.isEqual(null))) {
                this.addActionError(actionErrorMessage + "\u00e9chelle de ma\u00eetrise. non renseign\u00e9e !");
                continue;
            }
            if (!this.isNotDephyExpe() || !cropPestMaster.getPestMasters().stream().map(PestMaster::getQualifier).anyMatch(Predicate.isEqual(null))) continue;
            this.addActionError(actionErrorMessage + "qualification du niveau de ma\u00eetrise. non renseign\u00e9e !");
        }
    }

    private void validateCropPest(List<String> cropIds) {
        List allCropPestMasters = this.highlights.getCropPestMastersBySector().values().stream().filter(Objects::nonNull).flatMap(Collection::stream).toList();
        String actionErrorMessage = "Bilan des pratiques et \u00c9tat sanitaire des cultures (cultures assol\u00e9es), ma\u00eetrise des ravageurs: ";
        for (CropPestMaster cropPestMaster : allCropPestMasters) {
            Collection pestMasters;
            Sector sector = cropPestMaster.getSector();
            boolean sectorUsesIntegerValues = sector == Sector.MARAICHAGE || sector == Sector.HORTICULTURE;
            this.filterOnValidGrowingSystemCrops(cropIds, cropPestMaster);
            if (cropPestMaster.getCrops().isEmpty()) {
                this.addActionError(actionErrorMessage + "Culture non renseign\u00e9e !");
            }
            if ((pestMasters = cropPestMaster.getPestMasters()).isEmpty()) {
                this.addActionError(actionErrorMessage + "Ravageur non renseign\u00e9 !");
                continue;
            }
            if (pestMasters.stream().anyMatch(pestMaster -> pestMaster.getAgressor() == null && pestMaster.getCodeGroupeCibleMaa() == null)) {
                this.addActionError(actionErrorMessage + "Ravageur non renseign\u00e9 !");
                continue;
            }
            if (this.isNotDephyExpe() && sectorUsesIntegerValues && pestMasters.stream().map(PestMaster::getPressureScaleInt).anyMatch(Predicate.isEqual(null)) || !sectorUsesIntegerValues && pestMasters.stream().map(PestMaster::getPressureScale).anyMatch(Predicate.isEqual(null))) {
                this.addActionError(actionErrorMessage + "\u00e9chelle de pression. non renseign\u00e9e !");
                continue;
            }
            if (this.isNotDephyExpe() && sectorUsesIntegerValues && pestMasters.stream().map(PestMaster::getMasterScaleInt).anyMatch(Predicate.isEqual(null)) || !sectorUsesIntegerValues && pestMasters.stream().map(PestMaster::getMasterScale).anyMatch(Predicate.isEqual(null))) {
                this.addActionError(actionErrorMessage + "\u00e9chelle de ma\u00eetrise. non renseign\u00e9e !");
                continue;
            }
            if (!this.isNotDephyExpe() || !pestMasters.stream().map(PestMaster::getQualifier).anyMatch(Predicate.isEqual(null))) continue;
            this.addActionError(actionErrorMessage + "qualification du niveau de ma\u00eetrise. non renseign\u00e9e !");
        }
    }

    private void validateCropDisease(List<String> cropIds) {
        List allCropDiseaseMasters = this.highlights.getCropDiseaseMastersBySector().values().stream().filter(Objects::nonNull).flatMap(Collection::stream).toList();
        String actionErrorMessage = "Bilan des pratiques et \u00c9tat sanitaire des cultures (cultures assol\u00e9es), ma\u00eetrise des maladies: ";
        for (CropPestMaster cropPestMaster : allCropDiseaseMasters) {
            this.filterOnValidGrowingSystemCrops(cropIds, cropPestMaster);
            if (cropPestMaster.getCrops().isEmpty()) {
                this.addActionError(actionErrorMessage + "Culture non renseign\u00e9e !");
            }
            if (cropPestMaster.getPestMasters().isEmpty()) {
                this.addActionError(actionErrorMessage + "Maladie non renseign\u00e9e !");
                continue;
            }
            if (cropPestMaster.getPestMasters().stream().anyMatch(pestMaster -> pestMaster.getAgressor() == null && pestMaster.getCodeGroupeCibleMaa() == null)) {
                this.addActionError(actionErrorMessage + "Maladie non renseign\u00e9e !");
                continue;
            }
            if (this.isNotDephyExpe() && cropPestMaster.getPestMasters().stream().map(PestMaster::getPressureScale).anyMatch(Predicate.isEqual(null))) {
                this.addActionError(actionErrorMessage + "\u00e9chelle de pression. non renseign\u00e9e !");
                continue;
            }
            if (this.isNotDephyExpe() && cropPestMaster.getPestMasters().stream().map(PestMaster::getMasterScale).anyMatch(Predicate.isEqual(null))) {
                this.addActionError(actionErrorMessage + "\u00e9chelle de ma\u00eetrise. non renseign\u00e9e !");
                continue;
            }
            if (!this.isNotDephyExpe() || !cropPestMaster.getPestMasters().stream().map(PestMaster::getQualifier).anyMatch(Predicate.isEqual(null))) continue;
            this.addActionError(actionErrorMessage + "qualification du niveau de ma\u00eetrise. non renseign\u00e9e !");
        }
    }

    private void validateVerse(List<String> cropIds) {
        List allCropPestMasters = this.highlights.getVerseMastersBySector().values().stream().filter(Objects::nonNull).flatMap(Collection::stream).toList();
        String actionErrorMessage = "Bilan des pratiques et \u00c9tat sanitaire des cultures (cultures assol\u00e9es), ma\u00eetrise de la verse: ";
        for (VerseMaster verseMaster : allCropPestMasters) {
            this.filterOnValidGrowingSystemCrops(cropIds, verseMaster);
            if (!verseMaster.getCrops().isEmpty()) continue;
            this.addActionError(actionErrorMessage + "Culture non renseign\u00e9e !");
        }
    }

    private void validateArboCropDisease(List<String> cropIds) {
        if (this.reportGrowingSystem.getSectors() != null && this.reportGrowingSystem.getSectors().contains(Sector.ARBORICULTURE) && (this.reportGrowingSystem.getArboChemicalFungicideIFT() != null || this.reportGrowingSystem.getArboBioControlFungicideIFT() != null || this.reportGrowingSystem.getArboCopperQuantity() != null || this.reportGrowingSystem.getArboDiseaseQualifier() != null || CollectionUtils.isNotEmpty((Collection)this.highlights.getArboCropDiseaseMasters()))) {
            String actionErrorMessage = "Bilan des pratiques et \u00c9tat sanitaire des cultures (Arboriculture), Ma\u00eetrise des maladies et bact\u00e9rioses: ";
            if (this.reportGrowingSystem.getArboDiseaseQualifier() == null) {
                this.addFieldError("reportGrowingSystem.arboDiseaseQualifier", this.getText("common.filedValue.required"));
                this.addActionError(actionErrorMessage + "Niveau global de ma\u00eetrise des maladies non renseign\u00e9e !");
            }
            if (CollectionUtils.isNotEmpty((Collection)this.highlights.getArboCropDiseaseMasters())) {
                for (ArboCropPestMaster arboCropPestMaster : this.highlights.getArboCropDiseaseMasters()) {
                    this.filterOnValidGrowingSystemCrops(cropIds, arboCropPestMaster);
                    if (!arboCropPestMaster.getCrops().isEmpty()) continue;
                    this.addActionError(actionErrorMessage + "Culture non renseign\u00e9e !");
                }
            }
        }
    }

    private void validateArboCropPest(List<String> cropIds) {
        if (this.reportGrowingSystem.getSectors() != null && this.reportGrowingSystem.getSectors().contains(Sector.ARBORICULTURE) && (this.reportGrowingSystem.getArboChemicalPestIFT() != null || this.reportGrowingSystem.getArboBioControlPestIFT() != null || this.reportGrowingSystem.getArboPestQualifier() != null || CollectionUtils.isNotEmpty((Collection)this.highlights.getArboCropPestMasters()))) {
            String actionErrorMessage = "Bilan des pratiques et \u00c9tat sanitaire des cultures (Arboriculture), ma\u00eetrise des ravageurs: ";
            if (this.reportGrowingSystem.getArboPestQualifier() == null) {
                this.addFieldError("reportGrowingSystem.arboPestQualifier", this.getText("common.filedValue.required"));
                this.addActionError(actionErrorMessage + "Niveau global de ma\u00eetrise des ravageurs non renseign\u00e9e !");
            }
            if (CollectionUtils.isNotEmpty((Collection)this.highlights.getArboCropPestMasters())) {
                for (ArboCropPestMaster arboCropPestMaster : this.highlights.getArboCropPestMasters()) {
                    this.filterOnValidGrowingSystemCrops(cropIds, arboCropPestMaster);
                    if (!arboCropPestMaster.getCrops().isEmpty()) continue;
                    this.addActionError(actionErrorMessage + "Culture non renseign\u00e9e !");
                }
            }
        }
    }

    private void validateArboCropAdventice(List<String> cropIds) {
        if (CollectionUtils.isNotEmpty((Collection)this.highlights.getArboCropAdventiceMasters())) {
            String actionErrorMessage = "Bilan des pratiques et \u00c9tat sanitaire des cultures (Arboriculture), ma\u00eetrise des adventices: ";
            for (ArboCropAdventiceMaster arboCropAdventiceMaster : this.highlights.getArboCropAdventiceMasters()) {
                this.filterOnValidGrowingSystemCrops(cropIds, arboCropAdventiceMaster);
                if (arboCropAdventiceMaster.getCrops().isEmpty()) {
                    this.addActionError(actionErrorMessage + "Culture non renseign\u00e9e !");
                }
                if (!this.isNotDephyExpe()) continue;
                if (arboCropAdventiceMaster.getPestMasters().stream().map(ArboAdventiceMaster::getAgressor).anyMatch(Predicate.isEqual(null))) {
                    this.addActionError(actionErrorMessage + "Adventice non renseign\u00e9e !");
                    continue;
                }
                if (arboCropAdventiceMaster.getPestMasters().stream().map(ArboAdventiceMaster::getMasterScale).anyMatch(Predicate.isEqual(null))) {
                    this.addActionError(actionErrorMessage + "\u00e9chelle de ma\u00eetrise non renseign\u00e9e !");
                    continue;
                }
                if (!arboCropAdventiceMaster.getPestMasters().stream().map(ArboAdventiceMaster::getQualifier).anyMatch(Predicate.isEqual(null))) continue;
                this.addActionError(actionErrorMessage + "qualification du niveau de ma\u00eetrise non renseign\u00e9e !");
            }
        }
    }

    private void validateVitiDisease() {
        if (CollectionUtils.isNotEmpty((Collection)this.highlights.getVitiDiseaseMasters())) {
            String actionErrorMessage = "Bilan des pratiques et \u00c9tat sanitaire des cultures (Viticulture), ma\u00eetrise des maladies: ";
            ArrayList<CallSite> diseaseMastersErrorMessages = new ArrayList<CallSite>();
            for (VitiPestMaster vitiPestMaster : this.highlights.getVitiDiseaseMasters()) {
                if (vitiPestMaster.getTreatmentCount() == null) {
                    diseaseMastersErrorMessages.add((CallSite)((Object)(actionErrorMessage + " " + vitiPestMaster.getAgressor().getLabel() + ", Nombre de traitements non renseign\u00e9e !")));
                }
                if (vitiPestMaster.getBioControlFungicideIFT() == null) {
                    diseaseMastersErrorMessages.add((CallSite)((Object)(actionErrorMessage + " " + vitiPestMaster.getAgressor().getLabel() + ", IFT-Fongicide biocontr\u00f4le non renseign\u00e9e !")));
                }
                if (vitiPestMaster.getChemicalFungicideIFT() != null) continue;
                diseaseMastersErrorMessages.add((CallSite)((Object)(actionErrorMessage + " " + vitiPestMaster.getAgressor().getLabel() + ", IFT-Fongicide (chimique) non renseign\u00e9e !")));
            }
            if (this.reportGrowingSystem.getVitiDiseaseChemicalFungicideIFT() == null) {
                this.addFieldError("reportGrowingSystem.vitiDiseaseChemicalFungicideIFT", this.getText("common.filedValue.required"));
                diseaseMastersErrorMessages.add((CallSite)((Object)(actionErrorMessage + "IFT-fongicide du syst\u00e8me de culture (chimique) non renseign\u00e9e !")));
            }
            if (this.reportGrowingSystem.getVitiDiseaseBioControlFungicideIFT() == null) {
                this.addFieldError("reportGrowingSystem.vitiDiseaseBioControlFungicideIFT", this.getText("common.filedValue.required"));
                diseaseMastersErrorMessages.add((CallSite)((Object)(actionErrorMessage + "IFT-fongicide biocontr\u00f4le du syst\u00e8me de culture non renseign\u00e9e !")));
            }
            if (this.reportGrowingSystem.getVitiDiseaseCopperQuantity() == null) {
                this.addFieldError("reportGrowingSystem.vitiDiseaseCopperQuantity", this.getText("common.filedValue.required"));
                diseaseMastersErrorMessages.add((CallSite)((Object)(actionErrorMessage + "Quantit\u00e9 de cuivre appliqu\u00e9e (Kg Cu/ha) non renseign\u00e9e !")));
            }
            if (this.reportGrowingSystem.getVitiDiseaseQualifier() == null) {
                this.addFieldError("reportGrowingSystem.vitiDiseaseQualifier", this.getText("common.filedValue.required"));
                diseaseMastersErrorMessages.add((CallSite)((Object)(actionErrorMessage + "Niveau global de ma\u00eetrise des maladies non renseign\u00e9e !")));
            }
            for (String string : diseaseMastersErrorMessages) {
                this.addActionError(string);
            }
            Set pestIds = this.highlights.getVitiDiseaseMasters().stream().map(VitiPestMaster::getAgressor).filter(Objects::nonNull).map(RefNuisibleEDI.class::cast).map(RefNuisibleEDI::getReference_id).collect(Collectors.toSet());
            if (!pestIds.containsAll(Arrays.asList(19089, 19224, 19725, 18536))) {
                this.addActionError(actionErrorMessage + "Les maladies 'Mildiou', 'O\u00efdium', 'Virose Black Rot' et 'Botrytis - Pourriture Grise' sont obligatoires");
            }
        }
    }

    private void validateVitiPest() {
        if (CollectionUtils.isNotEmpty((Collection)this.highlights.getVitiPestMasters())) {
            String actionErrorMessage = "Bilan des pratiques et \u00c9tat sanitaire des cultures (Viticulture), ma\u00eetrise des ravageurs: ";
            ArrayList<CallSite> pestMastersErrorMessages = new ArrayList<CallSite>();
            List vitiPestMasters = this.highlights.getVitiPestMasters();
            for (VitiPestMaster vitiPestMaster : vitiPestMasters) {
                if (vitiPestMaster.getTreatmentCount() == null) {
                    pestMastersErrorMessages.add((CallSite)((Object)(actionErrorMessage + " " + vitiPestMaster.getAgressor().getLabel() + ", Nombre de traitements non renseign\u00e9e !")));
                }
                if (vitiPestMaster.getBioControlFungicideIFT() == null) {
                    pestMastersErrorMessages.add((CallSite)((Object)(actionErrorMessage + " " + vitiPestMaster.getAgressor().getLabel() + ", IFT-ravageurs biocontr\u00f4le non renseign\u00e9e !")));
                }
                if (vitiPestMaster.getChemicalFungicideIFT() == null) {
                    pestMastersErrorMessages.add((CallSite)((Object)(actionErrorMessage + " " + vitiPestMaster.getAgressor().getLabel() + ", IFT-ravageurs (chimique) non renseign\u00e9e !")));
                }
                if (!this.isNotDephyExpe()) continue;
                if (vitiPestMaster.getPressureScale() == null) {
                    pestMastersErrorMessages.add((CallSite)((Object)(actionErrorMessage + " " + vitiPestMaster.getAgressor().getLabel() + ", \u00e9chelle de pression non renseign\u00e9e !")));
                }
                if (vitiPestMaster.getMasterScale() == null) {
                    pestMastersErrorMessages.add((CallSite)((Object)(actionErrorMessage + " " + vitiPestMaster.getAgressor().getLabel() + ", \u00e9chelle de ma\u00eetrise non renseign\u00e9e !")));
                }
                if (vitiPestMaster.getQualifier() != null) continue;
                pestMastersErrorMessages.add((CallSite)((Object)(actionErrorMessage + " " + vitiPestMaster.getAgressor().getLabel() + ", qualification du niveau de ma\u00eetrise non renseign\u00e9e !")));
            }
            for (String string : pestMastersErrorMessages) {
                this.addActionError(string);
            }
            if (this.reportGrowingSystem.getVitiPestChemicalPestIFT() == null) {
                this.addFieldError("reportGrowingSystem.vitiPestChemicalPestIFT", this.getText("common.filedValue.required"));
                this.addActionError(actionErrorMessage + "IFT-ravageurs du syst\u00e8me de culture (chimique)  non renseign\u00e9e !");
            }
            if (this.reportGrowingSystem.getVitiPestBioControlPestIFT() == null) {
                this.addFieldError("reportGrowingSystem.vitiPestBioControlPestIFT", this.getText("common.filedValue.required"));
                this.addActionError(actionErrorMessage + "IFT-ravageurs biocontr\u00f4le du syst\u00e8me de culture non renseign\u00e9e !");
            }
            if (this.reportGrowingSystem.getVitiPestQualifier() == null) {
                this.addFieldError("reportGrowingSystem.vitiPestQualifier", this.getText("common.filedValue.required"));
                this.addActionError(actionErrorMessage + "Niveau global de ma\u00eetrise des ravageurs non renseign\u00e9e !");
            }
            Set pestIds = this.highlights.getVitiPestMasters().stream().map(VitiPestMaster::getAgressor).filter(Objects::nonNull).map(RefNuisibleEDI.class::cast).map(RefNuisibleEDI::getReference_id).collect(Collectors.toSet());
            if (!pestIds.containsAll(Arrays.asList(18721, 18722, 999996))) {
                this.addActionError(actionErrorMessage + "Les ravageurs 'Cicadelle de la flavescence dor\u00e9e', 'Cicadelle des grillures' et 'Tordeuse(s) de la grappe' sont obligatoires");
            }
        }
    }

    public void validate() {
        if (this.hasFieldErrors()) {
            for (List errors : this.getFieldErrors().values()) {
                for (String error : errors) {
                    this.addActionError(error);
                }
            }
        }
        if (!this.reportGrowingSystem.isPersisted() && this.reportFilter != null) {
            if (this.reportFilter.getCampaign() == null) {
                this.addActionError("Aucune campagne de renseign\u00e9e !");
                this.addFieldError("campaign", this.getText("common.filedValue.required"));
            }
            if (this.reportFilter.getCampaign() != null && !CommonService.getInstance().isCampaignValid(this.reportFilter.getCampaign())) {
                this.addActionError("campaign '" + this.reportFilter.getCampaign() + "' non valide !");
                this.addFieldError("campaign", this.getText("common.filedValue.required"));
            }
            if (StringUtils.isBlank((CharSequence)this.growingSystemId)) {
                this.addActionError("Aucun syst\u00e8me de culture s\u00e9lectionn\u00e9 !");
                this.addFieldError("selectGrowingSystemError", this.getText("common.filedValue.required"));
            }
        }
        if (!StringUtils.isBlank((CharSequence)this.growingSystemId)) {
            GrowingSystem growingSystem = this.growingSystemService.getGrowingSystem(this.growingSystemId);
            if (StringUtils.isBlank((CharSequence)this.reportRegionalId) && growingSystem != null && TypeDEPHY.DEPHY_EXPE != growingSystem.getGrowingPlan().getType()) {
                this.addActionError("Aucun bilan de campagne r\u00e9gional s\u00e9lectionn\u00e9");
                this.addFieldError("selectReportRegionalError", this.getText("common.filedValue.required"));
            }
        }
        if (CollectionUtils.isEmpty((Collection)this.reportSectors)) {
            this.addActionError("Aucune fili\u00e8re s\u00e9lectionn\u00e9e !");
            this.addFieldError("sectorsError", this.getText("common.filedValue.required"));
        } else {
            this.reportGrowingSystem.setSectors((Collection)this.reportSectors);
        }
        if (StringUtils.isBlank((CharSequence)this.reportGrowingSystem.getAuthor())) {
            this.addActionError("Aucun r\u00e9dacteur pour ce bilan de campagne !");
            this.addFieldError("authorError", this.getText("common.filedValue.required"));
        }
        this.validateHighlights();
        this.reportGrowingSystem.setVitiYieldObjective(this.vitiYieldObjective);
        this.reportGrowingSystem.setVitiLossCause1(this.vitiLossCause1);
        if (LOGGER.isErrorEnabled()) {
            String pre;
            String string = pre = this.reportGrowingSystem.isPersisted() ? "For reportGrowingSystem with Id '" + this.reportGrowingSystem.getTopiaId() + "'" : "";
            if (this.hasFieldErrors()) {
                LOGGER.error((Object)("For user email:" + this.getAuthenticatedUser().getEmail() + ": " + pre + this.getFieldErrors().toString()));
            }
            if (this.hasActionErrors()) {
                LOGGER.error((Object)("For user email:" + this.getAuthenticatedUser().getEmail() + ": " + pre + this.getActionErrors().toString()));
            }
        }
        if (this.hasErrors()) {
            this.initForInput();
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "report-growing-system-edit-input", "reportGrowingSystemId", "${reportGrowingSystemId}"})})
    public String execute() throws Exception {
        this.reportGrowingSystem = this.reportService.createOrUpdateReportGrowingSystem(this.reportGrowingSystem, this.growingSystemId, this.reportRegionalId, this.highlights, this.createManagementMode);
        this.reportGrowingSystemId = this.reportGrowingSystem.getTopiaId();
        this.notificationSupport.reportGrowingSystemSaved(this.reportGrowingSystem);
        return "success";
    }

    public ReportGrowingSystem getReportGrowingSystem() {
        if (this.reportGrowingSystem == null) {
            this.reportGrowingSystem = new ReportGrowingSystemImpl();
        }
        return this.reportGrowingSystem;
    }

    private void filterOnValidGrowingSystemCrops(List<String> cropIds, FoodMaster foodMaster) {
        Collection crops = foodMaster.getCrops();
        Collection crops0 = crops.stream().filter(crop -> cropIds.contains(crop.getTopiaId())).collect(Collectors.toList());
        foodMaster.setCrops(crops0);
    }

    private void filterOnValidGrowingSystemCrops(List<String> cropIds, YieldLoss yieldLoss) {
        Collection crops = yieldLoss.getCrops();
        Collection crops0 = crops.stream().filter(crop -> cropIds.contains(crop.getTopiaId())).collect(Collectors.toList());
        yieldLoss.setCrops(crops0);
    }

    private void filterOnValidGrowingSystemCrops(List<String> cropIds, CropPestMaster cropPestMaster) {
        Collection crops = cropPestMaster.getCrops();
        Collection crops0 = crops.stream().filter(crop -> cropIds.contains(crop.getTopiaId())).collect(Collectors.toList());
        cropPestMaster.setCrops(crops0);
    }

    private void filterOnValidGrowingSystemCrops(List<String> cropIds, ArboCropPestMaster arboCropPestMaster) {
        Collection crops = arboCropPestMaster.getCrops();
        Collection crops0 = crops.stream().filter(crop -> cropIds.contains(crop.getTopiaId())).collect(Collectors.toList());
        arboCropPestMaster.setCrops(crops0);
    }

    private void filterOnValidGrowingSystemCrops(List<String> cropIds, ArboCropAdventiceMaster arboCropPestMaster) {
        Collection crops = arboCropPestMaster.getCrops();
        Collection crops0 = crops.stream().filter(crop -> cropIds.contains(crop.getTopiaId())).collect(Collectors.toList());
        arboCropPestMaster.setCrops(crops0);
    }

    private void filterOnValidGrowingSystemCrops(List<String> cropIds, VerseMaster verseMaster) {
        Collection crops = verseMaster.getCrops();
        Collection crops0 = crops.stream().filter(crop -> cropIds.contains(crop.getTopiaId())).collect(Collectors.toList());
        verseMaster.setCrops(crops0);
    }

    public void setReportFilter(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.reportFilter = (ReportFilter)this.getGson().fromJson(json, type);
    }

    public Map<IftEstimationMethod, String> getAllIftEstimationMethods() {
        return this.getEnumAsMap((Object[])IftEstimationMethod.values());
    }

    public void setIftEstimationMethod(String iftEstimationMethodName) {
        if (StringUtils.isNotBlank((CharSequence)iftEstimationMethodName)) {
            IftEstimationMethod iftEstimationMethod = IftEstimationMethod.valueOf((String)iftEstimationMethodName);
            this.reportGrowingSystem.setIftEstimationMethod(iftEstimationMethod);
        }
    }

    public void setCreateManagementMode(boolean createManagementMode) {
        this.createManagementMode = createManagementMode;
    }

    public void setReportSectors(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.reportSectors = (List)this.getGson().fromJson(json, type);
    }

    public void setCropAdventiceMastersJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List cropMasterBySectorList = (List)this.getGson().fromJson("[" + json + "]", type);
        this.setCropMastersJson(cropMasterBySectorList, (arg_0, arg_1) -> ((ReportGrowingSystemCollections)this.highlights).addDephyExpeCropAdventiceMasters(arg_0, arg_1), arg_0 -> ((ReportGrowingSystemCollections)this.highlights).addNoneDephyExpeCropAdventiceMasters(arg_0));
    }

    public void setCropDiseaseMastersJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List cropMasterBySectorList = (List)this.getGson().fromJson("[" + json + "]", type);
        this.setCropMastersJson(cropMasterBySectorList, (arg_0, arg_1) -> ((ReportGrowingSystemCollections)this.highlights).addDephyExpeCropDiseaseMasters(arg_0, arg_1), arg_0 -> ((ReportGrowingSystemCollections)this.highlights).addNoneDephyExpeCropDiseaseMasters(arg_0));
    }

    public void setCropPestMastersJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List cropMasterBySectorList = (List)this.getGson().fromJson("[" + json + "]", type);
        this.setCropMastersJson(cropMasterBySectorList, (arg_0, arg_1) -> ((ReportGrowingSystemCollections)this.highlights).addDephyExpeCropPestMasters(arg_0, arg_1), arg_0 -> ((ReportGrowingSystemCollections)this.highlights).addNoneDephyExpeCropPestMasters(arg_0));
    }

    public void setVerseMastersJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List cropMasterBySectorList = (List)this.getGson().fromJson("[" + json + "]", type);
        this.setCropMastersJson(cropMasterBySectorList, (arg_0, arg_1) -> ((ReportGrowingSystemCollections)this.highlights).addDephyExpeVerseMasters(arg_0, arg_1), arg_0 -> ((ReportGrowingSystemCollections)this.highlights).addNoneDephyExpeVerseMasters(arg_0));
    }

    public void setFoodMastersJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List cropMasterBySectorList = (List)this.getGson().fromJson("[" + json + "]", type);
        this.setCropMastersJson(cropMasterBySectorList, (arg_0, arg_1) -> ((ReportGrowingSystemCollections)this.highlights).addDephyExpeFoodMasters(arg_0, arg_1), arg_0 -> ((ReportGrowingSystemCollections)this.highlights).addNoneDephyExpeFoodMasters(arg_0));
    }

    public void setYieldLossesJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List cropMasterBySectorList = (List)this.getGson().fromJson("[" + json + "]", type);
        this.setCropMastersJson(cropMasterBySectorList, (arg_0, arg_1) -> ((ReportGrowingSystemCollections)this.highlights).addDephyExpeYieldLosses(arg_0, arg_1), arg_0 -> ((ReportGrowingSystemCollections)this.highlights).addNoneDephyExpeYieldLosses(arg_0));
    }

    protected <T> void setCropMastersJson(List<Map<Sector, List<T>>> cropMasterBySectorList, BiConsumer<Sector, List<T>> addDephyExpeCropMasters, Consumer<List<T>> addNonDephyExpeCropMasters) {
        if (cropMasterBySectorList != null) {
            for (Map<Sector, List<T>> cropMasterBySector : cropMasterBySectorList) {
                for (Map.Entry<Sector, List<T>> sectorArrayListEntry : cropMasterBySector.entrySet()) {
                    Sector sector = sectorArrayListEntry.getKey();
                    List<T> cropMasters = sectorArrayListEntry.getValue();
                    if (sector != null) {
                        addDephyExpeCropMasters.accept(sector, cropMasters);
                        continue;
                    }
                    addNonDephyExpeCropMasters.accept(cropMasters);
                }
            }
        }
    }

    public void setArboCropDiseaseMastersJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List arboCropPestMasters = (List)this.getGson().fromJson(json, type);
        this.highlights.setArboDiseaseMasters(arboCropPestMasters);
    }

    public void setArboCropPestMastersJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List arboCropPestMasters = (List)this.getGson().fromJson(json, type);
        this.highlights.setArboPestMasters(arboCropPestMasters);
    }

    public void setArboCropAdventiceMastersJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List arboCropAdventiceMasters = (List)this.getGson().fromJson(json, type);
        this.highlights.setArboAdventiceMasters(arboCropAdventiceMasters);
    }

    public void setArboFoodMastersJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List foodMasters = (List)this.getGson().fromJson(json, type);
        if (foodMasters != null) {
            foodMasters.forEach(foodMaster -> foodMaster.setSector(Sector.ARBORICULTURE));
            this.highlights.addArboFoodMasters(foodMasters);
        }
    }

    public void setArboYieldLossesJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List arboYieldLosses = (List)this.getGson().fromJson(json, type);
        if (arboYieldLosses != null) {
            arboYieldLosses.forEach(yieldLoss -> yieldLoss.setSector(Sector.ARBORICULTURE));
            this.highlights.addArboYieldLosses(arboYieldLosses);
        }
    }

    public void setVitiDiseaseMastersJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List vitiPestMasters = (List)this.getGson().fromJson(json, type);
        this.highlights.setVitiDiseaseMasters(vitiPestMasters);
    }

    public void setVitiPestMastersJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List vitiPestMasters = (List)this.getGson().fromJson(json, type);
        this.highlights.setVitiPestMasters(vitiPestMasters);
    }

    public void setVitiFoodMastersJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List foodMasters = (List)this.getGson().fromJson(json, type);
        if (foodMasters != null) {
            foodMasters.forEach(foodMaster -> foodMaster.setSector(Sector.VITICULTURE));
            this.highlights.addVitiFoodMasters(foodMasters);
        }
    }

    public void setYieldInfosJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List yieldInfos = (List)this.getGson().fromJson("[" + json + "]", type);
        this.highlights.setYieldInfos((Collection)yieldInfos);
    }

    public Map<BioAgressorType, BioAgressorParentType> getTreatmentTargetCategoriesByParent() {
        return Referentials.getTreatmentTargetBioAgressorParentTypes().stream().collect(Collectors.toMap(BioAgressorParentType::getParent, Function.identity()));
    }

    @Generated
    public ReportService getReportService() {
        return this.reportService;
    }

    @Generated
    public ManagementModeService getManagementModeService() {
        return this.managementModeService;
    }

    @Generated
    public GrowingSystemService getGrowingSystemService() {
        return this.growingSystemService;
    }

    @Generated
    public ReferentialService getReferentialService() {
        return this.referentialService;
    }

    @Generated
    public ReportFilter getReportFilter() {
        return this.reportFilter;
    }

    @Generated
    public String getDomainId() {
        return this.domainId;
    }

    @Generated
    public String getGrowingSystemId() {
        return this.growingSystemId;
    }

    @Generated
    public String getReportGrowingSystemId() {
        return this.reportGrowingSystemId;
    }

    @Generated
    public String getReportRegionalId() {
        return this.reportRegionalId;
    }

    @Generated
    public Map<String, String> getReportRegionalList() {
        return this.reportRegionalList;
    }

    @Generated
    public boolean isCreateManagementMode() {
        return this.createManagementMode;
    }

    @Generated
    public String getObserveManagementModeId() {
        return this.observeManagementModeId;
    }

    @Generated
    public LinkedHashMap<Integer, String> getRelatedReportGrowingSystems() {
        return this.relatedReportGrowingSystems;
    }

    @Generated
    public String getIftEstimationMethodName() {
        return this.iftEstimationMethodName;
    }

    @Generated
    public IftEstimationMethod getIftEstimationMethod() {
        return this.iftEstimationMethod;
    }

    @Generated
    public ReportGrowingSystemCollections getHighlights() {
        return this.highlights;
    }

    @Generated
    public List<Sector> getReportSectors() {
        return this.reportSectors;
    }

    @Generated
    public List<GroupeCibleDTO> getGroupesCibles() {
        return this.groupesCibles;
    }

    @Generated
    public String getDefaultArboAdventiceId() {
        return this.defaultArboAdventiceId;
    }

    @Generated
    public Set<IftEstimationMethod> getIftEstimationMethods() {
        return this.iftEstimationMethods;
    }

    @Generated
    public YieldObjective getVitiYieldObjective() {
        return this.vitiYieldObjective;
    }

    @Generated
    public YieldLossCause getVitiLossCause1() {
        return this.vitiLossCause1;
    }

    @Generated
    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Generated
    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    @Generated
    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    @Generated
    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    @Generated
    public void setReportGrowingSystem(ReportGrowingSystem reportGrowingSystem) {
        this.reportGrowingSystem = reportGrowingSystem;
    }

    @Generated
    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    @Generated
    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

    @Generated
    public void setReportGrowingSystemId(String reportGrowingSystemId) {
        this.reportGrowingSystemId = reportGrowingSystemId;
    }

    @Generated
    public void setReportRegionalId(String reportRegionalId) {
        this.reportRegionalId = reportRegionalId;
    }

    @Generated
    public void setReportRegionalList(Map<String, String> reportRegionalList) {
        this.reportRegionalList = reportRegionalList;
    }

    @Generated
    public void setObserveManagementModeId(String observeManagementModeId) {
        this.observeManagementModeId = observeManagementModeId;
    }

    @Generated
    public void setRelatedReportGrowingSystems(LinkedHashMap<Integer, String> relatedReportGrowingSystems) {
        this.relatedReportGrowingSystems = relatedReportGrowingSystems;
    }

    @Generated
    public void setIftEstimationMethodName(String iftEstimationMethodName) {
        this.iftEstimationMethodName = iftEstimationMethodName;
    }

    @Generated
    public void setGroupesCibles(List<GroupeCibleDTO> groupesCibles) {
        this.groupesCibles = groupesCibles;
    }

    @Generated
    public void setDefaultArboAdventiceId(String defaultArboAdventiceId) {
        this.defaultArboAdventiceId = defaultArboAdventiceId;
    }

    @Generated
    public void setIftEstimationMethods(Set<IftEstimationMethod> iftEstimationMethods) {
        this.iftEstimationMethods = iftEstimationMethods;
    }

    @Generated
    public void setVitiYieldObjective(YieldObjective vitiYieldObjective) {
        this.vitiYieldObjective = vitiYieldObjective;
    }

    @Generated
    public void setVitiLossCause1(YieldLossCause vitiLossCause1) {
        this.vitiLossCause1 = vitiLossCause1;
    }
}

