/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.practiced;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.BufferStrip;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.FrostProtectionType;
import fr.inra.agrosyst.api.entities.HosesPositionning;
import fr.inra.agrosyst.api.entities.IrrigationSystemType;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.PompEngineType;
import fr.inra.agrosyst.api.entities.SolWaterPh;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.ZoneType;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlotImpl;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinage;
import fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDI;
import fr.inra.agrosyst.api.entities.referential.RefSolCaracteristiqueIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppa;
import fr.inra.agrosyst.api.services.plot.Plots;
import fr.inra.agrosyst.api.services.plot.SolHorizonDto;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotService;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class PracticedPlotsEdit
extends AbstractAgrosystAction
implements Preparable {
    private static final long serialVersionUID = -1618279547328450777L;
    private static final Log LOGGER = LogFactory.getLog(PracticedPlotsEdit.class);
    protected transient PracticedPlotService practicedPlotService;
    protected transient PracticedSystemService practicedSystemService;
    protected transient ReferentialService referentialService;
    protected String practicedPlotTopiaId;
    protected PracticedPlot practicedPlot;
    protected String practicedSystemTopiaId;
    protected PracticedSystem practicedSystem;
    protected List<PracticedSystem> practicedSystems;
    protected String locationTopiaId;
    protected List<RefParcelleZonageEDI> parcelleZonages;
    protected List<String> selectedPlotZoningIds;
    protected List<RefSolTextureGeppa> solTextures;
    protected String selectedSurfaceTextureId;
    protected String selectedSubSoilTextureId;
    protected List<RefSolProfondeurIndigo> solProfondeurs;
    protected String selectedSolProfondeurId;
    protected List<SolHorizonDto> solHorizons;
    protected String solHorizonsJson;
    protected List<RefSolCaracteristiqueIndigo> solCaracteristiques;
    protected List<RefElementVoisinage> adjacentElements;
    protected List<String> adjacentElementIds;

    public void setPracticedPlotService(PracticedPlotService practicedPlotService) {
        this.practicedPlotService = practicedPlotService;
    }

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void prepare() {
        this.practicedPlot = this.practicedPlotService.getPracticedPlot(this.practicedPlotTopiaId);
        if (this.practicedPlot.isPersisted()) {
            this.authorizationService.checkPracticedPlotReadable(this.practicedPlotTopiaId);
            this.activated = this.practicedSystemService.areActivated(this.practicedPlot.getPracticedSystem());
            boolean bl = this.readOnly = !this.authorizationService.isPracticedPlotWritable(this.practicedPlotTopiaId);
            if (this.readOnly) {
                this.notificationSupport.practicedPlotNotWritable();
            }
        }
    }

    @Action(value="practiced-plots-edit-input")
    public String input() throws Exception {
        this.initForInput();
        if (this.practicedPlot.getLocation() != null) {
            this.locationTopiaId = this.practicedPlot.getLocation().getTopiaId();
        }
        if (this.practicedPlot.getPlotZonings() != null) {
            this.selectedPlotZoningIds = this.practicedPlot.getPlotZonings().stream().map(Entities.GET_TOPIA_ID).collect(Collectors.toList());
        }
        if (this.practicedPlot.getSurfaceTexture() != null) {
            this.selectedSurfaceTextureId = this.practicedPlot.getSurfaceTexture().getTopiaId();
        }
        if (this.practicedPlot.getSubSoilTexture() != null) {
            this.selectedSubSoilTextureId = this.practicedPlot.getSubSoilTexture().getTopiaId();
        }
        if (this.practicedPlot.getSolDepth() != null) {
            this.selectedSolProfondeurId = this.practicedPlot.getSolDepth().getTopiaId();
        }
        this.solHorizons = this.practicedPlot.getSolHorizon() != null ? Lists.newArrayList((Iterable)Collections2.transform((Collection)this.practicedPlot.getSolHorizon(), Plots.SOL_HORIZON_TO_DTO::apply)) : new ArrayList();
        this.adjacentElementIds = this.practicedPlot.getAdjacentElements() != null ? this.practicedPlot.getAdjacentElements().stream().map(Entities.GET_TOPIA_ID).collect(Collectors.toList()) : new ArrayList();
        return "input";
    }

    protected void initForInput() {
        if (!this.practicedPlot.isPersisted()) {
            this.practicedSystems = this.practicedPlotService.getPracticedSystemsWithoutPracticedPlot(this.getNavigationContext());
        } else {
            this.practicedSystem = (PracticedSystem)IterableUtils.first((Iterable)this.practicedPlot.getPracticedSystem());
        }
        this.parcelleZonages = this.referentialService.getAllActiveParcelleZonage();
        this.solTextures = this.referentialService.getAllActiveSolTextures();
        this.solProfondeurs = this.referentialService.getAllActiveSolProfondeurs();
        this.solCaracteristiques = this.referentialService.getAllActiveSolCaracteristiques();
        this.adjacentElements = this.referentialService.getAllActiveElementVoisinages();
    }

    public void validate() {
        if (!this.practicedPlot.isPersisted() && StringUtils.isBlank((CharSequence)this.practicedSystemTopiaId)) {
            this.addActionError("Aucun syst\u00e8me synth\u00e9tis\u00e9 n'est s\u00e9lectionn\u00e9 !");
        }
        if (this.practicedPlot.isPersisted() && !this.practicedSystemService.areActivated(this.practicedPlot.getPracticedSystem())) {
            this.addActionError("Le syst\u00e8me synth\u00e9tis\u00e9 est d\u00e9sactiv\u00e9 !");
        }
        if (StringUtils.isBlank((CharSequence)this.practicedPlot.getName())) {
            this.addFieldError("plot.name", this.getText("common.filedValue.required"));
            this.addActionError("Le nom de parcelle est non renseign\u00e9 !");
        }
        try {
            this.convertSolHorizons(this.solHorizonsJson);
        }
        catch (Exception ex) {
            this.addActionError("Exception:" + String.valueOf(ex) + "\n/!\\ D\u00e9sol\u00e9 les donn\u00e9es saisies depuis votre dernier enregistrement concernant les horizons de sol n'ont pu \u00eatre r\u00e9cup\u00e9r\u00e9es !");
            if (this.practicedPlot.getSolHorizon() != null) {
                this.solHorizons = Lists.newArrayList((Iterable)Collections2.transform((Collection)this.practicedPlot.getSolHorizon(), Plots.SOL_HORIZON_TO_DTO::apply));
            }
            this.solHorizons = new ArrayList();
        }
        if (this.hasErrors()) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, action errors : practicedSystemTopiaId:'%s' -> %s", this.practicedSystemTopiaId, this.getActionErrors().toString()));
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, fields errors : practicedSystemTopiaId:'%s' -> %s", this.practicedSystemTopiaId, this.getFieldErrors().toString()));
            }
            this.initForInput();
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "practiced-plots-edit-input", "practicedPlotTopiaId", "${practicedPlot.topiaId}"})})
    public String execute() throws Exception {
        this.practicedPlot = this.practicedPlotService.createOrUpdatePracticedPlot(this.practicedPlot, this.practicedSystemTopiaId, this.locationTopiaId, this.selectedSurfaceTextureId, this.selectedSubSoilTextureId, this.selectedSolProfondeurId, this.selectedPlotZoningIds, this.solHorizons, this.adjacentElementIds);
        this.notificationSupport.practicedPlotSaved(this.practicedPlot);
        return "success";
    }

    public PracticedPlot getPracticedPlot() {
        return Objects.requireNonNullElseGet(this.practicedPlot, PracticedPlotImpl::new);
    }

    public void convertSolHorizons(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.solHorizons = (List)this.getGson().fromJson(json, type);
    }

    public Map<MaxSlope, String> getMaxSlopes() {
        return this.getEnumAsMap((Object[])MaxSlope.values());
    }

    public Map<BufferStrip, String> getBufferStrips() {
        return this.getEnumAsMap((Object[])BufferStrip.values());
    }

    public Map<WaterFlowDistance, String> getWaterFlowDistances() {
        return this.getEnumAsMap((Object[])WaterFlowDistance.values());
    }

    public String getPracticedPlotTopiaId() {
        return this.practicedPlotTopiaId;
    }

    public void setPracticedPlotTopiaId(String plotTopiaId) {
        this.practicedPlotTopiaId = plotTopiaId;
    }

    public void setLocationTopiaId(String locationTopiaId) {
        this.locationTopiaId = locationTopiaId;
    }

    public String getLocationTopiaId() {
        return this.locationTopiaId;
    }

    public List<RefParcelleZonageEDI> getParcelleZonages() {
        return this.parcelleZonages;
    }

    public void setSelectedPlotZoningIds(List<String> selectedPlotZoningIds) {
        this.selectedPlotZoningIds = selectedPlotZoningIds;
    }

    public List<String> getSelectedPlotZoningIds() {
        return this.selectedPlotZoningIds;
    }

    public Map<IrrigationSystemType, String> getIrrigationSystemTypes() {
        return this.getEnumAsMap((Object[])IrrigationSystemType.values());
    }

    public Map<PompEngineType, String> getPompEngineTypes() {
        return this.getEnumAsMap((Object[])PompEngineType.values());
    }

    public Map<HosesPositionning, String> getHosesPositionnings() {
        return this.getEnumAsMap((Object[])HosesPositionning.values());
    }

    public Map<FrostProtectionType, String> getFrostProtectionTypes() {
        return this.getEnumAsMap((Object[])FrostProtectionType.values());
    }

    public Map<SolWaterPh, String> getSolWaterPhs() {
        return this.getEnumAsMap((Object[])SolWaterPh.values());
    }

    public List<RefSolTextureGeppa> getSolTextures() {
        return this.solTextures;
    }

    public List<RefSolProfondeurIndigo> getSolProfondeurs() {
        return this.solProfondeurs;
    }

    public String getSelectedSurfaceTextureId() {
        return this.selectedSurfaceTextureId;
    }

    public void setSelectedSurfaceTextureId(String selectedSurfaceTextureId) {
        this.selectedSurfaceTextureId = selectedSurfaceTextureId;
    }

    public String getSelectedSubSoilTextureId() {
        return this.selectedSubSoilTextureId;
    }

    public void setSelectedSubSoilTextureId(String selectedSubSoilTextureId) {
        this.selectedSubSoilTextureId = selectedSubSoilTextureId;
    }

    public String getSelectedSolProfondeurId() {
        return this.selectedSolProfondeurId;
    }

    public void setSelectedSolProfondeurId(String selectedSolProfondeurId) {
        this.selectedSolProfondeurId = selectedSolProfondeurId;
    }

    public List<SolHorizonDto> getSolHorizons() {
        return this.solHorizons;
    }

    public void setSolHorizons(String json) {
        this.solHorizonsJson = json;
    }

    public List<RefSolCaracteristiqueIndigo> getSolCaracteristiques() {
        return this.solCaracteristiques;
    }

    public Map<ZoneType, String> getZoneTypes() {
        return this.getEnumAsMap((Object[])ZoneType.values());
    }

    public List<RefElementVoisinage> getAdjacentElements() {
        return this.adjacentElements;
    }

    public List<String> getAdjacentElementIds() {
        return this.adjacentElementIds;
    }

    public void setAdjacentElementIds(List<String> adjacentElementIds) {
        this.adjacentElementIds = adjacentElementIds;
    }

    public String getPracticedSystemTopiaId() {
        return this.practicedSystemTopiaId;
    }

    public void setPracticedSystemTopiaId(String practicedSystemTopiaId) {
        this.practicedSystemTopiaId = practicedSystemTopiaId;
    }

    public PracticedSystem getPracticedSystem() {
        return this.practicedSystem;
    }

    public List<PracticedSystem> getPracticedSystems() {
        return this.practicedSystems;
    }
}

