/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.practiced;

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadToolsCouplingJson
extends AbstractJsonAction {
    private static final long serialVersionUID = -6352586060492623909L;
    private static final Log LOGGER = LogFactory.getLog(LoadToolsCouplingJson.class);
    protected transient EffectiveCropCycleService effectiveService;
    protected transient PracticedSystemService practicedSystemService;
    protected transient String agrosystInterventionTypes;
    protected transient String growingSystemId;
    protected transient String campaigns;
    protected transient String zoneTopiaId;

    public void setEffectiveService(EffectiveCropCycleService effectiveService) {
        this.effectiveService = effectiveService;
    }

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

    public void setCampaigns(String campaigns) {
        this.campaigns = campaigns;
    }

    public void setZoneTopiaId(String zoneTopiaId) {
        this.zoneTopiaId = zoneTopiaId;
    }

    public String execute() {
        try {
            Set agrosystInterventionTypeSet = this.getAgrosystInterventionTypesSet(this.agrosystInterventionTypes);
            this.jsonData = Strings.isNullOrEmpty((String)this.zoneTopiaId) ? this.practicedSystemService.getToolsCouplingModelForInterventionTypes(this.growingSystemId, this.campaigns, agrosystInterventionTypeSet) : this.effectiveService.getToolsCouplingModelForInterventionTypes(this.zoneTopiaId, agrosystInterventionTypeSet);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load tools copling for (growingSystemId: '%s', campaigns: '%s'),(zoneTopiaId: '%s'),  agrosystInterventionTypes '%s':", this.growingSystemId, this.campaigns, this.zoneTopiaId, this.agrosystInterventionTypes), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    public void setAgrosystInterventionTypes(String json) {
        this.agrosystInterventionTypes = json;
    }

    protected Set<AgrosystInterventionType> getAgrosystInterventionTypesSet(String json) {
        Set result = null;
        if (StringUtils.isNotBlank((CharSequence)json)) {
            Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
            result = (Set)this.getGson().fromJson(json, type);
            result.removeIf(Objects::isNull);
        }
        return result;
    }
}

