/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.itk;

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.services.domain.ToolsCouplingDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadCopyPasteGlobalInfoJson
extends AbstractJsonAction {
    private static final long serialVersionUID = -6352586060492623909L;
    private static final Log LOGGER = LogFactory.getLog(LoadCopyPasteGlobalInfoJson.class);
    protected transient EffectiveCropCycleService effectiveService;
    protected transient PracticedSystemService practicedSystemService;
    protected transient ReferentialService referentialService;
    protected transient String agrosystInterventionTypes;
    protected transient String growingSystemId;
    protected transient String campaigns;
    protected transient String zoneTopiaId;
    protected transient Map<AgrosystInterventionType, List<ToolsCouplingDto>> agrosystInterventionTypesToolsCouplingDtos;

    public void setEffectiveService(EffectiveCropCycleService effectiveService) {
        this.effectiveService = effectiveService;
    }

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

    public void setCampaigns(String campaigns) {
        this.campaigns = campaigns;
    }

    public void setZoneTopiaId(String zoneTopiaId) {
        this.zoneTopiaId = zoneTopiaId;
    }

    public String execute() {
        try {
            Map domainInputs;
            Map allSectorByCodeEspeceBotaniqueCodeQualifiant;
            Map allCodeEspeceBotaniqueCodeQualifantBySpeciesCode;
            Set interventionTypes = this.getAgrosystInterventionTypes(this.agrosystInterventionTypes);
            if (Strings.isNullOrEmpty((String)this.zoneTopiaId)) {
                this.agrosystInterventionTypesToolsCouplingDtos = this.practicedSystemService.getToolsCouplingModelForInterventionTypes(this.growingSystemId, this.campaigns, interventionTypes);
                allCodeEspeceBotaniqueCodeQualifantBySpeciesCode = this.practicedSystemService.getAllCodeEspeceBotaniqueCodeQualifantBySpeciesCodeForDomainIds(this.growingSystemId, this.campaigns);
                allSectorByCodeEspeceBotaniqueCodeQualifiant = this.practicedSystemService.getSectorByCodeEspceBotaniqueCodeQualifiant(this.growingSystemId, this.campaigns);
                domainInputs = this.practicedSystemService.getDomainInputs(this.growingSystemId, this.campaigns);
            } else {
                this.agrosystInterventionTypesToolsCouplingDtos = this.effectiveService.getToolsCouplingModelForInterventionTypes(this.zoneTopiaId, interventionTypes);
                allCodeEspeceBotaniqueCodeQualifantBySpeciesCode = this.effectiveService.getAllCodeEspeceBotaniqueCodeQualifantBySpeciesCodeForDomainIds(this.zoneTopiaId);
                allSectorByCodeEspeceBotaniqueCodeQualifiant = this.effectiveService.getSectorByCodeEspceBotaniqueCodeQualifiant(this.zoneTopiaId);
                domainInputs = new HashMap();
            }
            HashMap<String, Map> result = new HashMap<String, Map>();
            result.put("agrosystInterventionTypesToolsCouplingDtos", this.agrosystInterventionTypesToolsCouplingDtos);
            result.put("allCodeEspeceBotaniqueCodeQualifantBySpeciesCode", allCodeEspeceBotaniqueCodeQualifantBySpeciesCode);
            result.put("allSectorByCodeEspeceBotaniqueCodeQualifiant", allSectorByCodeEspeceBotaniqueCodeQualifiant);
            result.put("practicedDomainInputStockUnitByCodes", domainInputs);
            this.jsonData = result;
            return "success";
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Exception on harvesting price loading, parameters growingSystemId '%s', campaigns '%s', zoneId '%s':", this.growingSystemId, this.campaigns, this.zoneTopiaId), (Throwable)e);
            }
            return "error";
        }
    }

    public void setAgrosystInterventionTypes(String json) {
        this.agrosystInterventionTypes = json;
    }

    private Set<AgrosystInterventionType> getAgrosystInterventionTypes(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        Set agrosystInterventionTypes = (Set)this.getGson().fromJson(json, type);
        return agrosystInterventionTypes;
    }
}

